/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.platform.Services;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_7919;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final ClientConfig CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static Sorting[] DEFAULT_SORTING;
    public static Boolean[] DEFAULT_SORTING_DIRECTION;
    public static int newFrontierShape;
    public static int newFrontierCount;
    public static int newFrontierShapeWidth;
    public static int newFrontierShapeRadius;
    public static int newFrontierChunkShape;
    public static int newFrontierChunkShapeWidth;
    public static int newFrontierChunkShapeLength;
    public static FrontierData.Mode newFrontierMode;
    public static AfterCreatingFrontier afterCreatingFrontier;
    public static boolean pasteName;
    public static boolean pasteVisibility;
    public static boolean pasteColor;
    public static boolean pasteBanner;
    public static boolean pasteOptionsVisible;
    public static Visibility frontierVisibility;
    public static Visibility announceInChat;
    public static Visibility announceInTitle;
    public static Visibility fullscreenVisibility;
    public static Visibility fullscreenNameVisibility;
    public static Visibility fullscreenOwnerVisibility;
    public static Visibility fullscreenBannerVisibility;
    public static Visibility fullscreenDayVisibility;
    public static Visibility fullscreenNightVisibility;
    public static Visibility fullscreenUndergroundVisibility;
    public static Visibility fullscreenTopoVisibility;
    public static Visibility fullscreenBiomeVisibility;
    public static Visibility minimapVisibility;
    public static Visibility minimapNameVisibility;
    public static Visibility minimapOwnerVisibility;
    public static Visibility minimapBannerVisibility;
    public static Visibility minimapDayVisibility;
    public static Visibility minimapNightVisibility;
    public static Visibility minimapUndergroundVisibility;
    public static Visibility minimapTopoVisibility;
    public static Visibility minimapBiomeVisibility;
    public static Visibility webmapVisibility;
    public static Visibility webmapNameVisibility;
    public static Visibility webmapOwnerVisibility;
    public static Visibility webmapBannerVisibility;
    public static Visibility webmapDayVisibility;
    public static Visibility webmapNightVisibility;
    public static Visibility webmapUndergroundVisibility;
    public static Visibility webmapTopoVisibility;
    public static Visibility webmapBiomeVisibility;
    public static int titleAnnouncementDuration;
    public static int titleAnnouncementTimeout;
    public static boolean titleAnnouncementAboveHotbar;
    public static boolean announceUnnamedFrontiers;
    public static int snapDistance;
    public static String sendCommand;
    public static boolean hideNamesThatDontFit;
    public static double polygonsOpacity;
    public static int borderWidth;
    public static double borderOpacity;
    public static int textSize;
    public static double textOpacity;
    public static TextColor textColor;
    public static int bannerSize;
    public static double bannerOpacity;
    public static boolean fullscreenButtons;
    public static boolean askConfirmationFrontierDelete;
    public static boolean askConfirmationGroupDelete;
    public static boolean askConfirmationUserDelete;
    public static List<Sorting> frontierSorting;
    public static List<Boolean> frontierSortingDirection;
    public static FilterFrontierType filterFrontierType;
    public static FilterFrontierOwner filterFrontierOwner;
    public static String filterFrontierDimension;
    public static boolean hudEnabled;
    public static boolean hudAutoAdjustAnchor;
    public static boolean hudSnapToBorder;
    public static int hudTextSize;
    public static int hudBannerSize;
    public static HUDSlot hudSlot1;
    public static HUDSlot hudSlot2;
    public static HUDSlot hudSlot3;
    public static HUDAnchor hudAnchor;
    public static int hudXPosition;
    public static int hudYPosition;

    public static void bakeConfig() {
        newFrontierShape = (Integer)Config.CLIENT.newFrontierShape.get();
        newFrontierCount = (Integer)Config.CLIENT.newFrontierCount.get();
        newFrontierShapeWidth = (Integer)Config.CLIENT.newFrontierShapeWidth.get();
        newFrontierShapeRadius = (Integer)Config.CLIENT.newFrontierShapeRadius.get();
        newFrontierChunkShape = (Integer)Config.CLIENT.newFrontierChunkShape.get();
        newFrontierChunkShapeWidth = (Integer)Config.CLIENT.newFrontierChunkShapeWidth.get();
        newFrontierChunkShapeLength = (Integer)Config.CLIENT.newFrontierChunkShapeLength.get();
        newFrontierMode = (FrontierData.Mode)((Object)Config.CLIENT.newFrontierMode.get());
        afterCreatingFrontier = (AfterCreatingFrontier)((Object)Config.CLIENT.afterCreatingFrontier.get());
        pasteName = (Boolean)Config.CLIENT.pasteName.get();
        pasteVisibility = (Boolean)Config.CLIENT.pasteVisibility.get();
        pasteColor = (Boolean)Config.CLIENT.pasteColor.get();
        pasteBanner = (Boolean)Config.CLIENT.pasteBanner.get();
        pasteOptionsVisible = (Boolean)Config.CLIENT.pasteOptionsVisible.get();
        frontierVisibility = (Visibility)((Object)Config.CLIENT.frontierVisibility.get());
        announceInChat = (Visibility)((Object)Config.CLIENT.announceInChat.get());
        announceInTitle = (Visibility)((Object)Config.CLIENT.announceInTitle.get());
        fullscreenVisibility = (Visibility)((Object)Config.CLIENT.fullscreenVisibility.get());
        fullscreenNameVisibility = (Visibility)((Object)Config.CLIENT.fullscreenNameVisibility.get());
        fullscreenOwnerVisibility = (Visibility)((Object)Config.CLIENT.fullscreenOwnerVisibility.get());
        fullscreenBannerVisibility = (Visibility)((Object)Config.CLIENT.fullscreenBannerVisibility.get());
        fullscreenDayVisibility = (Visibility)((Object)Config.CLIENT.fullscreenDayVisibility.get());
        fullscreenNightVisibility = (Visibility)((Object)Config.CLIENT.fullscreenNightVisibility.get());
        fullscreenUndergroundVisibility = (Visibility)((Object)Config.CLIENT.fullscreenUndergroundVisibility.get());
        fullscreenTopoVisibility = (Visibility)((Object)Config.CLIENT.fullscreenTopoVisibility.get());
        fullscreenBiomeVisibility = (Visibility)((Object)Config.CLIENT.fullscreenBiomeVisibility.get());
        minimapVisibility = (Visibility)((Object)Config.CLIENT.minimapVisibility.get());
        minimapNameVisibility = (Visibility)((Object)Config.CLIENT.minimapNameVisibility.get());
        minimapOwnerVisibility = (Visibility)((Object)Config.CLIENT.minimapOwnerVisibility.get());
        minimapBannerVisibility = (Visibility)((Object)Config.CLIENT.minimapBannerVisibility.get());
        minimapDayVisibility = (Visibility)((Object)Config.CLIENT.minimapDayVisibility.get());
        minimapNightVisibility = (Visibility)((Object)Config.CLIENT.minimapNightVisibility.get());
        minimapUndergroundVisibility = (Visibility)((Object)Config.CLIENT.minimapUndergroundVisibility.get());
        minimapTopoVisibility = (Visibility)((Object)Config.CLIENT.minimapTopoVisibility.get());
        minimapBiomeVisibility = (Visibility)((Object)Config.CLIENT.minimapBiomeVisibility.get());
        webmapVisibility = (Visibility)((Object)Config.CLIENT.webmapVisibility.get());
        webmapNameVisibility = (Visibility)((Object)Config.CLIENT.webmapNameVisibility.get());
        webmapOwnerVisibility = (Visibility)((Object)Config.CLIENT.webmapOwnerVisibility.get());
        webmapBannerVisibility = (Visibility)((Object)Config.CLIENT.webmapBannerVisibility.get());
        webmapDayVisibility = (Visibility)((Object)Config.CLIENT.webmapDayVisibility.get());
        webmapNightVisibility = (Visibility)((Object)Config.CLIENT.webmapNightVisibility.get());
        webmapUndergroundVisibility = (Visibility)((Object)Config.CLIENT.webmapUndergroundVisibility.get());
        webmapTopoVisibility = (Visibility)((Object)Config.CLIENT.webmapTopoVisibility.get());
        webmapBiomeVisibility = (Visibility)((Object)Config.CLIENT.webmapBiomeVisibility.get());
        titleAnnouncementDuration = (Integer)Config.CLIENT.titleAnnouncementDuration.get();
        titleAnnouncementTimeout = (Integer)Config.CLIENT.titleAnnouncementTimeout.get();
        titleAnnouncementAboveHotbar = (Boolean)Config.CLIENT.titleAnnouncementAboveHotbar.get();
        announceUnnamedFrontiers = (Boolean)Config.CLIENT.announceUnnamedFrontiers.get();
        snapDistance = (Integer)Config.CLIENT.snapDistance.get();
        sendCommand = (String)Config.CLIENT.sendCommand.get();
        hideNamesThatDontFit = (Boolean)Config.CLIENT.hideNamesThatDontFit.get();
        polygonsOpacity = (Double)Config.CLIENT.polygonsOpacity.get();
        borderWidth = (Integer)Config.CLIENT.borderWidth.get();
        borderOpacity = (Double)Config.CLIENT.borderOpacity.get();
        textSize = (Integer)Config.CLIENT.textSize.get();
        textOpacity = (Double)Config.CLIENT.textOpacity.get();
        textColor = (TextColor)((Object)Config.CLIENT.textColor.get());
        bannerSize = (Integer)Config.CLIENT.bannerSize.get();
        bannerOpacity = (Double)Config.CLIENT.bannerOpacity.get();
        fullscreenButtons = (Boolean)Config.CLIENT.fullscreenButtons.get();
        askConfirmationFrontierDelete = (Boolean)Config.CLIENT.askConfirmationFrontierDelete.get();
        askConfirmationGroupDelete = (Boolean)Config.CLIENT.askConfirmationGroupDelete.get();
        askConfirmationUserDelete = (Boolean)Config.CLIENT.askConfirmationUserDelete.get();
        frontierSorting = ((List)Config.CLIENT.frontierSorting.get()).stream().map(Sorting::valueOf).collect(Collectors.toList());
        frontierSortingDirection = new ArrayList<Boolean>((Collection)Config.CLIENT.frontierSortingDirection.get());
        filterFrontierType = (FilterFrontierType)((Object)Config.CLIENT.filterFrontierType.get());
        filterFrontierOwner = (FilterFrontierOwner)((Object)Config.CLIENT.filterFrontierOwner.get());
        filterFrontierDimension = (String)Config.CLIENT.filterFrontierDimension.get();
        hudEnabled = (Boolean)Config.CLIENT.hudEnabled.get();
        hudAutoAdjustAnchor = (Boolean)Config.CLIENT.hudAutoAdjustAnchor.get();
        hudSnapToBorder = (Boolean)Config.CLIENT.hudSnapToBorder.get();
        hudTextSize = (Integer)Config.CLIENT.hudTextSize.get();
        hudBannerSize = (Integer)Config.CLIENT.hudBannerSize.get();
        hudSlot1 = (HUDSlot)((Object)Config.CLIENT.hudSlot1.get());
        hudSlot2 = (HUDSlot)((Object)Config.CLIENT.hudSlot2.get());
        hudSlot3 = (HUDSlot)((Object)Config.CLIENT.hudSlot3.get());
        hudAnchor = (HUDAnchor)((Object)Config.CLIENT.hudAnchor.get());
        hudXPosition = (Integer)Config.CLIENT.hudXPosition.get();
        hudYPosition = (Integer)Config.CLIENT.hudYPosition.get();
        Config.validateSorting();
    }

    private static void save() {
        Config.CLIENT.newFrontierShape.set((Object)newFrontierShape);
        Config.CLIENT.newFrontierCount.set((Object)newFrontierCount);
        Config.CLIENT.newFrontierShapeWidth.set((Object)newFrontierShapeWidth);
        Config.CLIENT.newFrontierShapeRadius.set((Object)newFrontierShapeRadius);
        Config.CLIENT.newFrontierChunkShape.set((Object)newFrontierChunkShape);
        Config.CLIENT.newFrontierChunkShapeWidth.set((Object)newFrontierChunkShapeWidth);
        Config.CLIENT.newFrontierChunkShapeLength.set((Object)newFrontierChunkShapeLength);
        Config.CLIENT.newFrontierMode.set((Object)newFrontierMode);
        Config.CLIENT.afterCreatingFrontier.set((Object)afterCreatingFrontier);
        Config.CLIENT.pasteName.set((Object)pasteName);
        Config.CLIENT.pasteVisibility.set((Object)pasteVisibility);
        Config.CLIENT.pasteColor.set((Object)pasteColor);
        Config.CLIENT.pasteBanner.set((Object)pasteBanner);
        Config.CLIENT.pasteOptionsVisible.set((Object)pasteOptionsVisible);
        Config.CLIENT.frontierVisibility.set((Object)frontierVisibility);
        Config.CLIENT.announceInChat.set((Object)announceInChat);
        Config.CLIENT.announceInTitle.set((Object)announceInTitle);
        Config.CLIENT.fullscreenVisibility.set((Object)fullscreenVisibility);
        Config.CLIENT.fullscreenNameVisibility.set((Object)fullscreenNameVisibility);
        Config.CLIENT.fullscreenOwnerVisibility.set((Object)fullscreenOwnerVisibility);
        Config.CLIENT.fullscreenBannerVisibility.set((Object)fullscreenBannerVisibility);
        Config.CLIENT.fullscreenDayVisibility.set((Object)fullscreenDayVisibility);
        Config.CLIENT.fullscreenNightVisibility.set((Object)fullscreenNightVisibility);
        Config.CLIENT.fullscreenUndergroundVisibility.set((Object)fullscreenUndergroundVisibility);
        Config.CLIENT.fullscreenTopoVisibility.set((Object)fullscreenTopoVisibility);
        Config.CLIENT.fullscreenBiomeVisibility.set((Object)fullscreenBiomeVisibility);
        Config.CLIENT.minimapVisibility.set((Object)minimapVisibility);
        Config.CLIENT.minimapNameVisibility.set((Object)minimapNameVisibility);
        Config.CLIENT.minimapOwnerVisibility.set((Object)minimapOwnerVisibility);
        Config.CLIENT.minimapBannerVisibility.set((Object)minimapBannerVisibility);
        Config.CLIENT.minimapDayVisibility.set((Object)minimapDayVisibility);
        Config.CLIENT.minimapNightVisibility.set((Object)minimapNightVisibility);
        Config.CLIENT.minimapUndergroundVisibility.set((Object)minimapUndergroundVisibility);
        Config.CLIENT.minimapTopoVisibility.set((Object)minimapTopoVisibility);
        Config.CLIENT.minimapBiomeVisibility.set((Object)minimapBiomeVisibility);
        Config.CLIENT.webmapVisibility.set((Object)webmapVisibility);
        Config.CLIENT.webmapNameVisibility.set((Object)webmapNameVisibility);
        Config.CLIENT.webmapOwnerVisibility.set((Object)webmapOwnerVisibility);
        Config.CLIENT.webmapBannerVisibility.set((Object)webmapBannerVisibility);
        Config.CLIENT.webmapDayVisibility.set((Object)webmapDayVisibility);
        Config.CLIENT.webmapNightVisibility.set((Object)webmapNightVisibility);
        Config.CLIENT.webmapUndergroundVisibility.set((Object)webmapUndergroundVisibility);
        Config.CLIENT.webmapTopoVisibility.set((Object)webmapTopoVisibility);
        Config.CLIENT.webmapBiomeVisibility.set((Object)webmapBiomeVisibility);
        Config.CLIENT.titleAnnouncementDuration.set((Object)titleAnnouncementDuration);
        Config.CLIENT.titleAnnouncementTimeout.set((Object)titleAnnouncementTimeout);
        Config.CLIENT.titleAnnouncementAboveHotbar.set((Object)titleAnnouncementAboveHotbar);
        Config.CLIENT.announceUnnamedFrontiers.set((Object)announceUnnamedFrontiers);
        Config.CLIENT.snapDistance.set((Object)snapDistance);
        Config.CLIENT.sendCommand.set((Object)sendCommand);
        Config.CLIENT.hideNamesThatDontFit.set((Object)hideNamesThatDontFit);
        Config.CLIENT.polygonsOpacity.set((Object)polygonsOpacity);
        Config.CLIENT.borderWidth.set((Object)borderWidth);
        Config.CLIENT.borderOpacity.set((Object)borderOpacity);
        Config.CLIENT.textSize.set((Object)textSize);
        Config.CLIENT.textOpacity.set((Object)textOpacity);
        Config.CLIENT.textColor.set((Object)textColor);
        Config.CLIENT.bannerSize.set((Object)bannerSize);
        Config.CLIENT.bannerOpacity.set((Object)bannerOpacity);
        Config.CLIENT.fullscreenButtons.set((Object)fullscreenButtons);
        Config.CLIENT.askConfirmationFrontierDelete.set((Object)askConfirmationFrontierDelete);
        Config.CLIENT.askConfirmationGroupDelete.set((Object)askConfirmationGroupDelete);
        Config.CLIENT.askConfirmationUserDelete.set((Object)askConfirmationUserDelete);
        Config.CLIENT.frontierSorting.set(frontierSorting.stream().map(Enum::toString).toList());
        Config.CLIENT.frontierSortingDirection.set(frontierSortingDirection);
        Config.CLIENT.filterFrontierType.set((Object)filterFrontierType);
        Config.CLIENT.filterFrontierOwner.set((Object)filterFrontierOwner);
        Config.CLIENT.filterFrontierDimension.set((Object)filterFrontierDimension);
        Config.CLIENT.hudEnabled.set((Object)hudEnabled);
        Config.CLIENT.hudAutoAdjustAnchor.set((Object)hudAutoAdjustAnchor);
        Config.CLIENT.hudSnapToBorder.set((Object)hudSnapToBorder);
        Config.CLIENT.hudTextSize.set((Object)hudTextSize);
        Config.CLIENT.hudBannerSize.set((Object)hudBannerSize);
        Config.CLIENT.hudSlot1.set((Object)hudSlot1);
        Config.CLIENT.hudSlot2.set((Object)hudSlot2);
        Config.CLIENT.hudSlot3.set((Object)hudSlot3);
        Config.CLIENT.hudAnchor.set((Object)hudAnchor);
        Config.CLIENT.hudXPosition.set((Object)hudXPosition);
        Config.CLIENT.hudYPosition.set((Object)hudYPosition);
        CLIENT_SPEC.save();
    }

    public static boolean getVisibilityValue(Visibility visibility, boolean custom) {
        return switch (visibility.ordinal()) {
            case 1 -> true;
            case 2 -> false;
            default -> custom;
        };
    }

    public static class_2561 getTranslatedName(String name) {
        ForgeConfigSpec.ValueSpec valueSpec = Config.getValueSpec(name);
        if (valueSpec != null) {
            return class_2561.method_43471((String)valueSpec.getTranslationKey());
        }
        return class_5244.field_39003;
    }

    public static <E extends Enum<E>> class_2561 getTranslatedEnum(E value) {
        return class_2561.method_43471((String)("mapfrontiers.config." + value.name()));
    }

    @Nullable
    public static class_7919 getTooltip(String name) {
        ForgeConfigSpec.ValueSpec valueSpec = Config.getValueSpec(name);
        if (valueSpec != null) {
            class_5250 tooltip = class_2561.method_43471((String)(valueSpec.getTranslationKey() + ".tooltip"));
            tooltip.method_27693("\n\n");
            tooltip.method_10852((class_2561)class_2561.method_43469((String)"mapfrontiers.default", (Object[])new Object[]{Config.getDefault(valueSpec)}).method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true))));
            return class_7919.method_47407((class_2561)tooltip);
        }
        return null;
    }

    public static class_2561 getDefault(ForgeConfigSpec.ValueSpec valueSpec) {
        Object defaultValue = valueSpec.getDefault();
        if (Enum.class.isAssignableFrom(valueSpec.getClazz())) {
            return Config.getTranslatedEnum((Enum)defaultValue);
        }
        if (valueSpec.getClazz() == Boolean.class) {
            return class_2561.method_43471((String)((Boolean)defaultValue != false ? "options.on" : "options.off"));
        }
        return class_2561.method_43470((String)defaultValue.toString());
    }

    public static boolean isInRange(String name, Object value) {
        ForgeConfigSpec.ValueSpec valueSpec = Config.getValueSpec(name);
        if (valueSpec != null) {
            return valueSpec.test(value);
        }
        return false;
    }

    private static ForgeConfigSpec.ValueSpec getValueSpec(String name) {
        return Config.getValueSpec(Arrays.asList(name.split("\\.")), CLIENT_SPEC.getSpec());
    }

    private static ForgeConfigSpec.ValueSpec getValueSpec(List<String> path, UnmodifiableConfig valueMap) {
        if (path.isEmpty()) {
            return null;
        }
        Object value = valueMap.valueMap().get(path.getFirst());
        if (value == null) {
            return null;
        }
        if (value instanceof com.electronwill.nightconfig.core.Config) {
            return Config.getValueSpec(path.subList(1, path.size()), (UnmodifiableConfig)((com.electronwill.nightconfig.core.Config)value));
        }
        return (ForgeConfigSpec.ValueSpec)value;
    }

    public static Point getHUDAnchor(HUDAnchor anchor) {
        class_310 mc = class_310.method_1551();
        Point p = new Point();
        int displayWidth = mc.method_22683().method_4489();
        int displayHeight = mc.method_22683().method_4506();
        switch (anchor.ordinal()) {
            case 0: {
                p.x = displayWidth / 2;
                break;
            }
            case 1: {
                p.x = displayWidth;
                break;
            }
            case 2: {
                p.x = displayWidth;
                p.y = displayHeight / 2;
                break;
            }
            case 3: {
                p.x = displayWidth;
                p.y = displayHeight;
                break;
            }
            case 4: {
                p.x = displayWidth / 2;
                p.y = displayHeight;
                break;
            }
            case 5: {
                p.y = displayHeight;
                break;
            }
            case 6: {
                p.y = displayHeight / 2;
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                p = Config.getMinimapCorner();
                break;
            }
            case 9: {
                p = Config.getMinimapCorner();
                if (p.y < displayHeight / 2) {
                    p.y = 0;
                    break;
                }
                if (p.y <= displayHeight / 2) break;
                p.y = displayHeight;
                break;
            }
            case 10: {
                p = Config.getMinimapCorner();
                if (p.x < displayWidth / 2) {
                    p.x = 0;
                    break;
                }
                if (p.x <= displayWidth / 2) break;
                p.x = displayWidth;
            }
        }
        return p;
    }

    public static Point getHUDOrigin(HUDAnchor anchor, int hudWidth, int hudHeight) {
        Point p = new Point();
        switch (anchor.ordinal()) {
            case 0: {
                p.x = hudWidth / 2;
                break;
            }
            case 1: {
                p.x = hudWidth;
                break;
            }
            case 2: {
                p.x = hudWidth;
                p.y = hudHeight / 2;
                break;
            }
            case 3: {
                p.x = hudWidth;
                p.y = hudHeight;
                break;
            }
            case 4: {
                p.x = hudWidth / 2;
                p.y = hudHeight;
                break;
            }
            case 5: {
                p.y = hudHeight;
                break;
            }
            case 6: {
                p.y = hudHeight / 2;
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                p = Config.getHUDOriginFromMinimap(hudWidth, hudHeight);
            }
        }
        return p;
    }

    public static Point getMinimapCorner() {
        class_310 mc = class_310.method_1551();
        Point corner = new Point();
        int displayWidth = mc.method_22683().method_4489();
        int displayHeight = mc.method_22683().method_4506();
        switch (Services.JOURNEYMAP.getMinimapPosition()) {
            case TopRight: {
                corner.x = displayWidth;
                break;
            }
            case BottomRight: {
                corner.x = displayWidth;
                corner.y = displayHeight;
                break;
            }
            case BottomLeft: {
                corner.y = displayHeight;
                break;
            }
            case TopLeft: {
                break;
            }
            case TopCenter: {
                corner.x = displayWidth / 2;
                break;
            }
            case Center: {
                corner.x = displayWidth / 2;
                corner.y = displayHeight / 2;
            }
        }
        if (Services.JOURNEYMAP.isMinimapEnabled()) {
            try {
                int minimapWidth = (int)Services.JOURNEYMAP.getMinimapWidth();
                int minimapHeight = (int)Services.JOURNEYMAP.getMinimapHeight();
                int translateX = (int)Services.JOURNEYMAP.getMinimapTranslateX();
                int translateY = (int)Services.JOURNEYMAP.getMinimapTranslateY();
                int margin = Services.JOURNEYMAP.getMinimapMargin();
                minimapWidth += margin * 2;
                minimapHeight += margin * 2;
                translateX += displayWidth / 2;
                translateY += displayHeight / 2;
                switch (Services.JOURNEYMAP.getMinimapPosition()) {
                    case TopRight: {
                        corner.x = translateX - minimapWidth / 2;
                        corner.y = translateY + minimapHeight / 2;
                        break;
                    }
                    case BottomRight: {
                        corner.x = translateX - minimapWidth / 2;
                        corner.y = translateY - minimapHeight / 2;
                        break;
                    }
                    case BottomLeft: {
                        corner.x = translateX + minimapWidth / 2;
                        corner.y = translateY - minimapHeight / 2;
                        break;
                    }
                    case TopLeft: {
                        corner.x = translateX + minimapWidth / 2;
                        corner.y = translateY + minimapHeight / 2;
                        break;
                    }
                    case TopCenter: {
                        corner.x = translateX;
                        corner.y = translateY + minimapHeight / 2;
                        break;
                    }
                    case Center: {
                        corner.x = translateX;
                        corner.y = translateY;
                    }
                }
            }
            catch (Exception e) {
                MapFrontiers.LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
        return corner;
    }

    public static Point getHUDOriginFromMinimap(int hudWidth, int hudHeight) {
        Point origin = new Point();
        switch (Services.JOURNEYMAP.getMinimapPosition()) {
            case TopRight: {
                origin.x = hudWidth;
                break;
            }
            case BottomRight: {
                origin.x = hudWidth;
                origin.y = hudHeight;
                break;
            }
            case BottomLeft: {
                origin.y = hudHeight;
                break;
            }
            case TopLeft: {
                break;
            }
            case TopCenter: {
                origin.x = hudWidth / 2;
                break;
            }
            case Center: {
                origin.x = hudWidth / 2;
                origin.y = hudHeight / 2;
            }
        }
        return origin;
    }

    private static void validateSorting() {
        if (frontierSorting.size() > Sorting.values().length || frontierSortingDirection.size() != frontierSorting.size()) {
            frontierSorting = new ArrayList<Sorting>(Arrays.asList(DEFAULT_SORTING));
            frontierSortingDirection = new ArrayList<Boolean>(Arrays.asList(DEFAULT_SORTING_DIRECTION));
            Config.save();
            return;
        }
        ArrayList<Sorting> missings = new ArrayList<Sorting>();
        for (Sorting sort : Sorting.values()) {
            int count = Collections.frequency(frontierSorting, (Object)sort);
            if (count > 1) {
                frontierSorting = new ArrayList<Sorting>(Arrays.asList(DEFAULT_SORTING));
                frontierSortingDirection = new ArrayList<Boolean>(Arrays.asList(DEFAULT_SORTING_DIRECTION));
                Config.save();
                return;
            }
            if (count != 0) continue;
            missings.add(sort);
        }
        if (!missings.isEmpty()) {
            for (Sorting missing : missings) {
                frontierSorting.add(missing);
                int index = Arrays.asList(DEFAULT_SORTING).indexOf((Object)missing);
                frontierSortingDirection.add(DEFAULT_SORTING_DIRECTION[index]);
            }
            Config.save();
        }
    }

    private static boolean isValidSorting(Object s) {
        try {
            if (s instanceof Sorting) {
                return true;
            }
            if (s instanceof String) {
                String string = (String)s;
                Sorting.valueOf(string);
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private static boolean isValidSortingDirection(Object s) {
        if (s instanceof Boolean) {
            return true;
        }
        if (s instanceof String) {
            String string = (String)s;
            return string.equals("true") || string.equals("false");
        }
        return false;
    }

    static {
        DEFAULT_SORTING = new Sorting[]{Sorting.Created, Sorting.Name, Sorting.Owner, Sorting.VertexChunk, Sorting.Area, Sorting.Modified};
        DEFAULT_SORTING_DIRECTION = new Boolean[]{false, true, true, true, true, false};
        Pair specPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (ClientConfig)specPair.getLeft();
        ClientEventHandler.subscribeUpdatedConfigEvent(Config.class, Config::save);
    }

    public static class ClientConfig {
        public final ForgeConfigSpec.IntValue newFrontierShape;
        public final ForgeConfigSpec.IntValue newFrontierCount;
        public final ForgeConfigSpec.IntValue newFrontierShapeWidth;
        public final ForgeConfigSpec.IntValue newFrontierShapeRadius;
        public final ForgeConfigSpec.IntValue newFrontierChunkShape;
        public final ForgeConfigSpec.IntValue newFrontierChunkShapeWidth;
        public final ForgeConfigSpec.IntValue newFrontierChunkShapeLength;
        public final ForgeConfigSpec.EnumValue<FrontierData.Mode> newFrontierMode;
        public final ForgeConfigSpec.EnumValue<AfterCreatingFrontier> afterCreatingFrontier;
        public final ForgeConfigSpec.BooleanValue pasteName;
        public final ForgeConfigSpec.BooleanValue pasteVisibility;
        public final ForgeConfigSpec.BooleanValue pasteColor;
        public final ForgeConfigSpec.BooleanValue pasteBanner;
        public final ForgeConfigSpec.BooleanValue pasteOptionsVisible;
        public final ForgeConfigSpec.EnumValue<Visibility> frontierVisibility;
        public final ForgeConfigSpec.EnumValue<Visibility> announceInChat;
        public final ForgeConfigSpec.EnumValue<Visibility> announceInTitle;
        public final ForgeConfigSpec.EnumValue<Visibility> fullscreenVisibility;
        public final ForgeConfigSpec.EnumValue<Visibility> fullscreenNameVisibility;
        public final ForgeConfigSpec.EnumValue<Visibility> fullscreenOwnerVisibility;
        public final ForgeConfigSpec.EnumValue<Visibility> fullscreenBannerVisibility;
        public final ForgeConfigSpec.EnumValue<Visibility> fullscreenDayVisibility;
        public final ForgeConfigSpec.EnumValue<Visibility> fullscreenNightVisibility;
        public final ForgeConfigSpec.EnumValue<Visibility> fullscreenUndergroundVisibility;
        public final ForgeConfigSpec.EnumValue<Visibility> fullscreenTopoVisibility;
        public final ForgeConfigSpec.EnumValue<Visibility> fullscreenBiomeVisibility;
        public final ForgeConfigSpec.EnumValue<Visibility> minimapVisibility;
        public final ForgeConfigSpec.EnumValue<Visibility> minimapNameVisibility;
        public final ForgeConfigSpec.EnumValue<Visibility> minimapOwnerVisibility;
        public final ForgeConfigSpec.EnumValue<Visibility> minimapBannerVisibility;
        public final ForgeConfigSpec.EnumValue<Visibility> minimapDayVisibility;
        public final ForgeConfigSpec.EnumValue<Visibility> minimapNightVisibility;
        public final ForgeConfigSpec.EnumValue<Visibility> minimapUndergroundVisibility;
        public final ForgeConfigSpec.EnumValue<Visibility> minimapTopoVisibility;
        public final ForgeConfigSpec.EnumValue<Visibility> minimapBiomeVisibility;
        public final ForgeConfigSpec.EnumValue<Visibility> webmapVisibility;
        public final ForgeConfigSpec.EnumValue<Visibility> webmapNameVisibility;
        public final ForgeConfigSpec.EnumValue<Visibility> webmapOwnerVisibility;
        public final ForgeConfigSpec.EnumValue<Visibility> webmapBannerVisibility;
        public final ForgeConfigSpec.EnumValue<Visibility> webmapDayVisibility;
        public final ForgeConfigSpec.EnumValue<Visibility> webmapNightVisibility;
        public final ForgeConfigSpec.EnumValue<Visibility> webmapUndergroundVisibility;
        public final ForgeConfigSpec.EnumValue<Visibility> webmapTopoVisibility;
        public final ForgeConfigSpec.EnumValue<Visibility> webmapBiomeVisibility;
        public final ForgeConfigSpec.IntValue titleAnnouncementDuration;
        public final ForgeConfigSpec.IntValue titleAnnouncementTimeout;
        public final ForgeConfigSpec.BooleanValue titleAnnouncementAboveHotbar;
        public final ForgeConfigSpec.BooleanValue announceUnnamedFrontiers;
        public final ForgeConfigSpec.IntValue snapDistance;
        public final ForgeConfigSpec.ConfigValue<String> sendCommand;
        public final ForgeConfigSpec.BooleanValue hideNamesThatDontFit;
        public final ForgeConfigSpec.DoubleValue polygonsOpacity;
        public final ForgeConfigSpec.IntValue borderWidth;
        public final ForgeConfigSpec.DoubleValue borderOpacity;
        public final ForgeConfigSpec.IntValue textSize;
        public final ForgeConfigSpec.DoubleValue textOpacity;
        public final ForgeConfigSpec.EnumValue<TextColor> textColor;
        public final ForgeConfigSpec.IntValue bannerSize;
        public final ForgeConfigSpec.DoubleValue bannerOpacity;
        public final ForgeConfigSpec.BooleanValue fullscreenButtons;
        public final ForgeConfigSpec.BooleanValue askConfirmationFrontierDelete;
        public final ForgeConfigSpec.BooleanValue askConfirmationGroupDelete;
        public final ForgeConfigSpec.BooleanValue askConfirmationUserDelete;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> frontierSorting;
        public final ForgeConfigSpec.ConfigValue<List<? extends Boolean>> frontierSortingDirection;
        public final ForgeConfigSpec.EnumValue<FilterFrontierType> filterFrontierType;
        public final ForgeConfigSpec.EnumValue<FilterFrontierOwner> filterFrontierOwner;
        public final ForgeConfigSpec.ConfigValue<String> filterFrontierDimension;
        public final ForgeConfigSpec.BooleanValue hudEnabled;
        public final ForgeConfigSpec.BooleanValue hudAutoAdjustAnchor;
        public final ForgeConfigSpec.BooleanValue hudSnapToBorder;
        public final ForgeConfigSpec.IntValue hudTextSize;
        public final ForgeConfigSpec.IntValue hudBannerSize;
        public final ForgeConfigSpec.EnumValue<HUDSlot> hudSlot1;
        public final ForgeConfigSpec.EnumValue<HUDSlot> hudSlot2;
        public final ForgeConfigSpec.EnumValue<HUDSlot> hudSlot3;
        public final ForgeConfigSpec.EnumValue<HUDAnchor> hudAnchor;
        public final ForgeConfigSpec.IntValue hudXPosition;
        public final ForgeConfigSpec.IntValue hudYPosition;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            this.newFrontierShape = builder.defineInRange("newFrontierShape", 0, 0, 11);
            this.newFrontierCount = builder.defineInRange("newFrontierVertexCount", 16, 3, 999);
            this.newFrontierShapeWidth = builder.defineInRange("newFrontierShapeWidth", 10, 0, 999);
            this.newFrontierShapeRadius = builder.defineInRange("newFrontierShapeRadius", 20, 0, 999);
            this.newFrontierChunkShape = builder.defineInRange("newFrontierChunkShape", 0, 0, 7);
            this.newFrontierChunkShapeWidth = builder.defineInRange("newFrontierChunkShapeWidth", 5, 0, 32);
            this.newFrontierChunkShapeLength = builder.defineInRange("newFrontierChunkShapeLength", 5, 0, 32);
            this.newFrontierMode = builder.defineEnum("newFrontierMode", (Enum)FrontierData.Mode.Vertex);
            this.afterCreatingFrontier = builder.defineEnum("afterCreatingFrontier", (Enum)AfterCreatingFrontier.Info);
            this.pasteName = builder.define("pasteName", false);
            this.pasteVisibility = builder.define("pasteVisibility", true);
            this.pasteColor = builder.define("pasteColor", true);
            this.pasteBanner = builder.define("pasteBanner", true);
            this.pasteOptionsVisible = builder.define("pasteOptionsVisible", false);
            this.frontierVisibility = builder.comment("Force all frontier to be shown or hidden. In Custom you can decide for each frontier.").translation("mapfrontiers.config.frontierVisibility").defineEnum("frontierVisibility", (Enum)Visibility.Custom);
            this.announceInChat = builder.comment("Force all frontier to be announced in chat. In Custom you can decide for each frontier.").translation("mapfrontiers.config.announceInChat").defineEnum("announceInChat", (Enum)Visibility.Custom);
            this.announceInTitle = builder.comment("Force all frontier to be announced as a title. In Custom you can decide for each frontier.").translation("mapfrontiers.config.announceInTitle").defineEnum("announceInTitle", (Enum)Visibility.Custom);
            this.fullscreenVisibility = builder.comment("Force all frontier to be shown or hidden on the fullscreen map. In Custom you can decide for each frontier.").translation("mapfrontiers.config.fullscreenVisibility").defineEnum("fullscreenVisibility", (Enum)Visibility.Custom);
            this.fullscreenNameVisibility = builder.comment("Force all frontier names to be shown or hidden on the fullscreen map. In Custom you can decide for each frontier.").translation("mapfrontiers.config.fullscreenNameVisibility").defineEnum("fullscreenNameVisibility", (Enum)Visibility.Custom);
            this.fullscreenOwnerVisibility = builder.comment("Force all frontier owners to be shown or hidden on the fullscreen map. In Custom you can decide for each frontier.").translation("mapfrontiers.config.fullscreenOwnerVisibility").defineEnum("fullscreenOwnerVisibility", (Enum)Visibility.Custom);
            this.fullscreenBannerVisibility = builder.comment("Force all frontier banners to be shown or hidden on the fullscreen map. In Custom you can decide for each frontier.").translation("mapfrontiers.config.fullscreenBannerVisibility").defineEnum("fullscreenBannerVisibility", (Enum)Visibility.Custom);
            this.fullscreenDayVisibility = builder.comment("Force all frontier to be shown or hidden on the day fullscreen map. In Custom you can decide for each frontier.").translation("mapfrontiers.config.fullscreenDayVisibility").defineEnum("fullscreenDayVisibility", (Enum)Visibility.Custom);
            this.fullscreenNightVisibility = builder.comment("Force all frontier to be shown or hidden on the night fullscreen map. In Custom you can decide for each frontier.").translation("mapfrontiers.config.fullscreenNightVisibility").defineEnum("fullscreenNightVisibility", (Enum)Visibility.Custom);
            this.fullscreenUndergroundVisibility = builder.comment("Force all frontier to be shown or hidden on the underground fullscreen map. In Custom you can decide for each frontier.").translation("mapfrontiers.config.fullscreenUndergroundVisibility").defineEnum("fullscreenUndergroundVisibility", (Enum)Visibility.Custom);
            this.fullscreenTopoVisibility = builder.comment("Force all frontier to be shown or hidden on the topo fullscreen map. In Custom you can decide for each frontier.").translation("mapfrontiers.config.fullscreenTopoVisibility").defineEnum("fullscreenTopoVisibility", (Enum)Visibility.Custom);
            this.fullscreenBiomeVisibility = builder.comment("Force all frontier to be shown or hidden on the biome fullscreen map. In Custom you can decide for each frontier.").translation("mapfrontiers.config.fullscreenBiomeVisibility").defineEnum("fullscreenBiomeVisibility", (Enum)Visibility.Custom);
            this.minimapVisibility = builder.comment("Force all frontier to be shown or hidden on the minimap. In Custom you can decide for each frontier.").translation("mapfrontiers.config.minimapVisibility").defineEnum("minimapVisibility", (Enum)Visibility.Custom);
            this.minimapNameVisibility = builder.comment("Force all frontier names to be shown or hidden on the minimap. In Custom you can decide for each frontier.").translation("mapfrontiers.config.minimapNameVisibility").defineEnum("minimapNameVisibility", (Enum)Visibility.Custom);
            this.minimapOwnerVisibility = builder.comment("Force all frontier owners to be shown or hidden on the minimap. In Custom you can decide for each frontier.").translation("mapfrontiers.config.minimapOwnerVisibility").defineEnum("minimapOwnerVisibility", (Enum)Visibility.Custom);
            this.minimapBannerVisibility = builder.comment("Force all frontier banners to be shown or hidden on the minimap. In Custom you can decide for each frontier.").translation("mapfrontiers.config.minimapBannerVisibility").defineEnum("minimapBannerVisibility", (Enum)Visibility.Custom);
            this.minimapDayVisibility = builder.comment("Force all frontier to be shown or hidden on the day minimap. In Custom you can decide for each frontier.").translation("mapfrontiers.config.minimapDayVisibility").defineEnum("minimapDayVisibility", (Enum)Visibility.Custom);
            this.minimapNightVisibility = builder.comment("Force all frontier to be shown or hidden on the night minimap. In Custom you can decide for each frontier.").translation("mapfrontiers.config.minimapNightVisibility").defineEnum("minimapNightVisibility", (Enum)Visibility.Custom);
            this.minimapUndergroundVisibility = builder.comment("Force all frontier to be shown or hidden on the underground minimap. In Custom you can decide for each frontier.").translation("mapfrontiers.config.minimapUndergroundVisibility").defineEnum("minimapUndergroundVisibility", (Enum)Visibility.Custom);
            this.minimapTopoVisibility = builder.comment("Force all frontier to be shown or hidden on the topo minimap. In Custom you can decide for each frontier.").translation("mapfrontiers.config.minimapTopoVisibility").defineEnum("minimapTopoVisibility", (Enum)Visibility.Custom);
            this.minimapBiomeVisibility = builder.comment("Force all frontier to be shown or hidden on the biome minimap. In Custom you can decide for each frontier.").translation("mapfrontiers.config.minimapBiomeVisibility").defineEnum("minimapBiomeVisibility", (Enum)Visibility.Custom);
            this.webmapVisibility = builder.comment("Force all frontier to be shown or hidden on the webmap. In Custom you can decide for each frontier.").translation("mapfrontiers.config.webmapVisibility").defineEnum("webmapVisibility", (Enum)Visibility.Custom);
            this.webmapNameVisibility = builder.comment("Force all frontier names to be shown or hidden on the webmap. In Custom you can decide for each frontier.").translation("mapfrontiers.config.webmapNameVisibility").defineEnum("webmapNameVisibility", (Enum)Visibility.Custom);
            this.webmapOwnerVisibility = builder.comment("Force all frontier owners to be shown or hidden on the webmap. In Custom you can decide for each frontier.").translation("mapfrontiers.config.webmapOwnerVisibility").defineEnum("webmapOwnerVisibility", (Enum)Visibility.Custom);
            this.webmapBannerVisibility = builder.comment("Force all frontier banners to be shown or hidden on the webmap. In Custom you can decide for each frontier.").translation("mapfrontiers.config.webmapBannerVisibility").defineEnum("webmapBannerVisibility", (Enum)Visibility.Custom);
            this.webmapDayVisibility = builder.comment("Force all frontier to be shown or hidden on the day webmap. In Custom you can decide for each frontier.").translation("mapfrontiers.config.webmapDayVisibility").defineEnum("webmapDayVisibility", (Enum)Visibility.Custom);
            this.webmapNightVisibility = builder.comment("Force all frontier to be shown or hidden on the night webmap. In Custom you can decide for each frontier.").translation("mapfrontiers.config.webmapNightVisibility").defineEnum("webmapNightVisibility", (Enum)Visibility.Custom);
            this.webmapUndergroundVisibility = builder.comment("Force all frontier to be shown or hidden on the underground webmap. In Custom you can decide for each frontier.").translation("mapfrontiers.config.webmapUndergroundVisibility").defineEnum("webmapUndergroundVisibility", (Enum)Visibility.Custom);
            this.webmapTopoVisibility = builder.comment("Force all frontier to be shown or hidden on the topo webmap. In Custom you can decide for each frontier.").translation("mapfrontiers.config.webmapTopoVisibility").defineEnum("webmapTopoVisibility", (Enum)Visibility.Custom);
            this.webmapBiomeVisibility = builder.comment("Force all frontier to be shown or hidden on the biome webmap. In Custom you can decide for each frontier.").translation("mapfrontiers.config.webmapBiomeVisibility").defineEnum("webmapBiomeVisibility", (Enum)Visibility.Custom);
            this.titleAnnouncementDuration = builder.comment("Duration of title announcement, in game ticks.").translation("mapfrontiers.config.titleAnnouncementDuration").defineInRange("titleAnnouncementDuration", 70, 0, 1200);
            this.titleAnnouncementTimeout = builder.comment("Minimum time between consecutive title announcement, in game ticks.").translation("mapfrontiers.config.titleAnnouncementTimeout").defineInRange("titleAnnouncementTimeout", 0, 0, 1200);
            this.titleAnnouncementAboveHotbar = builder.comment("Show the frontier announcement above the hotbar instead of showing it as a title.").translation("mapfrontiers.config.titleAnnouncementAboveHotbar").define("titleAnnouncementAboveHotbar", false);
            this.announceUnnamedFrontiers = builder.comment("Announce unnamed frontiers in chat/title.").translation("mapfrontiers.config.announceUnnamedFrontiers").define("announceUnnamedFrontiers", false);
            this.snapDistance = builder.comment("Distance at which vertices are attached to nearby vertices.").translation("mapfrontiers.config.snapDistance").defineInRange("snapDistance", 8, 0, 16);
            this.sendCommand = builder.define("sendCommand", (Object)"msg");
            this.hideNamesThatDontFit = builder.comment("Hides the name if it is wider than the frontier at the zoom level it is being viewed.").translation("mapfrontiers.config.hideNamesThatDontFit").define("hideNamesThatDontFit", true);
            this.polygonsOpacity = builder.comment("Transparency of the frontier polygons. 0.0 is fully transparent and 1.0 is opaque.").translation("mapfrontiers.config.polygonsOpacity").defineInRange("polygonsOpacity", 0.4, 0.0, 1.0);
            this.borderWidth = builder.comment("Width of the frontier border.").translation("mapfrontiers.config.borderWidth").defineInRange("borderWidth", 0, 0, 64);
            this.borderOpacity = builder.comment("Transparency of the frontier border. 0.0 is fully transparent and 1.0 is opaque.").translation("mapfrontiers.config.borderOpacity").defineInRange("borderOpacity", 1.0, 0.0, 1.0);
            this.textSize = builder.comment("Size of the frontier text.").translation("mapfrontiers.config.textSize").defineInRange("textSize", 2, 1, 5);
            this.textOpacity = builder.comment("Transparency of the frontier text. 0.0 is fully transparent and 1.0 is opaque.").translation("mapfrontiers.config.textOpacity").defineInRange("textOpacity", 1.0, 0.0, 1.0);
            this.textColor = builder.comment("Color of the frontier text. Frontier will use the frontier color. Bright will also use the same color but with maximum brightness.").translation("mapfrontiers.config.textColor").defineEnum("textColor", (Enum)TextColor.Frontier);
            this.bannerSize = builder.comment("Size of the frontier banner.").translation("mapfrontiers.config.bannerSize").defineInRange("bannerSize", 1, 1, 5);
            this.bannerOpacity = builder.comment("Transparency of the frontier banner. 0.0 is fully transparent and 1.0 is opaque.").translation("mapfrontiers.config.bannerOpacity").defineInRange("bannerOpacity", 1.0, 0.0, 1.0);
            this.fullscreenButtons = builder.comment("Show buttons on fullscreen map.").translation("mapfrontiers.config.fullscreenButtons").define("fullscreenButtons", true);
            this.askConfirmationFrontierDelete = builder.comment("Show a confirmation dialog before deleting a frontier.").translation("mapfrontiers.config.askConfirmationFrontierDelete").define("askConfirmationFrontierDelete", true);
            this.askConfirmationGroupDelete = builder.comment("Show a confirmation dialog before deleting a group.").translation("mapfrontiers.config.askConfirmationGroupDelete").define("askConfirmationGroupDelete", true);
            this.askConfirmationUserDelete = builder.comment("Show a confirmation dialog before deleting an user.").translation("mapfrontiers.config.askConfirmationUserDelete").define("askConfirmationUserDelete", true);
            this.frontierSorting = builder.comment("Order of the frontier list sorting modes.").defineList("frontierSorting", () -> Arrays.stream(DEFAULT_SORTING).map(Enum::toString).toList(), Config::isValidSorting);
            this.frontierSortingDirection = builder.comment("Direction of the frontier list sorting modes. True means ascending and false means descending.").defineList("frontierSortingDirection", () -> Arrays.asList(DEFAULT_SORTING_DIRECTION), Config::isValidSortingDirection);
            this.filterFrontierType = builder.defineEnum("filterFrontierType", (Enum)FilterFrontierType.All);
            this.filterFrontierOwner = builder.defineEnum("filterFrontierOwner", (Enum)FilterFrontierOwner.All);
            this.filterFrontierDimension = builder.define("filterFrontierDimension", (Object)"all");
            builder.push("hud");
            this.hudEnabled = builder.comment("Show the HUD on screen.").translation("mapfrontiers.config.hud.enabled").define("enabled", true);
            this.hudAutoAdjustAnchor = builder.comment("Automatically switch to nearest anchor when HUD position is edited (on settings screen).").translation("mapfrontiers.config.hud.autoAdjustAnchor").define("autoAdjustAnchor", true);
            this.hudSnapToBorder = builder.comment("Automatically snap to closest border when HUD position is edited (on settings screen).").translation("mapfrontiers.config.hud.snapToBorder").define("snapToBorder", true);
            this.hudTextSize = builder.comment("Size of the HUD text.").translation("mapfrontiers.config.hud.textSize").defineInRange("textSize", 1, 1, 8);
            this.hudBannerSize = builder.comment("Size of the HUD banner.").translation("mapfrontiers.config.hud.bannerSize").defineInRange("bannerSize", 3, 1, 8);
            this.hudSlot1 = builder.comment("HUD element on slot 1.").translation("mapfrontiers.config.hud.slot1").defineEnum("slot1", (Enum)HUDSlot.Name);
            this.hudSlot2 = builder.comment("HUD element on slot 2.").translation("mapfrontiers.config.hud.slot2").defineEnum("slot2", (Enum)HUDSlot.Owner);
            this.hudSlot3 = builder.comment("HUD element on slot 3.").translation("mapfrontiers.config.hud.slot3").defineEnum("slot3", (Enum)HUDSlot.Banner);
            this.hudAnchor = builder.comment("Anchor point of the HUD. In the case of choosing the minimap as an anchor, its default position will be used as a reference in the coordinates.").translation("mapfrontiers.config.hud.anchor").defineEnum("anchor", (Enum)HUDAnchor.MinimapHorizontal);
            this.hudXPosition = builder.defineInRange("xPosition", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.hudYPosition = builder.defineInRange("yPosition", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
            builder.pop();
        }
    }

    public static enum AfterCreatingFrontier {
        Info,
        Edit,
        Nothing;

    }

    public static enum Visibility {
        Custom,
        Always,
        Never;

    }

    public static enum TextColor {
        Frontier,
        Bright,
        White;

    }

    public static enum FilterFrontierType {
        All,
        Global,
        Personal;

    }

    public static enum FilterFrontierOwner {
        All,
        You,
        Others;

    }

    public static enum HUDSlot {
        None,
        Name,
        Owner,
        Banner;

    }

    public static enum HUDAnchor {
        ScreenTop,
        ScreenTopRight,
        ScreenRight,
        ScreenBottomRight,
        ScreenBottom,
        ScreenBottomLeft,
        ScreenLeft,
        ScreenTopLeft,
        Minimap,
        MinimapHorizontal,
        MinimapVertical;

    }

    public static class Point {
        public int x = 0;
        public int y = 0;
    }

    public static enum Sorting {
        Name,
        Owner,
        VertexChunk,
        Area,
        Modified,
        Created;

    }
}

