/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common.network;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.common.util.UUIDHelper;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

@ParametersAreNonnullByDefault
public class PacketFrontierDeleted {
    public static final class_2960 CHANNEL = class_2960.method_60655((String)"mapfrontiers", (String)"packet_frontier_deleted");
    public static final class_9139<class_9129, PacketFrontierDeleted> STREAM_CODEC = class_9139.method_56438(PacketFrontierDeleted::encode, PacketFrontierDeleted::new);
    private class_5321<class_1937> dimension = class_1937.field_25179;
    private UUID frontierID;
    private boolean personal;
    private int playerID = -1;

    public PacketFrontierDeleted(class_5321<class_1937> dimension, UUID frontierID, boolean personal, int playerID) {
        this.dimension = dimension;
        this.frontierID = frontierID;
        this.personal = personal;
        this.playerID = playerID;
    }

    public static class_8710.class_9154<class_8710> type() {
        return new class_8710.class_9154(CHANNEL);
    }

    public PacketFrontierDeleted(class_2540 buf) {
        try {
            if (buf.readableBytes() > 1) {
                this.dimension = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)buf.method_10810());
                this.frontierID = UUIDHelper.fromBytes((ByteBuf)buf);
                this.personal = buf.readBoolean();
                this.playerID = buf.readInt();
            }
        }
        catch (Throwable t) {
            MapFrontiers.LOGGER.error(String.format("Failed to read message for PacketFrontierDeleted: %s", t));
        }
    }

    public void encode(class_2540 buf) {
        try {
            buf.method_10812(this.dimension.method_29177());
            UUIDHelper.toBytes((ByteBuf)buf, this.frontierID);
            buf.method_52964(this.personal);
            buf.method_53002(this.playerID);
        }
        catch (Throwable t) {
            MapFrontiers.LOGGER.error(String.format("Failed to write message for PacketFrontierDeleted: %s", t));
        }
    }

    public static void handle(PacketContext<PacketFrontierDeleted> ctx) {
        if (Side.CLIENT.equals((Object)ctx.side())) {
            boolean deleted;
            PacketFrontierDeleted message = (PacketFrontierDeleted)ctx.message();
            boolean bl = deleted = MapFrontiersClient.getFrontiersOverlayManager(message.personal).deleteFrontier(message.dimension, message.frontierID) != null;
            if (deleted) {
                ClientEventHandler.postDeletedFrontierEvent(message.frontierID);
            }
        }
    }
}

