/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common.network;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.client.gui.screen.ModSettings;
import games.alejandrocoria.mapfrontiers.common.FrontiersManager;
import games.alejandrocoria.mapfrontiers.common.network.PacketHandler;
import games.alejandrocoria.mapfrontiers.common.network.PacketSettingsProfile;
import games.alejandrocoria.mapfrontiers.common.settings.FrontierSettings;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;

@ParametersAreNonnullByDefault
public class PacketFrontierSettings {
    public static final class_2960 CHANNEL = class_2960.method_60655((String)"mapfrontiers", (String)"packet_frontier_settings");
    public static final class_9139<class_9129, PacketFrontierSettings> STREAM_CODEC = class_9139.method_56438(PacketFrontierSettings::encode, PacketFrontierSettings::new);
    private final FrontierSettings settings;

    public PacketFrontierSettings(FrontierSettings settings) {
        this.settings = settings;
    }

    public static class_8710.class_9154<class_8710> type() {
        return new class_8710.class_9154(CHANNEL);
    }

    public PacketFrontierSettings(class_2540 buf) {
        this.settings = new FrontierSettings();
        try {
            if (buf.readableBytes() > 1) {
                this.settings.fromBytes(buf);
                this.settings.setChangeCounter(buf.readInt());
            }
        }
        catch (Throwable t) {
            MapFrontiers.LOGGER.error(String.format("Failed to read message for PacketFrontierSettings: %s", t));
        }
    }

    public void encode(class_2540 buf) {
        try {
            this.settings.toBytes(buf);
            buf.method_53002(this.settings.getChangeCounter());
        }
        catch (Throwable t) {
            MapFrontiers.LOGGER.error(String.format("Failed to write message for PacketFrontierSettings: %s", t));
        }
    }

    public static void handle(PacketContext<PacketFrontierSettings> ctx) {
        PacketFrontierSettings message = (PacketFrontierSettings)ctx.message();
        if (Side.SERVER.equals((Object)ctx.side())) {
            class_3222 player = ctx.sender();
            if (player == null) {
                return;
            }
            MinecraftServer server = player.method_5682();
            if (FrontiersManager.instance.getSettings().checkAction(FrontierSettings.Action.UpdateSettings, new SettingsUser((class_1657)player), MapFrontiers.isOPorHost(player), null)) {
                FrontiersManager.instance.setSettings(message.settings);
                for (class_3222 p : server.method_3760().method_14571()) {
                    PacketHandler.sendTo(new PacketSettingsProfile(FrontiersManager.instance.getSettings().getProfile(p)), p);
                }
            } else {
                PacketHandler.sendTo(new PacketSettingsProfile(FrontiersManager.instance.getSettings().getProfile(player)), player);
            }
        } else if (Side.CLIENT.equals((Object)ctx.side()) && class_310.method_1551().field_1755 instanceof ModSettings) {
            ((ModSettings)class_310.method_1551().field_1755).setFrontierSettings(message.settings);
        }
    }
}

