/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common.network;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.FrontiersManager;
import games.alejandrocoria.mapfrontiers.common.network.PacketFrontierDeleted;
import games.alejandrocoria.mapfrontiers.common.network.PacketFrontierUpdated;
import games.alejandrocoria.mapfrontiers.common.network.PacketHandler;
import games.alejandrocoria.mapfrontiers.common.network.PacketSettingsProfile;
import games.alejandrocoria.mapfrontiers.common.settings.FrontierSettings;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUserShared;
import games.alejandrocoria.mapfrontiers.common.util.UUIDHelper;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;

@ParametersAreNonnullByDefault
public class PacketRemoveSharedUserPersonalFrontier {
    public static final class_2960 CHANNEL = class_2960.method_60655((String)"mapfrontiers", (String)"packet_remove_shared_user_personal_frontier");
    public static final class_9139<class_9129, PacketRemoveSharedUserPersonalFrontier> STREAM_CODEC = class_9139.method_56438(PacketRemoveSharedUserPersonalFrontier::encode, PacketRemoveSharedUserPersonalFrontier::new);
    private UUID frontierID;
    private final SettingsUser targetUser;

    public PacketRemoveSharedUserPersonalFrontier(UUID frontierID, SettingsUser user) {
        this.frontierID = frontierID;
        this.targetUser = user;
    }

    public static class_8710.class_9154<class_8710> type() {
        return new class_8710.class_9154(CHANNEL);
    }

    public PacketRemoveSharedUserPersonalFrontier(class_2540 buf) {
        this.targetUser = new SettingsUser();
        try {
            if (buf.readableBytes() > 1) {
                this.frontierID = UUIDHelper.fromBytes((ByteBuf)buf);
                this.targetUser.fromBytes(buf);
            }
        }
        catch (Throwable t) {
            MapFrontiers.LOGGER.error(String.format("Failed to read message for PacketRemoveSharedUserPersonalFrontier: %s", t));
        }
    }

    public void encode(class_2540 buf) {
        try {
            UUIDHelper.toBytes((ByteBuf)buf, this.frontierID);
            this.targetUser.toBytes(buf);
        }
        catch (Throwable t) {
            MapFrontiers.LOGGER.error(String.format("Failed to write message for PacketRemoveSharedUserPersonalFrontier: %s", t));
        }
    }

    public static void handle(PacketContext<PacketRemoveSharedUserPersonalFrontier> ctx) {
        if (Side.SERVER.equals((Object)ctx.side())) {
            PacketRemoveSharedUserPersonalFrontier message = (PacketRemoveSharedUserPersonalFrontier)ctx.message();
            class_3222 player = ctx.sender();
            if (player == null) {
                return;
            }
            MinecraftServer server = player.method_5682();
            SettingsUser playerUser = new SettingsUser((class_1657)player);
            message.targetUser.fillMissingInfo(false, server);
            if (message.targetUser.uuid == null) {
                return;
            }
            FrontierData currentFrontier = FrontiersManager.instance.getFrontierFromID(message.frontierID);
            if (currentFrontier != null && currentFrontier.getPersonal()) {
                if (FrontiersManager.instance.getSettings().checkAction(FrontierSettings.Action.SharePersonalFrontier, playerUser, MapFrontiers.isOPorHost(player), currentFrontier.getOwner())) {
                    SettingsUserShared userShared = currentFrontier.getUserShared(message.targetUser);
                    if (userShared == null || userShared.getUser().equals(playerUser)) {
                        return;
                    }
                    if (currentFrontier.checkActionUserShared(playerUser, SettingsUserShared.Action.UpdateSettings)) {
                        currentFrontier.removeUserShared(message.targetUser);
                        if (userShared.isPending()) {
                            FrontiersManager.instance.removePendingShareFrontier(message.targetUser);
                        } else {
                            FrontiersManager.instance.deletePersonalFrontier(message.targetUser, currentFrontier.getDimension(), message.frontierID);
                            class_3222 targetPlayer = server.method_3760().method_14602(message.targetUser.uuid);
                            if (targetPlayer != null) {
                                PacketHandler.sendTo(new PacketFrontierDeleted(currentFrontier.getDimension(), message.frontierID, true, -1), targetPlayer);
                            }
                        }
                        PacketHandler.sendToUsersWithAccess(new PacketFrontierUpdated(currentFrontier, player.method_5628()), currentFrontier, server);
                        currentFrontier.removeChange(FrontierData.Change.Shared);
                    }
                } else {
                    PacketHandler.sendTo(new PacketSettingsProfile(FrontiersManager.instance.getSettings().getProfile(player)), player);
                }
            }
        }
    }
}

