/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client;

import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.platform.Services;
import it.unimi.dsi.fastutil.Pair;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;

public class FrontierLocalOverrides {
    private final Map<UUID, Pair<FrontierData.VisibilityData, FrontierData.VisibilityData>> overrides = new HashMap<UUID, Pair<FrontierData.VisibilityData, FrontierData.VisibilityData>>();
    private File ModDir;

    public FrontierLocalOverrides() {
        this.loadData();
    }

    public Pair<FrontierData.VisibilityData, FrontierData.VisibilityData> getVisibility(UUID id) {
        Pair<FrontierData.VisibilityData, FrontierData.VisibilityData> override = this.overrides.get(id);
        if (override == null) {
            return Pair.of((Object)new FrontierData.VisibilityData(), (Object)new FrontierData.VisibilityData(false));
        }
        return override;
    }

    public void setVisibility(UUID id, Pair<FrontierData.VisibilityData, FrontierData.VisibilityData> visibility) {
        if (((FrontierData.VisibilityData)visibility.second()).hasSome()) {
            this.overrides.put(id, visibility);
        } else {
            this.overrides.remove(id);
        }
        this.saveData();
    }

    private boolean readFromNBT(CompoundTag nbt) {
        boolean needBackup = false;
        try {
            int version = nbt.getIntOr("Version", 0);
            if (version == 0) {
                MapFrontiers.LOGGER.warn("Data version in frontier_overrides not found, expected 10");
                needBackup = true;
            } else if (version > 10) {
                MapFrontiers.LOGGER.warn("Data version in frontier_overrides higher than expected. The mod uses 10");
                needBackup = true;
            }
            ListTag overridesTagList = nbt.getListOrEmpty("overrides");
            for (int i = 0; i < overridesTagList.size(); ++i) {
                CompoundTag overrideTag = (CompoundTag)overridesTagList.getCompound(i).get();
                UUID id = UUID.fromString((String)overrideTag.getString("id").get());
                CompoundTag dataTag = (CompoundTag)overrideTag.getCompound("data").get();
                FrontierData.VisibilityData data = new FrontierData.VisibilityData();
                data.readFromNBT(dataTag, version);
                CompoundTag maskTag = (CompoundTag)overrideTag.getCompound("mask").get();
                FrontierData.VisibilityData mask = new FrontierData.VisibilityData(false);
                mask.readFromNBT(maskTag, version);
                if (!mask.hasSome()) continue;
                this.overrides.put(id, (Pair<FrontierData.VisibilityData, FrontierData.VisibilityData>)Pair.of((Object)data, (Object)mask));
            }
        }
        catch (Exception ignored) {
            return true;
        }
        return needBackup;
    }

    private void writeToNBT(CompoundTag nbt) {
        ListTag overridesTagList = new ListTag();
        for (Map.Entry<UUID, Pair<FrontierData.VisibilityData, FrontierData.VisibilityData>> override : this.overrides.entrySet()) {
            CompoundTag overrideTag = new CompoundTag();
            overrideTag.putString("id", override.getKey().toString());
            CompoundTag dataTag = new CompoundTag();
            ((FrontierData.VisibilityData)override.getValue().first()).writeToNBT(dataTag);
            overrideTag.put("data", (Tag)dataTag);
            CompoundTag maskTag = new CompoundTag();
            ((FrontierData.VisibilityData)override.getValue().second()).writeToNBT(maskTag);
            overrideTag.put("mask", (Tag)maskTag);
            overridesTagList.add((Object)overrideTag);
        }
        nbt.put("overrides", (Tag)overridesTagList);
        nbt.putInt("Version", 10);
    }

    private void loadData() {
        try {
            File jmDir = Services.JOURNEYMAP.getJMWorldDir(Minecraft.getInstance());
            this.ModDir = new File(jmDir, "mapfrontier");
            this.ModDir.mkdirs();
            CompoundTag nbtFrontiers = this.loadFile("frontier_overrides.dat");
            if (!nbtFrontiers.isEmpty() && this.readFromNBT(nbtFrontiers)) {
                MapFrontiers.createBackup(this.ModDir, "frontier_overrides.dat");
                this.saveData();
            }
        }
        catch (Exception e) {
            MapFrontiers.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private void saveData() {
        if (this.ModDir != null) {
            CompoundTag nbtFrontiers = new CompoundTag();
            this.writeToNBT(nbtFrontiers);
            this.saveFile("frontier_overrides.dat", nbtFrontiers);
        }
    }

    private void saveFile(String filename, CompoundTag nbt) {
        try {
            File f = new File(this.ModDir, filename);
            try (FileOutputStream outputStream = new FileOutputStream(f);){
                NbtIo.writeCompressed((CompoundTag)nbt, (OutputStream)outputStream);
            }
            catch (Exception e) {
                MapFrontiers.LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        catch (Exception e) {
            MapFrontiers.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private CompoundTag loadFile(String filename) {
        File f = new File(this.ModDir, filename);
        if (f.exists()) {
            CompoundTag compoundTag;
            FileInputStream inputStream = new FileInputStream(f);
            try {
                compoundTag = NbtIo.readCompressed((InputStream)inputStream, (NbtAccounter)NbtAccounter.unlimitedHeap());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    MapFrontiers.LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
            inputStream.close();
            return compoundTag;
        }
        return new CompoundTag();
    }
}

