/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component;

import games.alejandrocoria.mapfrontiers.client.mixin.AbstractSliderButtonAccessor;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;

@ParametersAreNonnullByDefault
public class SimpleSlider
extends AbstractSliderButton {
    private final Font font;
    private final int minValue;
    private final int maxValue;
    private final ValueChanged callback;
    private boolean dragging = false;
    private final String translationKey;

    public SimpleSlider(Font font, int width, String translationKey, int minValue, int maxValue, int initialValue, ValueChanged callback) {
        super(0, 0, width, 16, (Component)Component.literal((String)String.valueOf(initialValue)), SimpleSlider.normalize(initialValue, minValue, maxValue));
        this.font = font;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.callback = callback;
        this.translationKey = translationKey;
        this.updateMessage();
    }

    private static double normalize(int value, int min, int max) {
        return (double)(value - min) / (double)(max - min);
    }

    private int denormalize(double value) {
        return (int)Math.round((double)this.minValue + value * (double)(this.maxValue - this.minValue));
    }

    protected void updateMessage() {
        this.setMessage((Component)Component.translatable((String)this.translationKey, (Object[])new Object[]{this.denormalize(this.value)}));
    }

    protected void applyValue() {
        int val = this.denormalize(this.value);
        this.callback.onChanged(val, this.dragging);
    }

    public void setValue(int value) {
        this.value = SimpleSlider.normalize(value, this.minValue, this.maxValue);
        this.updateMessage();
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double hDelta, double vDelta) {
        if (this.visible && this.isHovered) {
            int val = this.denormalize(this.value);
            val = vDelta > 0.0 ? Math.min(val + 1, this.maxValue) : Math.max(val - 1, this.minValue);
            this.setValue(val);
            this.applyValue();
            return true;
        }
        return false;
    }

    protected void onDrag(MouseButtonEvent event, double dragX, double dragY) {
        this.dragging = true;
        super.onDrag(event, dragX, dragY);
    }

    public void mouseReleased() {
        if (this.dragging) {
            this.dragging = false;
            this.applyValue();
        }
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int lineColor = ((AbstractSliderButtonAccessor)((Object)this)).getCanChangeValue() ? -1 : -8947849;
        graphics.hLine(this.getX(), this.getX() + this.width - 1, this.getY(), lineColor);
        graphics.hLine(this.getX(), this.getX() + this.width - 1, this.getY() + this.height - 1, lineColor);
        graphics.vLine(this.getX(), this.getY(), this.getY() + this.height - 1, lineColor);
        graphics.vLine(this.getX() + this.width - 1, this.getY(), this.getY() + this.height - 1, lineColor);
        int handleX = this.getX() + (int)(this.value * (double)(this.width - 6)) + 1;
        graphics.fill(handleX, this.getY() + 1, handleX + 4, this.getY() + this.height - 1, this.isHoveredOrFocused() ? -1 : -5592406);
        graphics.drawCenteredString(this.font, this.getMessage(), this.getX() + this.width / 2, this.getY() + 5, this.isHovered ? -1 : -6710887);
    }

    public static interface ValueChanged {
        public void onChanged(int var1, boolean var2);
    }
}

