/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component.scroll;

import games.alejandrocoria.mapfrontiers.client.gui.component.button.IconButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.scroll.ScrollBox;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsGroup;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.resources.language.I18n;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class GroupElement
extends ScrollBox.ScrollElement {
    private final Font font;
    private final SettingsGroup group;
    private IconButton buttonDelete;

    public GroupElement(Font font, SettingsGroup group) {
        super(160, 16);
        this.font = font;
        this.group = group;
        if (!group.isSpecial()) {
            this.buttonDelete = new IconButton(IconButton.Type.Remove, button -> {});
        }
    }

    public SettingsGroup getGroup() {
        return this.group;
    }

    @Override
    protected void setX(int x) {
        super.setX(x);
        if (this.buttonDelete != null) {
            this.buttonDelete.setX(this.x + 145);
        }
    }

    @Override
    protected void setY(int y) {
        super.setY(y);
        if (this.buttonDelete != null) {
            this.buttonDelete.setY(this.y + 1);
        }
    }

    @Override
    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks, boolean selected, boolean focused) {
        String text;
        int color = -4144960;
        if (selected) {
            color = -1;
        }
        if (this.isHovered) {
            graphics.fill(this.x, this.y, this.x + this.width, this.y + this.height, -1607454672);
        }
        if (this.buttonDelete != null && (this.isHovered || focused)) {
            this.buttonDelete.render(graphics, mouseX, mouseY, partialTicks);
        }
        if ((text = this.group.getName()).isEmpty()) {
            text = I18n.get((String)"mapfrontiers.unnamed", (Object[])new Object[]{ChatFormatting.ITALIC});
        }
        graphics.drawString(this.font, text, this.x + 4, this.y + 4, color);
    }

    @Override
    protected ScrollBox.ScrollElement.Action mousePressed(MouseButtonEvent event, boolean doubleClick) {
        if (this.visible && this.isHovered) {
            if (this.buttonDelete != null && this.buttonDelete.isMouseOver(event.x(), event.y())) {
                return ScrollBox.ScrollElement.Action.Deleted;
            }
            return ScrollBox.ScrollElement.Action.Clicked;
        }
        return ScrollBox.ScrollElement.Action.None;
    }

    @Override
    protected boolean canBeDeleted() {
        return true;
    }
}

