/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component.textbox;

import games.alejandrocoria.mapfrontiers.client.gui.component.textbox.TextBox;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import org.apache.commons.lang3.StringUtils;

@ParametersAreNonnullByDefault
public class TextBoxUser
extends TextBox {
    private final Minecraft mc;
    private final Font font;
    private String partialText;
    private final List<String> suggestions;
    private final List<String> suggestionsToDraw;
    private Component error;
    private int maxSuggestionWidth = 0;
    private int suggestionIndex = 0;

    public TextBoxUser(Minecraft mc, Font font, int width) {
        this(mc, font, width, "");
    }

    public TextBoxUser(Minecraft mc, Font font, int width, String defaultText) {
        super(font, width, defaultText);
        this.mc = mc;
        this.font = font;
        this.suggestions = new ArrayList<String>();
        this.suggestionsToDraw = new ArrayList<String>();
        this.setError(null);
    }

    public void setError(@Nullable Component error) {
        this.error = error;
        if (this.error != null) {
            this.suggestions.clear();
            this.suggestionsToDraw.clear();
        }
    }

    @Override
    public boolean keyPressed(KeyEvent event) {
        if (event.input() == 342) {
            if (this.suggestions.isEmpty()) {
                this.suggestionIndex = 0;
                ClientPacketListener handler = this.mc.getConnection();
                if (!StringUtils.isBlank((CharSequence)this.getValue()) && handler != null) {
                    this.partialText = this.getValue();
                    for (PlayerInfo playerInfo : handler.getOnlinePlayers()) {
                        String name = playerInfo.getProfile().name();
                        if (name == null || !name.regionMatches(true, 0, this.partialText, 0, this.partialText.length())) continue;
                        this.suggestions.add(name);
                    }
                }
            } else {
                ++this.suggestionIndex;
                if (this.suggestionIndex >= this.suggestions.size()) {
                    this.suggestionIndex = 0;
                }
            }
            this.suggestionsToDraw.clear();
            if (!this.suggestions.isEmpty()) {
                this.setValue(this.suggestions.get(this.suggestionIndex));
                if (this.suggestions.size() == 1) {
                    this.suggestions.clear();
                } else {
                    this.maxSuggestionWidth = 0;
                    int size = this.suggestions.size();
                    if (size > 7) {
                        size = 7;
                    }
                    int firstIndex = 0;
                    if (this.suggestionIndex > 6) {
                        firstIndex = this.suggestionIndex - 6;
                    }
                    for (int i = firstIndex; i < firstIndex + size; ++i) {
                        this.suggestionsToDraw.add(this.suggestions.get(i));
                        int textWidth = this.font.width(this.suggestions.get(i));
                        if (textWidth <= this.maxSuggestionWidth) continue;
                        this.maxSuggestionWidth = textWidth;
                    }
                }
            }
            return true;
        }
        this.suggestions.clear();
        this.suggestionsToDraw.clear();
        return super.keyPressed(event);
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        block7: {
            block6: {
                if (this.error == null) {
                    this.setTextColor(-2039584);
                } else {
                    this.setTextColor(-2289391);
                }
                super.renderWidget(graphics, mouseX, mouseY, partialTicks);
                if (this.error == null) break block6;
                List errorList = this.font.split((FormattedText)this.error, this.width - 8);
                int maxErrorWidth = this.width - 8;
                graphics.fill(this.getX() - 1, this.getY() - errorList.size() * 12 - 5, this.getX() + maxErrorWidth + 9, this.getY() - 1, -6250336);
                graphics.fill(this.getX(), this.getY() - errorList.size() * 12 - 4, this.getX() + maxErrorWidth + 8, this.getY() - 1, -16777216);
                int posX = this.getX() + 4;
                int posY = this.getY() - errorList.size() * 12;
                for (FormattedCharSequence e : errorList) {
                    graphics.drawString(this.font, e, posX, posY, -1);
                    posY += 12;
                }
                break block7;
            }
            if (this.suggestionsToDraw.isEmpty()) break block7;
            graphics.fill(this.getX() - 1, this.getY() - this.suggestionsToDraw.size() * 12 - 5, this.getX() + this.maxSuggestionWidth + 9, this.getY() - 1, -6250336);
            graphics.fill(this.getX(), this.getY() - this.suggestionsToDraw.size() * 12 - 4, this.getX() + this.maxSuggestionWidth + 8, this.getY() - 1, -16777216);
            int posX = this.getX() + 4;
            int posY = this.getY() - 12;
            for (int i = this.suggestionsToDraw.size() - 1; i >= 0; --i) {
                String t = this.suggestionsToDraw.get(i);
                if (this.suggestionsToDraw.get(i) == this.suggestions.get(this.suggestionIndex)) {
                    graphics.drawString(this.font, t, posX, posY, -1);
                } else {
                    String suffix = t.substring(0, this.partialText.length());
                    String rest = t.substring(this.partialText.length());
                    graphics.drawString(this.font, suffix, posX, posY, -1);
                    graphics.drawString(this.font, rest, posX + this.font.width(suffix), posY, 0xAAAAAA);
                }
                posY -= 12;
            }
        }
    }

    @Override
    public void setFocused(boolean isFocusedIn) {
        super.setFocused(isFocusedIn);
        if (!isFocusedIn) {
            this.suggestions.clear();
            this.suggestionsToDraw.clear();
        } else {
            this.setError(null);
        }
    }
}

