/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.dialog;

import games.alejandrocoria.mapfrontiers.client.gui.component.StringWidget;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.CheckBoxButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.OptionButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.SimpleButton;
import games.alejandrocoria.mapfrontiers.client.gui.screen.AutoScaledScreen;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.layouts.SpacerElement;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;

@ParametersAreNonnullByDefault
public class VisibilityDialog
extends AutoScaledScreen {
    private static final Component generalLabel = Component.translatable((String)"mapfrontiers.general");
    private static final Component showFrontierLabel = Component.translatable((String)"mapfrontiers.show_frontier");
    private static final Component announceInChatLabel = Component.translatable((String)"mapfrontiers.announce_in_chat");
    private static final Component announceInTitleLabel = Component.translatable((String)"mapfrontiers.announce_in_title");
    private static final Component fullscreenLabel = Component.translatable((String)"mapfrontiers.fullscreen");
    private static final Component showNameLabel = Component.translatable((String)"mapfrontiers.show_name");
    private static final Component showOwnerLabel = Component.translatable((String)"mapfrontiers.show_owner");
    private static final Component showBannerLabel = Component.translatable((String)"mapfrontiers.show_banner");
    private static final Component minimapLabel = Component.translatable((String)"mapfrontiers.minimap");
    private static final Component webmapLabel = Component.translatable((String)"mapfrontiers.webmap");
    private static final Component dayLabel = Component.translatable((String)"mapfrontiers.day");
    private static final Component nightLabel = Component.translatable((String)"mapfrontiers.night");
    private static final Component undergroundLabel = Component.translatable((String)"mapfrontiers.underground");
    private static final Component topoLabel = Component.translatable((String)"mapfrontiers.topo");
    private static final Component biomeLabel = Component.translatable((String)"mapfrontiers.biome");
    private static final Component doneLabel = Component.translatable((String)"gui.done");
    private static final Component onLabel = Component.translatable((String)"options.on");
    private static final Component offLabel = Component.translatable((String)"options.off");
    private final FrontierData.VisibilityData visibilityData;
    @Nullable
    private final FrontierData.VisibilityData visibilityMask;
    private final BiConsumer<FrontierData.VisibilityData, FrontierData.VisibilityData> afterDoneCallback;
    protected SimpleButton doneButton;

    public VisibilityDialog(FrontierData.VisibilityData visibilityData, BiConsumer<FrontierData.VisibilityData, FrontierData.VisibilityData> afterDoneCallback) {
        super((Component)Component.empty(), 554, 191);
        this.visibilityData = new FrontierData.VisibilityData(visibilityData);
        this.visibilityMask = null;
        this.afterDoneCallback = afterDoneCallback;
    }

    public VisibilityDialog(FrontierData.VisibilityData visibilityData, FrontierData.VisibilityData visibilityDataMask, BiConsumer<FrontierData.VisibilityData, FrontierData.VisibilityData> afterDoneCallback) {
        super((Component)Component.empty(), 554, 191);
        this.visibilityData = new FrontierData.VisibilityData(visibilityData);
        this.visibilityMask = new FrontierData.VisibilityData(visibilityDataMask);
        this.afterDoneCallback = afterDoneCallback;
    }

    @Override
    protected void initScreen() {
        LinearLayout mainLayout = LinearLayout.vertical().spacing(8);
        mainLayout.defaultCellSetting().alignHorizontallyCenter();
        this.content.addChild((LayoutElement)mainLayout);
        LinearLayout mainColumns = LinearLayout.horizontal().spacing(16);
        mainLayout.addChild((LayoutElement)mainColumns);
        LinearLayout generalColumn = LinearLayout.vertical().spacing(6);
        generalColumn.defaultCellSetting().alignHorizontallyCenter();
        mainColumns.addChild((LayoutElement)generalColumn);
        generalColumn.addChild((LayoutElement)new StringWidget((Component)generalLabel.copy().withStyle(Style.EMPTY.withBold(Boolean.valueOf(true))), this.font).setColor(-4144960));
        GridLayout generalGrid = new GridLayout().spacing(4);
        generalColumn.addChild((LayoutElement)generalGrid);
        int row = 1;
        this.createWidgets(generalGrid, row++, showFrontierLabel, FrontierData.VisibilityData.Visibility.Frontier);
        generalGrid.addChild((LayoutElement)SpacerElement.height((int)2), row++, 0);
        this.createWidgets(generalGrid, row++, announceInChatLabel, FrontierData.VisibilityData.Visibility.AnnounceInChat);
        this.createWidgets(generalGrid, row++, announceInTitleLabel, FrontierData.VisibilityData.Visibility.AnnounceInTitle);
        LinearLayout fullscreenColumn = LinearLayout.vertical().spacing(6);
        fullscreenColumn.defaultCellSetting().alignHorizontallyCenter();
        mainColumns.addChild((LayoutElement)fullscreenColumn);
        fullscreenColumn.addChild((LayoutElement)new StringWidget((Component)fullscreenLabel.copy().withStyle(Style.EMPTY.withBold(Boolean.valueOf(true))), this.font).setColor(-4144960));
        GridLayout fullscreenGrid = new GridLayout().spacing(4);
        fullscreenColumn.addChild((LayoutElement)fullscreenGrid);
        row = 1;
        this.createWidgets(fullscreenGrid, row++, showFrontierLabel, FrontierData.VisibilityData.Visibility.Fullscreen);
        fullscreenGrid.addChild((LayoutElement)SpacerElement.height((int)2), row++, 0);
        this.createWidgets(fullscreenGrid, row++, showNameLabel, FrontierData.VisibilityData.Visibility.FullscreenName);
        this.createWidgets(fullscreenGrid, row++, showOwnerLabel, FrontierData.VisibilityData.Visibility.FullscreenOwner);
        this.createWidgets(fullscreenGrid, row++, showBannerLabel, FrontierData.VisibilityData.Visibility.FullscreenBanner);
        fullscreenGrid.addChild((LayoutElement)SpacerElement.height((int)2), row++, 0);
        this.createWidgets(fullscreenGrid, row++, dayLabel, FrontierData.VisibilityData.Visibility.FullscreenDay);
        this.createWidgets(fullscreenGrid, row++, nightLabel, FrontierData.VisibilityData.Visibility.FullscreenNight);
        this.createWidgets(fullscreenGrid, row++, undergroundLabel, FrontierData.VisibilityData.Visibility.FullscreenUnderground);
        this.createWidgets(fullscreenGrid, row++, topoLabel, FrontierData.VisibilityData.Visibility.FullscreenTopo);
        this.createWidgets(fullscreenGrid, row++, biomeLabel, FrontierData.VisibilityData.Visibility.FullscreenBiome);
        LinearLayout minimapColumn = LinearLayout.vertical().spacing(6);
        minimapColumn.defaultCellSetting().alignHorizontallyCenter();
        mainColumns.addChild((LayoutElement)minimapColumn);
        minimapColumn.addChild((LayoutElement)new StringWidget((Component)minimapLabel.copy().withStyle(Style.EMPTY.withBold(Boolean.valueOf(true))), this.font).setColor(-4144960));
        GridLayout minimapGrid = new GridLayout().spacing(4);
        minimapColumn.addChild((LayoutElement)minimapGrid);
        row = 1;
        this.createWidgets(minimapGrid, row++, showFrontierLabel, FrontierData.VisibilityData.Visibility.Minimap);
        minimapGrid.addChild((LayoutElement)SpacerElement.height((int)2), row++, 0);
        this.createWidgets(minimapGrid, row++, showNameLabel, FrontierData.VisibilityData.Visibility.MinimapName);
        this.createWidgets(minimapGrid, row++, showOwnerLabel, FrontierData.VisibilityData.Visibility.MinimapOwner);
        this.createWidgets(minimapGrid, row++, showBannerLabel, FrontierData.VisibilityData.Visibility.MinimapBanner);
        minimapGrid.addChild((LayoutElement)SpacerElement.height((int)2), row++, 0);
        this.createWidgets(minimapGrid, row++, dayLabel, FrontierData.VisibilityData.Visibility.MinimapDay);
        this.createWidgets(minimapGrid, row++, nightLabel, FrontierData.VisibilityData.Visibility.MinimapNight);
        this.createWidgets(minimapGrid, row++, undergroundLabel, FrontierData.VisibilityData.Visibility.MinimapUnderground);
        this.createWidgets(minimapGrid, row++, topoLabel, FrontierData.VisibilityData.Visibility.MinimapTopo);
        this.createWidgets(minimapGrid, row++, biomeLabel, FrontierData.VisibilityData.Visibility.MinimapBiome);
        LinearLayout webmapColumn = LinearLayout.vertical().spacing(6);
        webmapColumn.defaultCellSetting().alignHorizontallyCenter();
        mainColumns.addChild((LayoutElement)webmapColumn);
        webmapColumn.addChild((LayoutElement)new StringWidget((Component)webmapLabel.copy().withStyle(Style.EMPTY.withBold(Boolean.valueOf(true))), this.font).setColor(-4144960));
        GridLayout webmapGrid = new GridLayout().spacing(4);
        webmapColumn.addChild((LayoutElement)webmapGrid);
        row = 1;
        this.createWidgets(webmapGrid, row++, showFrontierLabel, FrontierData.VisibilityData.Visibility.Webmap);
        webmapGrid.addChild((LayoutElement)SpacerElement.height((int)2), row++, 0);
        this.createWidgets(webmapGrid, row++, showNameLabel, FrontierData.VisibilityData.Visibility.WebmapName);
        this.createWidgets(webmapGrid, row++, showOwnerLabel, FrontierData.VisibilityData.Visibility.WebmapOwner);
        this.createWidgets(webmapGrid, row++, showBannerLabel, FrontierData.VisibilityData.Visibility.WebmapBanner);
        webmapGrid.addChild((LayoutElement)SpacerElement.height((int)2), row++, 0);
        this.createWidgets(webmapGrid, row++, dayLabel, FrontierData.VisibilityData.Visibility.WebmapDay);
        this.createWidgets(webmapGrid, row++, nightLabel, FrontierData.VisibilityData.Visibility.WebmapNight);
        this.createWidgets(webmapGrid, row++, undergroundLabel, FrontierData.VisibilityData.Visibility.WebmapUnderground);
        this.createWidgets(webmapGrid, row++, topoLabel, FrontierData.VisibilityData.Visibility.WebmapTopo);
        this.createWidgets(webmapGrid, row++, biomeLabel, FrontierData.VisibilityData.Visibility.WebmapBiome);
        this.doneButton = (SimpleButton)mainLayout.addChild((LayoutElement)new SimpleButton(this.font, 100, doneLabel, b -> this.onClose()));
    }

    private void createWidgets(GridLayout layout, int row, Component label, FrontierData.VisibilityData.Visibility visibility) {
        layout.addChild((LayoutElement)new StringWidget(label, this.font).setColor(-4144960), row, 0);
        OptionButton button = new OptionButton(this.font, 28, b -> this.visibilityData.setValue(visibility, b.getSelected() == 0));
        button.addOption(onLabel);
        button.addOption(offLabel);
        button.setSelected(this.visibilityData.getValue(visibility) ? 0 : 1);
        layout.addChild((LayoutElement)button, row, 2);
        if (this.visibilityMask != null) {
            CheckBoxButton checkBox = new CheckBoxButton(this.visibilityMask.getValue(visibility), b -> {
                this.visibilityMask.setValue(visibility, b.isChecked());
                button.active = b.isChecked();
            });
            layout.addChild((LayoutElement)checkBox, row, 1);
            button.active = checkBox.isChecked();
        }
    }

    @Override
    public void renderScaledBackgroundScreen(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.drawCenteredBoxBackground(graphics, this.content.getWidth() + 20, this.content.getHeight() + 20);
    }

    public void onClose() {
        super.onClose();
        this.afterDoneCallback.accept(this.visibilityData, this.visibilityMask);
    }
}

