/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.screen;

import games.alejandrocoria.mapfrontiers.client.FrontierOverlay;
import games.alejandrocoria.mapfrontiers.client.FrontiersOverlayManager;
import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.client.gui.ColorConstants;
import games.alejandrocoria.mapfrontiers.client.gui.component.ColorPaletteWidget;
import games.alejandrocoria.mapfrontiers.client.gui.component.ColorPicker;
import games.alejandrocoria.mapfrontiers.client.gui.component.SimpleSlider;
import games.alejandrocoria.mapfrontiers.client.gui.component.StringWidget;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.IconButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.OptionButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.SimpleButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.textbox.TextBox;
import games.alejandrocoria.mapfrontiers.client.gui.component.textbox.TextBoxInt;
import games.alejandrocoria.mapfrontiers.client.gui.dialog.ConfirmationDialog;
import games.alejandrocoria.mapfrontiers.client.gui.dialog.DeleteConfirmationDialog;
import games.alejandrocoria.mapfrontiers.client.gui.dialog.VisibilityDialog;
import games.alejandrocoria.mapfrontiers.client.gui.screen.AutoScaledScreen;
import games.alejandrocoria.mapfrontiers.client.gui.screen.SendFrontier;
import games.alejandrocoria.mapfrontiers.client.gui.screen.ShareSettings;
import games.alejandrocoria.mapfrontiers.common.Config;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.network.PacketChangeFrontierToGlobal;
import games.alejandrocoria.mapfrontiers.common.network.PacketChangeFrontierToPersonal;
import games.alejandrocoria.mapfrontiers.common.network.PacketHandler;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsProfile;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.common.util.ColorHelper;
import games.alejandrocoria.mapfrontiers.platform.Services;
import it.unimi.dsi.fastutil.Pair;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Objects;
import java.util.Stack;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.api.v2.client.IClientAPI;
import journeymap.api.v2.client.display.Context;
import journeymap.api.v2.client.util.UIState;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.layouts.SpacerElement;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.ItemStack;

@ParametersAreNonnullByDefault
public class FrontierInfo
extends AutoScaledScreen {
    static final DateFormat dateFormat = new SimpleDateFormat();
    private static final Component titleLabel = Component.translatable((String)"mapfrontiers.title_info");
    private static final Component assignBannerLabel = Component.translatable((String)"mapfrontiers.assign_banner");
    private static final Component assignBannerWarnLabel = assignBannerLabel.copy().append((Component)Component.literal((String)(String.valueOf(ColorConstants.WARNING) + " !")));
    private static final Component removeBannerLabel = Component.translatable((String)"mapfrontiers.remove_banner");
    private static final String bannerRotationKey = "mapfrontiers.banner_rotation";
    private static final Component nameLabel = Component.translatable((String)"mapfrontiers.name");
    private static final Component personalLabel = Component.translatable((String)"mapfrontiers.config.Personal");
    private static final Component globalLabel = Component.translatable((String)"mapfrontiers.config.Global");
    private static final String verticesKey = "mapfrontiers.vertices";
    private static final String chunksKey = "mapfrontiers.chunks";
    private static final String ownerKey = "mapfrontiers.owner";
    private static final String originalOwnerKey = "mapfrontiers.original_owner";
    private static final String dimensionKey = "mapfrontiers.dimension";
    private static final String areaKey = "mapfrontiers.area";
    private static final String perimeterKey = "mapfrontiers.perimeter";
    private static final String createdKey = "mapfrontiers.created";
    private static final String modifiedKey = "mapfrontiers.modified";
    private static final Component visibilityLabel = Component.translatable((String)"mapfrontiers.visibility");
    private static final Component visibilityOverrideLabel = Component.translatable((String)"mapfrontiers.visibility_override");
    private static final Component colorLabel = Component.translatable((String)"mapfrontiers.color");
    private static final Component rLabel = Component.literal((String)"R");
    private static final Component gLabel = Component.literal((String)"G");
    private static final Component bLabel = Component.literal((String)"B");
    private static final Component randomColorLabel = Component.translatable((String)"mapfrontiers.random_color");
    private static final Component pasteNameLabel = Component.translatable((String)"mapfrontiers.paste_name");
    private static final Component pasteVisibilityLabel = Component.translatable((String)"mapfrontiers.paste_visibility");
    private static final Component pasteColorLabel = Component.translatable((String)"mapfrontiers.paste_color");
    private static final Component pasteBannerLabel = Component.translatable((String)"mapfrontiers.paste_banner");
    private static final Component selectInMapLabel = Component.translatable((String)"mapfrontiers.select_in_map");
    private static final Component shareSettingsLabel = Component.translatable((String)"mapfrontiers.share_settings");
    private static final Component sendLabel = Component.translatable((String)"mapfrontiers.send");
    private static final Component deleteLabel = Component.translatable((String)"mapfrontiers.delete");
    private static final Component doneLabel = Component.translatable((String)"gui.done");
    private static final Component onLabel = Component.translatable((String)"options.on");
    private static final Component offLabel = Component.translatable((String)"options.off");
    private static final Tooltip visibilityTooltip = Tooltip.create((Component)Component.translatable((String)"mapfrontiers.visibility.tooltip"));
    private static final Tooltip visibilityOverrideTooltip = Tooltip.create((Component)Component.translatable((String)"mapfrontiers.visibility_override.tooltip"));
    private static final Tooltip copyTooltip = Tooltip.create((Component)Component.translatable((String)"mapfrontiers.copy"));
    private static final Tooltip pasteTooltip = Tooltip.create((Component)Component.translatable((String)"mapfrontiers.paste"));
    private static final Tooltip openPasteTooltip = Tooltip.create((Component)Component.translatable((String)"mapfrontiers.open_paste_options"));
    private static final Tooltip closePasteTooltip = Tooltip.create((Component)Component.translatable((String)"mapfrontiers.close_paste_options"));
    private static final Tooltip undoTooltip = Tooltip.create((Component)Component.translatable((String)"mapfrontiers.undo"));
    private static final Tooltip redoTooltip = Tooltip.create((Component)Component.translatable((String)"mapfrontiers.redo"));
    private static final Tooltip changeToPersonalTooltip = Tooltip.create((Component)Component.translatable((String)"mapfrontiers.change_to_personal"));
    private static final Tooltip changeToGlobalTooltip = Tooltip.create((Component)Component.translatable((String)"mapfrontiers.change_to_global"));
    private static final Tooltip assignBannerWarnTooltip = Tooltip.create((Component)Component.literal((String)(String.valueOf(ColorConstants.WARNING) + "! " + String.valueOf(ChatFormatting.RESET))).append((Component)Component.translatable((String)"mapfrontiers.assign_banner_warn")));
    private final IClientAPI jmAPI;
    private final FrontiersOverlayManager frontiersOverlayManager;
    private final FrontierOverlay frontier;
    private int frontierHash;
    private TextBox textName1;
    private TextBox textName2;
    private SimpleButton buttonVisibility;
    private SimpleButton buttonVisibilityOverride;
    private TextBoxInt textRed;
    private TextBoxInt textGreen;
    private TextBoxInt textBlue;
    private SimpleButton buttonRandomColor;
    private ColorPicker colorPicker;
    private ColorPaletteWidget colorPalette;
    private IconButton buttonCopy;
    private IconButton buttonPaste;
    private IconButton buttonPasteOptions;
    private OptionButton buttonPasteName;
    private OptionButton buttonPasteVisibility;
    private OptionButton buttonPasteColor;
    private OptionButton buttonPasteBanner;
    private StringWidget labelPasteName;
    private StringWidget labelPasteVisibility;
    private StringWidget labelPasteColor;
    private StringWidget labelPasteBanner;
    private IconButton buttonUndo;
    private IconButton buttonRedo;
    private IconButton buttonChangeToPersonalGlobal;
    private SimpleButton buttonSelect;
    private SimpleButton buttonShareSettings;
    private SimpleButton buttonDelete;
    private SimpleButton buttonDone;
    private SimpleButton buttonBanner;
    private SimpleSlider sliderBannerRotation;
    private StringWidget modifiedLabel;
    private final Stack<FrontierData> undoStack = new Stack();
    private final Stack<FrontierData> redoStack = new Stack();

    public FrontierInfo(IClientAPI jmAPI, FrontierOverlay frontier) {
        super(titleLabel, 636, 350);
        this.jmAPI = jmAPI;
        this.frontiersOverlayManager = MapFrontiersClient.getFrontiersOverlayManager(frontier.getPersonal());
        this.frontier = frontier;
        this.frontierHash = frontier.getHash();
        this.undoStack.push(new FrontierData(frontier));
        ClientEventHandler.subscribeDeletedFrontierEvent((Object)this, frontierID -> {
            if (frontier.getId().equals(frontierID)) {
                this.onClose();
            }
        });
        ClientEventHandler.subscribeUpdatedFrontierEvent((Object)this, (frontierOverlay, playerID) -> {
            if (this.minecraft.player != null && frontier.getId().equals(frontierOverlay.getId())) {
                this.addToUndo(new FrontierData((FrontierData)frontierOverlay));
                if (playerID.intValue() != this.minecraft.player.getId()) {
                    this.rebuildWidgets();
                    this.repositionElements();
                } else if (frontier.getModified() != null) {
                    MutableComponent modified = Component.translatable((String)modifiedKey, (Object[])new Object[]{dateFormat.format(frontier.getModified())});
                    this.modifiedLabel.setMessage((Component)modified);
                }
            }
        });
        ClientEventHandler.subscribeUpdatedSettingsProfileEvent((Object)this, profile -> {
            this.updateButtons();
            this.updateBannerButton();
        });
    }

    @Override
    public void initScreen() {
        GridLayout mainLayout = new GridLayout().spacing(10);
        this.content.addChild((LayoutElement)mainLayout);
        LinearLayout bannerColumn = LinearLayout.vertical().spacing(2);
        bannerColumn.defaultCellSetting().alignHorizontallyCenter();
        mainLayout.addChild((LayoutElement)bannerColumn, 0, 0);
        this.buttonBanner = new SimpleButton(this.font, 144, assignBannerLabel, b -> {
            if (!this.frontier.hasBanner()) {
                ItemStack heldBanner = FrontierInfo.getHeldBanner(this.minecraft);
                if (heldBanner != null) {
                    this.frontier.setBanner(heldBanner);
                }
            } else {
                this.frontier.setBanner(null);
            }
            this.updateBannerButton();
            this.sendChangesToServer();
        });
        bannerColumn.addChild((LayoutElement)this.buttonBanner);
        this.sliderBannerRotation = new SimpleSlider(this.font, 144, bannerRotationKey, 0, 360, this.frontier.getBannerRotation(), (angle, dragging) -> {
            this.frontier.setBannerRotation(angle);
            if (!dragging) {
                this.sendChangesToServer();
            }
        });
        bannerColumn.addChild((LayoutElement)this.sliderBannerRotation);
        LinearLayout nameColumn = LinearLayout.vertical().spacing(2);
        nameColumn.defaultCellSetting().alignHorizontallyLeft();
        mainLayout.addChild((LayoutElement)nameColumn, 0, 1, 2, 1);
        nameColumn.addChild((LayoutElement)new StringWidget(nameLabel, this.font).setColor(-16711681));
        this.textName1 = new TextBox(this.font, 144);
        this.textName1.setMaxLength(17);
        this.textName1.setHeight(20);
        this.textName1.setValue(this.frontier.getName1());
        this.textName1.setLostFocusCallback(value -> this.sendChangesToServer());
        this.textName1.setValueChangedCallback(value -> {
            if (!this.frontier.getName1().equals(value)) {
                this.frontier.setName1((String)value);
            }
        });
        nameColumn.addChild((LayoutElement)this.textName1);
        this.textName2 = new TextBox(this.font, 144);
        this.textName2.setMaxLength(17);
        this.textName2.setHeight(20);
        this.textName2.setValue(this.frontier.getName2());
        this.textName2.setLostFocusCallback(value -> this.sendChangesToServer());
        this.textName2.setValueChangedCallback(value -> {
            if (!this.frontier.getName2().equals(value)) {
                this.frontier.setName2((String)value);
            }
        });
        nameColumn.addChild((LayoutElement)this.textName2);
        LinearLayout dataRow1 = LinearLayout.vertical();
        mainLayout.addChild((LayoutElement)dataRow1, 0, 2, 1, 2, LayoutSettings.defaults().alignHorizontallyLeft());
        LinearLayout dataRow1sub = LinearLayout.horizontal().spacing(12);
        dataRow1.addChild((LayoutElement)dataRow1sub);
        LinearLayout dataRow1subPersonalGlobal = LinearLayout.horizontal().spacing(4);
        dataRow1sub.addChild((LayoutElement)dataRow1subPersonalGlobal);
        dataRow1subPersonalGlobal.addChild((LayoutElement)new StringWidget(this.frontier.getPersonal() ? personalLabel : globalLabel, this.font).setColor(-1));
        this.buttonChangeToPersonalGlobal = (IconButton)dataRow1subPersonalGlobal.addChild((LayoutElement)new IconButton(IconButton.Type.Swap, b -> {
            if (this.frontier.getPersonal()) {
                new ConfirmationDialog("mapfrontiers.change_to_global_frontier_dialog", "mapfrontiers.change_to_global_frontier_dialog_desc", "mapfrontiers.change_to_global", "gui.cancel", null, response -> this.changeToGlobal()).display();
            } else {
                new ConfirmationDialog("mapfrontiers.change_to_personal_frontier_dialog", "mapfrontiers.change_to_personal_frontier_dialog_desc", "mapfrontiers.change_to_personal", "gui.cancel", null, response -> this.changeToPersonal()).display();
            }
        }));
        this.buttonChangeToPersonalGlobal.setTooltip(this.frontier.getPersonal() ? changeToGlobalTooltip : changeToPersonalTooltip);
        if (this.frontier.getMode() == FrontierData.Mode.Vertex) {
            MutableComponent vertices = Component.translatable((String)verticesKey, (Object[])new Object[]{this.frontier.getVertexCount()});
            dataRow1sub.addChild((LayoutElement)new StringWidget((Component)vertices, this.font).setColor(-1));
        } else {
            MutableComponent chunks = Component.translatable((String)chunksKey, (Object[])new Object[]{this.frontier.getChunkCount()});
            dataRow1sub.addChild((LayoutElement)new StringWidget((Component)chunks, this.font).setColor(-1));
        }
        MutableComponent owner = Component.translatable((String)ownerKey, (Object[])new Object[]{this.frontier.getOwner().toString()});
        if (this.frontier.wasCopied()) {
            owner.append((Component)Component.literal((String)(String.valueOf(ColorConstants.WARNING) + " !")));
        }
        StringWidget ownerWidget = (StringWidget)dataRow1sub.addChild((LayoutElement)new StringWidget((Component)owner, this.font).setColor(-1));
        if (this.frontier.wasCopied()) {
            Tooltip ownerTooltip = Tooltip.create((Component)Component.literal((String)(String.valueOf(ColorConstants.WARNING) + "! " + String.valueOf(ChatFormatting.RESET))).append((Component)Component.translatable((String)originalOwnerKey, (Object[])new Object[]{this.frontier.getCopiedFromUser().toString()})));
            ownerWidget.setTooltip(ownerTooltip);
        }
        MutableComponent dimension = Component.translatable((String)dimensionKey, (Object[])new Object[]{this.frontier.getDimension().location().toString()});
        dataRow1.addChild((LayoutElement)new StringWidget((Component)dimension, this.font).setColor(-6710887));
        LinearLayout dataRow2Col1 = LinearLayout.vertical();
        mainLayout.addChild((LayoutElement)dataRow2Col1, 1, 2, LayoutSettings.defaults().alignHorizontallyLeft());
        MutableComponent area = Component.translatable((String)areaKey, (Object[])new Object[]{Float.valueOf(this.frontier.area)});
        dataRow2Col1.addChild((LayoutElement)new StringWidget((Component)area, this.font).setColor(-1));
        MutableComponent perimeter = Component.translatable((String)perimeterKey, (Object[])new Object[]{Float.valueOf(this.frontier.perimeter)});
        dataRow2Col1.addChild((LayoutElement)new StringWidget((Component)perimeter, this.font).setColor(-1));
        LinearLayout dataRow2Col2 = LinearLayout.vertical();
        mainLayout.addChild((LayoutElement)dataRow2Col2, 1, 3, LayoutSettings.defaults().alignHorizontallyLeft());
        if (this.frontier.getCreated() != null) {
            MutableComponent created = Component.translatable((String)createdKey, (Object[])new Object[]{dateFormat.format(this.frontier.getCreated())});
            dataRow2Col2.addChild((LayoutElement)new StringWidget((Component)created, this.font).setColor(-1));
        }
        if (this.frontier.getModified() != null) {
            MutableComponent modified = Component.translatable((String)modifiedKey, (Object[])new Object[]{dateFormat.format(this.frontier.getModified())});
            this.modifiedLabel = (StringWidget)dataRow2Col2.addChild((LayoutElement)new StringWidget((Component)modified, this.font).setColor(-1));
        }
        this.buttonVisibility = new SimpleButton(this.font, 144, visibilityLabel, b -> new VisibilityDialog(this.frontier.getVisibilityData(), (newVisibilityData, newVisibilityMask) -> {
            if (!newVisibilityData.equals(this.frontier.getVisibilityData())) {
                this.frontier.setVisibilityData((FrontierData.VisibilityData)newVisibilityData);
                this.sendChangesToServer();
            }
        }).display());
        this.buttonVisibility.setTooltip(visibilityTooltip);
        mainLayout.addChild((LayoutElement)this.buttonVisibility, 2, 1);
        this.buttonVisibilityOverride = new SimpleButton(this.font, 144, visibilityOverrideLabel, b -> {
            Pair<FrontierData.VisibilityData, FrontierData.VisibilityData> override = MapFrontiersClient.getLocalOverrides().getVisibility(this.frontier.getId());
            new VisibilityDialog((FrontierData.VisibilityData)override.first(), (FrontierData.VisibilityData)override.second(), (newVisibilityData, newVisibilityMask) -> {
                if (!newVisibilityData.equals(override.first()) || !newVisibilityMask.equals(override.second())) {
                    Pair newOverride = Pair.of((Object)newVisibilityData, (Object)newVisibilityMask);
                    MapFrontiersClient.getLocalOverrides().setVisibility(this.frontier.getId(), (Pair<FrontierData.VisibilityData, FrontierData.VisibilityData>)newOverride);
                    this.frontier.setVisibilityOverride((Pair<FrontierData.VisibilityData, FrontierData.VisibilityData>)newOverride);
                }
            }).display();
        });
        this.buttonVisibilityOverride.setTooltip(visibilityOverrideTooltip);
        mainLayout.addChild((LayoutElement)this.buttonVisibilityOverride, 2, 2);
        this.colorPicker = new ColorPicker(this.frontier.getColor(), (color, dragging) -> {
            this.colorPalette.setColor((int)color);
            this.colorPickerUpdated((int)color, (boolean)dragging);
        });
        mainLayout.addChild((LayoutElement)this.colorPicker, 3, 1, LayoutSettings.defaults().alignVerticallyBottom());
        LinearLayout colorCol = LinearLayout.vertical().spacing(4);
        colorCol.defaultCellSetting().alignHorizontallyCenter();
        mainLayout.addChild((LayoutElement)colorCol, 3, 2);
        colorCol.addChild((LayoutElement)new StringWidget(colorLabel, this.font).setColor(-16711681), LayoutSettings.defaults().alignHorizontallyLeft());
        LinearLayout rgbRow = LinearLayout.horizontal().spacing(3);
        rgbRow.defaultCellSetting().alignVerticallyMiddle();
        colorCol.addChild((LayoutElement)rgbRow);
        rgbRow.addChild((LayoutElement)new StringWidget(rLabel, this.font, 8).setColor(-16711681));
        this.textRed = new TextBoxInt(0, 0, 255, this.font, 29);
        this.textRed.setHeight(20);
        this.textRed.setWidth(34);
        this.textRed.setValueChangedCallback(value -> {
            int newColor = this.frontier.getColor() & 0xFF00FFFF | value << 16;
            if (newColor != this.frontier.getColor()) {
                this.frontier.setColor(newColor);
                this.colorPicker.setColor(newColor);
                this.colorPalette.setColor(newColor);
                this.sendChangesToServer();
            }
        });
        rgbRow.addChild((LayoutElement)this.textRed);
        rgbRow.addChild((LayoutElement)SpacerElement.width((int)1));
        rgbRow.addChild((LayoutElement)new StringWidget(gLabel, this.font, 8).setColor(-16711681));
        this.textGreen = new TextBoxInt(0, 0, 255, this.font, 29);
        this.textGreen.setHeight(20);
        this.textGreen.setWidth(34);
        this.textGreen.setValueChangedCallback(value -> {
            int newColor = this.frontier.getColor() & 0xFFFF00FF | value << 8;
            if (newColor != this.frontier.getColor()) {
                this.frontier.setColor(newColor);
                this.colorPicker.setColor(newColor);
                this.colorPalette.setColor(newColor);
                this.sendChangesToServer();
            }
        });
        rgbRow.addChild((LayoutElement)this.textGreen);
        rgbRow.addChild((LayoutElement)SpacerElement.width((int)1));
        rgbRow.addChild((LayoutElement)new StringWidget(bLabel, this.font, 8).setColor(-16711681));
        this.textBlue = new TextBoxInt(0, 0, 255, this.font, 29);
        this.textBlue.setHeight(20);
        this.textBlue.setWidth(34);
        this.textBlue.setValueChangedCallback(value -> {
            int newColor = this.frontier.getColor() & 0xFFFFFF00 | value;
            if (newColor != this.frontier.getColor()) {
                this.frontier.setColor(newColor);
                this.colorPicker.setColor(newColor);
                this.colorPalette.setColor(newColor);
                this.sendChangesToServer();
            }
        });
        rgbRow.addChild((LayoutElement)this.textBlue);
        this.textRed.setValue((this.frontier.getColor() & 0xFF0000) >> 16);
        this.textGreen.setValue((this.frontier.getColor() & 0xFF00) >> 8);
        this.textBlue.setValue(this.frontier.getColor() & 0xFF);
        this.buttonRandomColor = new SimpleButton(this.font, 144, randomColorLabel, b -> {
            int newColor = ColorHelper.getRandomColor();
            this.frontier.setColor(newColor);
            this.colorPicker.setColor(newColor);
            this.textRed.setValue((newColor & 0xFF0000) >> 16);
            this.textGreen.setValue((newColor & 0xFF00) >> 8);
            this.textBlue.setValue(newColor & 0xFF);
            this.sendChangesToServer();
        });
        colorCol.addChild((LayoutElement)this.buttonRandomColor);
        this.colorPalette = new ColorPaletteWidget(this.frontier.getColor(), color -> {
            this.colorPicker.setColor((int)color);
            this.colorPickerUpdated((int)color, false);
        });
        colorCol.addChild((LayoutElement)this.colorPalette);
        GridLayout editCol = new GridLayout().rowSpacing(4);
        editCol.defaultCellSetting().alignHorizontallyLeft();
        editCol.addChild((LayoutElement)SpacerElement.width((int)116), 0, 0);
        mainLayout.addChild((LayoutElement)editCol, 3, 3, LayoutSettings.defaults().alignVerticallyBottom());
        this.labelPasteName = (StringWidget)editCol.addChild((LayoutElement)new StringWidget(pasteNameLabel, this.font).setColor(-4144960), 0, 0);
        this.buttonPasteName = (OptionButton)editCol.addChild((LayoutElement)this.createVisibilityOptionButton(Config.pasteName, value -> {
            Config.pasteName = value;
        }), 0, 1);
        this.labelPasteVisibility = (StringWidget)editCol.addChild((LayoutElement)new StringWidget(pasteVisibilityLabel, this.font).setColor(-4144960), 1, 0);
        this.buttonPasteVisibility = (OptionButton)editCol.addChild((LayoutElement)this.createVisibilityOptionButton(Config.pasteVisibility, value -> {
            Config.pasteVisibility = value;
        }), 1, 1);
        this.labelPasteColor = (StringWidget)editCol.addChild((LayoutElement)new StringWidget(pasteColorLabel, this.font).setColor(-4144960), 2, 0);
        this.buttonPasteColor = (OptionButton)editCol.addChild((LayoutElement)this.createVisibilityOptionButton(Config.pasteColor, value -> {
            Config.pasteColor = value;
        }), 2, 1);
        this.labelPasteBanner = (StringWidget)editCol.addChild((LayoutElement)new StringWidget(pasteBannerLabel, this.font).setColor(-4144960), 3, 0);
        this.buttonPasteBanner = (OptionButton)editCol.addChild((LayoutElement)this.createVisibilityOptionButton(Config.pasteBanner, value -> {
            Config.pasteBanner = value;
        }), 3, 1);
        LinearLayout editButtons = LinearLayout.horizontal().spacing(3);
        editCol.addChild((LayoutElement)editButtons, 4, 0);
        this.buttonCopy = (IconButton)editButtons.addChild((LayoutElement)new IconButton(IconButton.Type.Copy, b -> {
            MapFrontiersClient.setClipboard(this.frontier);
            this.updatePasteOptionsVisibility();
        }));
        this.buttonCopy.setTooltip(copyTooltip);
        LinearLayout pasteButtons = LinearLayout.horizontal();
        editButtons.addChild((LayoutElement)pasteButtons);
        this.buttonPaste = (IconButton)pasteButtons.addChild((LayoutElement)new IconButton(IconButton.Type.Paste, b -> {
            FrontierData clipboard = MapFrontiersClient.getClipboard();
            if (clipboard != null && (Config.pasteName || Config.pasteVisibility || Config.pasteColor || Config.pasteBanner)) {
                this.setFrontier(clipboard, Config.pasteName, Config.pasteVisibility, Config.pasteColor, Config.pasteBanner);
                this.sendChangesToServer();
                this.rebuildWidgets();
                this.repositionElements();
                if (this.minecraft.getLastInputType().isKeyboard()) {
                    this.setInitialFocus((GuiEventListener)this.buttonPaste);
                }
            }
        }));
        this.buttonPaste.setTooltip(pasteTooltip);
        this.buttonPasteOptions = (IconButton)pasteButtons.addChild((LayoutElement)new IconButton(IconButton.Type.ArrowUp, b -> {
            Config.pasteOptionsVisible = !Config.pasteOptionsVisible;
            this.updatePasteOptionsVisibility();
            ClientEventHandler.postUpdatedConfigEvent();
        }));
        this.buttonPasteOptions.setTooltip(openPasteTooltip);
        this.buttonUndo = (IconButton)editButtons.addChild((LayoutElement)new IconButton(IconButton.Type.Undo, b -> this.undo()));
        this.buttonUndo.setTooltip(undoTooltip);
        this.buttonRedo = (IconButton)editButtons.addChild((LayoutElement)new IconButton(IconButton.Type.Redo, b -> this.redo()));
        this.buttonRedo.setTooltip(redoTooltip);
        this.buttonSelect = (SimpleButton)this.bottomButtons.addChild((LayoutElement)new SimpleButton(this.font, 144, selectInMapLabel, b -> {
            BlockPos center = this.frontier.getCenter();
            this.closeAndReturnToFullscreenMap();
            Services.JOURNEYMAP.fullscreenMapCenterOn(center.getX(), center.getZ());
        }));
        this.buttonShareSettings = (SimpleButton)this.bottomButtons.addChild((LayoutElement)new SimpleButton(this.font, 144, shareSettingsLabel, b -> {
            if (MapFrontiersClient.isModOnServer()) {
                new ShareSettings(this.frontiersOverlayManager, this.frontier).display();
            } else {
                new SendFrontier(this.frontier).display();
            }
        }));
        this.buttonDelete = (SimpleButton)this.bottomButtons.addChild((LayoutElement)new SimpleButton(this.font, 144, deleteLabel, b -> {
            if (Config.askConfirmationFrontierDelete) {
                new DeleteConfirmationDialog("mapfrontiers.delete_frontier_dialog", response -> {
                    if (response == ConfirmationDialog.Response.ConfirmAlternative) {
                        Config.askConfirmationFrontierDelete = false;
                        ClientEventHandler.postUpdatedConfigEvent();
                    }
                    this.deleteFrontier();
                }).display();
            } else {
                this.deleteFrontier();
            }
        }));
        this.buttonDelete.setTextColors(-34953, -65536);
        this.buttonDone = (SimpleButton)this.bottomButtons.addChild((LayoutElement)new SimpleButton(this.font, 144, doneLabel, b -> this.onClose()));
        this.updateBannerButton();
        this.updateButtons();
        this.updatePasteOptionsVisibility();
        this.updateUndoRedoVisibility();
        this.setInitialFocus((GuiEventListener)this.buttonDone);
    }

    private OptionButton createVisibilityOptionButton(boolean defaultValue, Consumer<Boolean> consumer) {
        OptionButton button = new OptionButton(this.font, 28, b -> {
            consumer.accept(b.getSelected() == 0);
            this.sendChangesToServer();
        });
        button.addOption(onLabel);
        button.addOption(offLabel);
        button.setSelected(defaultValue ? 0 : 1);
        return button;
    }

    @Override
    public void renderScaledBackgroundScreen(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.drawCenteredBoxBackground(graphics, this.content.getWidth() + 20, this.content.getHeight() + 20);
    }

    @Override
    public void renderScaledScreen(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.frontier.getBannerRenderer().hasBanner()) {
            this.frontier.getBannerRenderer().renderBanner(graphics, this.buttonBanner.getX() + this.buttonBanner.getWidth() / 2, this.sliderBannerRotation.getY() + 25, 3);
        }
    }

    @Override
    public boolean mouseReleased(MouseButtonEvent event) {
        for (GuiEventListener w : this.children()) {
            if (!(w instanceof ColorPicker)) continue;
            w.mouseReleased(event);
        }
        this.sliderBannerRotation.mouseReleased();
        return super.mouseReleased(event);
    }

    @Override
    public boolean keyPressed(KeyEvent event) {
        if (event.input() == 90 && event.hasControlDown() && !event.hasShiftDown() && !event.hasAltDown()) {
            this.undo();
            return true;
        }
        if (event.input() == 90 && event.hasControlDown() && event.hasShiftDown() && !event.hasAltDown()) {
            this.redo();
            return true;
        }
        return super.keyPressed(event);
    }

    public void onClose() {
        this.sendChangesToServer();
        ClientEventHandler.unsubscribeAllEvents((Object)this);
        super.onClose();
    }

    private void deleteFrontier() {
        ClientEventHandler.unsubscribeAllEvents((Object)this);
        this.frontiersOverlayManager.clientDeleteFrontier(this.frontier);
        this.onClose();
    }

    private void colorPickerUpdated(int color, boolean dragging) {
        this.frontier.setColor(color);
        this.textRed.setValue((this.frontier.getColor() & 0xFF0000) >> 16);
        this.textGreen.setValue((this.frontier.getColor() & 0xFF00) >> 8);
        this.textBlue.setValue(this.frontier.getColor() & 0xFF);
        if (!dragging) {
            this.sendChangesToServer();
        }
    }

    private void undo() {
        if (this.undoStack.size() == 1) {
            return;
        }
        this.redoStack.push(this.undoStack.pop());
        this.setFrontier(this.undoStack.peek(), true, true, true, true);
        this.sendChangesToServer();
        this.rebuildWidgets();
        this.repositionElements();
        if (this.minecraft.getLastInputType().isKeyboard()) {
            if (this.undoStack.size() == 1) {
                this.setInitialFocus((GuiEventListener)this.buttonRedo);
            } else {
                this.setInitialFocus((GuiEventListener)this.buttonUndo);
            }
        }
    }

    private void redo() {
        if (this.redoStack.empty()) {
            return;
        }
        this.setFrontier(this.redoStack.peek(), true, true, true, true);
        this.undoStack.push(this.redoStack.pop());
        this.sendChangesToServer();
        this.rebuildWidgets();
        this.repositionElements();
        if (this.minecraft.getLastInputType().isKeyboard()) {
            if (this.redoStack.empty()) {
                this.setInitialFocus((GuiEventListener)this.buttonUndo);
            } else {
                this.setInitialFocus((GuiEventListener)this.buttonRedo);
            }
        }
    }

    private void setFrontier(FrontierData other, boolean name, boolean visibility, boolean color, boolean banner) {
        if (name) {
            this.frontier.setName1(other.getName1());
            this.frontier.setName2(other.getName2());
        }
        if (visibility) {
            this.frontier.setVisibilityData(other.getVisibilityData());
        }
        if (color) {
            this.frontier.setColor(other.getColor());
        }
        if (banner) {
            this.frontier.setBannerData(other.getbannerData());
        }
    }

    private void updateBannerButton() {
        if (!this.frontier.hasBanner()) {
            if (FrontierInfo.getHeldBanner(this.minecraft) != null) {
                this.buttonBanner.setMessage(assignBannerLabel);
                this.buttonBanner.setTooltip(null);
            } else {
                this.buttonBanner.setMessage(assignBannerWarnLabel);
                this.buttonBanner.setTooltip(assignBannerWarnTooltip);
            }
            this.sliderBannerRotation.visible = false;
        } else {
            this.buttonBanner.setMessage(removeBannerLabel);
            this.buttonBanner.setTooltip(null);
            this.sliderBannerRotation.visible = true;
        }
    }

    private static ItemStack getHeldBanner(@Nullable Minecraft minecraft) {
        if (minecraft == null || minecraft.player == null) {
            return null;
        }
        ItemStack mainhand = minecraft.player.getItemBySlot(EquipmentSlot.MAINHAND);
        ItemStack offhand = minecraft.player.getItemBySlot(EquipmentSlot.OFFHAND);
        ItemStack heldBanner = null;
        if (mainhand.getItem() instanceof BannerItem) {
            heldBanner = mainhand;
        } else if (offhand.getItem() instanceof BannerItem) {
            heldBanner = offhand;
        }
        return heldBanner;
    }

    private void changeToGlobal() {
        this.undoStack.clear();
        this.redoStack.clear();
        PacketHandler.sendToServer(new PacketChangeFrontierToGlobal(this.frontier.getId(), null));
    }

    private void changeToPersonal() {
        this.undoStack.clear();
        this.redoStack.clear();
        PacketHandler.sendToServer(new PacketChangeFrontierToPersonal(this.frontier.getId(), null));
    }

    private void updateButtons() {
        if (this.minecraft.player == null) {
            return;
        }
        SettingsProfile profile = MapFrontiersClient.getSettingsProfile();
        SettingsUser playerUser = new SettingsUser((Player)this.minecraft.player);
        SettingsProfile.AvailableActions actions = SettingsProfile.getAvailableActions(profile, this.frontier, playerUser);
        this.textName1.setEditable(actions.canUpdate);
        this.textName2.setEditable(actions.canUpdate);
        this.buttonVisibility.active = actions.canUpdate;
        this.textRed.setEditable(actions.canUpdate);
        this.textGreen.setEditable(actions.canUpdate);
        this.textBlue.setEditable(actions.canUpdate);
        this.buttonRandomColor.active = actions.canUpdate;
        this.colorPicker.active = actions.canUpdate;
        this.colorPalette.active = actions.canUpdate;
        this.buttonPaste.active = actions.canUpdate;
        this.buttonPasteOptions.active = actions.canUpdate;
        this.buttonChangeToPersonalGlobal.visible = this.frontier.getPersonal() ? MapFrontiersClient.isModOnServer() && this.frontier.getOwner().equals(playerUser) && profile.createFrontier == SettingsProfile.State.Enabled : actions.canDelete;
        this.buttonDelete.active = actions.canDelete;
        this.buttonBanner.visible = actions.canUpdate;
        this.sliderBannerRotation.visible = actions.canUpdate && this.frontier.hasBanner();
        UIState uiState = this.jmAPI.getUIState(Context.UI.Fullscreen);
        boolean bl = this.buttonSelect.active = uiState != null && this.frontier.getDimension().equals((Object)uiState.dimension);
        if (MapFrontiersClient.isModOnServer()) {
            this.buttonShareSettings.setMessage(shareSettingsLabel);
            this.buttonShareSettings.active = actions.canShare;
        } else {
            this.buttonShareSettings.setMessage(sendLabel);
        }
    }

    private void updatePasteOptionsVisibility() {
        this.buttonPasteOptions.visible = this.buttonPaste.visible = this.buttonPaste.active && MapFrontiersClient.getClipboard() != null;
        this.buttonPasteOptions.setType(Config.pasteOptionsVisible ? IconButton.Type.ArrowDown : IconButton.Type.ArrowUp);
        this.buttonPasteOptions.setTooltip(Config.pasteOptionsVisible ? closePasteTooltip : openPasteTooltip);
        this.buttonPasteName.visible = this.buttonPaste.visible && Config.pasteOptionsVisible;
        this.buttonPasteVisibility.visible = this.buttonPaste.visible && Config.pasteOptionsVisible;
        this.buttonPasteColor.visible = this.buttonPaste.visible && Config.pasteOptionsVisible;
        this.buttonPasteBanner.visible = this.buttonPaste.visible && Config.pasteOptionsVisible;
        this.labelPasteName.visible = this.buttonPaste.visible && Config.pasteOptionsVisible;
        this.labelPasteVisibility.visible = this.buttonPaste.visible && Config.pasteOptionsVisible;
        this.labelPasteColor.visible = this.buttonPaste.visible && Config.pasteOptionsVisible;
        this.labelPasteBanner.visible = this.buttonPaste.visible && Config.pasteOptionsVisible;
    }

    private void updateUndoRedoVisibility() {
        this.buttonUndo.visible = this.buttonPaste.active && this.undoStack.size() > 1;
        this.buttonRedo.visible = this.buttonPaste.active && this.redoStack.size() > 0;
    }

    private void sendChangesToServer() {
        SettingsProfile profile = MapFrontiersClient.getSettingsProfile();
        SettingsUser playerUser = new SettingsUser((Player)this.minecraft.player);
        SettingsProfile.AvailableActions actions = SettingsProfile.getAvailableActions(profile, this.frontier, playerUser);
        if (actions.canUpdate && this.frontier.getHash() != this.frontierHash) {
            this.frontierHash = this.frontier.getHash();
            this.frontiersOverlayManager.clientUpdateFrontier(this.frontier);
        }
    }

    private void addToUndo(FrontierData frontier) {
        FrontierData u;
        boolean add = this.undoStack.empty();
        if (!(add || Objects.equals((u = this.undoStack.peek()).getName1(), frontier.getName1()) && Objects.equals(u.getName2(), frontier.getName2()) && Objects.equals(u.getVisibilityData(), frontier.getVisibilityData()) && u.getColor() == frontier.getColor() && Objects.equals(u.getbannerData(), frontier.getbannerData()))) {
            add = true;
        }
        if (add) {
            this.undoStack.push(frontier);
            if (!this.redoStack.empty()) {
                this.redoStack.clear();
            }
            this.updateUndoRedoVisibility();
        }
    }
}

