/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common.settings;

import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.settings.FrontierSettings;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUserShared;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SettingsProfile {
    public State createFrontier = State.Disabled;
    public State deleteFrontier = State.Disabled;
    public State updateFrontier = State.Disabled;
    public State updateSettings = State.Disabled;
    public State personalFrontier = State.Disabled;

    public void setAction(FrontierSettings.Action action, State state) {
        switch (action) {
            case CreateGlobalFrontier: {
                this.createFrontier = state;
                break;
            }
            case DeleteGlobalFrontier: {
                this.deleteFrontier = state;
                break;
            }
            case UpdateGlobalFrontier: {
                this.updateFrontier = state;
                break;
            }
            case UpdateSettings: {
                this.updateSettings = state;
                break;
            }
            case SharePersonalFrontier: {
                this.personalFrontier = state;
            }
        }
    }

    public boolean isAllEnabled() {
        return this.createFrontier == State.Enabled && this.deleteFrontier == State.Enabled && this.updateFrontier == State.Enabled && this.updateSettings == State.Enabled && this.personalFrontier == State.Enabled;
    }

    public void fromBytes(ByteBuf buf) {
        this.createFrontier = State.values()[buf.readInt()];
        this.deleteFrontier = State.values()[buf.readInt()];
        this.updateFrontier = State.values()[buf.readInt()];
        this.updateSettings = State.values()[buf.readInt()];
        this.personalFrontier = State.values()[buf.readInt()];
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.createFrontier.ordinal());
        buf.writeInt(this.deleteFrontier.ordinal());
        buf.writeInt(this.updateFrontier.ordinal());
        buf.writeInt(this.updateSettings.ordinal());
        buf.writeInt(this.personalFrontier.ordinal());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof SettingsProfile) {
            SettingsProfile profile = (SettingsProfile)other;
            return this.createFrontier == profile.createFrontier && this.deleteFrontier == profile.deleteFrontier && this.updateFrontier == profile.updateFrontier && this.updateSettings == profile.updateSettings && this.personalFrontier == profile.personalFrontier;
        }
        return false;
    }

    public static AvailableActions getAvailableActions(@Nullable SettingsProfile profile, @Nullable FrontierData frontier, SettingsUser playerUser) {
        AvailableActions actions = new AvailableActions();
        if (profile == null) {
            if (frontier != null) {
                actions.canDelete = true;
                actions.canUpdate = true;
            }
            return actions;
        }
        if (frontier != null) {
            if (frontier.getPersonal()) {
                actions.canDelete = true;
                actions.canUpdate = frontier.checkActionUserShared(playerUser, SettingsUserShared.Action.UpdateFrontier);
                actions.canShare = MapFrontiersClient.isModOnServer() && profile.personalFrontier == State.Enabled;
            } else {
                boolean isOwner = frontier.getOwner().equals(playerUser);
                actions.canDelete = profile.deleteFrontier == State.Enabled || isOwner && profile.deleteFrontier == State.Owner;
                actions.canUpdate = profile.updateFrontier == State.Enabled || isOwner && profile.updateFrontier == State.Owner;
            }
        }
        return actions;
    }

    public static enum State {
        Enabled,
        Owner,
        Disabled;

    }

    public static class AvailableActions {
        public boolean canDelete = false;
        public boolean canUpdate = false;
        public boolean canShare = false;
    }
}

