/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.serialization.DynamicOps;
import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.client.mixin.CubeInvoker;
import games.alejandrocoria.mapfrontiers.client.mixin.GuiGraphicsAccessor;
import games.alejandrocoria.mapfrontiers.client.mixin.SpriteContentsInvoker;
import games.alejandrocoria.mapfrontiers.common.Config;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUserShared;
import it.unimi.dsi.fastutil.Pair;
import java.awt.Color;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.api.v2.client.IClientAPI;
import journeymap.api.v2.client.display.Context;
import journeymap.api.v2.client.display.Displayable;
import journeymap.api.v2.client.display.MarkerOverlay;
import journeymap.api.v2.client.display.PolygonOverlay;
import journeymap.api.v2.client.model.MapImage;
import journeymap.api.v2.client.model.MapPolygon;
import journeymap.api.v2.client.model.ShapeProperties;
import journeymap.api.v2.client.model.TextProperties;
import journeymap.api.v2.client.util.PolygonHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

@ParametersAreNonnullByDefault
public class FrontierOverlay
extends FrontierData {
    private static final MapImage markerVertex = new MapImage(ResourceLocation.fromNamespaceAndPath((String)"mapfrontiers", (String)"textures/gui/marker.png"), 0, 0, 12, 12, -1, 1.0f);
    private static final MapImage markerDot = new MapImage(ResourceLocation.fromNamespaceAndPath((String)"mapfrontiers", (String)"textures/gui/marker.png"), 12, 0, 8, 8, -1, 1.0f);
    public BlockPos topLeft;
    public BlockPos bottomRight;
    public float perimeter = 0.0f;
    public float area = 0.0f;
    private int vertexSelected = -1;
    protected FrontierData.VisibilityData effectiveVisibilityData;
    private boolean highlighted = false;
    private final IClientAPI jmAPI;
    private final List<PolygonOverlay> polygonOverlays = new ArrayList<PolygonOverlay>();
    private Area polygonArea;
    private final List<MarkerOverlay> markerOverlays = new ArrayList<MarkerOverlay>();
    private final List<MarkerOverlay> bannerOverlays = new ArrayList<MarkerOverlay>();
    private final BannerRenderer bannerRenderer = new BannerRenderer();
    private int hash;
    private boolean dirtyhash = true;
    private boolean needUpdateOverlay = true;

    public FrontierOverlay(FrontierData data, @Nullable IClientAPI jmAPI) {
        super(data);
        this.jmAPI = jmAPI;
        this.setVisibilityOverride(MapFrontiersClient.getLocalOverrides().getVisibility(this.id));
        if (this.banner != null) {
            this.bannerRenderer.createTexture(this.id, this.banner);
        }
        this.updateOverlay();
    }

    @Override
    public void updateFromData(FrontierData other) {
        super.updateFromData(other);
        this.setVisibilityOverride(MapFrontiersClient.getLocalOverrides().getVisibility(this.id));
        if (this.vertexSelected >= this.vertices.size()) {
            this.vertexSelected = this.vertices.size() - 1;
        }
        if (other.hasChange(FrontierData.Change.Name) || other.hasChange(FrontierData.Change.Vertices) || other.hasChange(FrontierData.Change.Color) || other.hasChange(FrontierData.Change.Visibility)) {
            this.updateOverlay();
        }
        if (other.hasChange(FrontierData.Change.Banner)) {
            if (this.banner == null) {
                this.bannerRenderer.releaseTexture();
            } else {
                this.bannerRenderer.createTexture(this.id, this.banner);
            }
            this.dirtyhash = true;
        }
    }

    public int getHash() {
        if (this.dirtyhash) {
            this.dirtyhash = false;
            this.hash = Objects.hash(new Object[]{this.id, this.color, this.dimension, this.name1, this.name2, this.visibilityData, this.vertices, this.chunks, this.mode, this.banner, this.usersShared, this.copiedFrom});
        }
        return this.hash;
    }

    public List<PolygonOverlay> getPolygonOverlays() {
        return this.polygonOverlays;
    }

    public List<MarkerOverlay> getBannerOverlays() {
        return this.bannerOverlays;
    }

    public void updateOverlayIfNeeded() {
        if (this.needUpdateOverlay) {
            this.needUpdateOverlay = false;
            this.updateOverlay();
        }
    }

    public void updateOverlay() {
        this.dirtyhash = true;
        if (this.jmAPI == null) {
            return;
        }
        this.removeOverlay();
        this.recalculateOverlays();
        if (Config.getVisibilityValue(Config.frontierVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.Frontier))) {
            try {
                for (PolygonOverlay polygon : this.polygonOverlays) {
                    this.jmAPI.show((Displayable)polygon);
                }
                for (MarkerOverlay marker : this.markerOverlays) {
                    this.jmAPI.show((Displayable)marker);
                }
                for (MarkerOverlay banner : this.bannerOverlays) {
                    this.jmAPI.show((Displayable)banner);
                }
            }
            catch (Throwable t) {
                MapFrontiers.LOGGER.error(t.getMessage(), t);
            }
        }
    }

    private void removeOverlay() {
        for (PolygonOverlay polygon : this.polygonOverlays) {
            this.jmAPI.remove((Displayable)polygon);
        }
        for (MarkerOverlay marker : this.markerOverlays) {
            this.jmAPI.remove((Displayable)marker);
        }
        for (MarkerOverlay banner : this.bannerOverlays) {
            this.jmAPI.remove((Displayable)banner);
        }
    }

    public void deleted() {
        this.removeOverlay();
        this.bannerRenderer.releaseTexture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pointIsInside(BlockPos pos, double maxDistanceToOpen) {
        if (this.mode == FrontierData.Mode.Vertex) {
            if (this.vertices.size() > 2) {
                return this.polygonArea != null && this.polygonArea.contains((double)pos.getX() + 0.5, (double)pos.getZ() + 0.5);
            }
            if (maxDistanceToOpen > 0.0) {
                List list = this.vertices;
                synchronized (list) {
                    for (int i = 0; i < this.vertices.size(); ++i) {
                        Vec3 point = Vec3.atLowerCornerOf((Vec3i)pos);
                        int y1 = pos.getY();
                        Vec3 edge1 = Vec3.atLowerCornerOf((Vec3i)((BlockPos)this.vertices.get(i)).atY(y1));
                        int y = pos.getY();
                        Vec3 edge2 = Vec3.atLowerCornerOf((Vec3i)((BlockPos)this.vertices.get((i + 1) % this.vertices.size())).atY(y));
                        double distance = FrontierOverlay.closestPointToEdge(point, edge1, edge2).distanceToSqr(point);
                        if (!(distance <= maxDistanceToOpen * maxDistanceToOpen)) continue;
                        return true;
                    }
                }
            }
        } else if (pos.getX() >= this.topLeft.getX() && pos.getX() <= this.bottomRight.getX() && pos.getZ() >= this.topLeft.getZ() && pos.getZ() <= this.bottomRight.getZ()) {
            return this.chunks.contains(new ChunkPos(pos));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectClosestVertex(BlockPos pos, double limit) {
        if (this.mode != FrontierData.Mode.Vertex) {
            this.vertexSelected = -1;
            return;
        }
        double distance = limit * limit;
        int closest = -1;
        if (!this.vertices.isEmpty()) {
            List list = this.vertices;
            synchronized (list) {
                for (int i = 0; i < this.vertices.size(); ++i) {
                    int y;
                    BlockPos vertex = (BlockPos)this.vertices.get(i);
                    double dist = vertex.distSqr((Vec3i)pos.atY(y = vertex.getY()));
                    if (!(dist <= distance)) continue;
                    distance = dist;
                    closest = i;
                }
            }
        }
        this.vertexSelected = closest;
        MapFrontiersClient.getFrontiersOverlayManager(this.personal).updateSelectedMarker(this.getDimension(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectClosestEdge(BlockPos pos) {
        if (this.mode != FrontierData.Mode.Vertex) {
            this.vertexSelected = -1;
            return;
        }
        double distance = Double.MAX_VALUE;
        int closest = -1;
        double angleSimilarity = -1.0;
        if (this.vertices.size() == 1) {
            closest = 0;
        } else if (this.vertices.size() > 1) {
            List list = this.vertices;
            synchronized (list) {
                for (int i = 0; i < this.vertices.size(); ++i) {
                    double dist;
                    double dot;
                    Vec3 point = Vec3.atLowerCornerOf((Vec3i)pos);
                    int y1 = pos.getY();
                    Vec3 edge1 = Vec3.atLowerCornerOf((Vec3i)((BlockPos)this.vertices.get(i)).atY(y1));
                    int y = pos.getY();
                    Vec3 edge2 = Vec3.atLowerCornerOf((Vec3i)((BlockPos)this.vertices.get((i + 1) % this.vertices.size())).atY(y));
                    if (edge1.equals((Object)edge2)) {
                        dot = -1.0;
                        dist = point.distanceToSqr(edge1);
                    } else {
                        Vec3 closestPoint = FrontierOverlay.closestPointToEdge(point, edge1, edge2);
                        if (!closestPoint.equals((Object)edge1) && !closestPoint.equals((Object)edge2)) {
                            dot = -1.0;
                        } else {
                            Vec3 toPos;
                            Vec3 edge = edge2.subtract(edge1);
                            Vec2 edgeDirection = new Vec2((float)edge.x, (float)edge.z).normalized();
                            if (closestPoint.equals((Object)edge1)) {
                                toPos = point.subtract(edge1);
                            } else {
                                edgeDirection = edgeDirection.negated();
                                toPos = point.subtract(edge2);
                            }
                            Vec2 toPosDirection = new Vec2((float)toPos.x, (float)toPos.z).normalized();
                            dot = toPosDirection.dot(edgeDirection);
                        }
                        dist = point.distanceToSqr(closestPoint);
                    }
                    if (dist < distance) {
                        distance = dist;
                        closest = i;
                        angleSimilarity = dot;
                        continue;
                    }
                    if (dist != distance || !(dot > angleSimilarity)) continue;
                    closest = i;
                    angleSimilarity = dot;
                }
            }
        }
        this.vertexSelected = closest;
        MapFrontiersClient.getFrontiersOverlayManager(this.personal).updateSelectedMarker(this.getDimension(), this);
    }

    private static Vec3 closestPointToEdge(Vec3 point, Vec3 edge1, Vec3 edge2) {
        Vec3 edge = edge2.subtract(edge1);
        if (edge.x == 0.0 && edge.z == 0.0) {
            return edge1;
        }
        double u = ((point.x - edge1.x) * edge.x + (point.z - edge1.z) * edge.z) / (edge.x * edge.x + edge.z * edge.z);
        if (u < 0.0) {
            return edge1;
        }
        if (u > 1.0) {
            return edge2;
        }
        return new Vec3(edge1.x + u * edge.x, point.y, edge1.z + u * edge.z);
    }

    public void setCurrentPlayerAsOwner() {
        if (Minecraft.getInstance().player != null) {
            this.owner = new SettingsUser((Player)Minecraft.getInstance().player);
        }
    }

    @Override
    public void setId(UUID id) {
        super.setId(id);
        this.needUpdateOverlay = true;
    }

    @Override
    public void addVertex(BlockPos pos) {
        this.addVertex(pos, this.vertexSelected + 1, Config.snapDistance);
        this.selectNextVertex();
    }

    public void addVertex(BlockPos pos, int index, int snapDistance) {
        if (snapDistance != 0) {
            pos = this.snapVertex(pos, snapDistance);
        }
        super.addVertex(pos, index);
        this.needUpdateOverlay = true;
    }

    @Override
    public void removeVertex(int index) {
        super.removeVertex(index);
        this.needUpdateOverlay = true;
    }

    @Override
    public void moveAllVertices(BlockPos delta) {
        super.moveAllVertices(delta);
        this.needUpdateOverlay = true;
    }

    @Override
    public boolean toggleChunk(ChunkPos chunk) {
        boolean added = super.toggleChunk(chunk);
        this.needUpdateOverlay = true;
        return added;
    }

    @Override
    public boolean addChunk(ChunkPos chunk) {
        if (super.addChunk(chunk)) {
            this.needUpdateOverlay = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeChunk(ChunkPos chunk) {
        if (super.removeChunk(chunk)) {
            this.needUpdateOverlay = true;
            return true;
        }
        return false;
    }

    @Override
    public void moveAllChunks(ChunkPos delta) {
        super.moveAllChunks(delta);
        this.needUpdateOverlay = true;
    }

    public boolean hasChunk(ChunkPos chunk) {
        return this.chunks.contains(chunk);
    }

    public List<ChunkPos> getConnectedChunks(ChunkPos chunk) {
        ArrayList<ChunkPos> connected = new ArrayList<ChunkPos>();
        if (!this.hasChunk(chunk)) {
            return connected;
        }
        HashSet<ChunkPos> visited = new HashSet<ChunkPos>();
        visited.add(chunk);
        HashSet<ChunkPos> toCheck = new HashSet<ChunkPos>();
        toCheck.add(chunk);
        while (!toCheck.isEmpty()) {
            ChunkPos pos = (ChunkPos)toCheck.iterator().next();
            toCheck.remove(pos);
            connected.add(pos);
            ChunkPos posUp = new ChunkPos(pos.x, pos.z - 1);
            if (!visited.contains(posUp) && this.hasChunk(posUp)) {
                toCheck.add(posUp);
            }
            visited.add(posUp);
            ChunkPos posDown = new ChunkPos(pos.x, pos.z + 1);
            if (!visited.contains(posDown) && this.hasChunk(posDown)) {
                toCheck.add(posDown);
            }
            visited.add(posDown);
            ChunkPos posRight = new ChunkPos(pos.x + 1, pos.z);
            if (!visited.contains(posRight) && this.hasChunk(posRight)) {
                toCheck.add(posRight);
            }
            visited.add(posRight);
            ChunkPos posLeft = new ChunkPos(pos.x - 1, pos.z);
            if (!visited.contains(posLeft) && this.hasChunk(posLeft)) {
                toCheck.add(posLeft);
            }
            visited.add(posLeft);
        }
        return connected;
    }

    public List<ChunkPos> getClosedRegion(ChunkPos chunk) {
        ArrayList<ChunkPos> region = new ArrayList<ChunkPos>();
        if (this.hasChunk(chunk) || this.chunks.isEmpty()) {
            return region;
        }
        ChunkPos topLeft = new ChunkPos(this.topLeft);
        ChunkPos bottomRight = new ChunkPos(this.bottomRight);
        if (chunk.x <= topLeft.x || chunk.x >= bottomRight.x || chunk.z <= topLeft.z || chunk.z >= bottomRight.z) {
            return region;
        }
        HashSet<ChunkPos> visited = new HashSet<ChunkPos>();
        visited.add(chunk);
        HashSet<ChunkPos> toCheck = new HashSet<ChunkPos>();
        toCheck.add(chunk);
        while (!toCheck.isEmpty()) {
            ChunkPos pos = (ChunkPos)toCheck.iterator().next();
            toCheck.remove(pos);
            region.add(pos);
            ChunkPos posUp = new ChunkPos(pos.x, pos.z - 1);
            if (!visited.contains(posUp) && !this.hasChunk(posUp)) {
                if (posUp.z == topLeft.z) {
                    return new ArrayList<ChunkPos>();
                }
                toCheck.add(posUp);
            }
            visited.add(posUp);
            ChunkPos posDown = new ChunkPos(pos.x, pos.z + 1);
            if (!visited.contains(posDown) && !this.hasChunk(posDown)) {
                if (posUp.z == bottomRight.z) {
                    return new ArrayList<ChunkPos>();
                }
                toCheck.add(posDown);
            }
            visited.add(posDown);
            ChunkPos posRight = new ChunkPos(pos.x + 1, pos.z);
            if (!visited.contains(posRight) && !this.hasChunk(posRight)) {
                if (posUp.x == bottomRight.x) {
                    return new ArrayList<ChunkPos>();
                }
                toCheck.add(posRight);
            }
            visited.add(posRight);
            ChunkPos posLeft = new ChunkPos(pos.x - 1, pos.z);
            if (!visited.contains(posLeft) && !this.hasChunk(posLeft)) {
                if (posUp.x == topLeft.x) {
                    return new ArrayList<ChunkPos>();
                }
                toCheck.add(posLeft);
            }
            visited.add(posLeft);
        }
        return region;
    }

    public void moveSelectedVertex(BlockPos pos, float snapDistance) {
        if (this.vertexSelected < 0 || this.vertexSelected >= this.vertices.size()) {
            return;
        }
        if (snapDistance != 0.0f) {
            pos = this.snapVertex(pos, snapDistance);
        }
        super.moveVertex(pos, this.vertexSelected);
        this.needUpdateOverlay = true;
        MapFrontiersClient.getFrontiersOverlayManager(this.personal).updateSelectedMarker(this.getDimension(), this);
    }

    @Override
    public void setName1(String name) {
        super.setName1(name);
        this.needUpdateOverlay = true;
    }

    @Override
    public void setName2(String name) {
        super.setName2(name);
        this.needUpdateOverlay = true;
    }

    @Override
    public void setVisibility(FrontierData.VisibilityData.Visibility visibility, boolean enable) {
        super.setVisibility(visibility, enable);
        this.setVisibilityOverride(MapFrontiersClient.getLocalOverrides().getVisibility(this.id));
        this.needUpdateOverlay = true;
    }

    @Override
    public void toggleVisibility(FrontierData.VisibilityData.Visibility visibility) {
        super.toggleVisibility(visibility);
        this.setVisibilityOverride(MapFrontiersClient.getLocalOverrides().getVisibility(this.id));
        this.needUpdateOverlay = true;
    }

    public void setVisibilityOverride(Pair<FrontierData.VisibilityData, FrontierData.VisibilityData> visibilityOverride) {
        this.effectiveVisibilityData = new FrontierData.VisibilityData(this.visibilityData);
        for (FrontierData.VisibilityData.Visibility visibility : FrontierData.VisibilityData.Visibility.values()) {
            if (!((FrontierData.VisibilityData)visibilityOverride.second()).getValue(visibility)) continue;
            this.effectiveVisibilityData.setValue(visibility, ((FrontierData.VisibilityData)visibilityOverride.first()).getValue(visibility));
        }
        this.needUpdateOverlay = true;
    }

    @Override
    public boolean getVisibility(FrontierData.VisibilityData.Visibility visibility) {
        return this.effectiveVisibilityData.getValue(visibility);
    }

    @Override
    public void setVisibilityData(FrontierData.VisibilityData visibilityData) {
        super.setVisibilityData(visibilityData);
        this.setVisibilityOverride(MapFrontiersClient.getLocalOverrides().getVisibility(this.id));
        this.needUpdateOverlay = true;
    }

    @Override
    public void setColor(int color) {
        super.setColor(color);
        this.needUpdateOverlay = true;
    }

    @Override
    public void setDimension(ResourceKey<Level> dimension) {
        super.setDimension(dimension);
        this.dirtyhash = true;
    }

    @Override
    public void setBanner(@Nullable ItemStack itemBanner) {
        super.setBanner(itemBanner);
        this.needUpdateOverlay = true;
        if (itemBanner == null) {
            this.bannerRenderer.releaseTexture();
        } else {
            this.bannerRenderer.createTexture(this.id, this.banner);
        }
    }

    @Override
    public void setBanner(DyeColor base, BannerPatternLayers bannerPatterns) {
        super.setBanner(base, bannerPatterns);
        this.bannerRenderer.createTexture(this.id, this.banner);
        this.needUpdateOverlay = true;
    }

    @Override
    public void setBannerData(@Nullable FrontierData.BannerData bannerData) {
        super.setBannerData(bannerData);
        this.needUpdateOverlay = true;
        if (bannerData == null) {
            this.bannerRenderer.releaseTexture();
        } else {
            this.bannerRenderer.createTexture(this.id, this.banner);
        }
    }

    @Override
    public void setBannerRotation(int rotation) {
        if (this.hasBanner()) {
            super.setBannerRotation(rotation);
            this.bannerRenderer.setRotation(rotation);
            this.needUpdateOverlay = true;
            this.dirtyhash = true;
        }
    }

    @Override
    public void addUserShared(SettingsUserShared userShared) {
        super.addUserShared(userShared);
        this.dirtyhash = true;
    }

    @Override
    public void removeUserShared(int index) {
        super.removeUserShared(index);
        this.dirtyhash = true;
    }

    @Override
    public void setUsersShared(List<SettingsUserShared> usersShared) {
        super.setUsersShared(usersShared);
        this.dirtyhash = true;
    }

    public BlockPos getClosestVertex(BlockPos vertex, double belowDistance) {
        BlockPos closest = null;
        double closestDistance = belowDistance;
        for (PolygonOverlay overlay : this.polygonOverlays) {
            for (BlockPos v : overlay.getOuterArea().getPoints()) {
                double distance = v.distSqr((Vec3i)vertex);
                if (!(distance <= closestDistance)) continue;
                closestDistance = distance;
                closest = v;
            }
            if (overlay.getHoles() == null) continue;
            for (MapPolygon hole : overlay.getHoles()) {
                for (BlockPos v : hole.getPoints()) {
                    double distance = v.distSqr((Vec3i)vertex);
                    if (!(distance <= closestDistance)) continue;
                    closestDistance = distance;
                    closest = v;
                }
            }
        }
        return closest;
    }

    public int[] getBannerBounds(int x, int y, int scale) {
        int width = 22 * scale;
        int height = 40 * scale;
        float centerX = (float)x + (float)width / 2.0f;
        float centerY = (float)y + (float)height / 2.0f;
        double radians = Math.toRadians(this.banner.rotation);
        double cos = Math.abs(Math.cos(radians));
        double sin = Math.abs(Math.sin(radians));
        float rotatedWidth = (float)((double)width * cos + (double)height * sin);
        float rotatedHeight = (float)((double)width * sin + (double)height * cos);
        int minX = (int)Math.floor(centerX - rotatedWidth / 2.0f);
        int maxX = (int)Math.ceil(centerX + rotatedWidth / 2.0f);
        int minY = (int)Math.floor(centerY - rotatedHeight / 2.0f);
        int maxY = (int)Math.ceil(centerY + rotatedHeight / 2.0f);
        return new int[]{minX, minY, maxX, maxY};
    }

    public BannerRenderer getBannerRenderer() {
        return this.bannerRenderer;
    }

    public void recreateBannerRenderer() {
        this.bannerRenderer.releaseTexture();
        if (this.banner != null) {
            this.bannerRenderer.createTexture(this.id, this.banner);
        }
    }

    public void removeSelectedVertex() {
        if (this.vertexSelected < 0) {
            return;
        }
        super.removeVertex(this.vertexSelected);
        this.vertexSelected = this.vertices.isEmpty() ? -1 : (this.vertexSelected > 0 ? --this.vertexSelected : this.vertices.size() - 1);
        MapFrontiersClient.getFrontiersOverlayManager(this.personal).updateSelectedMarker(this.getDimension(), this);
        this.needUpdateOverlay = true;
    }

    public void selectNextVertex() {
        ++this.vertexSelected;
        if (this.vertexSelected >= this.vertices.size()) {
            this.vertexSelected = -1;
        }
        MapFrontiersClient.getFrontiersOverlayManager(this.personal).updateSelectedMarker(this.getDimension(), this);
    }

    public int getSelectedVertexIndex() {
        return this.vertexSelected;
    }

    public BlockPos getSelectedVertex() {
        if (this.vertexSelected >= 0 && this.vertexSelected < this.vertices.size()) {
            return (BlockPos)this.vertices.get(this.vertexSelected);
        }
        return null;
    }

    public void setHighlighted(boolean highlighted) {
        this.highlighted = highlighted;
        this.needUpdateOverlay = true;
    }

    public BlockPos getCenter() {
        return new BlockPos((this.topLeft.getX() + this.bottomRight.getX()) / 2, 70, (this.topLeft.getZ() + this.bottomRight.getZ()) / 2);
    }

    private BlockPos snapVertex(BlockPos vertex, float snapDistance) {
        double dist;
        BlockPos v;
        BlockPos closest = vertex = vertex.atY(70);
        double closestDistance = snapDistance * snapDistance;
        for (FrontierOverlay frontier : MapFrontiersClient.getFrontiersOverlayManager(true).getAllFrontiers((ResourceKey<Level>)this.dimension)) {
            if (frontier == this || (v = frontier.getClosestVertex(vertex, closestDistance)) == null || !((dist = v.distSqr((Vec3i)vertex)) <= closestDistance)) continue;
            closest = v;
            closestDistance = dist;
        }
        for (FrontierOverlay frontier : MapFrontiersClient.getFrontiersOverlayManager(false).getAllFrontiers((ResourceKey<Level>)this.dimension)) {
            if (frontier == this || (v = frontier.getClosestVertex(vertex, closestDistance)) == null || !((dist = v.distSqr((Vec3i)vertex)) <= closestDistance)) continue;
            closest = v;
            closestDistance = dist;
        }
        return closest;
    }

    public void recalculateOverlays() {
        this.polygonOverlays.clear();
        this.markerOverlays.clear();
        this.bannerOverlays.clear();
        this.updateBounds();
        this.area = 0.0f;
        this.perimeter = 0.0f;
        this.polygonArea = null;
        ShapeProperties shapeProps = new ShapeProperties().setStrokeWidth((float)Config.borderWidth).setStrokeColor(this.color).setStrokeOpacity((float)Config.borderOpacity).setStrokePosition(ShapeProperties.StrokePosition.INSIDE).setFillColor(this.color).setFillOpacity((float)Config.polygonsOpacity);
        if (this.mode == FrontierData.Mode.Vertex) {
            this.recalculateVertices(shapeProps);
        } else {
            this.recalculateChunks(shapeProps);
        }
        if (this.highlighted) {
            ShapeProperties highlightShapeProps = new ShapeProperties().setStrokeWidth(2.0f).setStrokeColor(0xFFFFFF).setStrokeOpacity(1.0f).setStrokePosition(ShapeProperties.StrokePosition.OUTSIDE).setFillOpacity(0.0f);
            ArrayList<PolygonOverlay> highlightedOverlays = new ArrayList<PolygonOverlay>();
            for (PolygonOverlay polygonOverlay : this.polygonOverlays) {
                highlightedOverlays.add(new PolygonOverlay("mapfrontiers", this.dimension, highlightShapeProps, polygonOverlay.getOuterArea(), polygonOverlay.getHoles()));
            }
            this.polygonOverlays.addAll(highlightedOverlays);
        }
    }

    private void addPolygonOverlays(ShapeProperties shapeProps, MapPolygon polygon, @Nullable List<MapPolygon> polygonHoles) {
        PolygonOverlay overlay;
        boolean fullscreenV = Config.getVisibilityValue(Config.fullscreenVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.Fullscreen));
        boolean fullscreenNameV = Config.getVisibilityValue(Config.fullscreenNameVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.FullscreenName));
        boolean fullscreenOwnerV = Config.getVisibilityValue(Config.fullscreenOwnerVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.FullscreenOwner));
        boolean fullscreenBannerV = Config.getVisibilityValue(Config.fullscreenBannerVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.FullscreenBanner));
        boolean fullscreenDayV = Config.getVisibilityValue(Config.fullscreenDayVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.FullscreenDay));
        boolean fullscreenNightV = Config.getVisibilityValue(Config.fullscreenNightVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.FullscreenNight));
        boolean fullscreenUndergroundV = Config.getVisibilityValue(Config.fullscreenUndergroundVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.FullscreenUnderground));
        boolean fullscreenTopoV = Config.getVisibilityValue(Config.fullscreenTopoVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.FullscreenTopo));
        boolean fullscreenBiomeV = Config.getVisibilityValue(Config.fullscreenBiomeVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.FullscreenBiome));
        boolean minimapV = Config.getVisibilityValue(Config.minimapVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.Minimap));
        boolean minimapNameV = Config.getVisibilityValue(Config.minimapNameVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.MinimapName));
        boolean minimapOwnerV = Config.getVisibilityValue(Config.minimapOwnerVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.MinimapOwner));
        boolean minimapBannerV = Config.getVisibilityValue(Config.minimapBannerVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.MinimapBanner));
        boolean minimapDayV = Config.getVisibilityValue(Config.minimapDayVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.MinimapDay));
        boolean minimapNightV = Config.getVisibilityValue(Config.minimapNightVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.MinimapNight));
        boolean minimapUndergroundV = Config.getVisibilityValue(Config.minimapUndergroundVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.MinimapUnderground));
        boolean minimapTopoV = Config.getVisibilityValue(Config.minimapTopoVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.MinimapTopo));
        boolean minimapBiomeV = Config.getVisibilityValue(Config.minimapBiomeVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.MinimapBiome));
        boolean webmapV = Config.getVisibilityValue(Config.webmapVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.Webmap));
        boolean webmapNameV = Config.getVisibilityValue(Config.webmapNameVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.WebmapName));
        boolean webmapOwnerV = Config.getVisibilityValue(Config.webmapOwnerVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.WebmapOwner));
        boolean webmapBannerV = Config.getVisibilityValue(Config.webmapBannerVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.WebmapBanner));
        boolean webmapDayV = Config.getVisibilityValue(Config.webmapDayVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.WebmapDay));
        boolean webmapNightV = Config.getVisibilityValue(Config.webmapNightVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.WebmapNight));
        boolean webmapUndergroundV = Config.getVisibilityValue(Config.webmapUndergroundVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.WebmapUnderground));
        boolean webmapTopoV = Config.getVisibilityValue(Config.webmapTopoVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.WebmapTopo));
        boolean webmapBiomeV = Config.getVisibilityValue(Config.webmapBiomeVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.WebmapBiome));
        BlockPos firstpoint = (BlockPos)polygon.getPoints().getFirst();
        Rectangle2D.Double polygonBound = new Rectangle2D.Double(firstpoint.getX(), firstpoint.getZ(), 1.0, 1.0);
        for (BlockPos point : polygon.getPoints()) {
            polygonBound.add(point.getX(), point.getZ());
        }
        if (fullscreenV) {
            overlay = new PolygonOverlay("mapfrontiers", this.dimension, shapeProps, polygon, polygonHoles);
            overlay.setActiveUIs(new Context.UI[]{Context.UI.Fullscreen});
            overlay.setActiveMapTypes(this.getActiveMapTypes(fullscreenDayV, fullscreenNightV, fullscreenUndergroundV, fullscreenTopoV, fullscreenBiomeV));
            this.addNameOwnerAndBanner(overlay, polygonBound, fullscreenNameV, fullscreenOwnerV, fullscreenBannerV);
            this.polygonOverlays.add(overlay);
        }
        if (minimapV) {
            overlay = new PolygonOverlay("mapfrontiers", this.dimension, shapeProps, polygon, polygonHoles);
            overlay.setActiveUIs(new Context.UI[]{Context.UI.Minimap});
            overlay.setActiveMapTypes(this.getActiveMapTypes(minimapDayV, minimapNightV, minimapUndergroundV, minimapTopoV, minimapBiomeV));
            this.addNameOwnerAndBanner(overlay, polygonBound, minimapNameV, minimapOwnerV, minimapBannerV);
            this.polygonOverlays.add(overlay);
        }
        if (webmapV) {
            overlay = new PolygonOverlay("mapfrontiers", this.dimension, shapeProps, polygon, polygonHoles);
            overlay.setActiveUIs(new Context.UI[]{Context.UI.Webmap});
            overlay.setActiveMapTypes(this.getActiveMapTypes(webmapDayV, webmapNightV, webmapUndergroundV, webmapTopoV, webmapBiomeV));
            this.addNameOwnerAndBanner(overlay, polygonBound, webmapNameV, webmapOwnerV, webmapBannerV);
            this.polygonOverlays.add(overlay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalculateVertices(ShapeProperties shapeProps) {
        List list = this.vertices;
        synchronized (list) {
            if (this.vertices.size() > 2) {
                MapPolygon polygon = new MapPolygon(this.vertices);
                this.addPolygonOverlays(shapeProps, polygon, null);
                this.polygonArea = PolygonHelper.toArea((MapPolygon)polygon);
                BlockPos last = (BlockPos)this.vertices.getLast();
                for (BlockPos vertex : this.vertices) {
                    this.area += (float)(last.getX() * vertex.getZ() - last.getZ() * vertex.getX());
                    last = vertex;
                }
                this.area = Math.abs(this.area / 2.0f);
            } else {
                boolean fullscreenV = Config.getVisibilityValue(Config.fullscreenVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.Fullscreen));
                boolean fullscreenDayV = Config.getVisibilityValue(Config.fullscreenDayVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.FullscreenDay));
                boolean fullscreenNightV = Config.getVisibilityValue(Config.fullscreenNightVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.FullscreenNight));
                boolean fullscreenUndergroundV = Config.getVisibilityValue(Config.fullscreenUndergroundVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.FullscreenUnderground));
                boolean fullscreenTopoV = Config.getVisibilityValue(Config.fullscreenTopoVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.FullscreenTopo));
                boolean fullscreenBiomeV = Config.getVisibilityValue(Config.fullscreenBiomeVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.FullscreenBiome));
                boolean minimapV = Config.getVisibilityValue(Config.minimapVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.Minimap));
                boolean minimapDayV = Config.getVisibilityValue(Config.minimapDayVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.MinimapDay));
                boolean minimapNightV = Config.getVisibilityValue(Config.minimapNightVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.MinimapNight));
                boolean minimapUndergroundV = Config.getVisibilityValue(Config.minimapUndergroundVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.MinimapUnderground));
                boolean minimapTopoV = Config.getVisibilityValue(Config.minimapTopoVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.MinimapTopo));
                boolean minimapBiomeV = Config.getVisibilityValue(Config.minimapBiomeVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.MinimapBiome));
                boolean webmapV = Config.getVisibilityValue(Config.webmapVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.Webmap));
                boolean webmapDayV = Config.getVisibilityValue(Config.webmapDayVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.WebmapDay));
                boolean webmapNightV = Config.getVisibilityValue(Config.webmapNightVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.WebmapNight));
                boolean webmapUndergroundV = Config.getVisibilityValue(Config.webmapUndergroundVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.WebmapUnderground));
                boolean webmapTopoV = Config.getVisibilityValue(Config.webmapTopoVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.WebmapTopo));
                boolean webmapBiomeV = Config.getVisibilityValue(Config.webmapBiomeVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.WebmapBiome));
                if (fullscreenV) {
                    this.createMarkersFromVertices(Context.UI.Fullscreen, this.getActiveMapTypes(fullscreenDayV, fullscreenNightV, fullscreenUndergroundV, fullscreenTopoV, fullscreenBiomeV));
                }
                if (minimapV) {
                    this.createMarkersFromVertices(Context.UI.Minimap, this.getActiveMapTypes(minimapDayV, minimapNightV, minimapUndergroundV, minimapTopoV, minimapBiomeV));
                }
                if (webmapV) {
                    this.createMarkersFromVertices(Context.UI.Webmap, this.getActiveMapTypes(webmapDayV, webmapNightV, webmapUndergroundV, webmapTopoV, webmapBiomeV));
                }
            }
            if (this.vertices.size() > 1) {
                BlockPos last = (BlockPos)this.vertices.getLast();
                for (BlockPos vertex : this.vertices) {
                    this.perimeter += (float)Math.sqrt(vertex.distSqr((Vec3i)last));
                    last = vertex;
                }
            }
        }
    }

    private Context.MapType[] getActiveMapTypes(boolean day, boolean night, boolean underground, boolean topo, boolean biome) {
        ArrayList<Context.MapType> mapTypes = new ArrayList<Context.MapType>();
        if (day) {
            mapTypes.add(Context.MapType.Day);
        }
        if (night) {
            mapTypes.add(Context.MapType.Night);
        }
        if (underground) {
            mapTypes.add(Context.MapType.Underground);
        }
        if (topo) {
            mapTypes.add(Context.MapType.Topo);
        }
        if (biome) {
            mapTypes.add(Context.MapType.Biome);
        }
        return mapTypes.toArray(new Context.MapType[0]);
    }

    private void createMarkersFromVertices(Context.UI uiArray, Context.MapType[] mapTypesArray) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            MarkerOverlay marker = new MarkerOverlay("mapfrontiers", (BlockPos)this.vertices.get(i), markerVertex);
            marker.setDimension(this.dimension);
            marker.setDisplayOrder(100);
            marker.setActiveUIs(new Context.UI[]{uiArray});
            marker.setActiveMapTypes(mapTypesArray);
            this.markerOverlays.add(marker);
            if (i != 0 || this.vertices.size() != 2) continue;
            this.addMarkerDots((BlockPos)this.vertices.get(0), (BlockPos)this.vertices.get(1), uiArray, mapTypesArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalculateChunks(ShapeProperties shapeProps) {
        HashMultimap edges = HashMultimap.create();
        Set set = this.chunks;
        synchronized (set) {
            for (ChunkPos chunk : this.chunks) {
                FrontierOverlay.addNewEdge((Multimap<ChunkPos, ChunkPos>)edges, new ChunkPos(chunk.x, chunk.z), new ChunkPos(chunk.x + 1, chunk.z));
                FrontierOverlay.addNewEdge((Multimap<ChunkPos, ChunkPos>)edges, new ChunkPos(chunk.x + 1, chunk.z), new ChunkPos(chunk.x + 1, chunk.z + 1));
                FrontierOverlay.addNewEdge((Multimap<ChunkPos, ChunkPos>)edges, new ChunkPos(chunk.x + 1, chunk.z + 1), new ChunkPos(chunk.x, chunk.z + 1));
                FrontierOverlay.addNewEdge((Multimap<ChunkPos, ChunkPos>)edges, new ChunkPos(chunk.x, chunk.z + 1), new ChunkPos(chunk.x, chunk.z));
            }
        }
        ArrayList outerPolygons = new ArrayList();
        HashMultimap holesPolygons = HashMultimap.create();
        while (!edges.isEmpty()) {
            boolean clockwise;
            ChunkPos edge2;
            ChunkPos starting = (ChunkPos)Collections.min(edges.keySet(), (e1, e2) -> e1.x == e2.x ? e1.z - e2.z : e1.x - e2.x);
            ArrayList<ChunkPos> arrayList = new ArrayList<ChunkPos>();
            Object edge = starting;
            int direction = 1;
            do {
                arrayList.add((ChunkPos)edge);
                Iterator it = edges.get(edge).iterator();
                edge2 = (ChunkPos)it.next();
                while (it.hasNext() && Integer.signum(direction) == Integer.signum(edge2.x - ((ChunkPos)edge).x + ((ChunkPos)edge).z - edge2.z)) {
                    edge2 = (ChunkPos)it.next();
                }
                edges.remove(edge, (Object)edge2);
                direction = edge2.x - ((ChunkPos)edge).x + edge2.z - ((ChunkPos)edge).z;
            } while (!(edge = edge2).equals((Object)starting));
            this.perimeter += (float)(arrayList.size() * 16);
            boolean bl = clockwise = ((ChunkPos)arrayList.get((int)0)).x != ((ChunkPos)arrayList.get((int)1)).x;
            if (clockwise) {
                outerPolygons.add(arrayList);
                continue;
            }
            ChunkPos ray = (ChunkPos)arrayList.getFirst();
            ChunkPos outerFound = null;
            for (int i = 0; i < 999; ++i) {
                for (List list : outerPolygons) {
                    ChunkPos outerStart = (ChunkPos)list.getFirst();
                    if (list.contains(ray)) {
                        outerFound = outerStart;
                        break;
                    }
                    for (List hole : holesPolygons.get((Object)outerStart)) {
                        if (!hole.contains(ray)) continue;
                        outerFound = outerStart;
                        break;
                    }
                    if (outerFound == null) continue;
                    break;
                }
                if (outerFound != null) break;
                ray = new ChunkPos(ray.x - 1, ray.z);
            }
            if (outerFound != null) {
                holesPolygons.put(outerFound, arrayList);
                continue;
            }
            MapFrontiers.LOGGER.warn(String.format("Frontier %1$s is too large and the polygon corresponding to the hole %2$s could not be located", this.id, arrayList.getFirst()));
        }
        for (List list : outerPolygons) {
            FrontierOverlay.removeCollinear(list);
            for (List hole : holesPolygons.get((Object)((ChunkPos)list.getFirst()))) {
                FrontierOverlay.removeCollinear(hole);
            }
        }
        for (List list : outerPolygons) {
            MapPolygon polygon = new MapPolygon(list.stream().map(c -> new BlockPos(c.getMinBlockX(), 70, c.getMinBlockZ())).toList());
            ArrayList<MapPolygon> polygonHoles = null;
            if (holesPolygons.containsKey(list.getFirst())) {
                polygonHoles = new ArrayList<MapPolygon>();
                for (List hole : holesPolygons.get((Object)((ChunkPos)list.getFirst()))) {
                    polygonHoles.add(new MapPolygon(hole.stream().map(c -> new BlockPos(c.getMinBlockX(), 70, c.getMinBlockZ())).toList()));
                }
            }
            this.addPolygonOverlays(shapeProps, polygon, polygonHoles);
        }
        this.area = this.chunks.size() * 256;
    }

    private static void addNewEdge(Multimap<ChunkPos, ChunkPos> edges, ChunkPos from, ChunkPos to) {
        if (!edges.remove((Object)to, (Object)from)) {
            edges.put((Object)from, (Object)to);
        }
    }

    private static void removeCollinear(List<ChunkPos> chunks) {
        if (chunks.size() <= 4) {
            return;
        }
        ChunkPos prev = chunks.getFirst();
        for (int i = chunks.size() - 1; i > 0; --i) {
            ChunkPos next = chunks.get(i - 1);
            if (prev.x == next.x || prev.z == next.z) {
                chunks.remove(i);
            }
            if (i >= chunks.size()) continue;
            prev = chunks.get(i);
        }
    }

    private void addNameOwnerAndBanner(PolygonOverlay polygonOverlay, Rectangle2D.Double polygonBound, boolean nameVisible, boolean ownerVisible, boolean bannerVisible) {
        boolean bl = bannerVisible = bannerVisible && this.bannerRenderer.hasBanner();
        if (!(nameVisible || ownerVisible || bannerVisible)) {
            return;
        }
        TextProperties textProps = new TextProperties().setOpacity((float)Config.textOpacity).setScale((float)Config.textSize).setBackgroundOpacity(0.0f);
        switch (Config.textColor) {
            case Frontier: {
                textProps.setColor(this.color);
                break;
            }
            case Bright: {
                textProps.setColor(this.colorMaxBrightness(this.color));
                break;
            }
            case White: {
                textProps.setColor(-1);
            }
        }
        int lines = 0;
        int totalWidth = 0;
        Object label = "";
        if (nameVisible) {
            if (!this.name1.isEmpty()) {
                ++lines;
                totalWidth = Math.max(totalWidth, Minecraft.getInstance().font.width(this.name1));
                label = (String)label + this.name1;
            }
            if (!this.name2.isEmpty()) {
                ++lines;
                totalWidth = Math.max(totalWidth, Minecraft.getInstance().font.width(this.name2));
                if (!((String)label).isEmpty()) {
                    label = (String)label + "\n";
                }
                label = (String)label + this.name2;
            }
        }
        if (ownerVisible && !this.owner.username.isEmpty()) {
            ++lines;
            totalWidth = Math.max(totalWidth, Minecraft.getInstance().font.width(this.owner.username));
            if (!((String)label).isEmpty()) {
                label = (String)label + "\n";
            }
            label = (String)label + String.valueOf(ChatFormatting.ITALIC) + this.owner.username;
        }
        totalWidth *= Config.textSize;
        int totalHeight = lines * 9 * Config.textSize;
        if (bannerVisible) {
            totalHeight += 40 * Config.bannerSize;
        }
        int topOffset = totalHeight / 2;
        int textOffset = topOffset - lines * 9 * Config.textSize / 2;
        int bannerOffset = topOffset - lines * 9 * Config.textSize;
        if (lines > 1) {
            textOffset = bannerVisible ? (textOffset -= 6) : (textOffset += 12);
        } else if (lines == 1) {
            textOffset = bannerVisible ? (textOffset += 5) : (textOffset += 3);
        }
        textProps.setOffsetY(textOffset);
        if (Config.hideNamesThatDontFit) {
            if (bannerVisible) {
                totalWidth = Math.max(totalWidth, 20 * Config.bannerSize);
            }
            this.setMinSizeTextProperties(textProps, polygonBound, totalWidth + 6, totalHeight + 6);
        }
        if (bannerVisible) {
            MapImage bannerIcon = new MapImage(this.bannerRenderer.getImage());
            bannerIcon.setBlur(false);
            bannerIcon.setAnchorX((double)(10 * Config.bannerSize));
            bannerIcon.setAnchorY((double)bannerOffset);
            bannerIcon.setDisplayWidth((double)(20 * Config.bannerSize));
            bannerIcon.setDisplayHeight((double)(40 * Config.bannerSize));
            bannerIcon.setOpacity((float)Config.bannerOpacity);
            bannerIcon.setRotation(-this.bannerRenderer.getRotation());
            BlockPos polygonCenter = BlockPos.containing((double)polygonBound.getCenterX(), (double)70.0, (double)polygonBound.getCenterY());
            MarkerOverlay bannerOverlay = new MarkerOverlay("mapfrontiers", polygonCenter, bannerIcon);
            bannerOverlay.setActiveUIs(polygonOverlay.getActiveUIs().toArray(new Context.UI[0]));
            bannerOverlay.setActiveMapTypes(polygonOverlay.getActiveMapTypes().toArray(new Context.MapType[0]));
            bannerOverlay.setDimension(this.dimension);
            bannerOverlay.setMinZoom(textProps.getMinZoom());
            bannerOverlay.setMaxZoom(textProps.getMaxZoom());
            this.bannerOverlays.add(bannerOverlay);
            if (lines > 0) {
                bannerOverlay.setTextProperties(textProps).setOverlayGroupName("frontier").setLabel((String)label);
            }
        } else if (lines > 0) {
            polygonOverlay.setTextProperties(textProps).setOverlayGroupName("frontier").setLabel((String)label);
        }
    }

    private int colorMaxBrightness(int color) {
        float[] hsv = Color.RGBtoHSB(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, null);
        return Color.HSBtoRGB(hsv[0], hsv[1], 1.0f);
    }

    private void setMinSizeTextProperties(TextProperties textProperties, Rectangle2D.Double polygonBound, int width, int height) {
        int zoom;
        double polygonWidthScaled = polygonBound.getWidth() / 256.0;
        double polygonHeightScaled = polygonBound.getHeight() / 256.0;
        for (zoom = 2; ((double)width > polygonWidthScaled || (double)height > polygonHeightScaled) && zoom < 8192; zoom *= 2, polygonWidthScaled *= 2.0, polygonHeightScaled *= 2.0) {
        }
        textProperties.setMinZoom(zoom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBounds() {
        if (this.mode == FrontierData.Mode.Vertex) {
            if (this.vertices.isEmpty()) {
                this.topLeft = new BlockPos(0, 70, 0);
                this.bottomRight = new BlockPos(0, 70, 0);
            } else {
                int minX = Integer.MAX_VALUE;
                int minZ = Integer.MAX_VALUE;
                int maxX = Integer.MIN_VALUE;
                int maxZ = Integer.MIN_VALUE;
                List list = this.vertices;
                synchronized (list) {
                    for (BlockPos vertex : this.vertices) {
                        if (vertex.getX() < minX) {
                            minX = vertex.getX();
                        }
                        if (vertex.getZ() < minZ) {
                            minZ = vertex.getZ();
                        }
                        if (vertex.getX() > maxX) {
                            maxX = vertex.getX();
                        }
                        if (vertex.getZ() <= maxZ) continue;
                        maxZ = vertex.getZ();
                    }
                }
                this.topLeft = new BlockPos(minX, 70, minZ);
                this.bottomRight = new BlockPos(maxX, 70, maxZ);
            }
        } else if (this.chunks.isEmpty()) {
            this.topLeft = new BlockPos(0, 70, 0);
            this.bottomRight = new BlockPos(0, 70, 0);
        } else {
            int minX = Integer.MAX_VALUE;
            int minZ = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int maxZ = Integer.MIN_VALUE;
            Set set = this.chunks;
            synchronized (set) {
                for (ChunkPos chunk : this.chunks) {
                    if (chunk.x < minX) {
                        minX = chunk.x;
                    }
                    if (chunk.z < minZ) {
                        minZ = chunk.z;
                    }
                    if (chunk.x > maxX) {
                        maxX = chunk.x;
                    }
                    if (chunk.z <= maxZ) continue;
                    maxZ = chunk.z;
                }
            }
            this.topLeft = new BlockPos(minX * 16, 70, minZ * 16);
            this.bottomRight = new BlockPos(maxX * 16 + 16, 70, maxZ * 16 + 16);
        }
    }

    private void addMarkerDots(BlockPos from, BlockPos to, Context.UI uiArray, Context.MapType[] mapTypesArray) {
        if (Math.abs(to.getZ() - from.getZ()) < Math.abs(to.getX() - from.getX())) {
            if (from.getX() > to.getX()) {
                this.addLineMarkerDots(to.getX(), to.getZ(), from.getX(), from.getZ(), uiArray, mapTypesArray);
            } else {
                this.addLineMarkerDots(from.getX(), from.getZ(), to.getX(), to.getZ(), uiArray, mapTypesArray);
            }
        } else if (from.getZ() > to.getZ()) {
            this.addLineMarkerDots(to.getX(), to.getZ(), from.getX(), from.getZ(), uiArray, mapTypesArray);
        } else {
            this.addLineMarkerDots(from.getX(), from.getZ(), to.getX(), to.getZ(), uiArray, mapTypesArray);
        }
    }

    private void addLineMarkerDots(int x0, int z0, int x1, int z1, Context.UI uiArray, Context.MapType[] mapTypesArray) {
        int dx = Math.abs(x1 - x0);
        int sx = x0 < x1 ? 1 : -1;
        int dz = -Math.abs(z1 - z0);
        int sz = z0 < z1 ? 1 : -1;
        int err = dx + dz;
        int i = 0;
        while (x0 != x1 || z0 != z1) {
            int e2 = 2 * err;
            if (e2 >= dz) {
                if (x0 == x1) break;
                err += dz;
                x0 += sx;
            }
            if (e2 <= dx) {
                if (z0 == z1) break;
                err += dx;
                z0 += sz;
            }
            BlockPos pos = new BlockPos(x0, 70, z0);
            MarkerOverlay dot = new MarkerOverlay("mapfrontiers", pos, markerDot);
            dot.setDimension(this.dimension);
            dot.setDisplayOrder(99);
            dot.setActiveUIs(new Context.UI[]{uiArray});
            dot.setActiveMapTypes(mapTypesArray);
            int minZoom = 2;
            if (i % 2 == 0) {
                minZoom = 16384;
            } else if (i % 4 == 1) {
                minZoom = 8192;
            } else if (i % 8 == 3) {
                minZoom = 4096;
            }
            dot.setMinZoom(minZoom);
            this.markerOverlays.add(dot);
            ++i;
        }
    }

    static {
        markerVertex.setAnchorX(markerVertex.getDisplayWidth() / 2.0).setAnchorY(markerVertex.getDisplayHeight() / 2.0);
        markerDot.setAnchorX(markerDot.getDisplayWidth() / 2.0).setAnchorY(markerDot.getDisplayHeight() / 2.0);
    }

    public static class BannerRenderer {
        private ResourceLocation textureLocation;
        private NativeImage bannerImage;
        private int rotation;

        private void createTexture(UUID id, FrontierData.BannerData bannerData) {
            this.releaseTexture();
            this.rotation = bannerData.rotation;
            Minecraft mc = Minecraft.getInstance();
            ClientLevel level = mc.level;
            if (level == null) {
                return;
            }
            Optional bannerPatterns = BannerPatternLayers.CODEC.parse((DynamicOps)level.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)bannerData.patterns).result();
            if (!bannerPatterns.isPresent()) {
                MapFrontiers.LOGGER.error("Error creating banner pattern layers");
                return;
            }
            BannerPatternLayers patternLayers = (BannerPatternLayers)bannerPatterns.get();
            ModelPart bannerModelPart = mc.getEntityModels().bakeLayer(ModelLayers.STANDING_BANNER_FLAG).getChild("flag");
            float[] flagUV = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
            bannerModelPart.visit(new PoseStack(), (pose, path, i, cube) -> {
                for (ModelPart.Polygon polygon : ((CubeInvoker)cube).mapfrontiers$getPolygon()) {
                    if (!(polygon.normal().z() < 0.0f)) continue;
                    flagUV[0] = polygon.vertices()[0].u();
                    flagUV[1] = polygon.vertices()[0].v();
                    flagUV[2] = polygon.vertices()[2].u();
                    flagUV[3] = polygon.vertices()[2].v();
                }
            });
            if (flagUV[0] == flagUV[2] || flagUV[1] == flagUV[3]) {
                MapFrontiers.LOGGER.error("Error creating banner pattern layers");
                return;
            }
            TextureAtlasSprite base = Sheets.BANNER_BASE.sprite();
            SpriteContents baseSprite = base.contents();
            int width = (int)(Math.abs(flagUV[0] - flagUV[2]) * (float)baseSprite.width());
            int height = (int)(Math.abs(flagUV[1] - flagUV[3]) * (float)baseSprite.height());
            NativeImage tempBannerImage = new NativeImage(width, height, false);
            BannerRenderer.generateBannerLayer(tempBannerImage, flagUV, baseSprite, bannerData.baseColor);
            for (int i2 = 0; i2 < patternLayers.layers().size(); ++i2) {
                BannerPatternLayers.Layer layer = (BannerPatternLayers.Layer)patternLayers.layers().get(i2);
                ResourceLocation patternTextureLocation = ((BannerPattern)layer.pattern().value()).assetId().withPrefix("entity/banner/");
                TextureAtlasSprite sprite = (TextureAtlasSprite)mc.getTextureAtlas(Sheets.BANNER_SHEET).apply(patternTextureLocation);
                BannerRenderer.generateBannerLayer(tempBannerImage, flagUV, sprite.contents(), layer.color());
            }
            this.bannerImage = tempBannerImage.mappedCopy(ARGB::opaque);
            this.textureLocation = ResourceLocation.fromNamespaceAndPath((String)"mapfrontiers", (String)id.toString());
            DynamicTexture texture = new DynamicTexture(() -> this.textureLocation.toString(), this.bannerImage);
            texture.setFilter(false, false);
            mc.getTextureManager().register(this.textureLocation, (AbstractTexture)texture);
        }

        private static void generateBannerLayer(NativeImage bannerImage, float[] flagUV, SpriteContents sprite, DyeColor dye) {
            NativeImage spriteImage = ((SpriteContentsInvoker)sprite).mapfrontiers$getOriginalImage();
            for (int y = 0; y < bannerImage.getHeight(); ++y) {
                for (int x = 0; x < bannerImage.getWidth(); ++x) {
                    int u = (int)(Mth.lerp((float)(((float)x + 0.5f) / (float)bannerImage.getWidth()), (float)flagUV[2], (float)flagUV[0]) * (float)sprite.width());
                    int v = (int)(Mth.lerp((float)(((float)y + 0.5f) / (float)bannerImage.getHeight()), (float)flagUV[1], (float)flagUV[3]) * (float)sprite.height());
                    int color = ARGB.multiply((int)spriteImage.getPixel(u, v), (int)dye.getTextureDiffuseColor());
                    BannerRenderer.blendPixel(bannerImage, x, y, color);
                }
            }
        }

        private static void blendPixel(NativeImage image, int x, int y, int color) {
            int i = image.getPixel(x, y);
            float f = (float)ARGB.alpha((int)color) / 255.0f;
            float f1 = (float)ARGB.red((int)color) / 255.0f;
            float f2 = (float)ARGB.green((int)color) / 255.0f;
            float f3 = (float)ARGB.blue((int)color) / 255.0f;
            float f4 = (float)ARGB.alpha((int)i) / 255.0f;
            float f5 = (float)ARGB.red((int)i) / 255.0f;
            float f6 = (float)ARGB.green((int)i) / 255.0f;
            float f7 = (float)ARGB.blue((int)i) / 255.0f;
            float f8 = 1.0f - f;
            float f9 = f * f + f4 * f8;
            float f10 = f1 * f + f5 * f8;
            float f11 = f2 * f + f6 * f8;
            float f12 = f3 * f + f7 * f8;
            if (f9 > 1.0f) {
                f9 = 1.0f;
            }
            if (f10 > 1.0f) {
                f10 = 1.0f;
            }
            if (f11 > 1.0f) {
                f11 = 1.0f;
            }
            if (f12 > 1.0f) {
                f12 = 1.0f;
            }
            int j = (int)(f9 * 255.0f);
            int k = (int)(f10 * 255.0f);
            int l = (int)(f11 * 255.0f);
            int i1 = (int)(f12 * 255.0f);
            image.setPixel(x, y, ARGB.color((int)j, (int)k, (int)l, (int)i1));
        }

        public void renderBanner(GuiGraphics graphics, int centerX, int y, int scale) {
            if (this.textureLocation == null) {
                return;
            }
            int width = 20 * scale;
            int height = 40 * scale;
            int x = centerX - width / 2;
            float centerY = (float)y + (float)height / 2.0f;
            graphics.pose().pushMatrix();
            graphics.pose().translate((float)centerX, centerY);
            graphics.pose().rotate((float)Math.toRadians(this.rotation));
            graphics.pose().translate((float)(-centerX), -centerY);
            ((GuiGraphicsAccessor)graphics).innerBlitInvoker(RenderPipelines.GUI_TEXTURED, this.textureLocation, x, x + width, y, y + height, 0.0f, 1.0f, 0.0f, 1.0f, -1);
            graphics.pose().popMatrix();
        }

        public boolean hasBanner() {
            return this.textureLocation != null;
        }

        public NativeImage getImage() {
            return this.bannerImage;
        }

        private void releaseTexture() {
            if (this.textureLocation != null) {
                Minecraft.getInstance().getTextureManager().release(this.textureLocation);
                this.textureLocation = null;
            }
            if (this.bannerImage != null) {
                this.bannerImage.close();
                this.bannerImage = null;
            }
        }

        public void setRotation(int rotation) {
            this.rotation = rotation;
        }

        public int getRotation() {
            return this.rotation;
        }
    }
}

