/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client;

import com.mojang.brigadier.CommandDispatcher;
import games.alejandrocoria.mapfrontiers.MapFrontiersFabric;
import games.alejandrocoria.mapfrontiers.client.ChatFrontiers;
import games.alejandrocoria.mapfrontiers.client.FabricClientCommandAccept;
import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElementRegistry;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenMouseEvents;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import net.minecraft.class_437;

@ParametersAreNonnullByDefault
public class MapFrontiersClientFabric
extends MapFrontiersClient
implements ClientModInitializer {
    public void onInitializeClient() {
        openSettingsKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("mapfrontiers.key.open_settings", class_3675.class_307.field_1668, 297, "mapfrontiers.key.category"));
        ClientTickEvents.START_CLIENT_TICK.register(ClientEventHandler::postClientTickEvent);
        ClientTickEvents.END_CLIENT_TICK.register(client -> ClientEventHandler.postPlayerTickEvent(client, (class_1657)client.field_1724));
        HudElementRegistry.addLast((class_2960)class_2960.method_60655((String)"mapfrontiers", (String)"hud"), ClientEventHandler::postHudRenderEvent);
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> ClientEventHandler.postClientConnectedEvent());
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> ClientEventHandler.postClientDisconnectedEvent());
        ScreenEvents.BEFORE_INIT.register((client, theScreen, scaledWidth, scaledHeight) -> ScreenMouseEvents.beforeMouseRelease((class_437)theScreen).register((screen, mouseX, mouseY, button) -> ClientEventHandler.postMouseReleaseEvent(button)));
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> FabricClientCommandAccept.register((CommandDispatcher<FabricClientCommandSource>)dispatcher));
        ClientReceiveMessageEvents.ALLOW_CHAT.register((message, signedMessage, sender, params, receptionTimestamp) -> {
            boolean cancel = ChatFrontiers.receiveFrontierFromChat(message, sender != null ? sender.getId() : null);
            return !cancel;
        });
        MapFrontiersClientFabric.init();
        MapFrontiersFabric.LOGGER.info("Fabric onInitializeClient done");
    }
}

