/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component;

import games.alejandrocoria.mapfrontiers.client.gui.component.button.ButtonBase;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_7843;
import net.minecraft.class_7847;
import net.minecraft.class_8021;
import net.minecraft.class_8133;
import net.minecraft.class_8667;

@ParametersAreNonnullByDefault
public class TabbedBox
implements class_8133 {
    private final class_327 font;
    private final IntConsumer tabChanged;
    private int width;
    private int height;
    private final List<Tab> tabs = new ArrayList<Tab>();
    private final List<class_7843> contents = new ArrayList<class_7843>();
    private final class_8667 mainLayout = class_8667.method_52741().method_52735(16);
    private final class_8667 tabLayouts = class_8667.method_52742();
    private final class_7843 contentLayouts = new class_7843();
    private int selected;

    public TabbedBox(class_327 font, int width, int height, IntConsumer tabChanged) {
        this.font = font;
        this.tabChanged = tabChanged;
        this.selected = -1;
        this.width = width;
        this.height = height;
        this.contentLayouts.method_46446(width, height - 32);
        this.mainLayout.method_52737((class_8021)this.tabLayouts, class_7847.method_46481().method_46467());
        this.mainLayout.method_52737((class_8021)this.contentLayouts, class_7847.method_46481().method_46467());
    }

    public void addTab(class_2561 text, boolean enabled) {
        this.tabs.add(new Tab(this.font, text, this.tabs.size(), enabled, this::setTabSelected));
        this.tabLayouts.method_52736((class_8021)this.tabs.getLast());
        this.contents.add(new class_7843(this.width, this.height - 32));
        this.contentLayouts.method_46441((class_8021)this.contents.getLast());
        if (this.selected == -1) {
            this.selected = 0;
        }
    }

    public void setTabSelected(int tab) {
        if (this.selected != -1) {
            this.tabs.get(this.selected).setSelected(false);
        }
        this.selected = tab;
        this.tabs.get(this.selected).setSelected(true);
        for (int i = 0; i < this.contents.size(); ++i) {
            if (i == this.selected) {
                this.contents.get(i).method_48206(widget -> {
                    widget.field_22764 = true;
                });
                continue;
            }
            this.contents.get(i).method_48206(widget -> {
                widget.field_22764 = false;
            });
        }
        this.tabChanged.accept(this.selected);
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
        this.contentLayouts.method_46446(width, height - 32);
        for (class_7843 content : this.contents) {
            content.method_46446(width, height - 32);
        }
        this.method_48222();
    }

    public <T extends class_8021> T addChild(T layoutElement, int tab) {
        this.contents.get(tab).method_46441(layoutElement);
        return layoutElement;
    }

    public <T extends class_8021> T addChild(T layoutElement, int tab, class_7847 layoutSettings) {
        this.contents.get(tab).method_46444(layoutElement, layoutSettings);
        return layoutElement;
    }

    public void method_48227(Consumer<class_8021> visitor) {
        this.mainLayout.method_48227(visitor);
    }

    public void method_48222() {
        this.mainLayout.method_48222();
    }

    public int method_25368() {
        return this.mainLayout.method_25368();
    }

    public int method_25364() {
        return this.mainLayout.method_25364();
    }

    public void method_46421(int x) {
        this.mainLayout.method_46421(x);
    }

    public void method_46419(int y) {
        this.mainLayout.method_46419(y);
    }

    public int method_46426() {
        return this.mainLayout.method_46426();
    }

    public int method_46427() {
        return this.mainLayout.method_46427();
    }

    public void renderBackground(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.method_25294(this.method_46426(), this.method_46427() + 16, this.method_46426() + this.width, this.method_46427() + this.height, -955248624);
        if (this.selected == -1) {
            graphics.method_51738(this.method_46426(), this.method_46426() + this.width, this.method_46427() + 16, -8947849);
        } else {
            Tab tab = this.tabs.get(this.selected);
            graphics.method_51738(this.method_46426(), tab.method_46426(), this.method_46427() + 16, -8947849);
            graphics.method_51738(tab.method_46426() + tab.method_25368(), this.method_46426() + this.width, this.method_46427() + 16, -8947849);
        }
        graphics.method_51738(this.method_46426(), this.method_46426() + this.width, this.method_46427() + this.height, -8947849);
        graphics.method_51742(this.method_46426(), this.method_46427() + 16, this.method_46427() + this.height, -8947849);
        graphics.method_51742(this.method_46426() + this.width, this.method_46427() + 16, this.method_46427() + this.height, -8947849);
    }

    private static class Tab
    extends ButtonBase {
        private final class_327 font;
        private boolean selected = false;

        public Tab(class_327 font, class_2561 text, int index, boolean enabled, Consumer<Integer> onPress) {
            super(0, 0, 70, 16, text, b -> onPress.accept(index), class_4185.field_40754);
            this.font = font;
            this.field_22763 = enabled;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
            graphics.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364(), -955248624);
            graphics.method_51738(this.method_46426(), this.method_46426() + this.method_25368(), this.method_46427(), this.isKeyboardFocused() ? -1 : -8947849);
            graphics.method_51742(this.method_46426(), this.method_46427(), this.method_46427() + this.method_25364(), -8947849);
            graphics.method_51742(this.method_46426() + this.method_25368(), this.method_46427(), this.method_46427() + this.method_25364(), -8947849);
            int labelColor = -8947849;
            if (!this.field_22763) {
                labelColor = -12303292;
            } else if (this.selected || this.isHoveredOrKeyboardFocused()) {
                labelColor = -1;
            }
            graphics.method_27534(this.font, this.method_25369(), this.method_46426() + this.method_25368() / 2, this.method_46427() + 5, labelColor);
        }
    }
}

