/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.screen;

import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.client.gui.component.StringWidget;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.OptionButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.ShapeChunkButtons;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.ShapeVertexButtons;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.SimpleButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.textbox.TextBoxInt;
import games.alejandrocoria.mapfrontiers.client.gui.screen.AutoScaledScreen;
import games.alejandrocoria.mapfrontiers.common.Config;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsProfile;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.api.v2.client.IClientAPI;
import journeymap.api.v2.client.display.Context;
import journeymap.api.v2.client.util.UIState;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_7845;
import net.minecraft.class_7847;
import net.minecraft.class_8021;

@ParametersAreNonnullByDefault
public class NewFrontier
extends AutoScaledScreen {
    private static final class_2561 titleLabel = class_2561.method_43471((String)"mapfrontiers.title_new_frontier");
    private static final class_2561 frontierTypeLabel = class_2561.method_43471((String)"mapfrontiers.frontier_type");
    private static final class_2561 frontierModeLabel = class_2561.method_43471((String)"mapfrontiers.frontier_mode");
    private static final class_2561 afterCreatingLabel = class_2561.method_43471((String)"mapfrontiers.after_creating");
    private static final class_2561 vertexCountLabel = class_2561.method_43471((String)"mapfrontiers.shape_vertex_count");
    private static final class_2561 sizeInfoLabel = class_2561.method_43471((String)"mapfrontiers.shape_size_info");
    private static final String verticesKey = "mapfrontiers.vertices";
    private static final String chunksKey = "mapfrontiers.chunks";
    private static final class_2561 createLabel = class_2561.method_43471((String)"mapfrontiers.create");
    private static final class_2561 cancelLabel = class_2561.method_43471((String)"gui.cancel");
    private final IClientAPI jmAPI;
    private OptionButton buttonFrontierType;
    private OptionButton buttonFrontierMode;
    private OptionButton buttonAfterCreate;
    private ShapeVertexButtons shapeVertexButtons;
    private ShapeChunkButtons shapeChunkButtons;
    private StringWidget labelCount;
    private StringWidget labelCountInfo;
    private TextBoxInt textCount;
    private StringWidget labelSize;
    private StringWidget labelSizeInfo;
    private TextBoxInt textSize;
    private class_2338 centerPos;

    public NewFrontier(IClientAPI jmAPI, class_2338 centerPos) {
        super(titleLabel, 344, 295);
        this.jmAPI = jmAPI;
        this.centerPos = centerPos;
        ClientEventHandler.subscribeUpdatedSettingsProfileEvent((Object)this, profile -> {
            this.method_25419();
            new NewFrontier(jmAPI, centerPos).display();
        });
    }

    @Override
    public void initScreen() {
        class_7845 mainLayout = new class_7845().method_48637(8);
        this.content.method_52736((class_8021)mainLayout);
        class_7847 leftColumnSettings = class_7847.method_46481().method_46470();
        class_7847 rightColumnSettings = class_7847.method_46481().method_46461();
        class_7847 centerColumnSettings = class_7847.method_46481().method_46467();
        mainLayout.method_46455((class_8021)new StringWidget(frontierTypeLabel, this.field_22793).setColor(-4144960), 0, 0, leftColumnSettings);
        this.buttonFrontierType = new OptionButton(this.field_22793, 130, OptionButton.DO_NOTHING);
        this.buttonFrontierType.addOption(Config.getTranslatedEnum(Config.FilterFrontierType.Global));
        this.buttonFrontierType.addOption(Config.getTranslatedEnum(Config.FilterFrontierType.Personal));
        this.buttonFrontierType.setSelected(0);
        if (!MapFrontiersClient.isModOnServer() || MapFrontiersClient.getSettingsProfile().createFrontier != SettingsProfile.State.Enabled) {
            this.buttonFrontierType.setSelected(1);
            this.buttonFrontierType.field_22763 = false;
        }
        mainLayout.method_46455((class_8021)this.buttonFrontierType, 0, 1, rightColumnSettings);
        mainLayout.method_46455((class_8021)new StringWidget(frontierModeLabel, this.field_22793).setColor(-4144960), 1, 0, leftColumnSettings);
        this.buttonFrontierMode = new OptionButton(this.field_22793, 130, b -> {
            Config.newFrontierMode = FrontierData.Mode.values()[b.getSelected()];
            this.shapeButtonsUpdated();
        });
        this.buttonFrontierMode.addOption(Config.getTranslatedEnum(FrontierData.Mode.Vertex));
        this.buttonFrontierMode.addOption(Config.getTranslatedEnum(FrontierData.Mode.Chunk));
        this.buttonFrontierMode.setSelected(Config.newFrontierMode.ordinal());
        mainLayout.method_46455((class_8021)this.buttonFrontierMode, 1, 1, rightColumnSettings);
        mainLayout.method_46455((class_8021)new StringWidget(afterCreatingLabel, this.field_22793).setColor(-4144960), 2, 0, leftColumnSettings);
        this.buttonAfterCreate = new OptionButton(this.field_22793, 130, b -> {
            Config.afterCreatingFrontier = Config.AfterCreatingFrontier.values()[b.getSelected()];
        });
        this.buttonAfterCreate.addOption(Config.getTranslatedEnum(Config.AfterCreatingFrontier.Info));
        this.buttonAfterCreate.addOption(Config.getTranslatedEnum(Config.AfterCreatingFrontier.Edit));
        this.buttonAfterCreate.addOption(Config.getTranslatedEnum(Config.AfterCreatingFrontier.Nothing));
        this.buttonAfterCreate.setSelected(Config.afterCreatingFrontier.ordinal());
        mainLayout.method_46455((class_8021)this.buttonAfterCreate, 2, 1, rightColumnSettings);
        this.shapeVertexButtons = new ShapeVertexButtons(this.field_22793, Config.newFrontierShape, s -> this.shapeButtonsUpdated());
        mainLayout.method_46454((class_8021)this.shapeVertexButtons, 3, 0, 1, 2, centerColumnSettings);
        this.shapeChunkButtons = new ShapeChunkButtons(this.field_22793, Config.newFrontierChunkShape, s -> this.shapeButtonsUpdated());
        mainLayout.method_46454((class_8021)this.shapeChunkButtons, 3, 0, 1, 2, centerColumnSettings);
        this.labelCount = (StringWidget)mainLayout.method_46455((class_8021)new StringWidget(vertexCountLabel, this.field_22793).setColor(-1), 4, 0, leftColumnSettings);
        this.textCount = new TextBoxInt(Config.newFrontierCount, 1, 999, this.field_22793, 64);
        this.textCount.setValueChangedCallback(value -> {
            if (Config.isInRange("newFrontierVertexCount", value)) {
                Config.newFrontierCount = value;
            }
        });
        mainLayout.method_46455((class_8021)this.textCount, 4, 1, rightColumnSettings);
        this.labelCountInfo = (StringWidget)mainLayout.method_46454((class_8021)new StringWidget((class_2561)class_2561.method_43473(), this.field_22793).setColor(-1), 4, 0, 1, 2, centerColumnSettings);
        this.labelSize = (StringWidget)mainLayout.method_46455((class_8021)new StringWidget((class_2561)class_2561.method_43473(), this.field_22793).setColor(-1), 5, 0, leftColumnSettings);
        this.textSize = new TextBoxInt(1, 1, 999, this.field_22793, 64);
        this.textSize.setValueChangedCallback(value -> {
            if (Config.newFrontierMode == FrontierData.Mode.Vertex) {
                if (this.shapeVertexButtons.getShapeMeasure() == ShapeVertexButtons.ShapeMeasure.Width) {
                    if (Config.isInRange("newFrontierShapeWidth", value)) {
                        Config.newFrontierShapeWidth = value;
                    }
                } else if (this.shapeVertexButtons.getShapeMeasure() == ShapeVertexButtons.ShapeMeasure.Radius && Config.isInRange("newFrontierShapeRadius", value)) {
                    Config.newFrontierShapeRadius = value;
                }
            } else if (this.shapeChunkButtons.getShapeMeasure() == ShapeChunkButtons.ShapeMeasure.Width) {
                if (Config.isInRange("newFrontierChunkShapeWidth", value)) {
                    Config.newFrontierChunkShapeWidth = value;
                    this.shapeChunkButtons.setSize(value);
                }
            } else if (this.shapeChunkButtons.getShapeMeasure() == ShapeChunkButtons.ShapeMeasure.Length && Config.isInRange("newFrontierChunkShapeLength", value)) {
                Config.newFrontierChunkShapeLength = value;
                this.shapeChunkButtons.setSize(value);
            }
        });
        mainLayout.method_46455((class_8021)this.textSize, 5, 1, rightColumnSettings);
        this.labelSizeInfo = (StringWidget)mainLayout.method_46454((class_8021)new StringWidget(sizeInfoLabel, this.field_22793).setColor(-1), 5, 0, 1, 2, centerColumnSettings);
        this.bottomButtons.method_52736((class_8021)new SimpleButton(this.field_22793, 100, createLabel, b -> {
            boolean personal = this.buttonFrontierType.getSelected() == 1;
            this.closeAndReturnToFullscreenMap();
            UIState uiState = this.jmAPI.getUIState(Context.UI.Fullscreen);
            if (uiState != null) {
                MapFrontiersClient.getFrontiersOverlayManager(personal).clientCreateNewFrontier((class_5321<class_1937>)uiState.dimension, this.calculateVertices(), this.calculateChunks());
            }
        }));
        this.bottomButtons.method_52736((class_8021)new SimpleButton(this.field_22793, 100, cancelLabel, b -> this.method_25419()));
        this.shapeButtonsUpdated();
    }

    @Override
    public void renderScaledBackgroundScreen(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.drawCenteredBoxBackground(graphics, 344, 234);
    }

    public void method_25419() {
        ClientEventHandler.unsubscribeAllEvents((Object)this);
        ClientEventHandler.postUpdatedConfigEvent();
        super.method_25419();
    }

    private void shapeButtonsUpdated() {
        if (Config.newFrontierMode == FrontierData.Mode.Vertex) {
            int selected;
            this.shapeVertexButtons.field_22764 = true;
            this.shapeChunkButtons.field_22764 = false;
            Config.newFrontierShape = selected = this.shapeVertexButtons.getSelected();
            if (selected == 11) {
                this.labelCount.field_22764 = true;
                this.textCount.field_22764 = true;
                this.labelCountInfo.field_22764 = false;
            } else {
                this.labelCount.field_22764 = false;
                this.textCount.field_22764 = false;
                this.labelCountInfo.field_22764 = true;
                this.setLabelCountInfoMessage(verticesKey, this.shapeVertexButtons.getVertexCount());
            }
            this.labelSizeInfo.field_22764 = false;
            if (selected == 0 || selected == 1) {
                this.labelSize.field_22764 = false;
                this.textSize.field_22764 = false;
                this.method_48640();
                return;
            }
            this.labelSize.field_22764 = true;
            this.textSize.field_22764 = true;
            if (this.shapeVertexButtons.getShapeMeasure() == ShapeVertexButtons.ShapeMeasure.Width) {
                this.setLabelSizeMessage("mapfrontiers.shape_width");
                this.textSize.method_1852(String.valueOf(Config.newFrontierShapeWidth));
            } else if (this.shapeVertexButtons.getShapeMeasure() == ShapeVertexButtons.ShapeMeasure.Radius) {
                this.setLabelSizeMessage("mapfrontiers.shape_radius");
                this.textSize.method_1852(String.valueOf(Config.newFrontierShapeRadius));
            }
        } else {
            int selected;
            this.shapeVertexButtons.field_22764 = false;
            this.shapeChunkButtons.field_22764 = true;
            Config.newFrontierChunkShape = selected = this.shapeChunkButtons.getSelected();
            this.labelCount.field_22764 = false;
            this.textCount.field_22764 = false;
            this.labelCountInfo.field_22764 = true;
            this.setLabelCountInfoMessage(chunksKey, this.shapeChunkButtons.getChunkCount());
            boolean bl = this.labelSizeInfo.field_22764 = selected == 7;
            if (selected == 0 || selected == 1 || selected == 7) {
                this.labelSize.field_22764 = false;
                this.textSize.field_22764 = false;
                this.method_48640();
                return;
            }
            this.labelSize.field_22764 = true;
            this.textSize.field_22764 = true;
            if (this.shapeChunkButtons.getShapeMeasure() == ShapeChunkButtons.ShapeMeasure.Width) {
                this.setLabelSizeMessage("mapfrontiers.shape_width");
                this.textSize.method_1852(String.valueOf(Config.newFrontierChunkShapeWidth));
                this.shapeChunkButtons.setSize(Config.newFrontierChunkShapeWidth);
            } else if (this.shapeChunkButtons.getShapeMeasure() == ShapeChunkButtons.ShapeMeasure.Length) {
                this.setLabelSizeMessage("mapfrontiers.shape_length");
                this.textSize.method_1852(String.valueOf(Config.newFrontierChunkShapeLength));
                this.shapeChunkButtons.setSize(Config.newFrontierChunkShapeLength);
            }
        }
        this.method_48640();
    }

    private void setLabelSizeMessage(String key) {
        this.labelSize.method_25355((class_2561)class_2561.method_43471((String)key));
        this.labelSize.method_25358(this.field_22793.method_27525((class_5348)this.labelSize.method_25369()));
    }

    private void setLabelCountInfoMessage(String key, int count) {
        this.labelCountInfo.method_25355((class_2561)class_2561.method_43469((String)key, (Object[])new Object[]{count}));
        this.labelCountInfo.method_25358(this.field_22793.method_27525((class_5348)this.labelCountInfo.method_25369()));
    }

    private List<class_2338> calculateVertices() {
        if (Config.newFrontierMode != FrontierData.Mode.Vertex) {
            return null;
        }
        List<class_241> shapeVertices = this.shapeVertexButtons.getSelected() == 11 ? this.shapeVertexButtons.getVertices(Config.newFrontierCount) : this.shapeVertexButtons.getVertices();
        if (shapeVertices == null) {
            return new ArrayList<class_2338>();
        }
        double radius = 0.0;
        if (this.shapeVertexButtons.getShapeMeasure() == ShapeVertexButtons.ShapeMeasure.Width) {
            radius = Config.newFrontierShapeWidth;
            if (radius < 2.0) {
                radius = 2.0;
            }
            if (shapeVertices.size() == 3) {
                radius = radius * Math.sqrt(3.0) / 3.0;
            } else if (shapeVertices.size() == 4) {
                radius = Math.sqrt(radius * radius * 2.0) / 2.0;
            }
        } else if (this.shapeVertexButtons.getShapeMeasure() == ShapeVertexButtons.ShapeMeasure.Radius && (radius = (double)Config.newFrontierShapeRadius) < 1.0) {
            radius = 1.0;
        }
        LinkedHashSet<class_2338> polygonVertices = new LinkedHashSet<class_2338>();
        for (class_241 vertex : shapeVertices) {
            int x = (int)Math.round((double)vertex.field_1343 * radius) + this.centerPos.method_10263();
            int z = (int)Math.round((double)vertex.field_1342 * radius) + this.centerPos.method_10260();
            polygonVertices.add(new class_2338(x, 70, z));
        }
        return new ArrayList<class_2338>(polygonVertices);
    }

    private List<class_1923> calculateChunks() {
        ArrayList<class_1923> chunks;
        block11: {
            int selected;
            class_1923 playerChunk;
            block16: {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                block10: {
                                    if (Config.newFrontierMode != FrontierData.Mode.Chunk) {
                                        return null;
                                    }
                                    chunks = new ArrayList<class_1923>();
                                    playerChunk = new class_1923(this.centerPos);
                                    selected = this.shapeChunkButtons.getSelected();
                                    if (selected != 1) break block10;
                                    chunks.add(playerChunk);
                                    break block11;
                                }
                                if (selected != 2) break block12;
                                int shapeWidth = Config.newFrontierChunkShapeWidth;
                                class_1923 start = new class_1923(playerChunk.field_9181 - shapeWidth / 2, playerChunk.field_9180 - shapeWidth / 2);
                                for (int i = 0; i < shapeWidth * shapeWidth; ++i) {
                                    chunks.add(new class_1923(start.field_9181 + i % shapeWidth, start.field_9180 + i / shapeWidth));
                                }
                                break block11;
                            }
                            if (selected != 3) break block13;
                            int shapeWidth = Config.newFrontierChunkShapeWidth;
                            class_1923 start = new class_1923(playerChunk.field_9181 - shapeWidth / 2, playerChunk.field_9180 - shapeWidth / 2);
                            for (int i = 0; i < shapeWidth * shapeWidth; ++i) {
                                if (i >= shapeWidth && i < shapeWidth * (shapeWidth - 1) && i % shapeWidth != 0 && i % shapeWidth != shapeWidth - 1) continue;
                                chunks.add(new class_1923(start.field_9181 + i % shapeWidth, start.field_9180 + i / shapeWidth));
                            }
                            break block11;
                        }
                        if (selected != 4) break block14;
                        int shapeWidth = Config.newFrontierChunkShapeWidth;
                        class_1923 start = new class_1923(playerChunk.field_9181 - shapeWidth / 2, playerChunk.field_9180 - shapeWidth / 2);
                        for (int z = start.field_9180; z < start.field_9180 + shapeWidth; ++z) {
                            for (int x = start.field_9181; x < start.field_9181 + shapeWidth; ++x) {
                                int deltaX = x - playerChunk.field_9181;
                                int deltaZ = z - playerChunk.field_9180;
                                if (shapeWidth % 2 == 0) {
                                    deltaX += deltaX < 0 ? 1 : 0;
                                    deltaZ += deltaZ < 0 ? 1 : 0;
                                }
                                if (Math.abs(deltaX) + Math.abs(deltaZ) > (shapeWidth - 1) / 2) continue;
                                chunks.add(new class_1923(x, z));
                            }
                        }
                        break block11;
                    }
                    if (selected != 5) break block15;
                    int shapeLength = Config.newFrontierChunkShapeLength;
                    int start = playerChunk.field_9181 - shapeLength / 2;
                    for (int i = 0; i < shapeLength; ++i) {
                        chunks.add(new class_1923(start + i, playerChunk.field_9180));
                    }
                    break block11;
                }
                if (selected != 6) break block16;
                int shapeLength = Config.newFrontierChunkShapeLength;
                int start = playerChunk.field_9180 - shapeLength / 2;
                for (int i = 0; i < shapeLength; ++i) {
                    chunks.add(new class_1923(playerChunk.field_9181, start + i));
                }
                break block11;
            }
            if (selected != 7) break block11;
            class_1923 start = new class_1923(Math.floorDiv(playerChunk.field_9181, 32) * 32, Math.floorDiv(playerChunk.field_9180, 32) * 32);
            for (int z = 0; z < 32; ++z) {
                for (int x = 0; x < 32; ++x) {
                    chunks.add(new class_1923(start.field_9181 + x, start.field_9180 + z));
                }
            }
        }
        return chunks;
    }
}

