/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component.scroll;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_6328;
import net.minecraft.class_6382;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import net.minecraft.class_8027;
import net.minecraft.class_8494;
import net.minecraft.class_9017;

@ParametersAreNonnullByDefault
@class_6328
public class ScrollBox
extends class_9017 {
    private final int elementHeight;
    private int scrollStart = 0;
    private int scrollHeight;
    private int scrollBarPos = 0;
    private int scrollBarHeight = 0;
    private boolean scrollBarHovered = false;
    private boolean scrollBarGrabbed = false;
    private int scrollBarGrabbedYPos = 0;
    private final List<ScrollElement> elements = new ArrayList<ScrollElement>();
    private int selected = -1;
    private int focused = -1;
    private Consumer<ScrollElement> elementClickedCallback;
    private Consumer<ScrollElement> elementDeletedCallback;
    private Consumer<ScrollElement> elementDeletePressedCallback;

    public ScrollBox(int height, int elementWidth, int elementHeight) {
        super(0, 0, elementWidth + 15, Math.max(height, elementHeight + 1), (class_2561)class_2561.method_43473());
        this.elementHeight = elementHeight + 1;
        this.scrollHeight = this.field_22759 / this.elementHeight;
        this.field_22759 = this.scrollHeight * this.elementHeight;
    }

    public void setElementClickedCallback(Consumer<ScrollElement> callback) {
        this.elementClickedCallback = callback;
    }

    public void setElementDeletedCallback(Consumer<ScrollElement> callback) {
        this.elementDeletedCallback = callback;
    }

    public void setElementDeletePressedCallback(Consumer<ScrollElement> callback) {
        this.elementDeletePressedCallback = callback;
    }

    public List<ScrollElement> getElements() {
        return this.elements;
    }

    public void addElement(ScrollElement element) {
        element.setX(this.method_46426());
        element.setY(this.method_46427() + this.elements.size() * this.elementHeight);
        this.elements.add(element);
        this.scrollBarGrabbed = false;
        this.updateScrollWindow();
        this.updateScrollBar();
    }

    public void selectElement(ScrollElement element) {
        this.focused = this.selected = this.elements.indexOf(element);
    }

    @Nullable
    public ScrollElement getSelectedElement() {
        if (this.selected >= 0 && this.selected < this.elements.size()) {
            return this.elements.get(this.selected);
        }
        return null;
    }

    public void selectIndex(int index) {
        this.focused = this.selected = Math.min(Math.max(index, 0), this.elements.size() - 1);
    }

    public int getSelectedIndex() {
        return this.selected;
    }

    public void selectElementIf(Predicate<ScrollElement> pred) {
        ScrollElement element = this.elements.stream().filter(pred).findFirst().orElse(null);
        if (element == null) {
            this.selected = -1;
            this.focused = -1;
        } else {
            this.selectElement(element);
        }
    }

    public void removeElement(ScrollElement element) {
        ListIterator<ScrollElement> it = this.elements.listIterator();
        while (it.hasNext()) {
            if (it.next() != element) continue;
            this.removeElement(element, it);
            return;
        }
    }

    private void removeElement(ScrollElement element, ListIterator<ScrollElement> it) {
        it.remove();
        if (this.selected == this.elements.size()) {
            this.selected = this.elements.size() - 1;
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            this.elements.get(i).setY(this.method_46427() + i * this.elementHeight);
        }
        this.scrollBarGrabbed = false;
        this.updateScrollWindow();
        this.updateScrollBar();
        if (this.elementDeletedCallback != null) {
            this.elementDeletedCallback.accept(element);
        }
        if (this.selected >= 0 && this.elementClickedCallback != null) {
            this.elementClickedCallback.accept(this.getSelectedElement());
        }
        this.focused = this.selected;
    }

    public void removeAll() {
        this.elements.clear();
        this.selected = -1;
        this.focused = -1;
        this.scrollBarGrabbed = false;
        this.updateScrollWindow();
        this.updateScrollBar();
    }

    @Nullable
    public class_8016 method_48205(class_8023 navigationEvent) {
        List<class_364> children;
        if (!this.field_22764 || !this.field_22763 || this.elements.isEmpty()) {
            return null;
        }
        int focusedChild = -1;
        List<class_364> list = children = this.focused == -1 ? null : this.elements.get(this.focused).method_25396();
        if (children != null) {
            if (children.isEmpty()) {
                children = null;
            } else {
                for (int i = 0; i < children.size(); ++i) {
                    if (!children.get(i).method_25370()) continue;
                    focusedChild = i;
                    break;
                }
            }
        }
        if (this.method_25370()) {
            boolean forward = true;
            if (navigationEvent instanceof class_8023.class_8024) {
                class_8023.class_8024 arrowNavigation = (class_8023.class_8024)navigationEvent;
                forward = arrowNavigation.comp_1191().method_48241();
                if (arrowNavigation.comp_1191().method_48237() == class_8027.field_41822) {
                    if (children != null) {
                        if ((focusedChild += forward ? 1 : -1) < 0 || focusedChild >= children.size()) {
                            return null;
                        }
                        return class_8016.method_48192((class_4069)this, (class_8016)this.elements.get(this.focused).focusPathAtIndex(navigationEvent, focusedChild));
                    }
                    return null;
                }
            } else if (navigationEvent instanceof class_8023.class_8026) {
                class_8023.class_8026 tabNavigation = (class_8023.class_8026)navigationEvent;
                forward = tabNavigation.comp_1192();
            }
            if (forward) {
                if (this.focused == this.elements.size() - 1) {
                    return null;
                }
                ++this.focused;
            } else {
                if (this.focused == 0) {
                    return null;
                }
                this.focused = this.focused == -1 ? this.elements.size() - 1 : --this.focused;
            }
        } else {
            this.focused = navigationEvent.method_48231().method_48241() ? 0 : this.elements.size() - 1;
        }
        if (this.focused < this.scrollStart || this.focused >= this.scrollStart + this.scrollHeight) {
            this.scrollStart = this.focused < this.scrollStart ? this.focused : this.focused - this.scrollHeight + 1;
            this.updateScrollWindow();
            this.updateScrollBar();
        }
        if (!this.elements.get(this.focused).method_25396().isEmpty()) {
            if (focusedChild == -1) {
                focusedChild = 0;
            }
            return class_8016.method_48192((class_4069)this, (class_8016)this.elements.get(this.focused).focusPathAtIndex(navigationEvent, focusedChild));
        }
        return class_8016.method_48192((class_4069)this, (class_8016)class_8016.method_48193((class_364)((class_364)this.elements.get(this.focused))));
    }

    public void method_46421(int x) {
        super.method_46421(x);
        for (ScrollElement element : this.elements) {
            element.setX(x);
        }
    }

    public void method_46419(int y) {
        super.method_46419(y);
        for (int i = 0; i < this.elements.size(); ++i) {
            this.elements.get(i).setY(y + i * this.elementHeight);
        }
    }

    public void method_55445(int elementWidth, int height) {
        super.method_55445(elementWidth + 15, height);
        this.method_53533(height);
    }

    public void method_25358(int elementWidth) {
        super.method_25358(elementWidth + 15);
    }

    public void method_53533(int height) {
        super.method_53533(height);
        this.scrollHeight = this.field_22759 / this.elementHeight;
        this.field_22759 = this.scrollHeight * this.elementHeight;
        this.updateScrollWindow();
        this.updateScrollBar();
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }

    public List<? extends class_364> method_25396() {
        return this.elements;
    }

    public boolean method_25401(double mouseX, double mouseY, double hDelta, double vDelta) {
        if (this.field_22764 && (this.field_22762 || this.scrollBarHovered) && !this.scrollBarGrabbed) {
            int amount = (int)(-vDelta);
            if (amount < 0 && this.scrollStart == 0) {
                return false;
            }
            if (amount > 0 && this.scrollStart + this.scrollHeight >= this.elements.size()) {
                return false;
            }
            this.scrollStart += amount;
            this.updateScrollWindow();
            this.updateScrollBar();
            return true;
        }
        return false;
    }

    protected int method_44395() {
        return this.elementHeight;
    }

    protected double method_44393() {
        return this.elementHeight;
    }

    public void scrollBottom() {
        this.scrollStart = this.elements.size() - this.scrollHeight;
        this.scrollBarGrabbed = false;
        this.updateScrollWindow();
        this.updateScrollBar();
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        for (int i = 0; i < this.elements.size(); ++i) {
            boolean isFocused = this.focused == i && this.isKeyboardFocused();
            this.elements.get(i).render(graphics, mouseX, mouseY, partialTicks, this.selected == i, isFocused);
        }
        if (this.scrollBarHeight > 0) {
            this.scrollBarHovered = mouseX >= this.method_46426() + this.field_22758 - 10 && mouseY >= this.method_46427() && mouseX < this.method_46426() + this.field_22758 && mouseY < this.method_46427() + this.field_22759;
            int barColor = -8947849;
            if (this.scrollBarGrabbed) {
                barColor = -10066330;
            } else if (this.scrollBarHovered) {
                barColor = -5592406;
            }
            graphics.method_25294(this.method_46426() + this.field_22758 - 10, this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, 0x1AFFFFFF);
            graphics.method_25294(this.method_46426() + this.field_22758 - 10, this.method_46427() + this.scrollBarPos, this.method_46426() + this.field_22758, this.method_46427() + this.scrollBarPos + this.scrollBarHeight, barColor);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.field_22763 && this.field_22764 && this.method_25351(button)) {
            if (this.scrollBarHeight > 0 && mouseX >= (double)(this.method_46426() + this.field_22758 - 10) && mouseY >= (double)this.method_46427() && mouseX < (double)(this.method_46426() + this.field_22758) && mouseY < (double)(this.method_46427() + this.field_22759)) {
                if (mouseY < (double)(this.method_46427() + this.scrollBarPos)) {
                    this.method_25401(mouseX, mouseY, 0.0, 1.0);
                } else if (mouseY > (double)(this.method_46427() + this.scrollBarPos + this.scrollBarHeight)) {
                    this.method_25401(mouseX, mouseY, 0.0, -1.0);
                } else {
                    this.scrollBarGrabbed = true;
                    this.scrollBarGrabbedYPos = (int)mouseY - this.method_46427() - this.scrollBarPos;
                }
                return true;
            }
            if (this.field_22762 && !this.scrollBarGrabbed) {
                ListIterator<ScrollElement> it = this.elements.listIterator();
                while (it.hasNext()) {
                    ScrollElement element = it.next();
                    ScrollElement.Action action = element.mousePressed(mouseX, mouseY);
                    if (action == ScrollElement.Action.Deleted) {
                        if (this.elementDeletePressedCallback != null) {
                            this.elementDeletePressedCallback.accept(element);
                        } else {
                            this.removeElement(element, it);
                        }
                        return true;
                    }
                    if (action != ScrollElement.Action.Clicked || this.getSelectedElement() == element) continue;
                    this.selectElement(element);
                    if (this.elementClickedCallback != null) {
                        this.elementClickedCallback.accept(element);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public void mouseReleased() {
        if (this.field_22764 && this.scrollBarHeight > 0 && this.scrollBarGrabbed) {
            this.scrollBarGrabbed = false;
            this.updateScrollBar();
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.field_22763 && this.field_22764) {
            ScrollElement element;
            if (class_8494.method_51255((int)keyCode)) {
                this.selectIndex(this.focused);
                if (this.selected != -1) {
                    ScrollElement focusedElement = this.elements.get(this.focused);
                    if (!focusedElement.method_25396().isEmpty()) {
                        focusedElement.method_25404(keyCode, scanCode, modifiers);
                    } else if (this.elementClickedCallback != null) {
                        this.elementClickedCallback.accept(this.getSelectedElement());
                    }
                }
                return true;
            }
            if (keyCode == 261 && this.focused != -1 && (element = this.elements.get(this.focused)).canBeDeleted()) {
                if (this.elementDeletePressedCallback != null) {
                    this.elementDeletePressedCallback.accept(element);
                } else {
                    this.removeElement(element);
                }
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25349(double mouseX, double mouseY, double dragX, double dragY) {
        if (this.scrollBarHeight > 0 && this.scrollBarGrabbed) {
            int delta = (int)mouseY - this.method_46427() - this.scrollBarPos - this.scrollBarGrabbedYPos;
            if (delta == 0) {
                return;
            }
            this.scrollBarPos += delta;
            if (this.scrollBarPos < 0) {
                this.scrollBarPos = 0;
            } else if (this.scrollBarPos + this.scrollBarHeight > this.field_22759) {
                this.scrollBarPos = this.field_22759 - this.scrollBarHeight;
            }
            int newScrollStart = Math.round((float)this.scrollBarPos / (float)this.field_22759 * (float)this.elements.size());
            if (newScrollStart != this.scrollStart) {
                this.scrollStart = newScrollStart;
                this.updateScrollWindow();
            }
        }
    }

    protected boolean isHoveredOrKeyboardFocused() {
        return this.method_49606() || this.method_25370() && class_310.method_1551().method_48186().method_48183();
    }

    protected boolean isKeyboardFocused() {
        return this.method_25370() && class_310.method_1551().method_48186().method_48183();
    }

    private void updateScrollWindow() {
        if (this.elements.size() <= this.scrollHeight) {
            this.scrollStart = 0;
        } else {
            int bottomExtra = this.elements.size() - (this.scrollStart + this.scrollHeight);
            if (bottomExtra < 0) {
                this.scrollStart += bottomExtra;
            }
            if (this.scrollStart < 0) {
                this.scrollStart = 0;
            }
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            if (i < this.scrollStart || i >= this.scrollStart + this.scrollHeight) {
                this.elements.get((int)i).visible = false;
                continue;
            }
            this.elements.get((int)i).visible = true;
            this.elements.get(i).setY(this.method_46427() + (i - this.scrollStart) * this.elementHeight);
        }
    }

    private void updateScrollBar() {
        if (this.elements.size() <= this.scrollHeight) {
            this.scrollBarHeight = 0;
            this.scrollBarHovered = false;
            this.scrollBarGrabbed = false;
            return;
        }
        this.scrollBarHeight = Math.round((float)this.scrollHeight / (float)this.elements.size() * (float)this.field_22759);
        this.scrollBarPos = Math.round((float)this.scrollStart / (float)this.elements.size() * (float)this.field_22759);
        if (this.scrollBarPos + this.scrollBarHeight > this.field_22759) {
            this.scrollBarPos = this.field_22759 - this.scrollBarHeight;
        }
    }

    public static class ScrollElement
    implements class_4069 {
        protected boolean visible = true;
        protected int x = 0;
        protected int y = 0;
        protected boolean isHovered = false;
        protected class_364 focused;
        protected boolean dragging;
        protected final int height;
        protected final int width;

        protected ScrollElement(int width, int height) {
            this.width = width;
            this.height = height;
        }

        protected void setX(int x) {
            this.x = x;
        }

        protected void setY(int y) {
            this.y = y;
        }

        protected void render(class_332 graphics, int mouseX, int mouseY, float partialTicks, boolean selected, boolean focused) {
            if (this.visible) {
                this.isHovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
                this.renderWidget(graphics, mouseX, mouseY, partialTicks, selected, focused);
                if (focused) {
                    graphics.method_51738(this.x - 1, this.x + this.width, this.y - 1, -1);
                    graphics.method_51738(this.x - 1, this.x + this.width, this.y + this.height, -1);
                    graphics.method_51742(this.x - 1, this.y - 1, this.y + this.height, -1);
                    graphics.method_51742(this.x + this.width, this.y - 1, this.y + this.height, -1);
                }
            } else {
                this.isHovered = false;
            }
        }

        protected void renderWidget(class_332 graphics, int mouseX, int mouseY, float partialTicks, boolean selected, boolean focused) {
        }

        protected Action mousePressed(double mouseX, double mouseY) {
            return Action.None;
        }

        protected boolean canBeDeleted() {
            return false;
        }

        public List<class_364> method_25396() {
            return Collections.emptyList();
        }

        public boolean method_25397() {
            return this.dragging;
        }

        public void method_25398(boolean dragging) {
            this.dragging = dragging;
        }

        public class_364 method_25399() {
            return this.focused;
        }

        public void method_25395(@Nullable class_364 guiEventListener) {
            if (this.focused != null) {
                this.focused.method_25365(false);
            }
            this.focused = guiEventListener;
        }

        @Nullable
        public class_8016 focusPathAtIndex(class_8023 navigationEvent, int index) {
            int i;
            if (this.method_25396().isEmpty()) {
                return null;
            }
            class_8016 path = this.method_25396().get(Math.min(index, this.method_25396().size() - 1)).method_48205(navigationEvent);
            for (i = index; i < this.method_25396().size() && path == null && !this.method_25396().get(i).method_25370(); ++i) {
                path = this.method_25396().get(i).method_48205(navigationEvent);
            }
            for (i = index - 1; i > 0 && path == null && !this.method_25396().get(i).method_25370(); --i) {
                path = this.method_25396().get(i).method_48205(navigationEvent);
            }
            return class_8016.method_48192((class_4069)this, (class_8016)path);
        }

        public class_8016 method_48218() {
            if (this.method_25396().isEmpty()) {
                return class_8016.method_48193((class_364)this);
            }
            return this.method_25399() != null ? class_8016.method_48192((class_4069)this, (class_8016)this.method_25399().method_48218()) : class_8016.method_48193((class_364)this);
        }

        public static enum Action {
            None,
            Clicked,
            Deleted;

        }
    }
}

