/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common.network;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_2540;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

@ParametersAreNonnullByDefault
public class PacketPersonalFrontierShared {
    public static final class_2960 CHANNEL = class_2960.method_60655((String)"mapfrontiers", (String)"packet_personal_frontier_shared");
    public static final class_9139<class_9129, PacketPersonalFrontierShared> STREAM_CODEC = class_9139.method_56438(PacketPersonalFrontierShared::encode, PacketPersonalFrontierShared::new);
    private int shareMessageID;
    private final SettingsUser playerSharing;
    private final SettingsUser owner;
    private String name1;
    private String name2;

    public PacketPersonalFrontierShared(int shareMessageID, SettingsUser playerSharing, SettingsUser owner, String name1, String name2) {
        this.shareMessageID = shareMessageID;
        this.playerSharing = playerSharing;
        this.owner = owner;
        this.name1 = name1;
        this.name2 = name2;
    }

    public static class_8710.class_9154<class_8710> type() {
        return new class_8710.class_9154(CHANNEL);
    }

    public PacketPersonalFrontierShared(class_2540 buf) {
        this.playerSharing = new SettingsUser();
        this.owner = new SettingsUser();
        try {
            if (buf.readableBytes() > 1) {
                this.shareMessageID = buf.readInt();
                this.playerSharing.fromBytes(buf);
                this.owner.fromBytes(buf);
                this.name1 = buf.method_10800(17);
                this.name2 = buf.method_10800(17);
            }
        }
        catch (Throwable t) {
            MapFrontiers.LOGGER.error(String.format("Failed to read message for PacketPersonalFrontierShared: %s", t));
        }
    }

    public void encode(class_2540 buf) {
        try {
            buf.method_53002(this.shareMessageID);
            this.playerSharing.toBytes(buf);
            this.owner.toBytes(buf);
            buf.method_10814(this.name1);
            buf.method_10814(this.name2);
        }
        catch (Throwable t) {
            MapFrontiers.LOGGER.error(String.format("Failed to write message for PacketPersonalFrontierShared: %s", t));
        }
    }

    public static void handle(PacketContext<PacketPersonalFrontierShared> ctx) {
        if (Side.CLIENT.equals((Object)ctx.side())) {
            class_746 player = class_310.method_1551().field_1724;
            if (player == null) {
                return;
            }
            PacketPersonalFrontierShared message = (PacketPersonalFrontierShared)ctx.message();
            Object frontierName = message.name1.isEmpty() && message.name2.isEmpty() ? "Unnamed Frontier" : (message.name1.isEmpty() ? message.name2 : (message.name2.isEmpty() ? message.name1 : message.name1 + " " + message.name2));
            class_5250 button = class_2561.method_43470((String)frontierName);
            button.method_27694(style -> style.method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("Click to accept or use command /mfaccept " + message.shareMessageID)))));
            button.method_27694(style -> style.method_10982(Boolean.valueOf(true)));
            button.method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/mapfrontiersaccept " + message.shareMessageID)));
            class_5250 text = class_2561.method_43470((String)(message.playerSharing.toString("User not found") + " "));
            if (message.playerSharing.equals(message.owner)) {
                text.method_27693("want to share a frontier with you: ");
            } else {
                text.method_27693("want to share a frontier of " + message.owner.toString("User not found") + " with you: ");
            }
            text.method_10852((class_2561)button);
            player.method_7353((class_2561)text, false);
        }
    }
}

