/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common.util;

import com.mojang.authlib.GameProfile;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_640;
import net.minecraft.server.MinecraftServer;

@ParametersAreNonnullByDefault
public class UUIDHelper {
    public static UUID getUUIDFromName(String username, @Nullable MinecraftServer server) {
        GameProfile profile = null;
        if (server != null) {
            profile = server.method_3793().method_14515(username).orElse(null);
        } else {
            class_640 playerInfo;
            class_634 handler = class_310.method_1551().method_1562();
            if (handler != null && (playerInfo = handler.method_2874(username)) != null) {
                profile = playerInfo.method_2966();
            }
        }
        if (profile != null) {
            return profile.getId();
        }
        return null;
    }

    public static String getNameFromUUID(UUID uuid, @Nullable MinecraftServer server) {
        GameProfile profile = null;
        if (server != null) {
            profile = server.method_3793().method_14512(uuid).orElse(null);
        } else {
            class_640 playerInfo;
            class_634 handler = class_310.method_1551().method_1562();
            if (handler != null && (playerInfo = handler.method_2871(uuid)) != null) {
                profile = playerInfo.method_2966();
            }
        }
        if (profile != null) {
            return profile.getName();
        }
        return null;
    }

    public static UUID fromBytes(ByteBuf buf) {
        return new UUID(buf.readLong(), buf.readLong());
    }

    public static void toBytes(ByteBuf buf, UUID uuid) {
        buf.writeLong(uuid.getMostSignificantBits());
        buf.writeLong(uuid.getLeastSignificantBits());
    }

    private UUIDHelper() {
    }
}

