/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client;

import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.client.FrontierOverlay;
import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.client.plugin.MapFrontiersPlugin;
import games.alejandrocoria.mapfrontiers.common.Config;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.network.PacketCreateFrontier;
import games.alejandrocoria.mapfrontiers.common.network.PacketDeleteFrontier;
import games.alejandrocoria.mapfrontiers.common.network.PacketHandler;
import games.alejandrocoria.mapfrontiers.common.network.PacketPersonalFrontier;
import games.alejandrocoria.mapfrontiers.common.network.PacketSharePersonalFrontier;
import games.alejandrocoria.mapfrontiers.common.network.PacketUpdateFrontier;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.common.util.ColorHelper;
import games.alejandrocoria.mapfrontiers.common.util.ContainerHelper;
import games.alejandrocoria.mapfrontiers.platform.Services;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.api.v2.client.IClientAPI;
import journeymap.api.v2.client.display.Displayable;
import journeymap.api.v2.client.display.MarkerOverlay;
import journeymap.api.v2.client.model.MapImage;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;

@ParametersAreNonnullByDefault
public class FrontiersOverlayManager {
    private final IClientAPI jmAPI;
    private final HashMap<class_5321<class_1937>, ArrayList<FrontierOverlay>> dimensionsFrontiers;
    private final HashMap<class_5321<class_1937>, MarkerOverlay> markersSelected;
    private final boolean personal;
    private File ModDir;
    private static final class_310 minecraft = class_310.method_1551();
    private static final MapImage markerDotSelected = new MapImage(class_2960.method_60655((String)"mapfrontiers", (String)"textures/gui/marker.png"), 20, 0, 10, 10, -1, 1.0f);
    private static float targetDotSelectedOpacity = 0.3f;

    public FrontiersOverlayManager(IClientAPI jmAPI, boolean personal) {
        this.jmAPI = jmAPI;
        this.dimensionsFrontiers = new HashMap();
        this.markersSelected = new HashMap();
        this.personal = personal;
        ClientEventHandler.subscribeUpdatedConfigEvent(this, () -> this.updateAllOverlays(true));
    }

    public void close() {
        ClientEventHandler.unsubscribeAllEvents(this);
        for (List list : this.dimensionsFrontiers.values()) {
            for (FrontierOverlay frontier : list) {
                frontier.deleted();
            }
        }
        this.dimensionsFrontiers.clear();
        this.ModDir = null;
    }

    public void setFrontiersFromServer(List<FrontierData> frontiers) {
        block5: {
            block4: {
                this.ensureLoadData();
                if (!this.personal || minecraft.method_1542()) break block4;
                ArrayList<FrontierOverlay> localFrontiers = new ArrayList<FrontierOverlay>();
                this.dimensionsFrontiers.values().forEach(localFrontiers::addAll);
                for (FrontierData frontierData : frontiers) {
                    FrontierOverlay frontierOverlay;
                    if (localFrontiers.removeIf(x -> x.getId().equals(frontierData.getId()))) {
                        frontierOverlay = this.getAllFrontiers(frontierData.getDimension()).stream().filter(x -> x.getId().equals(frontierData.getId())).findFirst().orElseThrow();
                        frontierOverlay.updateFromData(frontierData);
                        continue;
                    }
                    frontierOverlay = new FrontierOverlay(frontierData, this.jmAPI);
                    this.getAllFrontiers(frontierData.getDimension()).add(frontierOverlay);
                }
                this.saveData();
                if (FrontiersOverlayManager.minecraft.field_1724 == null) break block5;
                SettingsUser playerUser = new SettingsUser((class_1657)FrontiersOverlayManager.minecraft.field_1724);
                for (FrontierOverlay frontier : localFrontiers) {
                    if (!frontier.getOwner().equals(playerUser)) continue;
                    frontier.removeAllUserShared();
                    PacketHandler.sendToServer(new PacketPersonalFrontier(frontier));
                    frontier.removeChanges();
                }
                break block5;
            }
            for (FrontierData data : frontiers) {
                FrontierOverlay frontierOverlay = new FrontierOverlay(data, this.jmAPI);
                this.getAllFrontiers(data.getDimension()).add(frontierOverlay);
            }
        }
    }

    public FrontierOverlay addFrontier(FrontierData data) {
        List<FrontierOverlay> frontiers = this.getAllFrontiers(data.getDimension());
        FrontierOverlay frontierOverlay = new FrontierOverlay(data, this.jmAPI);
        frontiers.add(frontierOverlay);
        if (this.personal && !minecraft.method_1542()) {
            this.saveData();
        }
        return frontierOverlay;
    }

    public void addFrontier(FrontierOverlay frontierOverlay) {
        List<FrontierOverlay> frontiers = this.getAllFrontiers(frontierOverlay.getDimension());
        frontiers.add(frontierOverlay);
        if (this.personal && !minecraft.method_1542()) {
            this.saveData();
        }
    }

    public void clientCreateNewFrontier(class_5321<class_1937> dimension, @Nullable List<class_2338> vertices, @Nullable List<class_1923> chunks) {
        if (MapFrontiersClient.isModOnServer()) {
            PacketHandler.sendToServer(new PacketCreateFrontier(dimension, this.personal, vertices, chunks));
        } else if (this.personal && FrontiersOverlayManager.minecraft.field_1724 != null) {
            FrontierData frontier = new FrontierData();
            frontier.setId(UUID.randomUUID());
            frontier.setOwner(new SettingsUser((class_1657)FrontiersOverlayManager.minecraft.field_1724));
            frontier.setDimension(dimension);
            frontier.setPersonal(true);
            frontier.setColor(ColorHelper.getRandomColor());
            frontier.setCreated(new Date());
            if (vertices != null) {
                frontier.setMode(FrontierData.Mode.Vertex);
                for (class_2338 vertex : vertices) {
                    frontier.addVertex(vertex);
                }
            }
            if (chunks != null) {
                frontier.setMode(FrontierData.Mode.Chunk);
                for (class_1923 chunk : chunks) {
                    frontier.toggleChunk(chunk);
                }
            }
            FrontierOverlay frontierOverlay = this.addFrontier(frontier);
            ClientEventHandler.postNewFrontierEvent(frontierOverlay, FrontiersOverlayManager.minecraft.field_1724.method_5628());
        }
    }

    public void clientDeleteFrontier(FrontierOverlay frontier) {
        if (MapFrontiersClient.isModOnServer()) {
            PacketHandler.sendToServer(new PacketDeleteFrontier(frontier.getId()));
        } else if (this.personal && FrontiersOverlayManager.minecraft.field_1724 != null && frontier.getOwner().equals(new SettingsUser((class_1657)FrontiersOverlayManager.minecraft.field_1724))) {
            this.deleteFrontier(frontier.getDimension(), frontier.getId());
            ClientEventHandler.postDeletedFrontierEvent(frontier.getId());
        }
    }

    public void clientUpdateFrontier(FrontierOverlay frontier) {
        FrontierOverlay frontierOverlay;
        if (MapFrontiersClient.isModOnServer()) {
            PacketHandler.sendToServer(new PacketUpdateFrontier(frontier));
            frontier.removeChanges();
        } else if (this.personal && FrontiersOverlayManager.minecraft.field_1724 != null && frontier.getOwner().equals(new SettingsUser((class_1657)FrontiersOverlayManager.minecraft.field_1724)) && (frontierOverlay = this.updateFrontier(frontier)) != null) {
            ClientEventHandler.postUpdatedFrontierEvent(frontierOverlay, FrontiersOverlayManager.minecraft.field_1724.method_5628());
        }
    }

    public void clientShareFrontier(UUID frontierID, SettingsUser targetUser) {
        if (MapFrontiersClient.isModOnServer()) {
            PacketHandler.sendToServer(new PacketSharePersonalFrontier(frontierID, targetUser));
        }
    }

    public FrontierOverlay deleteFrontier(UUID id) {
        for (class_5321<class_1937> dimension : this.dimensionsFrontiers.keySet()) {
            FrontierOverlay frontierOverlay = this.deleteFrontier(dimension, id);
            if (frontierOverlay == null) continue;
            return frontierOverlay;
        }
        return null;
    }

    public FrontierOverlay deleteFrontier(class_5321<class_1937> dimension, UUID id) {
        List<FrontierOverlay> frontiers = this.getAllFrontiers(dimension);
        int index = ContainerHelper.getIndexFromLambda(frontiers, i -> ((FrontierOverlay)frontiers.get(i)).getId().equals(id));
        if (index < 0) {
            return null;
        }
        FrontierOverlay frontier = frontiers.remove(index);
        frontier.deleted();
        if (this.personal && !minecraft.method_1542()) {
            this.saveData();
        }
        return frontier;
    }

    public FrontierOverlay updateFrontier(FrontierData data) {
        List<FrontierOverlay> frontiers = this.getAllFrontiers(data.getDimension());
        int index = ContainerHelper.getIndexFromLambda(frontiers, i -> ((FrontierOverlay)frontiers.get(i)).getId().equals(data.getId()));
        if (index < 0) {
            return null;
        }
        FrontierOverlay frontierOverlay = frontiers.get(index);
        frontierOverlay.updateFromData(data);
        frontierOverlay.setModified(new Date());
        if (this.personal && !minecraft.method_1542()) {
            this.saveData();
        }
        return frontierOverlay;
    }

    public Map<class_5321<class_1937>, ArrayList<FrontierOverlay>> getAllFrontiers() {
        this.ensureLoadData();
        return this.dimensionsFrontiers;
    }

    public List<FrontierOverlay> getAllFrontiers(class_5321<class_1937> dimension) {
        this.ensureLoadData();
        return this.dimensionsFrontiers.computeIfAbsent(dimension, k -> new ArrayList());
    }

    public List<FrontierOverlay> getFrontiersInPosition(class_5321<class_1937> dimension, class_2338 pos, double maxDistanceToOpen) {
        ArrayList<FrontierOverlay> frontiersInPosition = new ArrayList<FrontierOverlay>();
        ArrayList<FrontierOverlay> frontiers = this.dimensionsFrontiers.get(dimension);
        if (frontiers != null) {
            for (FrontierOverlay frontier : frontiers) {
                if (!frontier.getVisibility(FrontierData.VisibilityData.Visibility.Frontier) || !frontier.pointIsInside(pos, maxDistanceToOpen)) continue;
                frontiersInPosition.add(frontier);
            }
        }
        return frontiersInPosition;
    }

    public Set<FrontierOverlay> getFrontiersForAnnounce(class_5321<class_1937> dimension, class_2338 pos) {
        boolean forcedAnnounceInTitle;
        HashSet<FrontierOverlay> inPosition = new HashSet<FrontierOverlay>();
        if (Config.announceInChat == Config.Visibility.Never && Config.announceInTitle == Config.Visibility.Never) {
            return inPosition;
        }
        ArrayList<FrontierOverlay> frontiers = this.dimensionsFrontiers.get(dimension);
        boolean forcedAnnounceInChat = Config.announceInChat == Config.Visibility.Always;
        boolean bl = forcedAnnounceInTitle = Config.announceInTitle == Config.Visibility.Always;
        if (frontiers != null) {
            for (FrontierOverlay frontier : frontiers) {
                if (!forcedAnnounceInChat && !forcedAnnounceInTitle && !frontier.getVisibility(FrontierData.VisibilityData.Visibility.AnnounceInChat) && !frontier.getVisibility(FrontierData.VisibilityData.Visibility.AnnounceInTitle) || !frontier.pointIsInside(pos, 0.0)) continue;
                inPosition.add(frontier);
            }
        }
        return inPosition;
    }

    @Nullable
    public FrontierOverlay getFrontierCopiedFrom(UUID copiedFromId) {
        for (List list : this.dimensionsFrontiers.values()) {
            for (FrontierOverlay frontier : list) {
                if (!frontier.wasCopied() || !frontier.getCopiedFromId().equals(copiedFromId)) continue;
                return frontier;
            }
        }
        return null;
    }

    public void updateAllOverlays(boolean forceUpdate) {
        this.ensureLoadData();
        for (List list : this.dimensionsFrontiers.values()) {
            for (FrontierOverlay frontier : list) {
                if (forceUpdate) {
                    frontier.updateOverlay();
                    continue;
                }
                frontier.updateOverlayIfNeeded();
            }
        }
    }

    public void updateSelectedMarker(class_5321<class_1937> dimension, @Nullable FrontierOverlay frontier) {
        class_2338 pos;
        MarkerOverlay marker = this.markersSelected.get(dimension);
        if (marker != null) {
            this.jmAPI.remove((Displayable)marker);
        }
        if (frontier != null && (pos = frontier.getSelectedVertex()) != null) {
            marker = new MarkerOverlay("mapfrontiers", pos, markerDotSelected);
            marker.setDimension(dimension);
            marker.setDisplayOrder(101);
            try {
                this.jmAPI.show((Displayable)marker);
                this.markersSelected.put(dimension, marker);
            }
            catch (Throwable t) {
                MapFrontiers.LOGGER.error(t.getMessage(), t);
            }
        }
    }

    private boolean readFromNBT(class_2487 nbt) {
        boolean needBackup = false;
        try {
            int version = nbt.method_10550("Version");
            if (version == 0) {
                MapFrontiers.LOGGER.warn("Data version in personal_frontiers not found, expected 10");
                needBackup = true;
            } else if (version > 10) {
                MapFrontiers.LOGGER.warn("Data version in personal_frontiers higher than expected. The mod uses 10");
                needBackup = true;
            }
            class_2499 frontiersTagList = nbt.method_10554("frontiers", 10);
            for (int i = 0; i < frontiersTagList.size(); ++i) {
                FrontierData frontier = new FrontierData();
                class_2487 frontierTag = frontiersTagList.method_10602(i);
                frontier.readFromNBT(frontierTag, version);
                List<FrontierOverlay> frontiers = this.getAllFrontiers(frontier.getDimension());
                FrontierOverlay frontierOverlay = new FrontierOverlay(frontier, this.jmAPI);
                frontiers.add(frontierOverlay);
            }
        }
        catch (Exception ignored) {
            return true;
        }
        return needBackup;
    }

    private void writeToNBT(class_2487 nbt) {
        class_2499 frontiersTagList = new class_2499();
        if (FrontiersOverlayManager.minecraft.field_1724 != null) {
            SettingsUser playerUser = new SettingsUser((class_1657)FrontiersOverlayManager.minecraft.field_1724);
            for (Map.Entry<class_5321<class_1937>, ArrayList<FrontierOverlay>> frontiers : this.dimensionsFrontiers.entrySet()) {
                for (FrontierData frontierData : frontiers.getValue()) {
                    if (!frontierData.getPersonal() || !frontierData.getOwner().equals(playerUser)) continue;
                    class_2487 frontierTag = new class_2487();
                    frontierData.writeToNBT(frontierTag);
                    frontiersTagList.add((Object)frontierTag);
                }
            }
        }
        nbt.method_10566("frontiers", (class_2520)frontiersTagList);
        nbt.method_10569("Version", 10);
    }

    private void ensureLoadData() {
        if (this.personal && !minecraft.method_1542() && this.ModDir == null) {
            this.loadData();
        }
    }

    private void loadData() {
        try {
            File jmDir = Services.JOURNEYMAP.getJMWorldDir(class_310.method_1551());
            this.ModDir = new File(jmDir, "mapfrontier");
            this.ModDir.mkdirs();
            class_2487 nbtFrontiers = this.loadFile("personal_frontiers.dat");
            if (!nbtFrontiers.method_33133() && this.readFromNBT(nbtFrontiers)) {
                MapFrontiers.createBackup(this.ModDir, "personal_frontiers.dat");
                this.saveData();
            }
        }
        catch (Exception e) {
            MapFrontiers.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private void saveData() {
        if (this.personal && !minecraft.method_1542() && this.ModDir != null) {
            class_2487 nbtFrontiers = new class_2487();
            this.writeToNBT(nbtFrontiers);
            this.saveFile("personal_frontiers.dat", nbtFrontiers);
        }
    }

    private class_2487 loadFile(String filename) {
        File f = new File(this.ModDir, filename);
        if (f.exists()) {
            class_2487 class_24872;
            FileInputStream inputStream = new FileInputStream(f);
            try {
                class_24872 = class_2507.method_10629((InputStream)inputStream, (class_2505)class_2505.method_53898());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    MapFrontiers.LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
            inputStream.close();
            return class_24872;
        }
        return new class_2487();
    }

    private void saveFile(String filename, class_2487 nbt) {
        try {
            File f = new File(this.ModDir, filename);
            try (FileOutputStream outputStream = new FileOutputStream(f);){
                class_2507.method_10634((class_2487)nbt, (OutputStream)outputStream);
            }
            catch (Exception e) {
                MapFrontiers.LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        catch (Exception e) {
            MapFrontiers.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    static {
        markerDotSelected.setAnchorX(markerDotSelected.getDisplayWidth() / 2.0).setAnchorY(markerDotSelected.getDisplayHeight() / 2.0);
        markerDotSelected.setRotation(0);
        ClientEventHandler.subscribeClientTickEvent(FrontiersOverlayManager.class, client -> {
            if (MapFrontiersPlugin.isEditing()) {
                float opacity = markerDotSelected.getOpacity();
                if (opacity < targetDotSelectedOpacity) {
                    if ((opacity += client.method_61966().method_60636() * 0.5f) >= targetDotSelectedOpacity) {
                        opacity = targetDotSelectedOpacity;
                        targetDotSelectedOpacity = 0.0f;
                    }
                } else if ((opacity -= client.method_61966().method_60636() * 0.07f) <= targetDotSelectedOpacity) {
                    opacity = targetDotSelectedOpacity;
                    targetDotSelectedOpacity = 1.0f;
                }
                markerDotSelected.setOpacity(opacity);
            } else {
                markerDotSelected.setOpacity(0.0f);
                targetDotSelectedOpacity = 1.0f;
            }
        });
    }
}

