/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.hud;

import games.alejandrocoria.mapfrontiers.client.gui.component.AbstractWidgetNoNarration;
import games.alejandrocoria.mapfrontiers.client.gui.hud.HUD;
import games.alejandrocoria.mapfrontiers.common.Config;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_8016;
import net.minecraft.class_8023;

@ParametersAreNonnullByDefault
public class HUDWidget
extends AbstractWidgetNoNarration {
    private final HUD hud;
    private final boolean minimapEnabled;
    private Config.Point positionHUD = new Config.Point();
    private final Config.Point grabOffset = new Config.Point();
    private boolean grabbed = false;
    private final Consumer<HUDWidget> callbackHUDUpdated;

    public HUDWidget(HUD hud, boolean minimapEnabled, Consumer<HUDWidget> callbackHUDUpdated) {
        super(0, 0, 0, 0, (class_2561)class_2561.method_43473());
        this.hud = hud;
        this.minimapEnabled = minimapEnabled;
        this.callbackHUDUpdated = callbackHUDUpdated;
    }

    public void setPositionHUD(Config.Point positionHUD) {
        this.positionHUD = positionHUD;
    }

    @Nullable
    public class_8016 method_48205(class_8023 navigationEvent) {
        return null;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        int factor = (int)class_310.method_1551().method_22683().method_4495();
        int xScaled = (int)mouseX * factor;
        int yScaled = (int)mouseY * factor;
        return this.field_22763 && this.field_22764 && this.hud.isInside(xScaled, yScaled);
    }

    public void method_25348(double mouseX, double mouseY) {
        int factor = (int)class_310.method_1551().method_22683().method_4495();
        int xScaled = (int)mouseX * factor;
        int yScaled = (int)mouseY * factor;
        this.grabOffset.x = xScaled - this.positionHUD.x;
        this.grabOffset.y = yScaled - this.positionHUD.y;
        this.grabbed = true;
    }

    public void method_25357(double mouseX, double mouseY) {
        this.grabbed = false;
    }

    public void method_25349(double mouseX, double mouseY, double dragX, double dragY) {
        if (this.grabbed) {
            class_310 mc = class_310.method_1551();
            float factor = (float)mc.method_22683().method_4495();
            this.positionHUD.x = (int)(mouseX *= (double)factor) - this.grabOffset.x;
            this.positionHUD.y = (int)(mouseY *= (double)factor) - this.grabOffset.y;
            Config.Point anchorPoint = Config.getHUDAnchor(Config.hudAnchor);
            Config.Point originPoint = Config.getHUDOrigin(Config.hudAnchor, this.hud.getWidth(), this.hud.getHeight());
            if (Config.hudAutoAdjustAnchor) {
                Config.HUDAnchor closestAnchor = null;
                int closestDistance = 99999;
                Config.HUDAnchor[] hUDAnchorArray = Config.HUDAnchor.values();
                int n = hUDAnchorArray.length;
                for (int i = 0; i < n; ++i) {
                    Config.HUDAnchor anchor = hUDAnchorArray[i];
                    if ((anchor == Config.HUDAnchor.Minimap || anchor == Config.HUDAnchor.MinimapHorizontal || anchor == Config.HUDAnchor.MinimapVertical) && !this.minimapEnabled) continue;
                    Config.Point anchorP = Config.getHUDAnchor(anchor);
                    Config.Point originP = Config.getHUDOrigin(anchor, this.hud.getWidth(), this.hud.getHeight());
                    int distance = Math.abs(anchorP.x - this.positionHUD.x - originP.x) + Math.abs(anchorP.y - this.positionHUD.y - originP.y);
                    if (distance >= closestDistance) continue;
                    closestDistance = distance;
                    closestAnchor = anchor;
                }
                if (closestAnchor != null && closestAnchor != Config.hudAnchor) {
                    Config.hudAnchor = closestAnchor;
                    anchorPoint = Config.getHUDAnchor(Config.hudAnchor);
                    originPoint = Config.getHUDOrigin(Config.hudAnchor, this.hud.getWidth(), this.hud.getHeight());
                    this.callbackHUDUpdated.accept(this);
                }
            }
            Config.Point snapOffset = new Config.Point();
            if (Config.hudSnapToBorder) {
                snapOffset.x = 16;
                snapOffset.y = 16;
                for (Config.HUDAnchor anchor : Config.HUDAnchor.values()) {
                    if (anchor == Config.HUDAnchor.MinimapHorizontal || anchor == Config.HUDAnchor.MinimapVertical) continue;
                    Config.Point anchorP = Config.getHUDAnchor(anchor);
                    Config.Point originP = Config.getHUDOrigin(anchor, this.hud.getWidth(), this.hud.getHeight());
                    int offsetX = this.positionHUD.x - anchorP.x + originP.x;
                    int offsetY = this.positionHUD.y - anchorP.y + originP.y;
                    if (anchor == Config.HUDAnchor.Minimap) {
                        if (!this.minimapEnabled) continue;
                        int displayWidth = mc.method_22683().method_4489();
                        int displayHeight = mc.method_22683().method_4506();
                        if (anchorP.x < displayWidth / 2 && offsetX >= 16 || anchorP.x > displayWidth / 2 && offsetX <= -16 || anchorP.y < displayHeight / 2 && offsetY >= 16 || anchorP.y > displayHeight / 2 && offsetY <= -16) continue;
                    }
                    if (Math.abs(offsetX) < Math.abs(snapOffset.x)) {
                        snapOffset.x = offsetX;
                    }
                    if (Math.abs(offsetY) >= Math.abs(snapOffset.y)) continue;
                    snapOffset.y = offsetY;
                }
                if (snapOffset.x == 16) {
                    snapOffset.x = 0;
                }
                if (snapOffset.y == 16) {
                    snapOffset.y = 0;
                }
            }
            Config.hudXPosition = this.positionHUD.x - anchorPoint.x + originPoint.x - snapOffset.x;
            Config.hudYPosition = this.positionHUD.y - anchorPoint.y + originPoint.y - snapOffset.y;
            this.hud.configUpdated();
            this.callbackHUDUpdated.accept(this);
        }
    }

    public void method_25354(class_1144 soundHandlerIn) {
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.hud.draw(graphics, partialTicks);
        if (!this.grabbed) {
            this.positionHUD.x = this.hud.getPosX();
            this.positionHUD.y = this.hud.getPosY();
        }
    }
}

