/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.plugin;

import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.client.gui.FullscreenMap;
import games.alejandrocoria.mapfrontiers.common.Config;
import java.util.EnumSet;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.client.api.ClientPlugin;
import journeymap.client.api.IClientAPI;
import journeymap.client.api.IClientPlugin;
import journeymap.client.api.display.Context;
import journeymap.client.api.display.ModPopupMenu;
import journeymap.client.api.display.ThemeButtonDisplay;
import journeymap.client.api.event.ClientEvent;
import journeymap.client.api.event.DisplayUpdateEvent;
import journeymap.client.api.event.FullscreenMapEvent;
import net.minecraft.class_1937;
import net.minecraft.class_5321;

@ParametersAreNonnullByDefault
@ClientPlugin
public class MapFrontiersPlugin
implements IClientPlugin {
    private static FullscreenMap fullscreenMap;

    public void initialize(IClientAPI jmAPI) {
        MapFrontiersClient.setjmAPI(jmAPI);
        jmAPI.subscribe("mapfrontiers", EnumSet.of(ClientEvent.Type.MAP_CLICKED, ClientEvent.Type.MAP_DRAGGED, ClientEvent.Type.MAP_MOUSE_MOVED, ClientEvent.Type.DISPLAY_UPDATE));
        ClientEventHandler.subscribeAddonButtonDisplayEvent(MapFrontiersPlugin.class, buttonDisplay -> {
            if (!Config.fullscreenButtons) {
                return;
            }
            if (fullscreenMap == null) {
                fullscreenMap = new FullscreenMap(jmAPI);
            }
            fullscreenMap.addButtons((ThemeButtonDisplay)buttonDisplay);
        });
        ClientEventHandler.subscribeFullscreenPopupMenuEvent(MapFrontiersPlugin.class, popupMenu -> {
            if (!Config.fullscreenButtons) {
                return;
            }
            if (fullscreenMap != null) {
                fullscreenMap.addPopupMenu((ModPopupMenu)popupMenu);
            }
        });
    }

    public String getModId() {
        return "mapfrontiers";
    }

    public void onEvent(ClientEvent event) {
        if (!Config.fullscreenButtons) {
            return;
        }
        if (fullscreenMap == null) {
            return;
        }
        switch (event.type) {
            case MAP_CLICKED: {
                boolean cancel;
                FullscreenMapEvent.ClickEvent clickEvent = (FullscreenMapEvent.ClickEvent)event;
                FullscreenMapEvent.Stage relevantStage = (fullscreenMap.isEditingVertices() || fullscreenMap.isEditingChunks()) && clickEvent.getButton() == 1 ? FullscreenMapEvent.Stage.PRE : FullscreenMapEvent.Stage.POST;
                if (clickEvent.getStage() != relevantStage || !(cancel = fullscreenMap.mapClicked((class_5321<class_1937>)clickEvent.dimension, clickEvent.getLocation(), clickEvent.getButton()))) break;
                clickEvent.cancel();
                break;
            }
            case MAP_DRAGGED: {
                boolean cancel;
                FullscreenMapEvent.MouseDraggedEvent mouseDraggedEvent = (FullscreenMapEvent.MouseDraggedEvent)event;
                if (mouseDraggedEvent.getStage() != FullscreenMapEvent.Stage.PRE || !(cancel = fullscreenMap.mapDragged((class_5321<class_1937>)mouseDraggedEvent.dimension, mouseDraggedEvent.getLocation()))) break;
                mouseDraggedEvent.cancel();
                break;
            }
            case MAP_MOUSE_MOVED: {
                FullscreenMapEvent.MouseMoveEvent mouseMoveEvent = (FullscreenMapEvent.MouseMoveEvent)event;
                fullscreenMap.mouseMoved((class_5321<class_1937>)mouseMoveEvent.dimension, mouseMoveEvent.getLocation());
                break;
            }
            case DISPLAY_UPDATE: {
                DisplayUpdateEvent displayEvent = (DisplayUpdateEvent)event;
                if (displayEvent.uiState.ui != Context.UI.Fullscreen) break;
                if (displayEvent.uiState.active) {
                    fullscreenMap.updateButtons();
                    break;
                }
                fullscreenMap.stopEditing();
                fullscreenMap.close();
                fullscreenMap = null;
            }
        }
    }

    public static boolean isEditing() {
        if (!Config.fullscreenButtons) {
            return false;
        }
        return fullscreenMap != null && (fullscreenMap.isEditingVertices() || fullscreenMap.isEditingChunks());
    }
}

