/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common;

import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUserShared;
import games.alejandrocoria.mapfrontiers.common.util.StringHelper;
import games.alejandrocoria.mapfrontiers.common.util.UUIDHelper;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1657;
import net.minecraft.class_1746;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.StringUtils;

@ParametersAreNonnullByDefault
public class FrontierData {
    protected UUID id;
    protected final List<class_2338> vertices = new ArrayList<class_2338>();
    protected final Set<class_1923> chunks = new HashSet<class_1923>();
    protected Mode mode = Mode.Vertex;
    protected String name1 = "New";
    protected String name2 = "Frontier";
    protected boolean visible = true;
    protected boolean fullscreenVisible = true;
    protected boolean fullscreenNameVisible = true;
    protected boolean fullscreenOwnerVisible = false;
    protected boolean minimapVisible = true;
    protected boolean minimapNameVisible = true;
    protected boolean minimapOwnerVisible = false;
    protected boolean announceInChat = false;
    protected boolean announceInTitle = false;
    protected int color = -1;
    protected class_5321<class_1937> dimension;
    protected SettingsUser owner = new SettingsUser();
    protected BannerData banner;
    protected boolean personal = false;
    protected List<SettingsUserShared> usersShared;
    protected Date created;
    protected Date modified;
    protected Set<Change> changes = EnumSet.noneOf(Change.class);

    public FrontierData() {
        this.id = new UUID(0L, 0L);
    }

    public FrontierData(FrontierData other) {
        this.id = other.id;
        this.dimension = other.dimension;
        this.owner = other.owner;
        this.personal = other.personal;
        this.visible = other.visible;
        this.fullscreenVisible = other.fullscreenVisible;
        this.fullscreenNameVisible = other.fullscreenNameVisible;
        this.fullscreenOwnerVisible = other.fullscreenOwnerVisible;
        this.minimapVisible = other.minimapVisible;
        this.minimapNameVisible = other.minimapNameVisible;
        this.minimapOwnerVisible = other.minimapOwnerVisible;
        this.announceInChat = other.announceInChat;
        this.announceInTitle = other.announceInTitle;
        this.color = other.color;
        this.name1 = other.name1;
        this.name2 = other.name2;
        this.banner = other.banner == null ? null : new BannerData(other.banner);
        this.usersShared = other.usersShared;
        this.vertices.clear();
        this.vertices.addAll(other.vertices);
        this.chunks.clear();
        this.chunks.addAll(other.chunks);
        this.mode = other.mode;
        this.created = other.created;
        this.modified = other.modified;
        this.changes = EnumSet.noneOf(Change.class);
    }

    public void updateFromData(FrontierData other) {
        if (other == this) {
            this.changes = EnumSet.noneOf(Change.class);
            return;
        }
        this.id = other.id;
        this.dimension = other.dimension;
        this.owner = other.owner;
        this.personal = other.personal;
        if (other.changes.contains((Object)Change.Other)) {
            this.visible = other.visible;
            this.fullscreenVisible = other.fullscreenVisible;
            this.fullscreenNameVisible = other.fullscreenNameVisible;
            this.fullscreenOwnerVisible = other.fullscreenOwnerVisible;
            this.minimapVisible = other.minimapVisible;
            this.minimapNameVisible = other.minimapNameVisible;
            this.minimapOwnerVisible = other.minimapOwnerVisible;
            this.announceInChat = other.announceInChat;
            this.announceInTitle = other.announceInTitle;
            this.color = other.color;
        }
        if (other.changes.contains((Object)Change.Name)) {
            this.name1 = other.name1;
            this.name2 = other.name2;
        }
        if (other.changes.contains((Object)Change.Banner)) {
            this.banner = other.banner == null ? null : new BannerData(other.banner);
        }
        if (other.changes.contains((Object)Change.Shared)) {
            this.usersShared = other.usersShared;
        }
        if (other.changes.contains((Object)Change.Vertices)) {
            this.vertices.clear();
            this.vertices.addAll(other.vertices);
            this.chunks.clear();
            this.chunks.addAll(other.chunks);
            this.mode = other.mode;
        }
        this.modified = other.modified;
        this.changes = EnumSet.noneOf(Change.class);
    }

    public void setOwner(SettingsUser owner) {
        this.owner = owner;
    }

    public void ensureOwner(MinecraftServer server) {
        if (this.owner.isEmpty()) {
            List playerList;
            if (!server.method_3816() && !(playerList = server.method_3760().method_14571()).isEmpty()) {
                this.owner = new SettingsUser((class_1657)playerList.get(0));
            }
        } else {
            this.owner.fillMissingInfo(false, server);
        }
    }

    public SettingsUser getOwner() {
        return this.owner;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public UUID getId() {
        return this.id;
    }

    public int getVertexCount() {
        return this.vertices.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVertex(class_2338 pos, int index) {
        List<class_2338> list = this.vertices;
        synchronized (list) {
            this.vertices.add(index, pos.method_33096(70));
        }
        this.changes.add(Change.Vertices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVertex(class_2338 pos) {
        List<class_2338> list = this.vertices;
        synchronized (list) {
            this.addVertex(pos, this.vertices.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVertex(int index) {
        if (index < 0 || index >= this.vertices.size()) {
            return;
        }
        List<class_2338> list = this.vertices;
        synchronized (list) {
            this.vertices.remove(index);
        }
        this.changes.add(Change.Vertices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveVertex(class_2338 pos, int index) {
        if (index < 0 || index >= this.vertices.size()) {
            return;
        }
        List<class_2338> list = this.vertices;
        synchronized (list) {
            this.vertices.set(index, pos);
        }
        this.changes.add(Change.Vertices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toggleChunk(class_1923 chunk) {
        boolean added = false;
        Set<class_1923> set = this.chunks;
        synchronized (set) {
            if (!this.chunks.remove(chunk)) {
                this.chunks.add(chunk);
                added = true;
            }
        }
        this.changes.add(Change.Vertices);
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addChunk(class_1923 chunk) {
        Set<class_1923> set = this.chunks;
        synchronized (set) {
            if (this.chunks.add(chunk)) {
                this.changes.add(Change.Vertices);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeChunk(class_1923 chunk) {
        Set<class_1923> set = this.chunks;
        synchronized (set) {
            if (this.chunks.remove(chunk)) {
                this.changes.remove((Object)Change.Vertices);
                return true;
            }
        }
        return false;
    }

    public int getChunkCount() {
        return this.chunks.size();
    }

    public void setMode(Mode mode) {
        this.mode = mode;
        this.changes.add(Change.Vertices);
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setName1(String name) {
        this.name1 = name;
        this.changes.add(Change.Name);
    }

    public String getName1() {
        return this.name1;
    }

    public void setName2(String name) {
        this.name2 = name;
        this.changes.add(Change.Name);
    }

    public String getName2() {
        return this.name2;
    }

    public boolean isNamed() {
        return !StringUtils.isBlank((CharSequence)this.name1) || !StringUtils.isBlank((CharSequence)this.name2);
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.changes.add(Change.Other);
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setFullscreenVisible(boolean visible) {
        this.fullscreenVisible = visible;
        this.changes.add(Change.Other);
    }

    public boolean getFullscreenVisible() {
        return this.fullscreenVisible;
    }

    public void setMinimapVisible(boolean visible) {
        this.minimapVisible = visible;
        this.changes.add(Change.Other);
    }

    public boolean getMinimapVisible() {
        return this.minimapVisible;
    }

    public void setFullscreenNameVisible(boolean nameVisible) {
        this.fullscreenNameVisible = nameVisible;
        this.changes.add(Change.Other);
    }

    public boolean getFullscreenNameVisible() {
        return this.fullscreenNameVisible;
    }

    public void setFullscreenOwnerVisible(boolean ownerVisible) {
        this.fullscreenOwnerVisible = ownerVisible;
        this.changes.add(Change.Other);
    }

    public boolean getFullscreenOwnerVisible() {
        return this.fullscreenOwnerVisible;
    }

    public void setMinimapNameVisible(boolean nameVisible) {
        this.minimapNameVisible = nameVisible;
        this.changes.add(Change.Other);
    }

    public boolean getMinimapNameVisible() {
        return this.minimapNameVisible;
    }

    public void setMinimapOwnerVisible(boolean ownerVisible) {
        this.minimapOwnerVisible = ownerVisible;
        this.changes.add(Change.Other);
    }

    public boolean getMinimapOwnerVisible() {
        return this.minimapOwnerVisible;
    }

    public void setAnnounceInChat(boolean announceInChat) {
        this.announceInChat = announceInChat;
        this.changes.add(Change.Other);
    }

    public boolean getAnnounceInChat() {
        return this.announceInChat;
    }

    public void setAnnounceInTitle(boolean announceInTitle) {
        this.announceInTitle = announceInTitle;
        this.changes.add(Change.Other);
    }

    public boolean getAnnounceInTitle() {
        return this.announceInTitle;
    }

    public void setColor(int color) {
        this.color = color;
        this.changes.add(Change.Other);
    }

    public int getColor() {
        return this.color;
    }

    public void setDimension(class_5321<class_1937> dimension) {
        this.dimension = dimension;
    }

    public class_5321<class_1937> getDimension() {
        return this.dimension;
    }

    public void setBanner(@Nullable class_1799 itemBanner) {
        this.changes.add(Change.Banner);
        this.banner = itemBanner == null ? null : new BannerData(itemBanner);
    }

    public boolean hasBanner() {
        return this.banner != null;
    }

    public void setBannerData(@Nullable BannerData bannerData) {
        this.changes.add(Change.Banner);
        this.banner = bannerData == null ? null : new BannerData(bannerData);
    }

    public BannerData getbannerData() {
        return this.banner;
    }

    public void setBannerRotation(int rotation) {
        this.changes.add(Change.Banner);
        this.banner.rotation = rotation;
    }

    public int getBannerRotation() {
        return this.banner.rotation;
    }

    public void setPersonal(boolean personal) {
        this.personal = personal;
    }

    public boolean getPersonal() {
        return this.personal;
    }

    public void addUserShared(SettingsUserShared userShared) {
        if (this.usersShared == null) {
            this.usersShared = new ArrayList<SettingsUserShared>();
        }
        this.usersShared.add(userShared);
        this.changes.add(Change.Shared);
    }

    public void removeUserShared(int index) {
        if (this.usersShared == null) {
            return;
        }
        this.usersShared.remove(index);
        if (this.usersShared.isEmpty()) {
            this.usersShared = null;
        }
        this.changes.add(Change.Shared);
    }

    public void removeUserShared(SettingsUser user) {
        if (this.usersShared == null) {
            return;
        }
        this.usersShared.removeIf(x -> x.getUser().equals(user));
        this.changes.add(Change.Shared);
    }

    public void removeAllUserShared() {
        if (this.usersShared == null) {
            return;
        }
        this.usersShared = null;
        this.changes.add(Change.Shared);
    }

    public void setUsersShared(List<SettingsUserShared> usersShared) {
        this.usersShared = usersShared;
        this.changes.add(Change.Shared);
    }

    public void removePendingUsersShared() {
        if (this.usersShared == null) {
            return;
        }
        this.usersShared.removeIf(SettingsUserShared::isPending);
        this.changes.add(Change.Shared);
    }

    public List<SettingsUserShared> getUsersShared() {
        return this.usersShared;
    }

    public SettingsUserShared getUserShared(SettingsUser user) {
        if (this.usersShared == null) {
            return null;
        }
        for (SettingsUserShared u : this.usersShared) {
            if (!u.getUser().equals(user)) continue;
            return u;
        }
        return null;
    }

    public boolean hasUserShared(SettingsUser user) {
        return this.getUserShared(user) != null;
    }

    public boolean checkActionUserShared(SettingsUser user, SettingsUserShared.Action action) {
        if (user.equals(this.owner)) {
            return true;
        }
        if (this.usersShared == null) {
            return false;
        }
        SettingsUserShared userShared = this.getUserShared(user);
        if (userShared == null) {
            return false;
        }
        return userShared.hasAction(action);
    }

    public void setCreated(Date created) {
        this.created = created;
        this.modified = created;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public Date getModified() {
        return this.modified;
    }

    public void addChange(Change change) {
        this.changes.add(change);
    }

    public void removeChange(Change change) {
        this.changes.remove((Object)change);
    }

    public void removeChanges() {
        this.changes.clear();
    }

    public boolean hasChange(Change change) {
        return this.changes.contains((Object)change);
    }

    public void readFromNBT(class_2487 nbt, int version) {
        int i;
        class_2499 usersSharedTagList;
        boolean splitVisibility = version >= 10;
        this.id = UUID.fromString(nbt.method_10558("id"));
        this.color = nbt.method_10550("color");
        this.dimension = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(nbt.method_10558("dimension")));
        this.name1 = nbt.method_10558("name1");
        this.name2 = nbt.method_10558("name2");
        this.visible = nbt.method_10577("visible");
        if (splitVisibility) {
            this.fullscreenVisible = nbt.method_10577("fullscreenVisible");
            this.fullscreenNameVisible = nbt.method_10577("fullscreenNameVisible");
            this.fullscreenOwnerVisible = nbt.method_10577("fullscreenOwnerVisible");
            this.minimapVisible = nbt.method_10577("minimapVisible");
            this.minimapNameVisible = nbt.method_10577("minimapNameVisible");
            this.minimapOwnerVisible = nbt.method_10577("minimapOwnerVisible");
        } else {
            this.fullscreenVisible = nbt.method_10577("visible");
            this.minimapVisible = nbt.method_10577("visible");
            this.fullscreenNameVisible = nbt.method_10577("nameVisible");
            this.minimapNameVisible = nbt.method_10577("nameVisible");
            this.fullscreenOwnerVisible = nbt.method_10577("ownerVisible");
            this.minimapOwnerVisible = nbt.method_10577("ownerVisible");
        }
        if (nbt.method_10545("announceInChat")) {
            this.announceInChat = nbt.method_10577("announceInChat");
        }
        if (nbt.method_10545("announceInTitle")) {
            this.announceInTitle = nbt.method_10577("announceInTitle");
        }
        this.personal = nbt.method_10577("personal");
        this.owner = new SettingsUser();
        this.owner.readFromNBT(nbt.method_10562("owner"));
        if (nbt.method_10545("banner")) {
            this.banner = new BannerData();
            this.banner.readFromNBT(nbt.method_10562("banner"));
        }
        if (this.personal && !(usersSharedTagList = nbt.method_10554("usersShared", 10)).isEmpty()) {
            this.usersShared = new ArrayList<SettingsUserShared>();
            for (i = 0; i < usersSharedTagList.size(); ++i) {
                SettingsUserShared userShared = new SettingsUserShared();
                userShared.readFromNBT(usersSharedTagList.method_10602(i));
                this.usersShared.add(userShared);
            }
        }
        class_2499 verticesTagList = nbt.method_10554("vertices", 10);
        for (i = 0; i < verticesTagList.size(); ++i) {
            this.vertices.add(class_2512.method_10691((class_2487)verticesTagList.method_10602(i)));
        }
        class_2499 chunksTagList = nbt.method_10554("chunks", 10);
        for (int i2 = 0; i2 < chunksTagList.size(); ++i2) {
            this.chunks.add(new class_1923(chunksTagList.method_10602(i2).method_10550("X"), chunksTagList.method_10602(i2).method_10550("Z")));
        }
        String modeTag = nbt.method_10558("mode");
        if (modeTag.isEmpty()) {
            this.mode = Mode.Vertex;
        } else {
            try {
                this.mode = Mode.valueOf(modeTag);
            }
            catch (IllegalArgumentException e) {
                this.mode = this.chunks.size() > 0 ? Mode.Chunk : Mode.Vertex;
                String availableModes = StringHelper.enumValuesToString(Arrays.asList(Mode.values()));
                MapFrontiers.LOGGER.warn(String.format("Unknown mode in frontier %1$s. Found: \"%2$s\". Expected: %3$s", this.id, modeTag, availableModes));
            }
        }
        if (nbt.method_10545("created")) {
            this.created = new Date(nbt.method_10537("created"));
        }
        if (nbt.method_10545("modified")) {
            this.modified = new Date(nbt.method_10537("modified"));
        }
    }

    public void writeToNBT(class_2487 nbt) {
        nbt.method_10582("id", this.id.toString());
        nbt.method_10569("color", this.color);
        nbt.method_10582("dimension", this.dimension.method_29177().toString());
        nbt.method_10582("name1", this.name1);
        nbt.method_10582("name2", this.name2);
        nbt.method_10556("visible", this.visible);
        nbt.method_10556("fullscreenVisible", this.fullscreenVisible);
        nbt.method_10556("fullscreenNameVisible", this.fullscreenNameVisible);
        nbt.method_10556("fullscreenOwnerVisible", this.fullscreenOwnerVisible);
        nbt.method_10556("minimapVisible", this.minimapVisible);
        nbt.method_10556("minimapNameVisible", this.minimapNameVisible);
        nbt.method_10556("minimapOwnerVisible", this.minimapOwnerVisible);
        nbt.method_10556("announceInChat", this.announceInChat);
        nbt.method_10556("announceInTitle", this.announceInTitle);
        nbt.method_10556("personal", this.personal);
        class_2487 nbtOwner = new class_2487();
        this.owner.writeToNBT(nbtOwner);
        nbt.method_10566("owner", (class_2520)nbtOwner);
        if (this.banner != null) {
            class_2487 nbtBanner = new class_2487();
            this.banner.writeToNBT(nbtBanner);
            nbt.method_10566("banner", (class_2520)nbtBanner);
        }
        if (this.personal && this.usersShared != null) {
            class_2499 usersSharedTagList = new class_2499();
            for (SettingsUserShared userShared : this.usersShared) {
                class_2487 nbtUserShared = new class_2487();
                userShared.writeToNBT(nbtUserShared);
                usersSharedTagList.add((Object)nbtUserShared);
            }
            nbt.method_10566("usersShared", (class_2520)usersSharedTagList);
        }
        class_2499 verticesTagList = new class_2499();
        for (class_2338 pos : this.vertices) {
            verticesTagList.add((Object)class_2512.method_10692((class_2338)pos));
        }
        nbt.method_10566("vertices", (class_2520)verticesTagList);
        class_2499 chunksTagList = new class_2499();
        for (class_1923 pos : this.chunks) {
            class_2487 compoundtag = new class_2487();
            compoundtag.method_10569("X", pos.field_9181);
            compoundtag.method_10569("Z", pos.field_9180);
            chunksTagList.add((Object)compoundtag);
        }
        nbt.method_10566("chunks", (class_2520)chunksTagList);
        nbt.method_10582("mode", this.mode.name());
        if (this.created != null) {
            nbt.method_10544("created", this.created.getTime());
        }
        if (this.modified != null) {
            nbt.method_10544("modified", this.modified.getTime());
        }
    }

    public void fromBytes(class_2540 buf) {
        int i;
        this.changes.clear();
        for (Change change : Change.valuesArray) {
            if (!buf.readBoolean()) continue;
            this.changes.add(change);
        }
        this.id = UUIDHelper.fromBytes((ByteBuf)buf);
        this.dimension = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)buf.method_10810());
        this.personal = buf.readBoolean();
        this.owner = new SettingsUser();
        this.owner.fromBytes(buf);
        if (this.changes.contains((Object)Change.Other)) {
            this.color = buf.readInt();
            this.visible = buf.readBoolean();
            this.fullscreenVisible = buf.readBoolean();
            this.fullscreenNameVisible = buf.readBoolean();
            this.fullscreenOwnerVisible = buf.readBoolean();
            this.minimapVisible = buf.readBoolean();
            this.minimapNameVisible = buf.readBoolean();
            this.minimapOwnerVisible = buf.readBoolean();
            this.announceInChat = buf.readBoolean();
            this.announceInTitle = buf.readBoolean();
        }
        if (this.changes.contains((Object)Change.Name)) {
            int maxCharacters = 17;
            int maxBytes = maxCharacters * 4;
            this.name1 = buf.method_10800(maxBytes);
            this.name2 = buf.method_10800(maxBytes);
            if (this.name1.length() > maxCharacters) {
                this.name1 = this.name1.substring(0, maxCharacters);
            }
            if (this.name2.length() > maxCharacters) {
                this.name2 = this.name2.substring(0, maxCharacters);
            }
        }
        if (this.changes.contains((Object)Change.Banner)) {
            if (buf.readBoolean()) {
                this.banner = new BannerData();
                this.banner.fromBytes(buf);
            } else {
                this.banner = null;
            }
        }
        if (this.changes.contains((Object)Change.Shared)) {
            if (buf.readBoolean()) {
                this.usersShared = new ArrayList<SettingsUserShared>();
                int usersCount = buf.readInt();
                for (i = 0; i < usersCount; ++i) {
                    SettingsUserShared userShared = new SettingsUserShared();
                    userShared.fromBytes(buf);
                    this.usersShared.add(userShared);
                }
            } else {
                this.usersShared = null;
            }
        }
        if (this.changes.contains((Object)Change.Vertices)) {
            this.vertices.clear();
            int vertexCount = buf.readInt();
            for (i = 0; i < vertexCount; ++i) {
                class_2338 vertex = class_2338.method_10092((long)buf.readLong());
                this.vertices.add(vertex);
            }
            this.chunks.clear();
            int chunkCount = buf.readInt();
            for (int i2 = 0; i2 < chunkCount; ++i2) {
                class_1923 chunk = new class_1923(buf.readLong());
                this.chunks.add(chunk);
            }
            this.mode = Mode.values()[buf.readInt()];
        }
        this.created = buf.readBoolean() ? new Date(buf.readLong()) : null;
        this.modified = buf.readBoolean() ? new Date(buf.readLong()) : null;
    }

    public void toBytes(class_2540 buf) {
        this.toBytes(buf, true);
    }

    public void toBytes(class_2540 buf, boolean onlyChanges) {
        for (Change change : Change.valuesArray) {
            if (onlyChanges) {
                buf.writeBoolean(this.changes.contains((Object)change));
                continue;
            }
            buf.writeBoolean(true);
        }
        UUIDHelper.toBytes((ByteBuf)buf, this.id);
        buf.method_10812(this.dimension.method_29177());
        buf.writeBoolean(this.personal);
        this.owner.toBytes(buf);
        if (!onlyChanges || this.changes.contains((Object)Change.Other)) {
            buf.writeInt(this.color);
            buf.writeBoolean(this.visible);
            buf.writeBoolean(this.fullscreenVisible);
            buf.writeBoolean(this.fullscreenNameVisible);
            buf.writeBoolean(this.fullscreenOwnerVisible);
            buf.writeBoolean(this.minimapVisible);
            buf.writeBoolean(this.minimapNameVisible);
            buf.writeBoolean(this.minimapOwnerVisible);
            buf.writeBoolean(this.announceInChat);
            buf.writeBoolean(this.announceInTitle);
        }
        if (!onlyChanges || this.changes.contains((Object)Change.Name)) {
            int maxCharacters = 17;
            int maxBytes = maxCharacters * 4;
            buf.method_10788(this.name1, maxBytes);
            buf.method_10788(this.name2, maxBytes);
        }
        if (!onlyChanges || this.changes.contains((Object)Change.Banner)) {
            if (this.banner == null) {
                buf.writeBoolean(false);
            } else {
                buf.writeBoolean(true);
                this.banner.toBytes(buf);
            }
        }
        if (!onlyChanges || this.changes.contains((Object)Change.Shared)) {
            if (this.personal && this.usersShared != null) {
                buf.writeBoolean(true);
                buf.writeInt(this.usersShared.size());
                for (SettingsUserShared userShared : this.usersShared) {
                    userShared.toBytes(buf);
                }
            } else {
                buf.writeBoolean(false);
            }
        }
        if (!onlyChanges || this.changes.contains((Object)Change.Vertices)) {
            buf.writeInt(this.vertices.size());
            for (class_2338 pos : this.vertices) {
                buf.writeLong(pos.method_10063());
            }
            buf.writeInt(this.chunks.size());
            for (class_1923 pos : this.chunks) {
                buf.writeLong(pos.method_8324());
            }
            buf.writeInt(this.mode.ordinal());
        }
        if (this.created == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeLong(this.created.getTime());
        }
        if (this.modified == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeLong(this.modified.getTime());
        }
    }

    public static enum Mode {
        Vertex,
        Chunk;

    }

    public static enum Change {
        Name,
        Vertices,
        Banner,
        Shared,
        Other;

        public static final Change[] valuesArray;

        static {
            valuesArray = Change.values();
        }
    }

    public static class BannerData {
        public class_1767 baseColor;
        public class_2499 patterns;
        public int rotation;

        public BannerData() {
            this.baseColor = class_1767.field_7952;
            this.rotation = 0;
        }

        public BannerData(BannerData other) {
            this.baseColor = other.baseColor;
            if (other.patterns != null) {
                this.patterns = other.patterns.method_10612();
            }
            this.rotation = other.rotation;
        }

        public BannerData(class_1799 itemBanner) {
            class_2487 blockEntityTag = itemBanner.method_7941("BlockEntityTag");
            if (blockEntityTag != null && blockEntityTag.method_10573("Patterns", 9)) {
                this.patterns = blockEntityTag.method_10554("Patterns", 10);
            }
            if (itemBanner.method_7909() instanceof class_1746) {
                this.baseColor = ((class_1746)itemBanner.method_7909()).method_7706();
            }
            this.rotation = 0;
        }

        public void readFromNBT(class_2487 nbt) {
            this.baseColor = class_1767.method_7791((int)nbt.method_10550("Base"));
            this.patterns = nbt.method_10554("Patterns", 10);
            this.rotation = nbt.method_10550("Rotation");
        }

        public void writeToNBT(class_2487 nbt) {
            nbt.method_10569("Base", this.baseColor.method_7789());
            if (this.patterns != null) {
                nbt.method_10566("Patterns", (class_2520)this.patterns);
            }
            nbt.method_10569("Rotation", this.rotation);
        }

        public void fromBytes(class_2540 buf) {
            this.baseColor = class_1767.method_7791((int)buf.readInt());
            class_2487 nbt = buf.method_10798();
            if (nbt != null) {
                this.patterns = nbt.method_10554("Patterns", 10);
            }
            this.rotation = buf.readInt();
        }

        public void toBytes(class_2540 buf) {
            buf.writeInt(this.baseColor.method_7789());
            if (this.patterns == null) {
                buf.method_10794(null);
            } else {
                class_2487 nbt = new class_2487();
                nbt.method_10566("Patterns", (class_2520)this.patterns);
                buf.method_10794(nbt);
            }
            buf.writeInt(this.rotation);
        }

        public boolean equals(Object o) {
            if (!(o instanceof BannerData)) {
                return false;
            }
            BannerData that = (BannerData)o;
            return this.rotation == that.rotation && this.baseColor == that.baseColor && Objects.equals(this.patterns, that.patterns);
        }

        public int hashCode() {
            return Objects.hash(this.baseColor, this.patterns, this.rotation);
        }
    }
}

