/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common.network;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.FrontiersManager;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

@ParametersAreNonnullByDefault
public class PacketPersonalFrontier {
    public static final class_2960 CHANNEL = new class_2960("mapfrontiers", "packet_personal_frontier");
    private final FrontierData frontier;

    public PacketPersonalFrontier() {
        this.frontier = new FrontierData();
    }

    public PacketPersonalFrontier(FrontierData frontier) {
        this.frontier = frontier;
    }

    public static PacketPersonalFrontier decode(class_2540 buf) {
        PacketPersonalFrontier packet = new PacketPersonalFrontier();
        packet.frontier.fromBytes(buf);
        return packet;
    }

    public void encode(class_2540 buf) {
        this.frontier.toBytes(buf, false);
    }

    public static void handle(PacketContext<PacketPersonalFrontier> ctx) {
        if (Side.SERVER.equals((Object)ctx.side())) {
            PacketPersonalFrontier message = (PacketPersonalFrontier)ctx.message();
            class_3222 player = ctx.sender();
            if (player == null) {
                return;
            }
            SettingsUser playerUser = new SettingsUser((class_1657)player);
            FrontierData currentFrontier = FrontiersManager.instance.getFrontierFromID(message.frontier.getId());
            if (currentFrontier == null && message.frontier.getPersonal() && message.frontier.getOwner().equals(playerUser)) {
                message.frontier.removeAllUserShared();
                message.frontier.removeChange(FrontierData.Change.Shared);
                FrontiersManager.instance.addPersonalFrontier(message.frontier);
            }
        }
    }
}

