/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common.network;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.FrontiersManager;
import games.alejandrocoria.mapfrontiers.common.network.PacketHandler;
import games.alejandrocoria.mapfrontiers.common.network.PacketPersonalFrontierShared;
import games.alejandrocoria.mapfrontiers.common.network.PacketSettingsProfile;
import games.alejandrocoria.mapfrontiers.common.settings.FrontierSettings;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUserShared;
import games.alejandrocoria.mapfrontiers.common.util.UUIDHelper;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

@ParametersAreNonnullByDefault
public class PacketSharePersonalFrontier {
    public static final class_2960 CHANNEL = new class_2960("mapfrontiers", "packet_share_personal_frontier");
    private UUID frontierID;
    private final SettingsUser targetUser;

    public PacketSharePersonalFrontier() {
        this.targetUser = new SettingsUser();
    }

    public PacketSharePersonalFrontier(UUID frontierID, SettingsUser user) {
        this.frontierID = frontierID;
        this.targetUser = user;
    }

    public static PacketSharePersonalFrontier decode(class_2540 buf) {
        PacketSharePersonalFrontier packet = new PacketSharePersonalFrontier();
        packet.frontierID = UUIDHelper.fromBytes((ByteBuf)buf);
        packet.targetUser.fromBytes(buf);
        return packet;
    }

    public void encode(class_2540 buf) {
        UUIDHelper.toBytes((ByteBuf)buf, this.frontierID);
        this.targetUser.toBytes(buf);
    }

    public static void handle(PacketContext<PacketSharePersonalFrontier> ctx) {
        if (Side.SERVER.equals((Object)ctx.side())) {
            PacketSharePersonalFrontier message = (PacketSharePersonalFrontier)ctx.message();
            class_3222 player = ctx.sender();
            if (player == null) {
                return;
            }
            MinecraftServer server = player.field_13995;
            SettingsUser playerUser = new SettingsUser((class_1657)player);
            message.targetUser.fillMissingInfo(false, server);
            if (message.targetUser.uuid == null) {
                return;
            }
            class_3222 targetPlayer = server.method_3760().method_14602(message.targetUser.uuid);
            if (targetPlayer == null) {
                return;
            }
            FrontierData currentFrontier = FrontiersManager.instance.getFrontierFromID(message.frontierID);
            if (currentFrontier != null && currentFrontier.getPersonal()) {
                if (currentFrontier.getOwner().equals(message.targetUser) || currentFrontier.hasUserShared(message.targetUser)) {
                    return;
                }
                if (FrontiersManager.instance.getSettings().checkAction(FrontierSettings.Action.SharePersonalFrontier, playerUser, MapFrontiers.isOPorHost(player), currentFrontier.getOwner())) {
                    if (currentFrontier.checkActionUserShared(playerUser, SettingsUserShared.Action.UpdateSettings)) {
                        int shareMessageID = FrontiersManager.instance.addShareMessage(message.targetUser, currentFrontier.getId());
                        currentFrontier.addUserShared(new SettingsUserShared(message.targetUser, true));
                        PacketHandler.sendTo(new PacketPersonalFrontierShared(shareMessageID, playerUser, currentFrontier.getOwner(), currentFrontier.getName1(), currentFrontier.getName2()), targetPlayer);
                        currentFrontier.removeChange(FrontierData.Change.Shared);
                    }
                } else {
                    PacketHandler.sendTo(new PacketSettingsProfile(FrontiersManager.instance.getSettings().getProfile(player)), player);
                }
            }
        }
    }
}

