/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component.button;

import com.mojang.blaze3d.systems.RenderSystem;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.ButtonBase;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

@ParametersAreNonnullByDefault
public class IconButton
extends ButtonBase {
    private static final ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"mapfrontiers", (String)"textures/gui/buttons.png");
    private static final int textureSizeX = 34;
    private static final int textureSizeY = 120;
    private Type type;

    public IconButton(Type type, Button.OnPress pressedAction) {
        super(0, 0, type.width, type.height, (Component)Component.empty(), pressedAction, Button.DEFAULT_NARRATION);
        this.type = type;
    }

    public void setType(Type type) {
        this.type = type;
        this.setSize(type.width, type.height);
    }

    public void playDownSound(SoundManager soundHandlerIn) {
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.isHoveredOrKeyboardFocused()) {
            graphics.blit(texture, this.getX(), this.getY(), (float)this.type.texHoverX, (float)this.type.texHoverY, this.width, this.height, 34, 120);
        } else {
            graphics.blit(texture, this.getX(), this.getY(), (float)this.type.texX, (float)this.type.texY, this.width, this.height, 34, 120);
        }
    }

    public static enum Type {
        Add(0, 0, 13, 0, 13, 13),
        Remove(0, 13, 13, 13, 13, 13),
        Copy(0, 26, 17, 26, 17, 17),
        Paste(0, 43, 17, 43, 17, 17),
        ArrowUp(0, 60, 8, 60, 8, 17),
        ArrowDown(18, 60, 26, 60, 8, 17),
        Undo(0, 77, 17, 77, 17, 17),
        Redo(0, 94, 17, 94, 17, 17),
        Swap(0, 111, 9, 111, 9, 9);

        final int texX;
        final int texY;
        final int texHoverX;
        final int texHoverY;
        final int width;
        final int height;

        private Type(int texX, int texY, int texHoverX, int texHoverY, int width, int height) {
            this.texX = texX;
            this.texY = texY;
            this.texHoverX = texHoverX;
            this.texHoverY = texHoverY;
            this.width = width;
            this.height = height;
        }
    }
}

