/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component.textbox;

import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.StringUtils;

@ParametersAreNonnullByDefault
public class TextBox
extends EditBox {
    private final String defaultText;
    private Consumer<String> valueChangedCallback;
    private Consumer<String> lostFocusCallback;
    private Consumer<String> submitCallback;

    public TextBox(Font font, int width) {
        this(font, width, "");
    }

    public TextBox(Font font, int width, String defaultText) {
        super(font, 0, 0, width, 12, (Component)Component.empty());
        this.defaultText = defaultText;
        if (!StringUtils.isBlank((CharSequence)defaultText)) {
            this.setResponder(value -> this.updateDefaultText());
        }
        this.updateDefaultText();
    }

    public void setValueChangedCallback(Consumer<String> callback) {
        this.valueChangedCallback = callback;
        if (StringUtils.isBlank((CharSequence)this.defaultText)) {
            this.setResponder(value -> this.valueChangedCallback.accept((String)value));
        } else {
            this.setResponder(value -> {
                this.updateDefaultText();
                this.valueChangedCallback.accept((String)value);
            });
        }
    }

    public void setLostFocusCallback(Consumer<String> callback) {
        this.lostFocusCallback = callback;
    }

    public void setSubmitCallback(Consumer<String> callback) {
        this.submitCallback = callback;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public boolean charTyped(char c, int key) {
        boolean res = false;
        if (this.active && this.isHoveredOrFocused() && (res = super.charTyped(c, key)) && this.valueChangedCallback != null) {
            this.valueChangedCallback.accept(this.getValue());
        }
        return res;
    }

    public void setValue(String value) {
        super.setValue(value);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        boolean res = false;
        if (this.active && this.isHoveredOrFocused()) {
            res = super.keyPressed(keyCode, scanCode, modifiers);
            if (keyCode == 257 || keyCode == 335) {
                this.setFocused(false);
                if (this.submitCallback != null) {
                    this.submitCallback.accept(this.getValue());
                }
            }
        }
        return res;
    }

    public void setFocused(boolean isFocusedIn) {
        if (this.isFocused() && !isFocusedIn && this.lostFocusCallback != null) {
            this.lostFocusCallback.accept(this.getValue());
        }
        super.setFocused(isFocusedIn);
    }

    private void updateDefaultText() {
        if (this.getValue().isEmpty()) {
            this.setSuggestion(this.defaultText);
        } else {
            this.setSuggestion("");
        }
    }
}

