/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.screen;

import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.client.gui.component.StringWidget;
import games.alejandrocoria.mapfrontiers.client.gui.component.TabbedBox;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.IconButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.LinkButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.OptionButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.SimpleButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.scroll.GroupActionElement;
import games.alejandrocoria.mapfrontiers.client.gui.component.scroll.GroupElement;
import games.alejandrocoria.mapfrontiers.client.gui.component.scroll.ScrollBox;
import games.alejandrocoria.mapfrontiers.client.gui.component.scroll.UserElement;
import games.alejandrocoria.mapfrontiers.client.gui.component.textbox.TextBox;
import games.alejandrocoria.mapfrontiers.client.gui.component.textbox.TextBoxInt;
import games.alejandrocoria.mapfrontiers.client.gui.component.textbox.TextBoxUser;
import games.alejandrocoria.mapfrontiers.client.gui.dialog.ConfirmationDialog;
import games.alejandrocoria.mapfrontiers.client.gui.dialog.DeleteConfirmationDialog;
import games.alejandrocoria.mapfrontiers.client.gui.dialog.FrontierAppearanceDialog;
import games.alejandrocoria.mapfrontiers.client.gui.dialog.VisibilityDialog;
import games.alejandrocoria.mapfrontiers.client.gui.screen.AutoScaledScreen;
import games.alejandrocoria.mapfrontiers.client.gui.screen.HUDSettings;
import games.alejandrocoria.mapfrontiers.common.Config;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.network.PacketFrontierSettings;
import games.alejandrocoria.mapfrontiers.common.network.PacketHandler;
import games.alejandrocoria.mapfrontiers.common.network.PacketRequestFrontierSettings;
import games.alejandrocoria.mapfrontiers.common.settings.FrontierSettings;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsGroup;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsProfile;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.platform.Services;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.layouts.SpacerElement;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class ModSettings
extends AutoScaledScreen {
    private static final Component titleLabel = Component.translatable((String)"mapfrontiers.title_settings");
    private static final Component tabCreditsLabel = Component.translatable((String)"mapfrontiers.credits");
    private static final Component tabGeneralLabel = Component.translatable((String)"mapfrontiers.general");
    private static final Component tabGroupsLabel = Component.translatable((String)"mapfrontiers.groups");
    private static final Component tabActionsLabel = Component.translatable((String)"mapfrontiers.actions");
    private static final Component createdByLabel = Component.translatable((String)"mapfrontiers.credits_created_by");
    private static final Component manyThanksLabel = Component.translatable((String)"mapfrontiers.credits_many_thanks", (Object[])new Object[]{Services.PLATFORM.getPlatformName()});
    private static final Component projectLabel = Component.translatable((String)"mapfrontiers.credits_project");
    private static final Component patreonLabel = Component.translatable((String)"mapfrontiers.credits_patreon");
    private static final Component webLinkLabel = Component.literal((String)"alejandrocoria.games");
    private static final String webURL = "https://alejandrocoria.games";
    private static final Component curseForgeLinkLabel = Component.literal((String)"curseforge.com/minecraft/mc-mods/mapfrontiers");
    private static final String curseForgeURL = "https://www.curseforge.com/minecraft/mc-mods/mapfrontiers";
    private static final Component modrinthLinkLabel = Component.literal((String)"modrinth.com/mod/mapfrontiers");
    private static final String modrinthURL = "https://modrinth.com/mod/mapfrontiers";
    private static final Component patreonLinkLabel = Component.literal((String)"patreon.com/alejandrocoria");
    private static final String patreonURL = "https://patreon.com/alejandrocoria";
    private static final Component creditsTranslationLabel = Component.translatable((String)"mapfrontiers.credits_translation");
    private static final Component versionLabel = Component.literal((String)Services.PLATFORM.getModVersion());
    private static final String keyHintkey = "mapfrontiers.key.open_settings.hint";
    private static final Component frontiersLabel = Component.translatable((String)"mapfrontiers.frontiers");
    private static final Component frontierAppearanceLabel = Component.translatable((String)"mapfrontiers.frontier_appearance");
    private static final Component forcedVisibilityLabel = Component.translatable((String)"mapfrontiers.forced_visibility");
    private static final Component titleAnnouncementDurationLabel = Config.getTranslatedName("titleAnnouncementDuration");
    private static final Tooltip titleAnnouncementDurationTooltip = Config.getTooltip("titleAnnouncementDuration");
    private static final Component titleAnnouncementTimeoutLabel = Config.getTranslatedName("titleAnnouncementTimeout");
    private static final Tooltip titleAnnouncementTimeoutTooltip = Config.getTooltip("titleAnnouncementTimeout");
    private static final Component titleAnnouncementAboveHotbarLabel = Config.getTranslatedName("titleAnnouncementAboveHotbar");
    private static final Tooltip titleAnnouncementAboveHotbarTooltip = Config.getTooltip("titleAnnouncementAboveHotbar");
    private static final Component announceUnnamedFrontiersLabel = Config.getTranslatedName("announceUnnamedFrontiers");
    private static final Tooltip announceUnnamedFrontiersTooltip = Config.getTooltip("announceUnnamedFrontiers");
    private static final Component snapDistanceLabel = Config.getTranslatedName("snapDistance");
    private static final Tooltip snapDistanceTooltip = Config.getTooltip("snapDistance");
    private static final Component guiLabel = Component.translatable((String)"mapfrontiers.gui");
    private static final Component fullscreenButtonsLabel = Config.getTranslatedName("fullscreenButtons");
    private static final Tooltip fullscreenButtonsTooltip = Config.getTooltip("fullscreenButtons");
    private static final Component askConfirmationFrontierDeleteLabel = Config.getTranslatedName("askConfirmationFrontierDelete");
    private static final Tooltip askConfirmationFrontierDeleteTooltip = Config.getTooltip("askConfirmationFrontierDelete");
    private static final Component askConfirmationGroupDeleteLabel = Config.getTranslatedName("askConfirmationGroupDelete");
    private static final Tooltip askConfirmationGroupDeleteTooltip = Config.getTooltip("askConfirmationGroupDelete");
    private static final Component askConfirmationUserDeleteLabel = Config.getTranslatedName("askConfirmationUserDelete");
    private static final Tooltip askConfirmationUserDeleteTooltip = Config.getTooltip("askConfirmationUserDelete");
    private static final Component hudLabel = Component.translatable((String)"mapfrontiers.hud");
    private static final Component hudEnabledLabel = Config.getTranslatedName("hud.enabled");
    private static final Tooltip hudEnabledTooltip = Config.getTooltip("hud.enabled");
    private static final Component onLabel = Component.translatable((String)"options.on");
    private static final Component offLabel = Component.translatable((String)"options.off");
    private static final Component editHudLabel = Component.translatable((String)"mapfrontiers.edit_hud");
    private static final Component groupOpsDescLabel = Component.translatable((String)"mapfrontiers.group_ops_desc");
    private static final Component groupOwnersDescLabel = Component.translatable((String)"mapfrontiers.group_owners_desc");
    private static final Component groupEveryoneDescLabel = Component.translatable((String)"mapfrontiers.group_everyone_desc");
    private static final Component createGlobalFrontierLabel = Component.translatable((String)"mapfrontiers.create_global_frontier");
    private static final Component deleteGlobalFrontierLabel = Component.translatable((String)"mapfrontiers.delete_global_frontier");
    private static final Component updateGlobalFrontierLabel = Component.translatable((String)"mapfrontiers.update_global_frontier");
    private static final Component updateSettingsLabel = Component.translatable((String)"mapfrontiers.update_settings");
    private static final Component sharePersonalFrontierLabel = Component.translatable((String)"mapfrontiers.share_personal_frontier");
    private static final Component doneLabel = Component.translatable((String)"gui.done");
    private final boolean showKeyHint;
    private FrontierSettings settings;
    private TabbedBox tabbedBox;
    private LinkButton buttonWeb;
    private LinkButton buttonCurseForge;
    private LinkButton buttonModrinth;
    private StringWidget labelTitleAnnouncementDuration;
    private StringWidget labelTitleAnnouncementTimeout;
    private StringWidget labelTitleAnnouncementAboveHotbar;
    private StringWidget labelAnnounceUnnamedFrontiers;
    private StringWidget labelSnapDistance;
    private StringWidget labelFullscreenButtons;
    private StringWidget labelAskConfirmationFrontierDelete;
    private StringWidget labelAskConfirmationGroupDelete;
    private StringWidget labelAskConfirmationUserDelete;
    private StringWidget labelHUDEnabled;
    private TextBoxInt textTitleAnnouncementDuration;
    private TextBoxInt textTitleAnnouncementTimeout;
    private OptionButton buttonTitleAnnouncementAboveHotbar;
    private OptionButton buttonAnnounceUnnamedFrontiers;
    private TextBoxInt textSnapDistance;
    private SimpleButton buttonFrontierAppearance;
    private OptionButton buttonFullscreenButtons;
    private OptionButton buttonAskConfirmationFrontierDelete;
    private OptionButton buttonAskConfirmationGroupDelete;
    private OptionButton buttonAskConfirmationUserDelete;
    private OptionButton buttonHUDEnabled;
    private SimpleButton buttonEditHUD;
    private ScrollBox groups;
    private MultiLineTextWidget labelGroupDesc;
    private ScrollBox users;
    private TextBox textNewGroupName;
    private IconButton buttonNewGroup;
    private TextBoxUser textNewUser;
    private IconButton buttonNewUser;
    private TextBox textGroupName;
    private MultiLineTextWidget labelCreateFrontier;
    private MultiLineTextWidget labelDeleteFrontier;
    private MultiLineTextWidget labelUpdateFrontier;
    private MultiLineTextWidget labelUpdateSettings;
    private MultiLineTextWidget labelSharePersonalFrontier;
    private ScrollBox groupsActions;
    private SimpleButton buttonDone;
    private boolean canEditGroups;
    private Tab tabSelected;
    private int ticksSinceLastUpdate = 0;

    public ModSettings(boolean showKeyHint) {
        super(titleLabel, 696, 366);
        this.showKeyHint = showKeyHint;
        ClientEventHandler.subscribeUpdatedSettingsProfileEvent((Object)this, profile -> {
            if (profile.updateSettings == SettingsProfile.State.Enabled == this.canEditGroups) {
                return;
            }
            if (this.tabSelected != null) {
                MapFrontiersClient.setLastSettingsTab(this.tabSelected);
            }
            this.onClose();
            new ModSettings(showKeyHint).display();
        });
    }

    @Override
    public void initScreen() {
        if (this.tabSelected == null) {
            this.tabSelected = MapFrontiersClient.getLastSettingsTab();
        }
        boolean bl = this.canEditGroups = MapFrontiersClient.isModOnServer() && MapFrontiersClient.getSettingsProfile().updateSettings == SettingsProfile.State.Enabled;
        if (!(this.canEditGroups || this.tabSelected != Tab.Groups && this.tabSelected != Tab.Actions)) {
            this.tabSelected = Tab.Credits;
        }
        this.tabbedBox = (TabbedBox)this.content.addChild((LayoutElement)new TabbedBox(this.font, this.actualWidth - 80, this.actualHeight - 64, tab -> {
            this.tabSelected = Tab.values()[tab];
            if (this.tabSelected == Tab.Actions) {
                this.updateGroupsActions();
            }
            this.updateButtonsVisibility();
        }));
        this.tabbedBox.addTab(tabCreditsLabel, true);
        this.tabbedBox.addTab(tabGeneralLabel, true);
        this.tabbedBox.addTab(tabGroupsLabel, this.canEditGroups);
        this.tabbedBox.addTab(tabActionsLabel, this.canEditGroups);
        LinearLayout creditsLayout = LinearLayout.vertical().spacing(4);
        creditsLayout.defaultCellSetting().alignHorizontallyCenter();
        this.tabbedBox.addChild(creditsLayout, Tab.Credits.ordinal(), LayoutSettings.defaults().alignHorizontallyCenter().alignVerticallyTop());
        creditsLayout.addChild((LayoutElement)SpacerElement.height((int)16));
        creditsLayout.addChild((LayoutElement)new StringWidget(createdByLabel, this.font).setColor(-1));
        this.buttonWeb = (LinkButton)creditsLayout.addChild((LayoutElement)new LinkButton(this, this.font, webLinkLabel, b -> {
            MapFrontiersClient.setLastSettingsTab(this.tabSelected);
            ConfirmLinkScreen.confirmLinkNow((Screen)this, (String)webURL, (boolean)false);
        }){

            @NotNull
            public ScreenRectangle getRectangle() {
                return new ScreenRectangle(this.getX() - 100, this.getY(), this.getWidth() + 200, this.getHeight());
            }
        });
        creditsLayout.addChild((LayoutElement)SpacerElement.height((int)16));
        creditsLayout.addChild((LayoutElement)new StringWidget(manyThanksLabel, this.font).setColor(0xAAAAAA));
        creditsLayout.addChild((LayoutElement)SpacerElement.height((int)16));
        creditsLayout.addChild((LayoutElement)new StringWidget(projectLabel, this.font).setColor(0xAAAAAA));
        this.buttonCurseForge = (LinkButton)creditsLayout.addChild((LayoutElement)new LinkButton(this.font, curseForgeLinkLabel, b -> {
            MapFrontiersClient.setLastSettingsTab(this.tabSelected);
            ConfirmLinkScreen.confirmLinkNow((Screen)this, (String)curseForgeURL, (boolean)false);
        }));
        this.buttonModrinth = (LinkButton)creditsLayout.addChild((LayoutElement)new LinkButton(this.font, modrinthLinkLabel, b -> {
            MapFrontiersClient.setLastSettingsTab(this.tabSelected);
            ConfirmLinkScreen.confirmLinkNow((Screen)this, (String)modrinthURL, (boolean)false);
        }));
        creditsLayout.addChild((LayoutElement)SpacerElement.height((int)16));
        creditsLayout.addChild((LayoutElement)new StringWidget(patreonLabel, this.font).setColor(0xAAAAAA));
        this.buttonModrinth = (LinkButton)creditsLayout.addChild((LayoutElement)new LinkButton(this.font, patreonLinkLabel, b -> {
            MapFrontiersClient.setLastSettingsTab(this.tabSelected);
            ConfirmLinkScreen.confirmLinkNow((Screen)this, (String)patreonURL, (boolean)false);
        }));
        LinearLayout generalLayout = LinearLayout.vertical().spacing(4);
        generalLayout.defaultCellSetting().alignHorizontallyCenter();
        this.tabbedBox.addChild(generalLayout, Tab.General.ordinal(), LayoutSettings.defaults().alignHorizontallyCenter().alignVerticallyTop());
        generalLayout.addChild((LayoutElement)SpacerElement.height((int)16));
        generalLayout.addChild((LayoutElement)new StringWidget(frontiersLabel, this.font).setColor(-1));
        GridLayout miscLayout = new GridLayout().spacing(4);
        miscLayout.defaultCellSetting().alignHorizontallyLeft();
        generalLayout.addChild((LayoutElement)miscLayout);
        int row = 0;
        this.labelTitleAnnouncementDuration = (StringWidget)miscLayout.addChild((LayoutElement)new StringWidget(titleAnnouncementDurationLabel, this.font).setColor(-4144960), row, 0);
        this.labelTitleAnnouncementDuration.setTooltip(titleAnnouncementDurationTooltip);
        this.textTitleAnnouncementDuration = (TextBoxInt)miscLayout.addChild((LayoutElement)new TextBoxInt(70, 0, 1200, this.font, 40), row++, 1);
        this.textTitleAnnouncementDuration.setValue(String.valueOf(Config.titleAnnouncementDuration));
        this.textTitleAnnouncementDuration.setMaxLength(4);
        this.textTitleAnnouncementDuration.setValueChangedCallback(value -> {
            Config.titleAnnouncementDuration = value;
        });
        this.labelTitleAnnouncementTimeout = (StringWidget)miscLayout.addChild((LayoutElement)new StringWidget(titleAnnouncementTimeoutLabel, this.font).setColor(-4144960), row, 0);
        this.labelTitleAnnouncementTimeout.setTooltip(titleAnnouncementTimeoutTooltip);
        this.textTitleAnnouncementTimeout = (TextBoxInt)miscLayout.addChild((LayoutElement)new TextBoxInt(0, 0, 1200, this.font, 40), row++, 1);
        this.textTitleAnnouncementTimeout.setValue(String.valueOf(Config.titleAnnouncementTimeout));
        this.textTitleAnnouncementTimeout.setMaxLength(4);
        this.textTitleAnnouncementTimeout.setValueChangedCallback(value -> {
            Config.titleAnnouncementTimeout = value;
        });
        this.labelTitleAnnouncementAboveHotbar = (StringWidget)miscLayout.addChild((LayoutElement)new StringWidget(titleAnnouncementAboveHotbarLabel, this.font).setColor(-4144960), row, 0);
        this.labelTitleAnnouncementAboveHotbar.setTooltip(titleAnnouncementAboveHotbarTooltip);
        this.buttonTitleAnnouncementAboveHotbar = (OptionButton)miscLayout.addChild((LayoutElement)new OptionButton(this, this.font, 40, b -> {
            Config.titleAnnouncementAboveHotbar = b.getSelected() == 0;
        }){

            @NotNull
            public ScreenRectangle getRectangle() {
                return new ScreenRectangle(this.getX() - 300, this.getY(), this.getWidth() + 300, this.getHeight());
            }
        }, row++, 1);
        this.buttonTitleAnnouncementAboveHotbar.addOption(onLabel);
        this.buttonTitleAnnouncementAboveHotbar.addOption(offLabel);
        this.buttonTitleAnnouncementAboveHotbar.setSelected(Config.titleAnnouncementAboveHotbar ? 0 : 1);
        this.labelAnnounceUnnamedFrontiers = (StringWidget)miscLayout.addChild((LayoutElement)new StringWidget(announceUnnamedFrontiersLabel, this.font).setColor(-4144960), row, 0);
        this.labelAnnounceUnnamedFrontiers.setTooltip(announceUnnamedFrontiersTooltip);
        this.buttonAnnounceUnnamedFrontiers = (OptionButton)miscLayout.addChild((LayoutElement)new OptionButton(this.font, 40, b -> {
            Config.announceUnnamedFrontiers = b.getSelected() == 0;
        }), row++, 1);
        this.buttonAnnounceUnnamedFrontiers.addOption(onLabel);
        this.buttonAnnounceUnnamedFrontiers.addOption(offLabel);
        this.buttonAnnounceUnnamedFrontiers.setSelected(Config.announceUnnamedFrontiers ? 0 : 1);
        this.labelSnapDistance = (StringWidget)miscLayout.addChild((LayoutElement)new StringWidget(snapDistanceLabel, this.font).setColor(-4144960), row, 0);
        this.labelSnapDistance.setTooltip(snapDistanceTooltip);
        this.textSnapDistance = (TextBoxInt)miscLayout.addChild((LayoutElement)new TextBoxInt(8, 0, 16, this.font, 40), row++, 1);
        this.textSnapDistance.setValue(String.valueOf(Config.snapDistance));
        this.textSnapDistance.setMaxLength(2);
        this.textSnapDistance.setValueChangedCallback(value -> {
            Config.snapDistance = value;
        });
        this.buttonFrontierAppearance = new SimpleButton(this, this.font, 144, frontierAppearanceLabel, b -> new FrontierAppearanceDialog().display()){

            @NotNull
            public ScreenRectangle getRectangle() {
                return new ScreenRectangle(this.getX(), this.getY(), this.getWidth() + 100, this.getHeight());
            }
        };
        miscLayout.addChild((LayoutElement)this.buttonFrontierAppearance, row++, 0, 1, 2, LayoutSettings.defaults().alignHorizontallyCenter());
        SimpleButton buttonVisibility = new SimpleButton(this, this.font, 144, forcedVisibilityLabel, b -> new VisibilityDialog(this.createForcedVisibility(), this.createForcedVisibilityMask(), this::setForcedVisibility).display()){

            @NotNull
            public ScreenRectangle getRectangle() {
                return new ScreenRectangle(this.getX(), this.getY(), this.getWidth() + 100, this.getHeight());
            }
        };
        miscLayout.addChild((LayoutElement)buttonVisibility, row++, 0, 1, 2, LayoutSettings.defaults().alignHorizontallyCenter());
        miscLayout.addChild((LayoutElement)SpacerElement.height((int)4), row++, 0);
        miscLayout.addChild((LayoutElement)new StringWidget(guiLabel, this.font).setColor(-1), row++, 0, 1, 2, LayoutSettings.defaults().alignHorizontallyCenter());
        this.labelFullscreenButtons = (StringWidget)miscLayout.addChild((LayoutElement)new StringWidget(fullscreenButtonsLabel, this.font).setColor(-4144960), row, 0);
        this.labelFullscreenButtons.setTooltip(fullscreenButtonsTooltip);
        this.buttonFullscreenButtons = (OptionButton)miscLayout.addChild((LayoutElement)new OptionButton(this.font, 40, b -> {
            Config.fullscreenButtons = b.getSelected() == 0;
        }), row++, 1);
        this.buttonFullscreenButtons.addOption(onLabel);
        this.buttonFullscreenButtons.addOption(offLabel);
        this.buttonFullscreenButtons.setSelected(Config.fullscreenButtons ? 0 : 1);
        this.labelAskConfirmationFrontierDelete = (StringWidget)miscLayout.addChild((LayoutElement)new StringWidget(askConfirmationFrontierDeleteLabel, this.font).setColor(-4144960), row, 0);
        this.labelAskConfirmationFrontierDelete.setTooltip(askConfirmationFrontierDeleteTooltip);
        this.buttonAskConfirmationFrontierDelete = (OptionButton)miscLayout.addChild((LayoutElement)new OptionButton(this.font, 40, b -> {
            Config.askConfirmationFrontierDelete = b.getSelected() == 0;
        }), row++, 1);
        this.buttonAskConfirmationFrontierDelete.addOption(onLabel);
        this.buttonAskConfirmationFrontierDelete.addOption(offLabel);
        this.buttonAskConfirmationFrontierDelete.setSelected(Config.askConfirmationFrontierDelete ? 0 : 1);
        this.labelAskConfirmationGroupDelete = (StringWidget)miscLayout.addChild((LayoutElement)new StringWidget(askConfirmationGroupDeleteLabel, this.font).setColor(-4144960), row, 0);
        this.labelAskConfirmationGroupDelete.setTooltip(askConfirmationGroupDeleteTooltip);
        this.buttonAskConfirmationGroupDelete = (OptionButton)miscLayout.addChild((LayoutElement)new OptionButton(this.font, 40, b -> {
            Config.askConfirmationGroupDelete = b.getSelected() == 0;
        }), row++, 1);
        this.buttonAskConfirmationGroupDelete.addOption(onLabel);
        this.buttonAskConfirmationGroupDelete.addOption(offLabel);
        this.buttonAskConfirmationGroupDelete.setSelected(Config.askConfirmationGroupDelete ? 0 : 1);
        this.labelAskConfirmationUserDelete = (StringWidget)miscLayout.addChild((LayoutElement)new StringWidget(askConfirmationUserDeleteLabel, this.font).setColor(-4144960), row, 0);
        this.labelAskConfirmationUserDelete.setTooltip(askConfirmationUserDeleteTooltip);
        this.buttonAskConfirmationUserDelete = (OptionButton)miscLayout.addChild((LayoutElement)new OptionButton(this.font, 40, b -> {
            Config.askConfirmationUserDelete = b.getSelected() == 0;
        }), row++, 1);
        this.buttonAskConfirmationUserDelete.addOption(onLabel);
        this.buttonAskConfirmationUserDelete.addOption(offLabel);
        this.buttonAskConfirmationUserDelete.setSelected(Config.askConfirmationUserDelete ? 0 : 1);
        miscLayout.addChild((LayoutElement)SpacerElement.height((int)4), row++, 0);
        miscLayout.addChild((LayoutElement)new StringWidget(hudLabel, this.font).setColor(-1), row++, 0, 1, 2, LayoutSettings.defaults().alignHorizontallyCenter());
        this.labelHUDEnabled = (StringWidget)miscLayout.addChild((LayoutElement)new StringWidget(hudEnabledLabel, this.font).setColor(-4144960), row, 0);
        this.labelHUDEnabled.setTooltip(hudEnabledTooltip);
        this.buttonHUDEnabled = (OptionButton)miscLayout.addChild((LayoutElement)new OptionButton(this.font, 40, b -> {
            Config.hudEnabled = b.getSelected() == 0;
            this.updateButtonsVisibility();
        }), row++, 1);
        this.buttonHUDEnabled.addOption(onLabel);
        this.buttonHUDEnabled.addOption(offLabel);
        this.buttonHUDEnabled.setSelected(Config.hudEnabled ? 0 : 1);
        this.buttonEditHUD = (SimpleButton)generalLayout.addChild((LayoutElement)new SimpleButton(this, this.font, 100, editHudLabel, b -> {
            MapFrontiersClient.setLastSettingsTab(this.tabSelected);
            new HUDSettings().display();
        }){

            @NotNull
            public ScreenRectangle getRectangle() {
                return new ScreenRectangle(this.getX(), this.getY(), this.getWidth() + 100, this.getHeight());
            }
        });
        LinearLayout groupsLayout = LinearLayout.horizontal().spacing(4);
        groupsLayout.defaultCellSetting().alignHorizontallyLeft();
        this.tabbedBox.addChild(groupsLayout, Tab.Groups.ordinal());
        LinearLayout groupsCol = LinearLayout.vertical().spacing(4);
        groupsCol.defaultCellSetting().alignHorizontallyCenter();
        groupsLayout.addChild((LayoutElement)groupsCol);
        this.groups = (ScrollBox)groupsCol.addChild((LayoutElement)new ScrollBox(this.actualHeight - 120, 160, 16));
        this.groups.setElementClickedCallback(element -> {
            this.groupClicked((GroupElement)element);
            this.updateButtonsVisibility();
        });
        this.groups.setElementDeletePressedCallback(element -> {
            if (this.groups.getSelectedElement() != null) {
                this.groupClicked((GroupElement)element);
            }
            if (Config.askConfirmationGroupDelete) {
                new DeleteConfirmationDialog("mapfrontiers.delete_group_dialog", response -> {
                    if (response == ConfirmationDialog.Response.ConfirmAlternative) {
                        Config.askConfirmationGroupDelete = false;
                        this.buttonAskConfirmationGroupDelete.setSelected(1);
                        ClientEventHandler.postUpdatedConfigEvent();
                    }
                    this.groups.removeElement((ScrollBox.ScrollElement)element);
                    this.settings.removeCustomGroup(((GroupElement)element).getGroup());
                    this.sendChangesToServer();
                }).display();
            } else {
                this.groups.removeElement((ScrollBox.ScrollElement)element);
                this.settings.removeCustomGroup(((GroupElement)element).getGroup());
                this.sendChangesToServer();
            }
        });
        LinearLayout newGroupLayout = LinearLayout.horizontal().spacing(4);
        groupsCol.addChild((LayoutElement)newGroupLayout);
        this.textNewGroupName = (TextBox)newGroupLayout.addChild((LayoutElement)new TextBox(this.font, 140, I18n.get((String)"mapfrontiers.new_group_name", (Object[])new Object[0])));
        this.textNewGroupName.setMaxLength(22);
        this.textNewGroupName.setSubmitCallback(value -> this.newGroupPressed());
        this.buttonNewGroup = (IconButton)newGroupLayout.addChild((LayoutElement)new IconButton(IconButton.Type.Add, b -> this.newGroupPressed()));
        LinearLayout usersCol = LinearLayout.vertical().spacing(4);
        usersCol.defaultCellSetting().alignHorizontallyLeft();
        groupsLayout.addChild((LayoutElement)usersCol);
        this.textGroupName = (TextBox)usersCol.addChild((LayoutElement)new TextBox(this.font, 140));
        this.textGroupName.setMaxLength(22);
        this.textGroupName.setLostFocusCallback(value -> {
            GroupElement groupElement;
            if (this.tabSelected == Tab.Groups && (groupElement = (GroupElement)this.groups.getSelectedElement()) != null) {
                groupElement.getGroup().setName((String)value);
                this.sendChangesToServer();
            }
        });
        this.labelGroupDesc = (MultiLineTextWidget)usersCol.addChild((LayoutElement)new MultiLineTextWidget(groupOpsDescLabel, this.font).setColor(-4144960));
        this.users = (ScrollBox)usersCol.addChild((LayoutElement)new ScrollBox(this.actualHeight - 160, 258, 16));
        this.users.setElementDeletePressedCallback(element -> {
            SettingsGroup group = ((GroupElement)this.groups.getSelectedElement()).getGroup();
            if (Config.askConfirmationUserDelete) {
                new DeleteConfirmationDialog("mapfrontiers.delete_user_dialog", response -> {
                    if (response == ConfirmationDialog.Response.ConfirmAlternative) {
                        Config.askConfirmationUserDelete = false;
                        this.buttonAskConfirmationUserDelete.setSelected(1);
                        ClientEventHandler.postUpdatedConfigEvent();
                    }
                    this.users.removeElement((ScrollBox.ScrollElement)element);
                    group.removeUser(((UserElement)element).getUser());
                    this.sendChangesToServer();
                }).display();
            } else {
                this.users.removeElement((ScrollBox.ScrollElement)element);
                group.removeUser(((UserElement)element).getUser());
                this.sendChangesToServer();
            }
        });
        LinearLayout newUserLayout = LinearLayout.horizontal().spacing(4);
        usersCol.addChild((LayoutElement)newUserLayout);
        this.textNewUser = (TextBoxUser)newUserLayout.addChild((LayoutElement)new TextBoxUser(this.minecraft, this.font, 238, I18n.get((String)"mapfrontiers.new_user", (Object[])new Object[0])));
        this.textNewUser.setMaxLength(38);
        this.textNewUser.setSubmitCallback(value -> this.newUserPressed());
        this.buttonNewUser = (IconButton)newUserLayout.addChild((LayoutElement)new IconButton(IconButton.Type.Add, b -> this.newUserPressed()));
        LinearLayout actionsLayout = LinearLayout.vertical().spacing(8);
        actionsLayout.defaultCellSetting().alignHorizontallyCenter();
        this.tabbedBox.addChild(actionsLayout, Tab.Actions.ordinal());
        LinearLayout actionsHeader = LinearLayout.horizontal();
        actionsLayout.addChild((LayoutElement)actionsHeader);
        this.labelCreateFrontier = (MultiLineTextWidget)actionsHeader.addChild((LayoutElement)new MultiLineTextWidget(createGlobalFrontierLabel, this.font).setColor(-1));
        this.labelCreateFrontier.setCentered(true);
        this.labelDeleteFrontier = (MultiLineTextWidget)actionsHeader.addChild((LayoutElement)new MultiLineTextWidget(deleteGlobalFrontierLabel, this.font).setColor(-1));
        this.labelDeleteFrontier.setCentered(true);
        this.labelUpdateFrontier = (MultiLineTextWidget)actionsHeader.addChild((LayoutElement)new MultiLineTextWidget(updateGlobalFrontierLabel, this.font).setColor(-1));
        this.labelUpdateFrontier.setCentered(true);
        this.labelUpdateSettings = (MultiLineTextWidget)actionsHeader.addChild((LayoutElement)new MultiLineTextWidget(updateSettingsLabel, this.font).setColor(-1));
        this.labelUpdateSettings.setCentered(true);
        this.labelSharePersonalFrontier = (MultiLineTextWidget)actionsHeader.addChild((LayoutElement)new MultiLineTextWidget(sharePersonalFrontierLabel, this.font).setColor(-1));
        this.labelSharePersonalFrontier.setCentered(true);
        this.groupsActions = (ScrollBox)actionsLayout.addChild((LayoutElement)new ScrollBox(this.actualHeight - 128, 430, 16));
        this.buttonDone = (SimpleButton)this.bottomButtons.addChild((LayoutElement)new SimpleButton(this.font, 140, doneLabel, b -> this.onClose()));
        this.tabbedBox.setTabSelected(this.tabSelected.ordinal());
        this.updateButtonsVisibility();
        if (MapFrontiersClient.isModOnServer()) {
            PacketHandler.sendToServer(new PacketRequestFrontierSettings());
        }
    }

    @Override
    public void repositionElements() {
        this.tabbedBox.setSize(this.actualWidth - 80, this.actualHeight - 64);
        this.groups.setHeight(this.actualHeight - 120);
        this.users.setHeight(this.actualHeight - 160);
        this.groupsActions.setHeight(this.actualHeight - 128);
        super.repositionElements();
        this.textNewUser.setY(this.textNewGroupName.getY());
        this.buttonNewUser.setY(this.buttonNewGroup.getY());
        this.labelCreateFrontier.setX(this.groupsActions.getX() + 160 - this.labelCreateFrontier.getWidth() / 2);
        this.labelDeleteFrontier.setX(this.groupsActions.getX() + 220 - this.labelDeleteFrontier.getWidth() / 2);
        this.labelUpdateFrontier.setX(this.groupsActions.getX() + 280 - this.labelUpdateFrontier.getWidth() / 2);
        this.labelUpdateSettings.setX(this.groupsActions.getX() + 340 - this.labelUpdateSettings.getWidth() / 2);
        this.labelSharePersonalFrontier.setX(this.groupsActions.getX() + 400 - this.labelSharePersonalFrontier.getWidth() / 2);
    }

    public void tick() {
        if (!this.canEditGroups || this.settings == null) {
            return;
        }
        ++this.ticksSinceLastUpdate;
        if (this.ticksSinceLastUpdate >= 100) {
            this.ticksSinceLastUpdate = 0;
            PacketHandler.sendToServer(new PacketRequestFrontierSettings(this.settings.getChangeCounter()));
            ClientPacketListener handler = this.minecraft.getConnection();
            if (handler == null) {
                return;
            }
            for (ScrollBox.ScrollElement element : this.users.getElements()) {
                UserElement userElement = (UserElement)element;
                SettingsUser user = userElement.getUser();
                PlayerInfo networkplayerinfo = null;
                if (user.uuid != null) {
                    networkplayerinfo = handler.getPlayerInfo(user.uuid);
                } else if (!StringUtils.isBlank((CharSequence)user.username)) {
                    networkplayerinfo = handler.getPlayerInfo(user.username);
                }
                if (networkplayerinfo == null) {
                    userElement.setPingBar(0);
                    continue;
                }
                if (networkplayerinfo.getLatency() < 0) {
                    userElement.setPingBar(0);
                    continue;
                }
                if (networkplayerinfo.getLatency() < 150) {
                    userElement.setPingBar(5);
                    continue;
                }
                if (networkplayerinfo.getLatency() < 300) {
                    userElement.setPingBar(4);
                    continue;
                }
                if (networkplayerinfo.getLatency() < 600) {
                    userElement.setPingBar(3);
                    continue;
                }
                if (networkplayerinfo.getLatency() < 1000) {
                    userElement.setPingBar(2);
                    continue;
                }
                userElement.setPingBar(1);
            }
        }
    }

    @Override
    public void renderScaledBackgroundScreen(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.tabbedBox.renderBackground(graphics, mouseX, mouseY, partialTicks);
        if (this.tabSelected == Tab.Credits || this.tabSelected == Tab.General) {
            Component key;
            int y = this.tabbedBox.getY() + this.tabbedBox.getHeight() - 19;
            graphics.drawString(this.font, creditsTranslationLabel, this.tabbedBox.getX() + 10, y, -1);
            graphics.drawString(this.font, versionLabel, this.tabbedBox.getX() + this.tabbedBox.getWidth() - this.font.width((FormattedText)versionLabel) - 10, y, -1);
            if (this.showKeyHint && (key = MapFrontiersClient.getOpenSettingsKey()) != null) {
                graphics.drawCenteredString(this.font, (Component)Component.translatable((String)keyHintkey, (Object[])new Object[]{key}), this.tabbedBox.getX() + this.tabbedBox.getWidth() / 2, y, -1);
            }
        }
    }

    @Override
    public boolean keyPressed(int key, int value, int modifier) {
        if (key == 69 && !(this.getFocused() instanceof EditBox)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(key, value, modifier);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        for (GuiEventListener w : this.children()) {
            if (!(w instanceof ScrollBox)) continue;
            ((ScrollBox)w).mouseReleased();
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    private FrontierData.VisibilityData createForcedVisibility() {
        FrontierData.VisibilityData visibilityData = new FrontierData.VisibilityData();
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.Frontier, Config.frontierVisibility != Config.Visibility.Never);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.AnnounceInChat, Config.announceInChat == Config.Visibility.Always);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.AnnounceInTitle, Config.announceInTitle == Config.Visibility.Always);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.Fullscreen, Config.fullscreenVisibility != Config.Visibility.Never);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.FullscreenName, Config.fullscreenNameVisibility != Config.Visibility.Never);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.FullscreenOwner, Config.fullscreenOwnerVisibility == Config.Visibility.Always);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.FullscreenBanner, Config.fullscreenBannerVisibility == Config.Visibility.Always);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.FullscreenDay, Config.fullscreenDayVisibility != Config.Visibility.Never);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.FullscreenNight, Config.fullscreenNightVisibility != Config.Visibility.Never);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.FullscreenUnderground, Config.fullscreenUndergroundVisibility != Config.Visibility.Never);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.FullscreenTopo, Config.fullscreenTopoVisibility != Config.Visibility.Never);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.FullscreenBiome, Config.fullscreenBiomeVisibility != Config.Visibility.Never);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.Minimap, Config.minimapVisibility != Config.Visibility.Never);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.MinimapName, Config.minimapNameVisibility != Config.Visibility.Never);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.MinimapOwner, Config.minimapOwnerVisibility == Config.Visibility.Always);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.MinimapBanner, Config.minimapBannerVisibility == Config.Visibility.Always);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.MinimapDay, Config.minimapDayVisibility != Config.Visibility.Never);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.MinimapNight, Config.minimapNightVisibility != Config.Visibility.Never);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.MinimapUnderground, Config.minimapUndergroundVisibility != Config.Visibility.Never);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.MinimapTopo, Config.minimapTopoVisibility != Config.Visibility.Never);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.MinimapBiome, Config.minimapBiomeVisibility != Config.Visibility.Never);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.Webmap, Config.webmapVisibility != Config.Visibility.Never);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.WebmapName, Config.webmapNameVisibility != Config.Visibility.Never);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.WebmapOwner, Config.webmapOwnerVisibility == Config.Visibility.Always);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.WebmapBanner, Config.webmapBannerVisibility == Config.Visibility.Always);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.WebmapDay, Config.webmapDayVisibility != Config.Visibility.Never);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.WebmapNight, Config.webmapNightVisibility != Config.Visibility.Never);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.WebmapUnderground, Config.webmapUndergroundVisibility != Config.Visibility.Never);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.WebmapTopo, Config.webmapTopoVisibility != Config.Visibility.Never);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.WebmapBiome, Config.webmapBiomeVisibility != Config.Visibility.Never);
        return visibilityData;
    }

    private FrontierData.VisibilityData createForcedVisibilityMask() {
        FrontierData.VisibilityData visibilityData = new FrontierData.VisibilityData();
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.Frontier, Config.frontierVisibility != Config.Visibility.Custom);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.AnnounceInChat, Config.announceInChat != Config.Visibility.Custom);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.AnnounceInTitle, Config.announceInTitle != Config.Visibility.Custom);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.Fullscreen, Config.fullscreenVisibility != Config.Visibility.Custom);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.FullscreenName, Config.fullscreenNameVisibility != Config.Visibility.Custom);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.FullscreenOwner, Config.fullscreenOwnerVisibility != Config.Visibility.Custom);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.FullscreenBanner, Config.fullscreenBannerVisibility != Config.Visibility.Custom);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.FullscreenDay, Config.fullscreenDayVisibility != Config.Visibility.Custom);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.FullscreenNight, Config.fullscreenNightVisibility != Config.Visibility.Custom);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.FullscreenUnderground, Config.fullscreenUndergroundVisibility != Config.Visibility.Custom);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.FullscreenTopo, Config.fullscreenTopoVisibility != Config.Visibility.Custom);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.FullscreenBiome, Config.fullscreenBiomeVisibility != Config.Visibility.Custom);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.Minimap, Config.minimapVisibility != Config.Visibility.Custom);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.MinimapName, Config.minimapNameVisibility != Config.Visibility.Custom);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.MinimapOwner, Config.minimapOwnerVisibility != Config.Visibility.Custom);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.MinimapBanner, Config.minimapBannerVisibility != Config.Visibility.Custom);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.MinimapDay, Config.minimapDayVisibility != Config.Visibility.Custom);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.MinimapNight, Config.minimapNightVisibility != Config.Visibility.Custom);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.MinimapUnderground, Config.minimapUndergroundVisibility != Config.Visibility.Custom);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.MinimapTopo, Config.minimapTopoVisibility != Config.Visibility.Custom);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.MinimapBiome, Config.minimapBiomeVisibility != Config.Visibility.Custom);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.Webmap, Config.webmapVisibility != Config.Visibility.Custom);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.WebmapName, Config.webmapNameVisibility != Config.Visibility.Custom);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.WebmapOwner, Config.webmapOwnerVisibility != Config.Visibility.Custom);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.WebmapBanner, Config.webmapBannerVisibility != Config.Visibility.Custom);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.WebmapDay, Config.webmapDayVisibility != Config.Visibility.Custom);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.WebmapNight, Config.webmapNightVisibility != Config.Visibility.Custom);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.WebmapUnderground, Config.webmapUndergroundVisibility != Config.Visibility.Custom);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.WebmapTopo, Config.webmapTopoVisibility != Config.Visibility.Custom);
        visibilityData.setValue(FrontierData.VisibilityData.Visibility.WebmapBiome, Config.webmapBiomeVisibility != Config.Visibility.Custom);
        return visibilityData;
    }

    private void setForcedVisibility(FrontierData.VisibilityData visibilityData, FrontierData.VisibilityData visibilityDataMask) {
        Config.frontierVisibility = this.getVisibilityValue(visibilityData, visibilityDataMask, FrontierData.VisibilityData.Visibility.Frontier);
        Config.announceInChat = this.getVisibilityValue(visibilityData, visibilityDataMask, FrontierData.VisibilityData.Visibility.AnnounceInChat);
        Config.announceInTitle = this.getVisibilityValue(visibilityData, visibilityDataMask, FrontierData.VisibilityData.Visibility.AnnounceInTitle);
        Config.fullscreenVisibility = this.getVisibilityValue(visibilityData, visibilityDataMask, FrontierData.VisibilityData.Visibility.Fullscreen);
        Config.fullscreenNameVisibility = this.getVisibilityValue(visibilityData, visibilityDataMask, FrontierData.VisibilityData.Visibility.FullscreenName);
        Config.fullscreenOwnerVisibility = this.getVisibilityValue(visibilityData, visibilityDataMask, FrontierData.VisibilityData.Visibility.FullscreenOwner);
        Config.fullscreenBannerVisibility = this.getVisibilityValue(visibilityData, visibilityDataMask, FrontierData.VisibilityData.Visibility.FullscreenBanner);
        Config.fullscreenDayVisibility = this.getVisibilityValue(visibilityData, visibilityDataMask, FrontierData.VisibilityData.Visibility.FullscreenDay);
        Config.fullscreenNightVisibility = this.getVisibilityValue(visibilityData, visibilityDataMask, FrontierData.VisibilityData.Visibility.FullscreenNight);
        Config.fullscreenUndergroundVisibility = this.getVisibilityValue(visibilityData, visibilityDataMask, FrontierData.VisibilityData.Visibility.FullscreenUnderground);
        Config.fullscreenTopoVisibility = this.getVisibilityValue(visibilityData, visibilityDataMask, FrontierData.VisibilityData.Visibility.FullscreenTopo);
        Config.fullscreenBiomeVisibility = this.getVisibilityValue(visibilityData, visibilityDataMask, FrontierData.VisibilityData.Visibility.FullscreenBiome);
        Config.minimapVisibility = this.getVisibilityValue(visibilityData, visibilityDataMask, FrontierData.VisibilityData.Visibility.Minimap);
        Config.minimapNameVisibility = this.getVisibilityValue(visibilityData, visibilityDataMask, FrontierData.VisibilityData.Visibility.MinimapName);
        Config.minimapOwnerVisibility = this.getVisibilityValue(visibilityData, visibilityDataMask, FrontierData.VisibilityData.Visibility.MinimapOwner);
        Config.minimapBannerVisibility = this.getVisibilityValue(visibilityData, visibilityDataMask, FrontierData.VisibilityData.Visibility.MinimapBanner);
        Config.minimapDayVisibility = this.getVisibilityValue(visibilityData, visibilityDataMask, FrontierData.VisibilityData.Visibility.MinimapDay);
        Config.minimapNightVisibility = this.getVisibilityValue(visibilityData, visibilityDataMask, FrontierData.VisibilityData.Visibility.MinimapNight);
        Config.minimapUndergroundVisibility = this.getVisibilityValue(visibilityData, visibilityDataMask, FrontierData.VisibilityData.Visibility.MinimapUnderground);
        Config.minimapTopoVisibility = this.getVisibilityValue(visibilityData, visibilityDataMask, FrontierData.VisibilityData.Visibility.MinimapTopo);
        Config.minimapBiomeVisibility = this.getVisibilityValue(visibilityData, visibilityDataMask, FrontierData.VisibilityData.Visibility.MinimapBiome);
        Config.webmapVisibility = this.getVisibilityValue(visibilityData, visibilityDataMask, FrontierData.VisibilityData.Visibility.Webmap);
        Config.webmapNameVisibility = this.getVisibilityValue(visibilityData, visibilityDataMask, FrontierData.VisibilityData.Visibility.WebmapName);
        Config.webmapOwnerVisibility = this.getVisibilityValue(visibilityData, visibilityDataMask, FrontierData.VisibilityData.Visibility.WebmapOwner);
        Config.webmapBannerVisibility = this.getVisibilityValue(visibilityData, visibilityDataMask, FrontierData.VisibilityData.Visibility.WebmapBanner);
        Config.webmapDayVisibility = this.getVisibilityValue(visibilityData, visibilityDataMask, FrontierData.VisibilityData.Visibility.WebmapDay);
        Config.webmapNightVisibility = this.getVisibilityValue(visibilityData, visibilityDataMask, FrontierData.VisibilityData.Visibility.WebmapNight);
        Config.webmapUndergroundVisibility = this.getVisibilityValue(visibilityData, visibilityDataMask, FrontierData.VisibilityData.Visibility.WebmapUnderground);
        Config.webmapTopoVisibility = this.getVisibilityValue(visibilityData, visibilityDataMask, FrontierData.VisibilityData.Visibility.WebmapTopo);
        Config.webmapBiomeVisibility = this.getVisibilityValue(visibilityData, visibilityDataMask, FrontierData.VisibilityData.Visibility.WebmapBiome);
    }

    private Config.Visibility getVisibilityValue(FrontierData.VisibilityData visibilityData, FrontierData.VisibilityData visibilityDataMask, FrontierData.VisibilityData.Visibility visibility) {
        if (visibilityDataMask.getValue(visibility)) {
            return visibilityData.getValue(visibility) ? Config.Visibility.Always : Config.Visibility.Never;
        }
        return Config.Visibility.Custom;
    }

    private void newGroupPressed() {
        if (this.settings != null) {
            SettingsGroup group = this.settings.createCustomGroup(this.textNewGroupName.getValue());
            this.textNewGroupName.setValue("");
            GroupElement element = new GroupElement(this.font, group);
            this.groups.addElement(element);
            this.groups.scrollBottom();
            this.groupClicked(element);
            this.groupsActions.scrollBottom();
            this.sendChangesToServer();
        }
    }

    private void newUserPressed() {
        SettingsGroup group = ((GroupElement)this.groups.getSelectedElement()).getGroup();
        SettingsUser user = new SettingsUser();
        String usernameOrUUID = this.textNewUser.getValue();
        if (StringUtils.isBlank((CharSequence)usernameOrUUID)) {
            return;
        }
        if (usernameOrUUID.length() < 28) {
            user.username = usernameOrUUID;
            user.fillMissingInfo(false, null);
        } else {
            if ((usernameOrUUID = usernameOrUUID.replaceAll("[^0-9a-fA-F]", "")).length() != 32) {
                this.textNewUser.setError((Component)Component.translatable((String)"mapfrontiers.new_user_error_uuid_size"));
                return;
            }
            usernameOrUUID = usernameOrUUID.toLowerCase();
            String uuid = usernameOrUUID.substring(0, 8) + "-" + usernameOrUUID.substring(8, 12) + "-" + usernameOrUUID.substring(12, 16) + "-" + usernameOrUUID.substring(16, 20) + "-" + usernameOrUUID.substring(20, 32);
            try {
                user.uuid = UUID.fromString(uuid);
                user.fillMissingInfo(true, null);
            }
            catch (Exception e) {
                this.textNewUser.setError((Component)Component.translatable((String)"mapfrontiers.new_user_error_uuid_format"));
                return;
            }
        }
        if (group.hasUser(user)) {
            this.textNewUser.setError((Component)Component.translatable((String)"mapfrontiers.new_user_error_user_repeated"));
            return;
        }
        group.addUser(user);
        UserElement element = new UserElement(this.font, user);
        this.users.addElement(element);
        this.users.scrollBottom();
        this.textNewUser.setValue("");
        this.sendChangesToServer();
    }

    public void onClose() {
        ClientEventHandler.postUpdatedConfigEvent();
        MapFrontiersClient.setLastSettingsTab(this.tabSelected);
        ClientEventHandler.unsuscribeAllEvents((Object)this);
        super.onClose();
    }

    public void setFrontierSettings(FrontierSettings settings) {
        this.settings = settings;
        GroupElement selectedElement = (GroupElement)this.groups.getSelectedElement();
        int selectedIndex = this.groups.getSelectedIndex();
        this.groups.removeAll();
        this.groups.addElement(new GroupElement(this.font, settings.getOPsGroup()));
        this.groups.addElement(new GroupElement(this.font, settings.getOwnersGroup()));
        this.groups.addElement(new GroupElement(this.font, settings.getEveryoneGroup()));
        for (SettingsGroup group : settings.getCustomGroups()) {
            this.groups.addElement(new GroupElement(this.font, group));
        }
        this.updateGroupsActions();
        this.updateButtonsVisibility();
        if (selectedElement != null) {
            this.groups.selectElementIf(element -> ((GroupElement)element).getGroup().getName().equals(selectedElement.getGroup().getName()));
        }
        if (this.groups.getSelectedElement() == null) {
            this.groups.selectIndex(selectedIndex);
        }
        if (this.groups.getSelectedElement() != null) {
            this.groupClicked((GroupElement)this.groups.getSelectedElement());
        }
    }

    private void updateButtonsVisibility() {
        this.buttonEditHUD.visible = this.tabSelected == Tab.General && Config.hudEnabled && this.minecraft.player != null;
        this.buttonFrontierAppearance.visible = this.tabSelected == Tab.General && this.minecraft.player != null;
        this.textNewUser.visible = this.canAddNewUser();
        this.buttonNewUser.visible = this.canAddNewUser();
    }

    public void groupClicked(GroupElement element) {
        this.groups.selectElement(element);
        SettingsGroup group = element.getGroup();
        this.textGroupName.setValue(group.getName());
        this.textGroupName.setEditable(!group.isSpecial());
        this.textGroupName.setBordered(!group.isSpecial());
        this.textGroupName.setFocused(false);
        if (group == this.settings.getOPsGroup()) {
            this.labelGroupDesc.setMessage(groupOpsDescLabel);
        } else if (group == this.settings.getOwnersGroup()) {
            this.labelGroupDesc.setMessage(groupOwnersDescLabel);
        } else if (group == this.settings.getEveryoneGroup()) {
            this.labelGroupDesc.setMessage(groupEveryoneDescLabel);
        } else {
            this.labelGroupDesc.setMessage((Component)Component.empty());
        }
        this.updateUsers();
    }

    private void sendChangesToServer() {
        if (this.settings != null) {
            this.settings.advanceChangeCounter();
            PacketHandler.sendToServer(new PacketFrontierSettings(this.settings));
        }
    }

    private void updateUsers() {
        this.users.removeAll();
        GroupElement element = (GroupElement)this.groups.getSelectedElement();
        if (element != null && !element.getGroup().isSpecial()) {
            for (SettingsUser user : element.getGroup().getUsers()) {
                this.users.addElement(new UserElement(this.font, user));
            }
        }
        this.buttonNewUser.visible = this.canAddNewUser();
        this.textNewUser.visible = this.canAddNewUser();
        this.ticksSinceLastUpdate = 100;
    }

    private void updateGroupsActions() {
        if (this.settings != null) {
            this.groupsActions.removeAll();
            this.groupsActions.addElement(new GroupActionElement(this.font, this.settings.getOPsGroup(), this::actionChanged));
            this.groupsActions.addElement(new GroupActionElement(this.font, this.settings.getOwnersGroup(), true, this::actionChanged));
            this.groupsActions.addElement(new GroupActionElement(this.font, this.settings.getEveryoneGroup(), this::actionChanged));
            for (SettingsGroup group : this.settings.getCustomGroups()) {
                this.groupsActions.addElement(new GroupActionElement(this.font, group, this::actionChanged));
            }
        }
    }

    private void actionChanged(SettingsGroup group, FrontierSettings.Action action, boolean checked) {
        if (checked) {
            group.addAction(action);
        } else {
            group.removeAction(action);
        }
        this.sendChangesToServer();
    }

    private boolean canAddNewUser() {
        if (this.tabSelected == Tab.Groups && this.groups.getSelectedElement() != null) {
            SettingsGroup group = ((GroupElement)this.groups.getSelectedElement()).getGroup();
            return !group.isSpecial();
        }
        return false;
    }

    public static enum Tab {
        Credits,
        General,
        Groups,
        Actions;

    }
}

