/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.screen;

import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.client.gui.component.StringWidget;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.OptionButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.ShapeChunkButtons;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.ShapeVertexButtons;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.SimpleButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.textbox.TextBoxInt;
import games.alejandrocoria.mapfrontiers.client.gui.screen.AutoScaledScreen;
import games.alejandrocoria.mapfrontiers.common.Config;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsProfile;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.api.v2.client.IClientAPI;
import journeymap.api.v2.client.display.Context;
import journeymap.api.v2.client.util.UIState;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;

@ParametersAreNonnullByDefault
public class NewFrontier
extends AutoScaledScreen {
    private static final Component titleLabel = Component.translatable((String)"mapfrontiers.title_new_frontier");
    private static final Component frontierTypeLabel = Component.translatable((String)"mapfrontiers.frontier_type");
    private static final Component frontierModeLabel = Component.translatable((String)"mapfrontiers.frontier_mode");
    private static final Component afterCreatingLabel = Component.translatable((String)"mapfrontiers.after_creating");
    private static final Component vertexCountLabel = Component.translatable((String)"mapfrontiers.shape_vertex_count");
    private static final Component sizeInfoLabel = Component.translatable((String)"mapfrontiers.shape_size_info");
    private static final String verticesKey = "mapfrontiers.vertices";
    private static final String chunksKey = "mapfrontiers.chunks";
    private static final Component createLabel = Component.translatable((String)"mapfrontiers.create");
    private static final Component cancelLabel = Component.translatable((String)"gui.cancel");
    private final IClientAPI jmAPI;
    private OptionButton buttonFrontierType;
    private OptionButton buttonFrontierMode;
    private OptionButton buttonAfterCreate;
    private ShapeVertexButtons shapeVertexButtons;
    private ShapeChunkButtons shapeChunkButtons;
    private StringWidget labelCount;
    private StringWidget labelCountInfo;
    private TextBoxInt textCount;
    private StringWidget labelSize;
    private StringWidget labelSizeInfo;
    private TextBoxInt textSize;
    private BlockPos centerPos;

    public NewFrontier(IClientAPI jmAPI, BlockPos centerPos) {
        super(titleLabel, 344, 295);
        this.jmAPI = jmAPI;
        this.centerPos = centerPos;
        ClientEventHandler.subscribeUpdatedSettingsProfileEvent((Object)this, profile -> {
            this.onClose();
            new NewFrontier(jmAPI, centerPos).display();
        });
    }

    @Override
    public void initScreen() {
        GridLayout mainLayout = new GridLayout().spacing(8);
        this.content.addChild((LayoutElement)mainLayout);
        LayoutSettings leftColumnSettings = LayoutSettings.defaults().alignHorizontallyRight();
        LayoutSettings rightColumnSettings = LayoutSettings.defaults().alignHorizontallyLeft();
        LayoutSettings centerColumnSettings = LayoutSettings.defaults().alignHorizontallyCenter();
        mainLayout.addChild((LayoutElement)new StringWidget(frontierTypeLabel, this.font).setColor(-4144960), 0, 0, leftColumnSettings);
        this.buttonFrontierType = new OptionButton(this.font, 130, OptionButton.DO_NOTHING);
        this.buttonFrontierType.addOption(Config.getTranslatedEnum(Config.FilterFrontierType.Global));
        this.buttonFrontierType.addOption(Config.getTranslatedEnum(Config.FilterFrontierType.Personal));
        this.buttonFrontierType.setSelected(0);
        if (!MapFrontiersClient.isModOnServer() || MapFrontiersClient.getSettingsProfile().createFrontier != SettingsProfile.State.Enabled) {
            this.buttonFrontierType.setSelected(1);
            this.buttonFrontierType.active = false;
        }
        mainLayout.addChild((LayoutElement)this.buttonFrontierType, 0, 1, rightColumnSettings);
        mainLayout.addChild((LayoutElement)new StringWidget(frontierModeLabel, this.font).setColor(-4144960), 1, 0, leftColumnSettings);
        this.buttonFrontierMode = new OptionButton(this.font, 130, b -> {
            Config.newFrontierMode = FrontierData.Mode.values()[b.getSelected()];
            this.shapeButtonsUpdated();
        });
        this.buttonFrontierMode.addOption(Config.getTranslatedEnum(FrontierData.Mode.Vertex));
        this.buttonFrontierMode.addOption(Config.getTranslatedEnum(FrontierData.Mode.Chunk));
        this.buttonFrontierMode.setSelected(Config.newFrontierMode.ordinal());
        mainLayout.addChild((LayoutElement)this.buttonFrontierMode, 1, 1, rightColumnSettings);
        mainLayout.addChild((LayoutElement)new StringWidget(afterCreatingLabel, this.font).setColor(-4144960), 2, 0, leftColumnSettings);
        this.buttonAfterCreate = new OptionButton(this.font, 130, b -> {
            Config.afterCreatingFrontier = Config.AfterCreatingFrontier.values()[b.getSelected()];
        });
        this.buttonAfterCreate.addOption(Config.getTranslatedEnum(Config.AfterCreatingFrontier.Info));
        this.buttonAfterCreate.addOption(Config.getTranslatedEnum(Config.AfterCreatingFrontier.Edit));
        this.buttonAfterCreate.addOption(Config.getTranslatedEnum(Config.AfterCreatingFrontier.Nothing));
        this.buttonAfterCreate.setSelected(Config.afterCreatingFrontier.ordinal());
        mainLayout.addChild((LayoutElement)this.buttonAfterCreate, 2, 1, rightColumnSettings);
        this.shapeVertexButtons = new ShapeVertexButtons(this.font, Config.newFrontierShape, s -> this.shapeButtonsUpdated());
        mainLayout.addChild((LayoutElement)this.shapeVertexButtons, 3, 0, 1, 2, centerColumnSettings);
        this.shapeChunkButtons = new ShapeChunkButtons(this.font, Config.newFrontierChunkShape, s -> this.shapeButtonsUpdated());
        mainLayout.addChild((LayoutElement)this.shapeChunkButtons, 3, 0, 1, 2, centerColumnSettings);
        this.labelCount = (StringWidget)mainLayout.addChild((LayoutElement)new StringWidget(vertexCountLabel, this.font).setColor(-1), 4, 0, leftColumnSettings);
        this.textCount = new TextBoxInt(Config.newFrontierCount, 1, 999, this.font, 64);
        this.textCount.setValueChangedCallback(value -> {
            if (Config.isInRange("newFrontierVertexCount", value)) {
                Config.newFrontierCount = value;
            }
        });
        mainLayout.addChild((LayoutElement)this.textCount, 4, 1, rightColumnSettings);
        this.labelCountInfo = (StringWidget)mainLayout.addChild((LayoutElement)new StringWidget((Component)Component.empty(), this.font).setColor(-1), 4, 0, 1, 2, centerColumnSettings);
        this.labelSize = (StringWidget)mainLayout.addChild((LayoutElement)new StringWidget((Component)Component.empty(), this.font).setColor(-1), 5, 0, leftColumnSettings);
        this.textSize = new TextBoxInt(1, 1, 999, this.font, 64);
        this.textSize.setValueChangedCallback(value -> {
            if (Config.newFrontierMode == FrontierData.Mode.Vertex) {
                if (this.shapeVertexButtons.getShapeMeasure() == ShapeVertexButtons.ShapeMeasure.Width) {
                    if (Config.isInRange("newFrontierShapeWidth", value)) {
                        Config.newFrontierShapeWidth = value;
                    }
                } else if (this.shapeVertexButtons.getShapeMeasure() == ShapeVertexButtons.ShapeMeasure.Radius && Config.isInRange("newFrontierShapeRadius", value)) {
                    Config.newFrontierShapeRadius = value;
                }
            } else if (this.shapeChunkButtons.getShapeMeasure() == ShapeChunkButtons.ShapeMeasure.Width) {
                if (Config.isInRange("newFrontierChunkShapeWidth", value)) {
                    Config.newFrontierChunkShapeWidth = value;
                    this.shapeChunkButtons.setSize(value);
                }
            } else if (this.shapeChunkButtons.getShapeMeasure() == ShapeChunkButtons.ShapeMeasure.Length && Config.isInRange("newFrontierChunkShapeLength", value)) {
                Config.newFrontierChunkShapeLength = value;
                this.shapeChunkButtons.setSize(value);
            }
        });
        mainLayout.addChild((LayoutElement)this.textSize, 5, 1, rightColumnSettings);
        this.labelSizeInfo = (StringWidget)mainLayout.addChild((LayoutElement)new StringWidget(sizeInfoLabel, this.font).setColor(-1), 5, 0, 1, 2, centerColumnSettings);
        this.bottomButtons.addChild((LayoutElement)new SimpleButton(this.font, 100, createLabel, b -> {
            boolean personal = this.buttonFrontierType.getSelected() == 1;
            this.closeAndReturnToFullscreenMap();
            UIState uiState = this.jmAPI.getUIState(Context.UI.Fullscreen);
            if (uiState != null) {
                MapFrontiersClient.getFrontiersOverlayManager(personal).clientCreateNewfrontier((ResourceKey<Level>)uiState.dimension, this.calculateVertices(), this.calculateChunks());
            }
        }));
        this.bottomButtons.addChild((LayoutElement)new SimpleButton(this.font, 100, cancelLabel, b -> this.onClose()));
        this.shapeButtonsUpdated();
    }

    @Override
    public void renderScaledBackgroundScreen(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.drawCenteredBoxBackground(graphics, 344, 234);
    }

    public void onClose() {
        ClientEventHandler.unsuscribeAllEvents((Object)this);
        ClientEventHandler.postUpdatedConfigEvent();
        super.onClose();
    }

    private void shapeButtonsUpdated() {
        if (Config.newFrontierMode == FrontierData.Mode.Vertex) {
            int selected;
            this.shapeVertexButtons.visible = true;
            this.shapeChunkButtons.visible = false;
            Config.newFrontierShape = selected = this.shapeVertexButtons.getSelected();
            if (selected == 11) {
                this.labelCount.visible = true;
                this.textCount.visible = true;
                this.labelCountInfo.visible = false;
            } else {
                this.labelCount.visible = false;
                this.textCount.visible = false;
                this.labelCountInfo.visible = true;
                this.setLabelCountInfoMessage(verticesKey, this.shapeVertexButtons.getVertexCount());
            }
            this.labelSizeInfo.visible = false;
            if (selected == 0 || selected == 1) {
                this.labelSize.visible = false;
                this.textSize.visible = false;
                this.repositionElements();
                return;
            }
            this.labelSize.visible = true;
            this.textSize.visible = true;
            if (this.shapeVertexButtons.getShapeMeasure() == ShapeVertexButtons.ShapeMeasure.Width) {
                this.setLabelSizeMessage("mapfrontiers.shape_width");
                this.textSize.setValue(String.valueOf(Config.newFrontierShapeWidth));
            } else if (this.shapeVertexButtons.getShapeMeasure() == ShapeVertexButtons.ShapeMeasure.Radius) {
                this.setLabelSizeMessage("mapfrontiers.shape_radius");
                this.textSize.setValue(String.valueOf(Config.newFrontierShapeRadius));
            }
        } else {
            int selected;
            this.shapeVertexButtons.visible = false;
            this.shapeChunkButtons.visible = true;
            Config.newFrontierChunkShape = selected = this.shapeChunkButtons.getSelected();
            this.labelCount.visible = false;
            this.textCount.visible = false;
            this.labelCountInfo.visible = true;
            this.setLabelCountInfoMessage(chunksKey, this.shapeChunkButtons.getChunkCount());
            boolean bl = this.labelSizeInfo.visible = selected == 7;
            if (selected == 0 || selected == 1 || selected == 7) {
                this.labelSize.visible = false;
                this.textSize.visible = false;
                this.repositionElements();
                return;
            }
            this.labelSize.visible = true;
            this.textSize.visible = true;
            if (this.shapeChunkButtons.getShapeMeasure() == ShapeChunkButtons.ShapeMeasure.Width) {
                this.setLabelSizeMessage("mapfrontiers.shape_width");
                this.textSize.setValue(String.valueOf(Config.newFrontierChunkShapeWidth));
                this.shapeChunkButtons.setSize(Config.newFrontierChunkShapeWidth);
            } else if (this.shapeChunkButtons.getShapeMeasure() == ShapeChunkButtons.ShapeMeasure.Length) {
                this.setLabelSizeMessage("mapfrontiers.shape_length");
                this.textSize.setValue(String.valueOf(Config.newFrontierChunkShapeLength));
                this.shapeChunkButtons.setSize(Config.newFrontierChunkShapeLength);
            }
        }
        this.repositionElements();
    }

    private void setLabelSizeMessage(String key) {
        this.labelSize.setMessage((Component)Component.translatable((String)key));
        this.labelSize.setWidth(this.font.width((FormattedText)this.labelSize.getMessage()));
    }

    private void setLabelCountInfoMessage(String key, int count) {
        this.labelCountInfo.setMessage((Component)Component.translatable((String)key, (Object[])new Object[]{count}));
        this.labelCountInfo.setWidth(this.font.width((FormattedText)this.labelCountInfo.getMessage()));
    }

    private List<BlockPos> calculateVertices() {
        if (Config.newFrontierMode != FrontierData.Mode.Vertex) {
            return null;
        }
        List<Vec2> shapeVertices = this.shapeVertexButtons.getSelected() == 11 ? this.shapeVertexButtons.getVertices(Config.newFrontierCount) : this.shapeVertexButtons.getVertices();
        if (shapeVertices == null) {
            return new ArrayList<BlockPos>();
        }
        double radius = 0.0;
        if (this.shapeVertexButtons.getShapeMeasure() == ShapeVertexButtons.ShapeMeasure.Width) {
            radius = Config.newFrontierShapeWidth;
            if (radius < 2.0) {
                radius = 2.0;
            }
            if (shapeVertices.size() == 3) {
                radius = radius * Math.sqrt(3.0) / 3.0;
            } else if (shapeVertices.size() == 4) {
                radius = Math.sqrt(radius * radius * 2.0) / 2.0;
            }
        } else if (this.shapeVertexButtons.getShapeMeasure() == ShapeVertexButtons.ShapeMeasure.Radius && (radius = (double)Config.newFrontierShapeRadius) < 1.0) {
            radius = 1.0;
        }
        LinkedHashSet<BlockPos> polygonVertices = new LinkedHashSet<BlockPos>();
        for (Vec2 vertex : shapeVertices) {
            int x = (int)Math.round((double)vertex.x * radius) + this.centerPos.getX();
            int z = (int)Math.round((double)vertex.y * radius) + this.centerPos.getZ();
            polygonVertices.add(new BlockPos(x, 70, z));
        }
        return new ArrayList<BlockPos>(polygonVertices);
    }

    private List<ChunkPos> calculateChunks() {
        ArrayList<ChunkPos> chunks;
        block11: {
            int selected;
            ChunkPos playerChunk;
            block16: {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                block10: {
                                    if (Config.newFrontierMode != FrontierData.Mode.Chunk) {
                                        return null;
                                    }
                                    chunks = new ArrayList<ChunkPos>();
                                    playerChunk = new ChunkPos(this.centerPos);
                                    selected = this.shapeChunkButtons.getSelected();
                                    if (selected != 1) break block10;
                                    chunks.add(playerChunk);
                                    break block11;
                                }
                                if (selected != 2) break block12;
                                int shapeWidth = Config.newFrontierChunkShapeWidth;
                                ChunkPos start = new ChunkPos(playerChunk.x - shapeWidth / 2, playerChunk.z - shapeWidth / 2);
                                for (int i = 0; i < shapeWidth * shapeWidth; ++i) {
                                    chunks.add(new ChunkPos(start.x + i % shapeWidth, start.z + i / shapeWidth));
                                }
                                break block11;
                            }
                            if (selected != 3) break block13;
                            int shapeWidth = Config.newFrontierChunkShapeWidth;
                            ChunkPos start = new ChunkPos(playerChunk.x - shapeWidth / 2, playerChunk.z - shapeWidth / 2);
                            for (int i = 0; i < shapeWidth * shapeWidth; ++i) {
                                if (i >= shapeWidth && i < shapeWidth * (shapeWidth - 1) && i % shapeWidth != 0 && i % shapeWidth != shapeWidth - 1) continue;
                                chunks.add(new ChunkPos(start.x + i % shapeWidth, start.z + i / shapeWidth));
                            }
                            break block11;
                        }
                        if (selected != 4) break block14;
                        int shapeWidth = Config.newFrontierChunkShapeWidth;
                        ChunkPos start = new ChunkPos(playerChunk.x - shapeWidth / 2, playerChunk.z - shapeWidth / 2);
                        for (int z = start.z; z < start.z + shapeWidth; ++z) {
                            for (int x = start.x; x < start.x + shapeWidth; ++x) {
                                int deltaX = x - playerChunk.x;
                                int deltaZ = z - playerChunk.z;
                                if (shapeWidth % 2 == 0) {
                                    deltaX += deltaX < 0 ? 1 : 0;
                                    deltaZ += deltaZ < 0 ? 1 : 0;
                                }
                                if (Math.abs(deltaX) + Math.abs(deltaZ) > (shapeWidth - 1) / 2) continue;
                                chunks.add(new ChunkPos(x, z));
                            }
                        }
                        break block11;
                    }
                    if (selected != 5) break block15;
                    int shapeLength = Config.newFrontierChunkShapeLength;
                    int start = playerChunk.x - shapeLength / 2;
                    for (int i = 0; i < shapeLength; ++i) {
                        chunks.add(new ChunkPos(start + i, playerChunk.z));
                    }
                    break block11;
                }
                if (selected != 6) break block16;
                int shapeLength = Config.newFrontierChunkShapeLength;
                int start = playerChunk.z - shapeLength / 2;
                for (int i = 0; i < shapeLength; ++i) {
                    chunks.add(new ChunkPos(playerChunk.x, start + i));
                }
                break block11;
            }
            if (selected != 7) break block11;
            ChunkPos start = new ChunkPos(Math.floorDiv(playerChunk.x, 32) * 32, Math.floorDiv(playerChunk.z, 32) * 32);
            for (int z = 0; z < 32; ++z) {
                for (int x = 0; x < 32; ++x) {
                    chunks.add(new ChunkPos(start.x + x, start.z + z));
                }
            }
        }
        return chunks;
    }
}

