/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common;

import com.mojang.serialization.DynamicOps;
import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUserShared;
import games.alejandrocoria.mapfrontiers.common.util.StringHelper;
import games.alejandrocoria.mapfrontiers.common.util.UUIDHelper;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import org.apache.commons.lang3.StringUtils;

@ParametersAreNonnullByDefault
public class FrontierData {
    protected UUID id;
    protected final List<BlockPos> vertices = new ArrayList<BlockPos>();
    protected Set<ChunkPos> chunks = new HashSet<ChunkPos>();
    protected Mode mode = Mode.Vertex;
    protected String name1 = "New";
    protected String name2 = "Frontier";
    protected VisibilityData visibilityData;
    protected int color = -1;
    protected ResourceKey<Level> dimension;
    protected SettingsUser owner = new SettingsUser();
    protected BannerData banner;
    protected boolean personal = false;
    protected List<SettingsUserShared> usersShared;
    protected Date created;
    protected Date modified;
    protected Set<Change> changes = EnumSet.noneOf(Change.class);

    public FrontierData() {
        this.id = new UUID(0L, 0L);
        this.visibilityData = new VisibilityData();
    }

    public FrontierData(FrontierData other) {
        this.id = other.id;
        this.dimension = other.dimension;
        this.owner = other.owner;
        this.personal = other.personal;
        this.visibilityData = new VisibilityData(other.visibilityData);
        this.color = other.color;
        this.name1 = other.name1;
        this.name2 = other.name2;
        this.banner = other.banner;
        this.usersShared = other.usersShared;
        this.vertices.clear();
        this.vertices.addAll(other.vertices);
        this.chunks.clear();
        this.chunks.addAll(other.chunks);
        this.mode = other.mode;
        this.created = other.created;
        this.modified = other.modified;
        this.changes = EnumSet.noneOf(Change.class);
    }

    public void updateFromData(FrontierData other) {
        if (other == this) {
            this.changes = EnumSet.noneOf(Change.class);
            return;
        }
        this.id = other.id;
        this.dimension = other.dimension;
        this.owner = other.owner;
        this.personal = other.personal;
        if (other.changes.contains((Object)Change.Visibility)) {
            this.visibilityData = other.visibilityData;
        }
        if (other.changes.contains((Object)Change.Color)) {
            this.color = other.color;
        }
        if (other.changes.contains((Object)Change.Name)) {
            this.name1 = other.name1;
            this.name2 = other.name2;
        }
        if (other.changes.contains((Object)Change.Banner)) {
            this.banner = other.banner;
        }
        if (other.changes.contains((Object)Change.Shared)) {
            this.usersShared = other.usersShared;
        }
        if (other.changes.contains((Object)Change.Vertices)) {
            this.vertices.clear();
            this.vertices.addAll(other.vertices);
            this.chunks.clear();
            this.chunks.addAll(other.chunks);
            this.mode = other.mode;
        }
        this.modified = other.modified;
        this.changes = EnumSet.noneOf(Change.class);
    }

    public void setOwner(SettingsUser owner) {
        this.owner = owner;
    }

    public void ensureOwner(MinecraftServer server) {
        if (this.owner.isEmpty()) {
            List playerList;
            if (!server.isDedicatedServer() && !(playerList = server.getPlayerList().getPlayers()).isEmpty()) {
                this.owner = new SettingsUser((Player)playerList.getFirst());
            }
        } else {
            this.owner.fillMissingInfo(false, server);
        }
    }

    public SettingsUser getOwner() {
        return this.owner;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public UUID getId() {
        return this.id;
    }

    public int getVertexCount() {
        return this.vertices.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addVertex(BlockPos pos, int index) {
        List<BlockPos> list = this.vertices;
        synchronized (list) {
            this.vertices.add(index, pos.atY(70));
        }
        this.changes.add(Change.Vertices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVertex(BlockPos pos) {
        List<BlockPos> list = this.vertices;
        synchronized (list) {
            this.addVertex(pos, this.vertices.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVertex(int index) {
        if (index < 0 || index >= this.vertices.size()) {
            return;
        }
        List<BlockPos> list = this.vertices;
        synchronized (list) {
            this.vertices.remove(index);
        }
        this.changes.add(Change.Vertices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveVertex(BlockPos pos, int index) {
        if (index < 0 || index >= this.vertices.size()) {
            return;
        }
        List<BlockPos> list = this.vertices;
        synchronized (list) {
            this.vertices.set(index, pos);
        }
        this.changes.add(Change.Vertices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveAllVertices(BlockPos delta) {
        List<BlockPos> list = this.vertices;
        synchronized (list) {
            this.vertices.replaceAll(blockPos -> blockPos.offset((Vec3i)delta));
        }
        this.changes.add(Change.Vertices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toggleChunk(ChunkPos chunk) {
        boolean added = false;
        Set<ChunkPos> set = this.chunks;
        synchronized (set) {
            if (!this.chunks.remove(chunk)) {
                this.chunks.add(chunk);
                added = true;
            }
        }
        this.changes.add(Change.Vertices);
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addChunk(ChunkPos chunk) {
        Set<ChunkPos> set = this.chunks;
        synchronized (set) {
            if (this.chunks.add(chunk)) {
                this.changes.add(Change.Vertices);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeChunk(ChunkPos chunk) {
        Set<ChunkPos> set = this.chunks;
        synchronized (set) {
            if (this.chunks.remove(chunk)) {
                this.changes.add(Change.Vertices);
                return true;
            }
        }
        return false;
    }

    public int getChunkCount() {
        return this.chunks.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveAllChunks(ChunkPos delta) {
        Set<ChunkPos> set = this.chunks;
        synchronized (set) {
            this.chunks = this.chunks.stream().map(chunk -> new ChunkPos(chunk.x + delta.x, chunk.z + delta.z)).collect(Collectors.toSet());
        }
        this.changes.add(Change.Vertices);
    }

    public void setMode(Mode mode) {
        this.mode = mode;
        this.changes.add(Change.Vertices);
    }

    public Mode getMode() {
        return this.mode;
    }

    public boolean isEmpty() {
        if (this.mode == Mode.Vertex) {
            return this.vertices.isEmpty();
        }
        return this.chunks.isEmpty();
    }

    public void setName1(String name) {
        this.name1 = name;
        this.changes.add(Change.Name);
    }

    public String getName1() {
        return this.name1;
    }

    public void setName2(String name) {
        this.name2 = name;
        this.changes.add(Change.Name);
    }

    public String getName2() {
        return this.name2;
    }

    public boolean isNamed() {
        return !StringUtils.isBlank((CharSequence)this.name1) || !StringUtils.isBlank((CharSequence)this.name2);
    }

    public void setVisibility(VisibilityData.Visibility visibility, boolean enable) {
        this.visibilityData.setValue(visibility, enable);
        this.changes.add(Change.Visibility);
    }

    public void toggleVisibility(VisibilityData.Visibility visibility) {
        this.visibilityData.setValue(visibility, !this.visibilityData.getValue(visibility));
        this.changes.add(Change.Visibility);
    }

    public boolean getVisibility(VisibilityData.Visibility visibility) {
        return this.visibilityData.getValue(visibility);
    }

    public void setVisibilityData(VisibilityData visibilityData) {
        this.visibilityData = visibilityData;
        this.changes.add(Change.Visibility);
    }

    public VisibilityData getVisibilityData() {
        return this.visibilityData;
    }

    public void setColor(int color) {
        this.color = color;
        this.changes.add(Change.Color);
    }

    public int getColor() {
        return this.color;
    }

    public void setDimension(ResourceKey<Level> dimension) {
        this.dimension = dimension;
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public void setBanner(@Nullable ItemStack itemBanner) {
        this.changes.add(Change.Banner);
        this.banner = itemBanner == null ? null : new BannerData(itemBanner);
    }

    public void setBanner(DyeColor base, BannerPatternLayers bannerPatterns) {
        this.banner = new BannerData(base, bannerPatterns);
        this.changes.add(Change.Banner);
    }

    public boolean hasBanner() {
        return this.banner != null;
    }

    public void setBannerData(@Nullable BannerData bannerData) {
        this.banner = bannerData;
    }

    public BannerData getbannerData() {
        return this.banner;
    }

    public void setPersonal(boolean personal) {
        this.personal = personal;
    }

    public boolean getPersonal() {
        return this.personal;
    }

    public void addUserShared(SettingsUserShared userShared) {
        if (this.usersShared == null) {
            this.usersShared = new ArrayList<SettingsUserShared>();
        }
        this.usersShared.add(userShared);
        this.changes.add(Change.Shared);
    }

    public void removeUserShared(int index) {
        if (this.usersShared == null) {
            return;
        }
        this.usersShared.remove(index);
        if (this.usersShared.isEmpty()) {
            this.usersShared = null;
        }
        this.changes.add(Change.Shared);
    }

    public void removeUserShared(SettingsUser user) {
        if (this.usersShared == null) {
            return;
        }
        this.usersShared.removeIf(x -> x.getUser().equals(user));
        this.changes.add(Change.Shared);
    }

    public void removeAllUserShared() {
        if (this.usersShared == null) {
            return;
        }
        this.usersShared = null;
        this.changes.add(Change.Shared);
    }

    public void setUsersShared(List<SettingsUserShared> usersShared) {
        this.usersShared = usersShared;
        this.changes.add(Change.Shared);
    }

    public void removePendingUsersShared() {
        if (this.usersShared == null) {
            return;
        }
        this.usersShared.removeIf(SettingsUserShared::isPending);
        this.changes.add(Change.Shared);
    }

    public List<SettingsUserShared> getUsersShared() {
        return this.usersShared;
    }

    public SettingsUserShared getUserShared(SettingsUser user) {
        if (this.usersShared == null) {
            return null;
        }
        for (SettingsUserShared u : this.usersShared) {
            if (!u.getUser().equals(user)) continue;
            return u;
        }
        return null;
    }

    public boolean hasUserShared(SettingsUser user) {
        return this.getUserShared(user) != null;
    }

    public boolean checkActionUserShared(SettingsUser user, SettingsUserShared.Action action) {
        if (user.equals(this.owner)) {
            return true;
        }
        if (this.usersShared == null) {
            return false;
        }
        SettingsUserShared userShared = this.getUserShared(user);
        if (userShared == null) {
            return false;
        }
        return userShared.hasAction(action);
    }

    public void setCreated(Date created) {
        this.created = created;
        this.modified = created;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public Date getModified() {
        return this.modified;
    }

    public void addChange(Change change) {
        this.changes.add(change);
    }

    public void removeChange(Change change) {
        this.changes.remove((Object)change);
    }

    public void removeChanges() {
        this.changes.clear();
    }

    public boolean hasChange(Change change) {
        return this.changes.contains((Object)change);
    }

    public Set<Change> getChanges() {
        return EnumSet.copyOf(this.changes);
    }

    public void readFromNBT(CompoundTag nbt, int version) {
        int i;
        ListTag usersSharedTagList;
        this.id = UUID.fromString(nbt.getString("id"));
        this.color = nbt.getInt("color");
        this.dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)nbt.getString("dimension")));
        this.name1 = nbt.getString("name1");
        this.name2 = nbt.getString("name2");
        this.visibilityData.readFromNBT(nbt, version);
        this.personal = nbt.getBoolean("personal");
        this.owner = new SettingsUser();
        this.owner.readFromNBT(nbt.getCompound("owner"));
        if (nbt.contains("banner")) {
            this.banner = new BannerData();
            this.banner.readFromNBT(nbt.getCompound("banner"));
        }
        if (this.personal && !(usersSharedTagList = nbt.getList("usersShared", 10)).isEmpty()) {
            this.usersShared = new ArrayList<SettingsUserShared>();
            for (i = 0; i < usersSharedTagList.size(); ++i) {
                SettingsUserShared userShared = new SettingsUserShared();
                userShared.readFromNBT(usersSharedTagList.getCompound(i));
                this.usersShared.add(userShared);
            }
        }
        ListTag verticesTagList = nbt.getList("vertices", 10);
        for (i = 0; i < verticesTagList.size(); ++i) {
            CompoundTag posTag = verticesTagList.getCompound(i);
            this.vertices.add(new BlockPos(posTag.getInt("X"), 70, posTag.getInt("Z")));
        }
        ListTag chunksTagList = nbt.getList("chunks", 10);
        for (int i2 = 0; i2 < chunksTagList.size(); ++i2) {
            this.chunks.add(new ChunkPos(chunksTagList.getCompound(i2).getInt("X"), chunksTagList.getCompound(i2).getInt("Z")));
        }
        String modeTag = nbt.getString("mode");
        if (modeTag.isEmpty()) {
            this.mode = Mode.Vertex;
        } else {
            try {
                this.mode = Mode.valueOf(modeTag);
            }
            catch (IllegalArgumentException e) {
                this.mode = this.chunks.size() > 0 ? Mode.Chunk : Mode.Vertex;
                String availableModes = StringHelper.enumValuesToString(Arrays.asList(Mode.values()));
                MapFrontiers.LOGGER.warn(String.format("Unknown mode in frontier %1$s. Found: \"%2$s\". Expected: %3$s", this.id, modeTag, availableModes));
            }
        }
        if (nbt.contains("created")) {
            this.created = new Date(nbt.getLong("created"));
        }
        if (nbt.contains("modified")) {
            this.modified = new Date(nbt.getLong("modified"));
        }
    }

    public void writeToNBT(CompoundTag nbt) {
        nbt.putString("id", this.id.toString());
        nbt.putInt("color", this.color);
        nbt.putString("dimension", this.dimension.location().toString());
        nbt.putString("name1", this.name1);
        nbt.putString("name2", this.name2);
        this.visibilityData.writeToNBT(nbt);
        nbt.putBoolean("personal", this.personal);
        CompoundTag nbtOwner = new CompoundTag();
        this.owner.writeToNBT(nbtOwner);
        nbt.put("owner", (Tag)nbtOwner);
        if (this.banner != null) {
            CompoundTag nbtBanner = new CompoundTag();
            this.banner.writeToNBT(nbtBanner);
            nbt.put("banner", (Tag)nbtBanner);
        }
        if (this.personal && this.usersShared != null) {
            ListTag usersSharedTagList = new ListTag();
            for (SettingsUserShared userShared : this.usersShared) {
                CompoundTag nbtUserShared = new CompoundTag();
                userShared.writeToNBT(nbtUserShared);
                usersSharedTagList.add((Object)nbtUserShared);
            }
            nbt.put("usersShared", (Tag)usersSharedTagList);
        }
        ListTag verticesTagList = new ListTag();
        for (BlockPos pos : this.vertices) {
            CompoundTag compoundtag = new CompoundTag();
            compoundtag.putInt("X", pos.getX());
            compoundtag.putInt("Y", pos.getY());
            compoundtag.putInt("Z", pos.getZ());
            verticesTagList.add((Object)compoundtag);
        }
        nbt.put("vertices", (Tag)verticesTagList);
        ListTag chunksTagList = new ListTag();
        for (ChunkPos pos : this.chunks) {
            CompoundTag compoundtag = new CompoundTag();
            compoundtag.putInt("X", pos.x);
            compoundtag.putInt("Z", pos.z);
            chunksTagList.add((Object)compoundtag);
        }
        nbt.put("chunks", (Tag)chunksTagList);
        nbt.putString("mode", this.mode.name());
        if (this.created != null) {
            nbt.putLong("created", this.created.getTime());
        }
        if (this.modified != null) {
            nbt.putLong("modified", this.modified.getTime());
        }
    }

    public void fromBytes(FriendlyByteBuf buf) {
        int i;
        this.changes.clear();
        for (Change change : Change.valuesArray) {
            if (!buf.readBoolean()) continue;
            this.changes.add(change);
        }
        this.id = UUIDHelper.fromBytes((ByteBuf)buf);
        this.dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)buf.readResourceLocation());
        this.personal = buf.readBoolean();
        this.owner = new SettingsUser();
        this.owner.fromBytes(buf);
        if (this.changes.contains((Object)Change.Visibility)) {
            this.visibilityData.fromBytes(buf);
        }
        if (this.changes.contains((Object)Change.Color)) {
            this.color = buf.readInt();
        }
        if (this.changes.contains((Object)Change.Name)) {
            int maxCharacters = 17;
            int maxBytes = maxCharacters * 4;
            this.name1 = buf.readUtf(maxBytes);
            this.name2 = buf.readUtf(maxBytes);
            if (this.name1.length() > maxCharacters) {
                this.name1 = this.name1.substring(0, maxCharacters);
            }
            if (this.name2.length() > maxCharacters) {
                this.name2 = this.name2.substring(0, maxCharacters);
            }
        }
        if (this.changes.contains((Object)Change.Banner)) {
            if (buf.readBoolean()) {
                this.banner = new BannerData();
                this.banner.fromBytes(buf);
            } else {
                this.banner = null;
            }
        }
        if (this.changes.contains((Object)Change.Shared)) {
            if (buf.readBoolean()) {
                this.usersShared = new ArrayList<SettingsUserShared>();
                int usersCount = buf.readInt();
                for (i = 0; i < usersCount; ++i) {
                    SettingsUserShared userShared = new SettingsUserShared();
                    userShared.fromBytes(buf);
                    this.usersShared.add(userShared);
                }
            } else {
                this.usersShared = null;
            }
        }
        if (this.changes.contains((Object)Change.Vertices)) {
            this.vertices.clear();
            int vertexCount = buf.readInt();
            for (i = 0; i < vertexCount; ++i) {
                BlockPos vertex = BlockPos.of((long)buf.readLong());
                this.vertices.add(vertex);
            }
            this.chunks.clear();
            int chunkCount = buf.readInt();
            for (int i2 = 0; i2 < chunkCount; ++i2) {
                ChunkPos chunk = new ChunkPos(buf.readLong());
                this.chunks.add(chunk);
            }
            this.mode = Mode.values()[buf.readInt()];
        }
        this.created = buf.readBoolean() ? new Date(buf.readLong()) : null;
        this.modified = buf.readBoolean() ? new Date(buf.readLong()) : null;
    }

    public void toBytes(FriendlyByteBuf buf) {
        this.toBytes(buf, true);
    }

    public void toBytes(FriendlyByteBuf buf, boolean onlyChanges) {
        this.toBytes(buf, onlyChanges ? this.changes : null);
    }

    public void toBytes(FriendlyByteBuf buf, @Nullable Set<Change> withChanges) {
        for (Change change : Change.valuesArray) {
            if (withChanges != null) {
                buf.writeBoolean(withChanges.contains((Object)change));
                continue;
            }
            buf.writeBoolean(true);
        }
        UUIDHelper.toBytes((ByteBuf)buf, this.id);
        buf.writeResourceLocation(this.dimension.location());
        buf.writeBoolean(this.personal);
        this.owner.toBytes(buf);
        if (withChanges == null || withChanges.contains((Object)Change.Visibility)) {
            this.visibilityData.toBytes(buf);
        }
        if (withChanges == null || withChanges.contains((Object)Change.Color)) {
            buf.writeInt(this.color);
        }
        if (withChanges == null || withChanges.contains((Object)Change.Name)) {
            int maxCharacters = 17;
            int maxBytes = maxCharacters * 4;
            buf.writeUtf(this.name1, maxBytes);
            buf.writeUtf(this.name2, maxBytes);
        }
        if (withChanges == null || withChanges.contains((Object)Change.Banner)) {
            if (this.banner == null) {
                buf.writeBoolean(false);
            } else {
                buf.writeBoolean(true);
                this.banner.toBytes(buf);
            }
        }
        if (withChanges == null || withChanges.contains((Object)Change.Shared)) {
            if (this.personal && this.usersShared != null) {
                buf.writeBoolean(true);
                buf.writeInt(this.usersShared.size());
                for (SettingsUserShared userShared : this.usersShared) {
                    userShared.toBytes(buf);
                }
            } else {
                buf.writeBoolean(false);
            }
        }
        if (withChanges == null || withChanges.contains((Object)Change.Vertices)) {
            buf.writeInt(this.vertices.size());
            for (BlockPos pos : this.vertices) {
                buf.writeLong(pos.asLong());
            }
            buf.writeInt(this.chunks.size());
            for (ChunkPos pos : this.chunks) {
                buf.writeLong(pos.toLong());
            }
            buf.writeInt(this.mode.ordinal());
        }
        if (this.created == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeLong(this.created.getTime());
        }
        if (this.modified == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeLong(this.modified.getTime());
        }
    }

    public static enum Mode {
        Vertex,
        Chunk;

    }

    public static enum Change {
        Name,
        Vertices,
        Banner,
        Shared,
        Visibility,
        Color;

        public static final Change[] valuesArray;

        static {
            valuesArray = Change.values();
        }
    }

    public static class VisibilityData {
        private final EnumSet<Visibility> values;

        public VisibilityData() {
            this.values = EnumSet.of(Visibility.Frontier, new Visibility[]{Visibility.Fullscreen, Visibility.FullscreenName, Visibility.FullscreenDay, Visibility.FullscreenNight, Visibility.FullscreenUnderground, Visibility.FullscreenTopo, Visibility.FullscreenBiome, Visibility.Minimap, Visibility.MinimapName, Visibility.MinimapDay, Visibility.MinimapNight, Visibility.MinimapUnderground, Visibility.MinimapTopo, Visibility.MinimapBiome, Visibility.Webmap, Visibility.WebmapName, Visibility.WebmapDay, Visibility.WebmapNight, Visibility.WebmapUnderground, Visibility.WebmapTopo, Visibility.WebmapBiome});
        }

        public VisibilityData(boolean setAll) {
            this.values = setAll ? EnumSet.allOf(Visibility.class) : EnumSet.noneOf(Visibility.class);
        }

        public VisibilityData(VisibilityData other) {
            this.values = other.values.clone();
        }

        public int getHash() {
            return this.values.hashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof VisibilityData) {
                VisibilityData otherVisibility = (VisibilityData)other;
                return this.values.equals(otherVisibility.values);
            }
            return false;
        }

        public void setValue(Visibility value, boolean set) {
            if (set) {
                this.values.add(value);
            } else {
                this.values.remove((Object)value);
            }
        }

        public boolean getValue(Visibility value) {
            return this.values.contains((Object)value);
        }

        public boolean hasSome() {
            return !this.values.isEmpty();
        }

        public void readFromNBT(CompoundTag nbt, int version) {
            boolean splitVisibility = version >= 10;
            this.setValue(Visibility.Frontier, nbt.getBoolean("visible"));
            if (splitVisibility) {
                this.setValue(Visibility.Fullscreen, nbt.getBoolean("fullscreenVisible"));
                this.setValue(Visibility.FullscreenName, nbt.getBoolean("fullscreenNameVisible"));
                this.setValue(Visibility.FullscreenOwner, nbt.getBoolean("fullscreenOwnerVisible"));
                this.setValue(Visibility.FullscreenBanner, nbt.getBoolean("fullscreenBannerVisible"));
                this.setValue(Visibility.FullscreenDay, nbt.contains("fullscreenDay") ? nbt.getBoolean("fullscreenDay") : true);
                this.setValue(Visibility.FullscreenNight, nbt.contains("fullscreenNight") ? nbt.getBoolean("fullscreenNight") : true);
                this.setValue(Visibility.FullscreenUnderground, nbt.contains("fullscreenUnderground") ? nbt.getBoolean("fullscreenUnderground") : true);
                this.setValue(Visibility.FullscreenTopo, nbt.contains("fullscreenTopo") ? nbt.getBoolean("fullscreenTopo") : true);
                this.setValue(Visibility.FullscreenBiome, nbt.contains("fullscreenBiome") ? nbt.getBoolean("fullscreenBiome") : true);
                this.setValue(Visibility.Minimap, nbt.getBoolean("minimapVisible"));
                this.setValue(Visibility.MinimapName, nbt.getBoolean("minimapNameVisible"));
                this.setValue(Visibility.MinimapOwner, nbt.getBoolean("minimapOwnerVisible"));
                this.setValue(Visibility.MinimapBanner, nbt.getBoolean("minimapBannerVisible"));
                this.setValue(Visibility.MinimapDay, nbt.contains("minimapDay") ? nbt.getBoolean("minimapDay") : true);
                this.setValue(Visibility.MinimapNight, nbt.contains("minimapNight") ? nbt.getBoolean("minimapNight") : true);
                this.setValue(Visibility.MinimapUnderground, nbt.contains("minimapUnderground") ? nbt.getBoolean("minimapUnderground") : true);
                this.setValue(Visibility.MinimapTopo, nbt.contains("minimapTopo") ? nbt.getBoolean("minimapTopo") : true);
                this.setValue(Visibility.MinimapBiome, nbt.contains("minimapBiome") ? nbt.getBoolean("minimapBiome") : true);
                this.setValue(Visibility.Webmap, nbt.contains("webmapVisible") ? nbt.getBoolean("webmapVisible") : this.getValue(Visibility.Minimap));
                this.setValue(Visibility.WebmapName, nbt.contains("webmapNameVisible") ? nbt.getBoolean("webmapNameVisible") : this.getValue(Visibility.MinimapName));
                this.setValue(Visibility.WebmapOwner, nbt.contains("webmapOwnerVisible") ? nbt.getBoolean("webmapOwnerVisible") : this.getValue(Visibility.MinimapOwner));
                this.setValue(Visibility.WebmapBanner, nbt.contains("webmapBannerVisible") ? nbt.getBoolean("webmapBannerVisible") : this.getValue(Visibility.MinimapBanner));
                this.setValue(Visibility.WebmapDay, nbt.contains("webmapDay") ? nbt.getBoolean("webmapDay") : this.getValue(Visibility.MinimapDay));
                this.setValue(Visibility.WebmapNight, nbt.contains("webmapNight") ? nbt.getBoolean("webmapNight") : this.getValue(Visibility.MinimapNight));
                this.setValue(Visibility.WebmapUnderground, nbt.contains("webmapUnderground") ? nbt.getBoolean("webmapUnderground") : this.getValue(Visibility.MinimapUnderground));
                this.setValue(Visibility.WebmapTopo, nbt.contains("webmapTopo") ? nbt.getBoolean("webmapTopo") : this.getValue(Visibility.MinimapTopo));
                this.setValue(Visibility.WebmapBiome, nbt.contains("webmapBiome") ? nbt.getBoolean("webmapBiome") : this.getValue(Visibility.MinimapBiome));
            } else {
                this.setValue(Visibility.Fullscreen, nbt.getBoolean("visible"));
                this.setValue(Visibility.FullscreenName, nbt.getBoolean("visible"));
                this.setValue(Visibility.FullscreenOwner, nbt.getBoolean("nameVisible"));
                this.setValue(Visibility.FullscreenBanner, false);
                this.setValue(Visibility.FullscreenDay, nbt.getBoolean("visible"));
                this.setValue(Visibility.FullscreenNight, nbt.getBoolean("visible"));
                this.setValue(Visibility.FullscreenUnderground, nbt.getBoolean("visible"));
                this.setValue(Visibility.FullscreenTopo, nbt.getBoolean("visible"));
                this.setValue(Visibility.FullscreenBiome, nbt.getBoolean("visible"));
                this.setValue(Visibility.Minimap, nbt.getBoolean("visible"));
                this.setValue(Visibility.MinimapName, nbt.getBoolean("nameVisible"));
                this.setValue(Visibility.MinimapOwner, nbt.getBoolean("ownerVisible"));
                this.setValue(Visibility.MinimapBanner, false);
                this.setValue(Visibility.MinimapDay, nbt.getBoolean("visible"));
                this.setValue(Visibility.MinimapNight, nbt.getBoolean("visible"));
                this.setValue(Visibility.MinimapUnderground, nbt.getBoolean("visible"));
                this.setValue(Visibility.MinimapTopo, nbt.getBoolean("visible"));
                this.setValue(Visibility.MinimapBiome, nbt.getBoolean("visible"));
                this.setValue(Visibility.Webmap, nbt.getBoolean("visible"));
                this.setValue(Visibility.WebmapName, nbt.getBoolean("nameVisible"));
                this.setValue(Visibility.WebmapOwner, nbt.getBoolean("ownerVisible"));
                this.setValue(Visibility.WebmapBanner, false);
                this.setValue(Visibility.WebmapDay, nbt.getBoolean("visible"));
                this.setValue(Visibility.WebmapNight, nbt.getBoolean("visible"));
                this.setValue(Visibility.WebmapUnderground, nbt.getBoolean("visible"));
                this.setValue(Visibility.WebmapTopo, nbt.getBoolean("visible"));
                this.setValue(Visibility.WebmapBiome, nbt.getBoolean("visible"));
            }
            if (nbt.contains("announceInChat")) {
                this.setValue(Visibility.AnnounceInChat, nbt.getBoolean("announceInChat"));
            }
            if (nbt.contains("announceInTitle")) {
                this.setValue(Visibility.AnnounceInTitle, nbt.getBoolean("announceInTitle"));
            }
        }

        public void writeToNBT(CompoundTag nbt) {
            nbt.putBoolean("visible", this.getValue(Visibility.Frontier));
            nbt.putBoolean("announceInChat", this.getValue(Visibility.AnnounceInChat));
            nbt.putBoolean("announceInTitle", this.getValue(Visibility.AnnounceInTitle));
            nbt.putBoolean("fullscreenVisible", this.getValue(Visibility.Fullscreen));
            nbt.putBoolean("fullscreenNameVisible", this.getValue(Visibility.FullscreenName));
            nbt.putBoolean("fullscreenOwnerVisible", this.getValue(Visibility.FullscreenOwner));
            nbt.putBoolean("fullscreenBannerVisible", this.getValue(Visibility.FullscreenBanner));
            nbt.putBoolean("fullscreenDay", this.getValue(Visibility.FullscreenDay));
            nbt.putBoolean("fullscreenNight", this.getValue(Visibility.FullscreenNight));
            nbt.putBoolean("fullscreenUnderground", this.getValue(Visibility.FullscreenUnderground));
            nbt.putBoolean("fullscreenTopo", this.getValue(Visibility.FullscreenTopo));
            nbt.putBoolean("fullscreenBiome", this.getValue(Visibility.FullscreenBiome));
            nbt.putBoolean("minimapVisible", this.getValue(Visibility.Minimap));
            nbt.putBoolean("minimapNameVisible", this.getValue(Visibility.MinimapName));
            nbt.putBoolean("minimapOwnerVisible", this.getValue(Visibility.MinimapOwner));
            nbt.putBoolean("minimapBannerVisible", this.getValue(Visibility.MinimapBanner));
            nbt.putBoolean("minimapDay", this.getValue(Visibility.MinimapDay));
            nbt.putBoolean("minimapNight", this.getValue(Visibility.MinimapNight));
            nbt.putBoolean("minimapUnderground", this.getValue(Visibility.MinimapUnderground));
            nbt.putBoolean("minimapTopo", this.getValue(Visibility.MinimapTopo));
            nbt.putBoolean("minimapBiome", this.getValue(Visibility.MinimapBiome));
            nbt.putBoolean("webmapVisible", this.getValue(Visibility.Webmap));
            nbt.putBoolean("webmapNameVisible", this.getValue(Visibility.WebmapName));
            nbt.putBoolean("webmapOwnerVisible", this.getValue(Visibility.WebmapOwner));
            nbt.putBoolean("webmapBannerVisible", this.getValue(Visibility.WebmapBanner));
            nbt.putBoolean("webmapDay", this.getValue(Visibility.WebmapDay));
            nbt.putBoolean("webmapNight", this.getValue(Visibility.WebmapNight));
            nbt.putBoolean("webmapUnderground", this.getValue(Visibility.WebmapUnderground));
            nbt.putBoolean("webmapTopo", this.getValue(Visibility.WebmapTopo));
            nbt.putBoolean("webmapBiome", this.getValue(Visibility.WebmapBiome));
        }

        public void fromBytes(FriendlyByteBuf buf) {
            this.setValue(Visibility.Frontier, buf.readBoolean());
            this.setValue(Visibility.AnnounceInChat, buf.readBoolean());
            this.setValue(Visibility.AnnounceInTitle, buf.readBoolean());
            this.setValue(Visibility.Fullscreen, buf.readBoolean());
            this.setValue(Visibility.FullscreenName, buf.readBoolean());
            this.setValue(Visibility.FullscreenOwner, buf.readBoolean());
            this.setValue(Visibility.FullscreenBanner, buf.readBoolean());
            this.setValue(Visibility.FullscreenDay, buf.readBoolean());
            this.setValue(Visibility.FullscreenNight, buf.readBoolean());
            this.setValue(Visibility.FullscreenUnderground, buf.readBoolean());
            this.setValue(Visibility.FullscreenTopo, buf.readBoolean());
            this.setValue(Visibility.FullscreenBiome, buf.readBoolean());
            this.setValue(Visibility.Minimap, buf.readBoolean());
            this.setValue(Visibility.MinimapName, buf.readBoolean());
            this.setValue(Visibility.MinimapOwner, buf.readBoolean());
            this.setValue(Visibility.MinimapBanner, buf.readBoolean());
            this.setValue(Visibility.MinimapDay, buf.readBoolean());
            this.setValue(Visibility.MinimapNight, buf.readBoolean());
            this.setValue(Visibility.MinimapUnderground, buf.readBoolean());
            this.setValue(Visibility.MinimapTopo, buf.readBoolean());
            this.setValue(Visibility.MinimapBiome, buf.readBoolean());
            this.setValue(Visibility.Webmap, buf.readBoolean());
            this.setValue(Visibility.WebmapName, buf.readBoolean());
            this.setValue(Visibility.WebmapOwner, buf.readBoolean());
            this.setValue(Visibility.WebmapBanner, buf.readBoolean());
            this.setValue(Visibility.WebmapDay, buf.readBoolean());
            this.setValue(Visibility.WebmapNight, buf.readBoolean());
            this.setValue(Visibility.WebmapUnderground, buf.readBoolean());
            this.setValue(Visibility.WebmapTopo, buf.readBoolean());
            this.setValue(Visibility.WebmapBiome, buf.readBoolean());
        }

        public void toBytes(FriendlyByteBuf buf) {
            buf.writeBoolean(this.getValue(Visibility.Frontier));
            buf.writeBoolean(this.getValue(Visibility.AnnounceInChat));
            buf.writeBoolean(this.getValue(Visibility.AnnounceInTitle));
            buf.writeBoolean(this.getValue(Visibility.Fullscreen));
            buf.writeBoolean(this.getValue(Visibility.FullscreenName));
            buf.writeBoolean(this.getValue(Visibility.FullscreenOwner));
            buf.writeBoolean(this.getValue(Visibility.FullscreenBanner));
            buf.writeBoolean(this.getValue(Visibility.FullscreenDay));
            buf.writeBoolean(this.getValue(Visibility.FullscreenNight));
            buf.writeBoolean(this.getValue(Visibility.FullscreenUnderground));
            buf.writeBoolean(this.getValue(Visibility.FullscreenTopo));
            buf.writeBoolean(this.getValue(Visibility.FullscreenBiome));
            buf.writeBoolean(this.getValue(Visibility.Minimap));
            buf.writeBoolean(this.getValue(Visibility.MinimapName));
            buf.writeBoolean(this.getValue(Visibility.MinimapOwner));
            buf.writeBoolean(this.getValue(Visibility.MinimapBanner));
            buf.writeBoolean(this.getValue(Visibility.MinimapDay));
            buf.writeBoolean(this.getValue(Visibility.MinimapNight));
            buf.writeBoolean(this.getValue(Visibility.MinimapUnderground));
            buf.writeBoolean(this.getValue(Visibility.MinimapTopo));
            buf.writeBoolean(this.getValue(Visibility.MinimapBiome));
            buf.writeBoolean(this.getValue(Visibility.Webmap));
            buf.writeBoolean(this.getValue(Visibility.WebmapName));
            buf.writeBoolean(this.getValue(Visibility.WebmapOwner));
            buf.writeBoolean(this.getValue(Visibility.WebmapBanner));
            buf.writeBoolean(this.getValue(Visibility.WebmapDay));
            buf.writeBoolean(this.getValue(Visibility.WebmapNight));
            buf.writeBoolean(this.getValue(Visibility.WebmapUnderground));
            buf.writeBoolean(this.getValue(Visibility.WebmapTopo));
            buf.writeBoolean(this.getValue(Visibility.WebmapBiome));
        }

        public static enum Visibility {
            Frontier,
            AnnounceInChat,
            AnnounceInTitle,
            Fullscreen,
            FullscreenName,
            FullscreenOwner,
            FullscreenBanner,
            FullscreenDay,
            FullscreenNight,
            FullscreenUnderground,
            FullscreenTopo,
            FullscreenBiome,
            Minimap,
            MinimapName,
            MinimapOwner,
            MinimapBanner,
            MinimapDay,
            MinimapNight,
            MinimapUnderground,
            MinimapTopo,
            MinimapBiome,
            Webmap,
            WebmapName,
            WebmapOwner,
            WebmapBanner,
            WebmapDay,
            WebmapNight,
            WebmapUnderground,
            WebmapTopo,
            WebmapBiome;

        }
    }

    public static class BannerData {
        public DyeColor baseColor;
        public ListTag patterns;

        public BannerData() {
            this.baseColor = DyeColor.WHITE;
        }

        public BannerData(ItemStack item) {
            this(BannerData.getDyeColor(item), BannerData.getBannerPatternLayers(item));
        }

        public BannerData(DyeColor base, BannerPatternLayers bannerPatterns) {
            this.baseColor = base;
            ClientLevel level = Minecraft.getInstance().level;
            Optional patternsOptional = BannerPatternLayers.CODEC.encodeStart((DynamicOps)level.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)bannerPatterns).result();
            patternsOptional.ifPresent(tag -> {
                if (tag.getType().equals((Object)ListTag.TYPE)) {
                    this.patterns = (ListTag)tag.copy();
                }
            });
        }

        private static DyeColor getDyeColor(ItemStack item) {
            Item item2 = item.getItem();
            if (item2 instanceof BannerItem) {
                BannerItem itemBanner = (BannerItem)item2;
                return itemBanner.getColor();
            }
            return DyeColor.BLACK;
        }

        private static BannerPatternLayers getBannerPatternLayers(ItemStack item) {
            if (item.getComponents().has(DataComponents.BANNER_PATTERNS)) {
                return (BannerPatternLayers)item.getComponents().get(DataComponents.BANNER_PATTERNS);
            }
            return BannerPatternLayers.EMPTY;
        }

        public void readFromNBT(CompoundTag nbt) {
            this.baseColor = DyeColor.byId((int)nbt.getInt("Base"));
            this.patterns = nbt.getList("Patterns", 10);
        }

        public void writeToNBT(CompoundTag nbt) {
            nbt.putInt("Base", this.baseColor.getId());
            if (this.patterns != null) {
                nbt.put("Patterns", (Tag)this.patterns);
            }
        }

        public void fromBytes(FriendlyByteBuf buf) {
            this.baseColor = DyeColor.byId((int)buf.readInt());
            CompoundTag nbt = buf.readNbt();
            if (nbt != null) {
                this.patterns = nbt.getList("Patterns", 10);
            }
        }

        public void toBytes(FriendlyByteBuf buf) {
            buf.writeInt(this.baseColor.getId());
            if (this.patterns == null) {
                buf.writeNbt(null);
            } else {
                CompoundTag nbt = new CompoundTag();
                nbt.put("Patterns", (Tag)this.patterns);
                buf.writeNbt((Tag)nbt);
            }
        }
    }
}

