/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common.network;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.StringUtils;

@ParametersAreNonnullByDefault
public class PacketPersonalFrontierShared {
    public static final ResourceLocation CHANNEL = ResourceLocation.fromNamespaceAndPath((String)"mapfrontiers", (String)"packet_personal_frontier_shared");
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketPersonalFrontierShared> STREAM_CODEC = StreamCodec.ofMember(PacketPersonalFrontierShared::encode, PacketPersonalFrontierShared::new);
    private int shareMessageID;
    private final SettingsUser playerSharing;
    private final SettingsUser owner;
    private String name1;
    private String name2;

    public PacketPersonalFrontierShared(int shareMessageID, SettingsUser playerSharing, SettingsUser owner, String name1, String name2) {
        this.shareMessageID = shareMessageID;
        this.playerSharing = playerSharing;
        this.owner = owner;
        this.name1 = name1;
        this.name2 = name2;
    }

    public static CustomPacketPayload.Type<CustomPacketPayload> type() {
        return new CustomPacketPayload.Type(CHANNEL);
    }

    public PacketPersonalFrontierShared(FriendlyByteBuf buf) {
        this.playerSharing = new SettingsUser();
        this.owner = new SettingsUser();
        try {
            if (buf.readableBytes() > 1) {
                this.shareMessageID = buf.readInt();
                this.playerSharing.fromBytes(buf);
                this.owner.fromBytes(buf);
                this.name1 = buf.readUtf(17);
                this.name2 = buf.readUtf(17);
            }
        }
        catch (Throwable t) {
            MapFrontiers.LOGGER.error(String.format("Failed to read message for PacketPersonalFrontierShared: %s", t));
        }
    }

    public void encode(FriendlyByteBuf buf) {
        try {
            buf.writeInt(this.shareMessageID);
            this.playerSharing.toBytes(buf);
            this.owner.toBytes(buf);
            buf.writeUtf(this.name1);
            buf.writeUtf(this.name2);
        }
        catch (Throwable t) {
            MapFrontiers.LOGGER.error(String.format("Failed to write message for PacketPersonalFrontierShared: %s", t));
        }
    }

    public static void handle(PacketContext<PacketPersonalFrontierShared> ctx) {
        if (Side.CLIENT.equals((Object)ctx.side())) {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player == null) {
                return;
            }
            PacketPersonalFrontierShared message = (PacketPersonalFrontierShared)ctx.message();
            Object frontierName = message.name1.isEmpty() && message.name2.isEmpty() ? "Unnamed Frontier" : (message.name1.isEmpty() ? message.name2 : (message.name2.isEmpty() ? message.name1 : message.name1 + " " + message.name2));
            MutableComponent button = Component.literal((String)frontierName);
            button.withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)("Click to accept or use command /mfaccept " + message.shareMessageID)))));
            button.withStyle(style -> style.withBold(Boolean.valueOf(true)));
            button.withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/mapfrontiersaccept " + message.shareMessageID)));
            MutableComponent text = Component.literal((String)(PacketPersonalFrontierShared.userToString(message.playerSharing) + " "));
            if (message.playerSharing.equals(message.owner)) {
                text.append("want to share a frontier with you: ");
            } else {
                text.append("want to share a frontier from " + PacketPersonalFrontierShared.userToString(message.owner) + " with you: ");
            }
            text.append((Component)button);
            player.sendSystemMessage((Component)text);
        }
    }

    private static String userToString(SettingsUser user) {
        String string = !StringUtils.isBlank((CharSequence)user.username) ? user.username : (user.uuid != null ? user.uuid.toString() : "User not found");
        return string;
    }
}

