/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common.settings;

import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.common.util.StringHelper;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

@ParametersAreNonnullByDefault
public class SettingsUserShared {
    private final SettingsUser user;
    private Set<Action> actions;
    private boolean pending;

    public SettingsUserShared() {
        this.user = new SettingsUser();
        this.actions = EnumSet.noneOf(Action.class);
        this.pending = false;
    }

    public SettingsUserShared(SettingsUser user, boolean pending) {
        this.user = user;
        this.actions = EnumSet.noneOf(Action.class);
        this.pending = pending;
    }

    public SettingsUser getUser() {
        return this.user;
    }

    public void setActions(Set<Action> actions) {
        this.actions = actions;
    }

    public void addAction(Action action) {
        this.actions.add(action);
    }

    public void removeAction(Action action) {
        this.actions.remove((Object)action);
    }

    public boolean hasAction(Action action) {
        return this.actions.contains((Object)action);
    }

    public Set<Action> getActions() {
        return this.actions;
    }

    public void setPending(boolean pending) {
        this.pending = pending;
    }

    public boolean isPending() {
        return this.pending;
    }

    public void readFromNBT(CompoundTag nbt) {
        this.user.readFromNBT(nbt);
        this.pending = nbt.getBoolean("pending");
        this.actions.clear();
        ListTag actionsTagList = nbt.getList("actions", 8);
        for (int i = 0; i < actionsTagList.size(); ++i) {
            String actionTag = actionsTagList.getString(i);
            try {
                Action action = Action.valueOf(actionTag);
                this.actions.add(action);
                continue;
            }
            catch (IllegalArgumentException e) {
                String userName = this.user.username;
                if (userName.isEmpty()) {
                    userName = this.user.uuid.toString();
                }
                String availableActions = StringHelper.enumValuesToString(Arrays.asList(Action.values()));
                MapFrontiers.LOGGER.warn(String.format("Unknown action in user shared %1$s. Found: \"%2$s\". Expected: %3$s", userName, actionTag, availableActions));
            }
        }
    }

    public void writeToNBT(CompoundTag nbt) {
        this.user.writeToNBT(nbt);
        if (this.pending) {
            nbt.putBoolean("pending", true);
        }
        ListTag actionsTagList = new ListTag();
        for (Action action : this.actions) {
            StringTag actionTag = StringTag.valueOf((String)action.name());
            actionsTagList.add((Object)actionTag);
        }
        nbt.put("actions", (Tag)actionsTagList);
    }

    public void fromBytes(FriendlyByteBuf buf) {
        this.user.fromBytes(buf);
        this.pending = buf.readBoolean();
        this.actions.clear();
        for (Action action : Action.valuesArray) {
            if (!buf.readBoolean()) continue;
            this.actions.add(action);
        }
    }

    public void toBytes(FriendlyByteBuf buf) {
        this.user.toBytes(buf);
        buf.writeBoolean(this.pending);
        for (Action action : Action.valuesArray) {
            buf.writeBoolean(this.actions.contains((Object)action));
        }
    }

    public int hashCode() {
        int prime = 31;
        int hash = 1;
        hash = prime * hash + this.user.hashCode();
        hash = prime * hash + this.actions.hashCode();
        hash = prime * hash + (this.pending ? 1231 : 1237);
        return hash;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof SettingsUserShared) {
            SettingsUserShared otherUser = (SettingsUserShared)other;
            return this.user.equals(otherUser.user) && this.pending == otherUser.pending;
        }
        return false;
    }

    public static enum Action {
        UpdateFrontier,
        UpdateSettings;

        public static final Action[] valuesArray;

        static {
            valuesArray = Action.values();
        }
    }
}

