/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.brigadier.CommandDispatcher;
import games.alejandrocoria.mapfrontiers.MapFrontiersNeoForge;
import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.client.command.ClientCommandAccept;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.common.Config;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RenderFrameEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.common.NeoForge;

@ParametersAreNonnullByDefault
public class MapFrontiersClientNeoForge
extends MapFrontiersClient {
    public static void clientSetup(FMLClientSetupEvent event, IEventBus eventBus) {
        MapFrontiersClientNeoForge.init();
        NeoForge.EVENT_BUS.addListener(MapFrontiersClientNeoForge::livingUpdateEvent);
        NeoForge.EVENT_BUS.addListener(MapFrontiersClientNeoForge::onRenderTick);
        NeoForge.EVENT_BUS.addListener(MapFrontiersClientNeoForge::RenderGameOverlayEvent);
        NeoForge.EVENT_BUS.addListener(MapFrontiersClientNeoForge::clientConnectedToServer);
        NeoForge.EVENT_BUS.addListener(MapFrontiersClientNeoForge::clientDisconnectionFromServer);
        NeoForge.EVENT_BUS.addListener(MapFrontiersClientNeoForge::mouseEvent);
        NeoForge.EVENT_BUS.addListener(MapFrontiersClientNeoForge::onRegisterClientCommands);
        MapFrontiersNeoForge.LOGGER.info("NeoForge clientSetup done");
    }

    public static void livingUpdateEvent(ClientTickEvent.Post event) {
        Minecraft client = Minecraft.getInstance();
        if (client.level != null) {
            LocalPlayer player = client.player;
            ClientEventHandler.postPlayerTickEvent(client, (Player)player);
        }
    }

    public static void onRenderTick(RenderFrameEvent.Post event) {
        ClientEventHandler.postClientTickEvent(Minecraft.getInstance());
    }

    public static void RenderGameOverlayEvent(RenderGuiLayerEvent.Pre event) {
        if (VanillaGuiLayers.EFFECTS.equals((Object)event.getName())) {
            ClientEventHandler.postHudRenderEvent(event.getGuiGraphics(), event.getPartialTick());
        }
    }

    public static void clientConnectedToServer(ClientPlayerNetworkEvent.LoggingIn event) {
        ClientEventHandler.postClientConnectedEvent();
    }

    public static void clientDisconnectionFromServer(ClientPlayerNetworkEvent.LoggingOut event) {
        ClientEventHandler.postClientDisconnectedEvent();
    }

    public static void mouseEvent(InputEvent.MouseButton.Post event) {
        if (event.getAction() == 0) {
            ClientEventHandler.postMouseReleaseEvent(event.getButton());
        }
    }

    @SubscribeEvent
    public static void onRegisterClientCommands(RegisterClientCommandsEvent event) {
        ClientCommandAccept.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @EventBusSubscriber(modid="mapfrontiers", bus=EventBusSubscriber.Bus.MOD)
    public static class ConfigEventHandler {
        @SubscribeEvent
        public static void onModConfigEvent(ModConfigEvent.Loading configEvent) {
            if (configEvent.getConfig().getModId().equals("mapfrontiers") && configEvent.getConfig().getType() == ModConfig.Type.CLIENT) {
                Config.bakeConfig();
            }
        }
    }

    @EventBusSubscriber(value={Dist.CLIENT}, modid="mapfrontiers", bus=EventBusSubscriber.Bus.MOD)
    public static class KeyMappingsEventHandler {
        @SubscribeEvent
        public static void registerKeyMappingsEvent(RegisterKeyMappingsEvent event) {
            MapFrontiersClient.openSettingsKey = new KeyMapping("mapfrontiers.key.open_settings", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 297, "mapfrontiers.key.category");
            event.register(MapFrontiersClient.openSettingsKey);
        }
    }
}

