/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.platform;

import games.alejandrocoria.mapfrontiers.client.FrontierOverlay;
import games.alejandrocoria.mapfrontiers.common.util.ReflectionHelper;
import games.alejandrocoria.mapfrontiers.platform.services.IJourneyMapHelper;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import journeymap.api.v2.client.display.Context;
import journeymap.api.v2.client.display.MarkerOverlay;
import journeymap.api.v2.client.display.PolygonOverlay;
import journeymap.client.data.WorldData;
import journeymap.client.io.FileHandler;
import journeymap.client.io.ThemeLoader;
import journeymap.client.model.MapState;
import journeymap.client.model.MapType;
import journeymap.client.properties.MiniMapProperties;
import journeymap.client.render.JMRenderTypes;
import journeymap.client.render.draw.DrawMarkerStep;
import journeymap.client.render.draw.DrawPolygonStep;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.map.MapRenderer;
import journeymap.client.render.map.Renderer;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.minimap.DisplayVars;
import journeymap.client.ui.minimap.MiniMap;
import journeymap.client.ui.minimap.Position;
import journeymap.client.ui.minimap.Shape;
import journeymap.client.ui.theme.Theme;
import journeymap.common.waypoint.WaypointStore;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class NeoForgeJourneyMapHelper
implements IJourneyMapHelper {
    private static boolean minimapPropertiesInitialized = false;
    private static boolean minimapEnabled;
    private static int minimapSize;
    private static Shape minimapShape;
    private static Position minimapPosition;
    private static String minimapInfo1;
    private static String minimapInfo2;
    private static String minimapInfo3;
    private static String minimapInfo4;
    private static int minimapFontScale;
    private static int minimapCompassFontScale;

    @Override
    public File getJMWorldDir(Minecraft client) {
        return FileHandler.getJMWorldDir((Minecraft)client);
    }

    @Override
    public void fullscreenMapCenterOn(int x, int z) {
        UIManager.INSTANCE.openFullscreenMap().centerOn((double)x, (double)z);
    }

    @Override
    public boolean isMinimapEnabled() {
        return UIManager.INSTANCE.isMiniMapEnabled();
    }

    @Override
    public void drawMinimapPreview(GuiGraphics graphics) {
        UIManager.INSTANCE.getMiniMap().drawMap(graphics, true);
    }

    @Override
    public int getMinimapWidth() throws NoSuchFieldException, IllegalAccessException {
        return (Integer)ReflectionHelper.getPrivateField(NeoForgeJourneyMapHelper.getDisplayVars(), "minimapWidth");
    }

    @Override
    public int getMinimapHeight() throws NoSuchFieldException, IllegalAccessException {
        return (Integer)ReflectionHelper.getPrivateField(NeoForgeJourneyMapHelper.getDisplayVars(), "minimapHeight");
    }

    @Override
    public int getMinimapTranslateX() throws NoSuchFieldException, IllegalAccessException {
        return (Integer)ReflectionHelper.getPrivateField(NeoForgeJourneyMapHelper.getDisplayVars(), "translateX");
    }

    @Override
    public int getMinimapTranslateY() throws NoSuchFieldException, IllegalAccessException {
        return (Integer)ReflectionHelper.getPrivateField(NeoForgeJourneyMapHelper.getDisplayVars(), "translateY");
    }

    @Override
    public int getMinimapMargin() {
        Object minimapSpec = UIManager.INSTANCE.getMiniMap().getCurrentMinimapProperties().shape.get() == Shape.Circle && ThemeLoader.getCurrentTheme().minimap.circle != null ? ThemeLoader.getCurrentTheme().minimap.circle : ThemeLoader.getCurrentTheme().minimap.square;
        return minimapSpec.margin;
    }

    @Override
    public IJourneyMapHelper.JMPosition getMinimapPosition() {
        return switch ((Position)UIManager.INSTANCE.getMiniMap().getCurrentMinimapProperties().position.get()) {
            case Position.TopRight -> IJourneyMapHelper.JMPosition.TopRight;
            case Position.BottomRight -> IJourneyMapHelper.JMPosition.BottomRight;
            case Position.BottomLeft -> IJourneyMapHelper.JMPosition.BottomLeft;
            case Position.TopLeft -> IJourneyMapHelper.JMPosition.TopLeft;
            case Position.TopCenter -> IJourneyMapHelper.JMPosition.TopCenter;
            case Position.Center -> IJourneyMapHelper.JMPosition.Center;
            default -> IJourneyMapHelper.JMPosition.Custom;
        };
    }

    @Override
    public int minimapLabelBackgroundColor() {
        if (UIManager.INSTANCE.getMiniMap().getCurrentMinimapProperties().shape.get() == Shape.Circle && ThemeLoader.getCurrentTheme().minimap.circle != null) {
            return NeoForgeJourneyMapHelper.colorSpecToInt(ThemeLoader.getCurrentTheme().minimap.circle.labelTop.background);
        }
        return NeoForgeJourneyMapHelper.colorSpecToInt(ThemeLoader.getCurrentTheme().minimap.square.labelTop.background);
    }

    @Override
    public int minimapLabelHighlightColor() {
        if (UIManager.INSTANCE.getMiniMap().getCurrentMinimapProperties().shape.get() == Shape.Circle && ThemeLoader.getCurrentTheme().minimap.circle != null) {
            return NeoForgeJourneyMapHelper.colorSpecToInt(ThemeLoader.getCurrentTheme().minimap.circle.labelTop.highlight);
        }
        return NeoForgeJourneyMapHelper.colorSpecToInt(ThemeLoader.getCurrentTheme().minimap.square.labelTop.highlight);
    }

    @Override
    public int minimapLabelForegroundColor() {
        if (UIManager.INSTANCE.getMiniMap().getCurrentMinimapProperties().shape.get() == Shape.Circle && ThemeLoader.getCurrentTheme().minimap.circle != null) {
            return NeoForgeJourneyMapHelper.colorSpecToInt(ThemeLoader.getCurrentTheme().minimap.circle.labelTop.foreground);
        }
        return NeoForgeJourneyMapHelper.colorSpecToInt(ThemeLoader.getCurrentTheme().minimap.square.labelTop.foreground);
    }

    @Override
    public boolean minimapPropertiesChanged() {
        if (!minimapPropertiesInitialized) {
            NeoForgeJourneyMapHelper.setAllMinimapProperties();
            return true;
        }
        MiniMapProperties minimapProperties = UIManager.INSTANCE.getMiniMap().getCurrentMinimapProperties();
        if (!(minimapEnabled == minimapProperties.enabled.get() && minimapSize == minimapProperties.sizePercent.get() && minimapShape == minimapProperties.shape.get() && minimapPosition == minimapProperties.position.get() && minimapInfo1.equals(minimapProperties.info1Label.get()) && minimapInfo2.equals(minimapProperties.info2Label.get()) && minimapInfo3.equals(minimapProperties.info3Label.get()) && minimapInfo4.equals(minimapProperties.info4Label.get()) && minimapFontScale == minimapProperties.fontScale.get().intValue() && minimapCompassFontScale == minimapProperties.compassFontScale.get().intValue())) {
            NeoForgeJourneyMapHelper.setAllMinimapProperties();
            return true;
        }
        return false;
    }

    @Override
    public List<String> getDimensionList() {
        ArrayList<String> list = new ArrayList<String>();
        List dimensionProviders = WorldData.getDimensionProviders((List)WaypointStore.getInstance().getLoadedDimensions());
        for (WorldData.DimensionProvider dimension : dimensionProviders) {
            list.add(dimension.getDimensionId());
        }
        return list;
    }

    @Override
    public IJourneyMapHelper.ICustomPreviewRenderer createCustomPreviewRenderer() {
        return new CustomPreviewRenderer();
    }

    private static int colorSpecToInt(Theme.ColorSpec colorSpec) {
        int color = colorSpec.getColor();
        return color |= Math.round(colorSpec.alpha * 255.0f) << 24;
    }

    private static DisplayVars getDisplayVars() throws NoSuchFieldException, IllegalAccessException {
        MiniMap minimap = UIManager.INSTANCE.getMiniMap();
        return (DisplayVars)ReflectionHelper.getPrivateField(minimap, "dv");
    }

    private static void setAllMinimapProperties() {
        MiniMapProperties minimapProperties = UIManager.INSTANCE.getMiniMap().getCurrentMinimapProperties();
        minimapEnabled = minimapProperties.enabled.get();
        minimapSize = minimapProperties.sizePercent.get();
        minimapShape = (Shape)minimapProperties.shape.get();
        minimapPosition = (Position)minimapProperties.position.get();
        minimapInfo1 = minimapProperties.info1Label.get();
        minimapInfo2 = minimapProperties.info2Label.get();
        minimapInfo3 = minimapProperties.info3Label.get();
        minimapInfo4 = minimapProperties.info4Label.get();
        minimapFontScale = minimapProperties.fontScale.get().intValue();
        minimapCompassFontScale = minimapProperties.compassFontScale.get().intValue();
        minimapPropertiesInitialized = true;
    }

    private static class CustomPreviewRenderer
    implements IJourneyMapHelper.ICustomPreviewRenderer {
        private final MapRenderer mapRenderer;
        private final List<DrawStep> drawSteps = new ArrayList<DrawStep>();

        public CustomPreviewRenderer() {
            this.mapRenderer = new MapRenderer(Context.UI.Fullscreen);
            this.mapRenderer.setZoom(512.0);
            this.mapRenderer.setViewPortBounds(null);
            MapState mapState = new MapState();
            mapState.setMapType(MapType.day((ResourceKey)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"overworld"))));
            this.mapRenderer.setContext(mapState);
            this.mapRenderer.center(mapState.getWorldDir(), mapState.getMapType(), 0.0, 0.0, 512);
        }

        @Override
        public void setFrontiers(List<FrontierOverlay> frontierOverlays) {
            this.drawSteps.clear();
            for (FrontierOverlay frontierOverlay : frontierOverlays) {
                for (PolygonOverlay polygon : frontierOverlay.getPolygonOverlays()) {
                    this.drawSteps.add((DrawStep)new DrawPolygonStep(polygon));
                }
                for (MarkerOverlay banner : frontierOverlay.getBannerOverlays()) {
                    this.drawSteps.add((DrawStep)new DrawMarkerStep(banner));
                }
            }
        }

        @Override
        public void draw(GuiGraphics graphics, int x, int y, int size, float scaleFactor) {
            if (this.drawSteps.isEmpty()) {
                return;
            }
            int width = Minecraft.getInstance().getWindow().getScreenWidth();
            int height = Minecraft.getInstance().getWindow().getScreenHeight();
            double guiScale = Minecraft.getInstance().getWindow().getGuiScale();
            DrawUtil.sizeDisplay((double)width, (double)height);
            graphics.pose().pushPose();
            graphics.pose().translate((double)((float)(-width) * scaleFactor / 2.0f) + (double)x * guiScale, (double)((float)(-height) * scaleFactor / 2.0f) + (double)y * guiScale, 0.0);
            graphics.pose().scale(scaleFactor, scaleFactor, scaleFactor);
            this.mapRenderer.setViewPortBounds(new Rectangle2D.Double(0.0, 0.0, (float)width * scaleFactor, (float)height * scaleFactor));
            graphics.fill(JMRenderTypes.MINIMAP_RECTANGLE_MASK_RENDER_TYPE, width / 2 + 1, height / 2 + 1, width / 2 + size - 1, height / 2 + size - 1, 0, -1);
            for (DrawStep.Pass pass : DrawStep.Pass.values()) {
                int zLevel = 0;
                for (DrawStep drawStep : this.drawSteps) {
                    graphics.pose().pushPose();
                    graphics.pose().translate(0.0f, 0.0f, (float)(++zLevel));
                    drawStep.draw(graphics, (MultiBufferSource)graphics.bufferSource(), pass, 0.0, 0.0, (Renderer)this.mapRenderer, 1.0, 0.0);
                    graphics.pose().popPose();
                }
            }
            graphics.pose().popPose();
            DrawUtil.sizeDisplay((double)((double)width / guiScale), (double)((double)height / guiScale));
        }
    }
}

