/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client;

import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.client.FrontierOverlay;
import games.alejandrocoria.mapfrontiers.common.Config;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class ChatFrontiers {
    private static int receivedId = -1;
    private static final List<String> receivedData = new ArrayList<String>();
    private static final LinkedHashMap<Integer, FrontierData> receivedFrontiers = LinkedHashMap.newLinkedHashMap(3);

    public static void clear() {
        receivedId = -1;
        receivedData.clear();
        receivedFrontiers.clear();
    }

    @Nullable
    public static FrontierData getReceivedFrontier(int id) {
        return receivedFrontiers.get(id);
    }

    public static void removeReceivedId(int id) {
        receivedFrontiers.remove(id);
    }

    public static void sendFrontier(FrontierOverlay frontier, SettingsUser user) {
        try {
            CompoundTag nbt = new CompoundTag();
            frontier.writeToNBT(nbt);
            String encodedData = ChatFrontiers.encodeNBT(nbt);
            String command = Config.sendCommand + " " + user.username + " #MapFrontiers:";
            String format = "%d:%d:%d:%d:%s";
            ArrayList<String> dataList = new ArrayList<String>();
            int maxLength = 255 - command.length() - format.length();
            int dataLength = encodedData.length();
            for (int i = 0; i < dataLength; i += maxLength) {
                int end = Math.min(dataLength, i + maxLength);
                dataList.add(encodedData.substring(i, end));
            }
            int RandomId = new Random().nextInt(999) + 1;
            for (int i = 0; i < dataList.size(); ++i) {
                String message = command + String.format(format, 10, RandomId, i + 1, dataList.size(), dataList.get(i));
                Minecraft.getInstance().player.connection.sendCommand(message);
            }
        }
        catch (Throwable t) {
            MapFrontiers.LOGGER.error("Failed to send frontier {} {} to user {}: {}", (Object)frontier.getName1(), (Object)frontier.getName2(), (Object)user.username, (Object)t);
        }
    }

    public static boolean receiveFrontierFromChat(Component messageComponent, @Nullable UUID sender) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || sender == null) {
            return false;
        }
        String message = messageComponent.getString();
        int startIndex = message.indexOf("#MapFrontiers:");
        if (startIndex == -1) {
            return false;
        }
        if (player.getUUID().equals(sender)) {
            return true;
        }
        message = message.substring(startIndex);
        try {
            String[] parts = message.split(":", 6);
            if (parts.length != 6) {
                throw new IllegalArgumentException();
            }
            int version = Integer.parseInt(parts[1]);
            int id = Integer.parseInt(parts[2]);
            int index = Integer.parseInt(parts[3]);
            int total = Integer.parseInt(parts[4]);
            String data = parts[5];
            if (id > 999) {
                throw new IllegalArgumentException();
            }
            if (index < 1 || index > total) {
                throw new IllegalArgumentException();
            }
            if (id != receivedId || total != receivedData.size() || !StringUtil.isBlank((String)receivedData.get(index - 1))) {
                receivedData.clear();
                receivedData.addAll(Collections.nCopies(total, ""));
                receivedId = id;
            }
            receivedData.set(index - 1, data);
            if (receivedData.stream().noneMatch(String::isBlank)) {
                String encodedData = String.join((CharSequence)"", receivedData);
                FrontierData frontier = new FrontierData();
                frontier.readFromNBT(ChatFrontiers.decodeNBT(encodedData), version);
                frontier.setCopiedFromId(frontier.getId());
                frontier.setCopiedFromUser(frontier.getOwner());
                frontier.setId(UUID.randomUUID());
                frontier.setOwner(new SettingsUser((Player)player));
                frontier.setPersonal(true);
                receivedFrontiers.remove(receivedId);
                if (receivedFrontiers.size() == 3) {
                    Iterator<Map.Entry<Integer, FrontierData>> iterator = receivedFrontiers.entrySet().iterator();
                    iterator.next();
                    iterator.remove();
                }
                receivedFrontiers.putLast(receivedId, frontier);
                Object frontierName = frontier.getName1().isEmpty() && frontier.getName2().isEmpty() ? "Unnamed Frontier" : (frontier.getName1().isEmpty() ? frontier.getName2() : (frontier.getName2().isEmpty() ? frontier.getName1() : frontier.getName1() + " " + frontier.getName2()));
                MutableComponent button = Component.literal((String)frontierName);
                button.withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)("Click to accept or use command /mfacceptcopy " + receivedId)))));
                button.withStyle(style -> style.withBold(Boolean.valueOf(true)));
                button.withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/mapfrontiersacceptcopy " + receivedId)));
                SettingsUser userSender = new SettingsUser();
                userSender.uuid = sender;
                userSender.fillMissingInfo(true, null);
                MutableComponent text = Component.literal((String)(userSender.toString("User not found") + " "));
                if (userSender.equals(frontier.getCopiedFromUser())) {
                    text.append("want to send a frontier to you: ");
                } else {
                    text.append("want to send a frontier of " + frontier.getCopiedFromUser().toString("User not found") + " to you: ");
                }
                text.append((Component)button);
                player.displayClientMessage((Component)text, false);
                receivedId = -1;
            }
        }
        catch (Throwable t) {
            MapFrontiers.LOGGER.error("Failed to parse frontier from chat: \"{}\"\n{}", (Object)message, (Object)t);
            return false;
        }
        return true;
    }

    private static String encodeNBT(CompoundTag nbt) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (DataOutputStream dos = new DataOutputStream(baos);){
            NbtIo.writeCompressed((CompoundTag)nbt, (OutputStream)dos);
        }
        byte[] compressedBytes = baos.toByteArray();
        return Base64.getEncoder().encodeToString(compressedBytes);
    }

    private static CompoundTag decodeNBT(String base64) throws IOException {
        byte[] data = Base64.getDecoder().decode(base64);
        try (DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));){
            CompoundTag compoundTag = NbtIo.readCompressed((InputStream)dis, (NbtAccounter)NbtAccounter.create((long)16384L));
            return compoundTag;
        }
    }
}

