/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component.button;

import com.mojang.blaze3d.systems.RenderSystem;
import games.alejandrocoria.mapfrontiers.client.gui.component.AbstractWidgetNoNarration;
import games.alejandrocoria.mapfrontiers.client.gui.component.StringWidget;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

@ParametersAreNonnullByDefault
public class ShapeChunkButtons
extends AbstractWidgetNoNarration {
    private static final ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"mapfrontiers", (String)"textures/gui/shape_buttons.png");
    private static final int textureSizeX = 980;
    private static final int textureSizeY = 98;
    private int selected;
    private int size;
    private final StringWidget labelShapes;
    private final Consumer<ShapeChunkButtons> callbackShapeUpdated;

    public ShapeChunkButtons(Font font, int selected, Consumer<ShapeChunkButtons> callbackShapeUpdated) {
        super(0, 0, 214, 122, (Component)Component.empty());
        this.selected = selected;
        this.labelShapes = new StringWidget((Component)Component.translatable((String)"mapfrontiers.initial_shape"), font, StringWidget.Align.Center).setColor(-1);
        this.callbackShapeUpdated = callbackShapeUpdated;
    }

    public void setSize(int size) {
        this.size = Math.min(Math.max(size, 1), 32);
    }

    public int getSelected() {
        return this.selected;
    }

    public ShapeMeasure getShapeMeasure() {
        if (this.selected < 2 || this.selected == 7) {
            return ShapeMeasure.None;
        }
        if (this.selected < 5) {
            return ShapeMeasure.Width;
        }
        return ShapeMeasure.Length;
    }

    public int getChunkCount() {
        int chunks;
        switch (this.selected) {
            case 1: {
                chunks = 1;
                break;
            }
            case 2: {
                chunks = this.size * this.size;
                break;
            }
            case 3: {
                chunks = Math.max(1, (this.size - 1) * 4);
                break;
            }
            case 4: {
                chunks = (this.size * this.size + 1) / 2;
                if (this.size % 2 != 0) break;
                chunks += this.size;
                break;
            }
            case 5: 
            case 6: {
                chunks = this.size;
                break;
            }
            case 7: {
                chunks = 1024;
                break;
            }
            default: {
                chunks = 0;
            }
        }
        return chunks;
    }

    public void setX(int x) {
        super.setX(x);
        this.labelShapes.setX(x + 107);
    }

    public void setY(int y) {
        super.setY(y);
        this.labelShapes.setY(y + 2);
    }

    public boolean clicked(double mouseX, double mouseY) {
        if (!this.active || !this.visible) {
            return false;
        }
        return mouseX >= (double)this.getX() && mouseX < (double)(this.getX() + this.width) && mouseY >= (double)this.getY() && mouseY < (double)(this.getY() + this.height);
    }

    @Nullable
    public ComponentPath nextFocusPath(FocusNavigationEvent navigationEvent) {
        return null;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.clicked(mouseX, mouseY);
    }

    public void onClick(double mouseX, double mouseY) {
        double col = (mouseX - (double)this.getX() + 3.0) / 55.0;
        double row = (mouseY - (double)this.getY() - 15.0) / 55.0;
        if (col >= 0.0 && col < 4.0 && row >= 0.0 && row < 2.0) {
            this.selected = (int)col + (int)row * 4;
            this.callbackShapeUpdated.accept(this);
        }
    }

    public void playDownSound(SoundManager soundHandlerIn) {
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int col = 0;
        int row = 0;
        for (int i = 0; i < 8; ++i) {
            int texX = i * 49;
            int texY = 0;
            if (i == this.selected) {
                texY = 49;
            }
            graphics.blit(texture, this.getX() + col * 55, this.getY() + row * 55 + 18, (float)(texX + 588), (float)texY, 49, 49, 980, 98);
            if (++col != 4) continue;
            col = 0;
            ++row;
        }
        this.labelShapes.render(graphics, mouseX, mouseY, partialTicks);
    }

    public static enum ShapeMeasure {
        None,
        Width,
        Length;

    }
}

