/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component.button;

import com.mojang.blaze3d.systems.RenderSystem;
import games.alejandrocoria.mapfrontiers.client.gui.component.StringWidget;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.ButtonBase;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;

@ParametersAreNonnullByDefault
public class SimpleButton
extends ButtonBase {
    private final StringWidget label;
    private int textColor = -6710887;
    private int textColorHighlight = -1;
    private int textColorInactive = -13619152;

    public SimpleButton(Font font, int width, Component text, OnPress pressedAction) {
        super(0, 0, width, 16, text, b -> pressedAction.onPress((SimpleButton)b), Button.DEFAULT_NARRATION);
        this.label = new StringWidget(text, font, StringWidget.Align.Center);
    }

    public void setX(int x) {
        super.setX(x);
        this.label.setX(x + this.width / 2);
    }

    public void setY(int y) {
        super.setY(y);
        this.label.setY(y + 4);
    }

    public void setMessage(Component text) {
        this.label.setMessage(text);
        this.setX(this.getX());
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (!this.active) {
            this.label.setColor(this.textColorInactive);
        } else if (this.isHoveredOrKeyboardFocused()) {
            this.label.setColor(this.textColorHighlight);
        } else {
            this.label.setColor(this.textColor);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int borderColor = this.isKeyboardFocused() ? -1 : (this.active ? -8947849 : -12303292);
        graphics.hLine(this.getX(), this.getX() + this.width - 1, this.getY(), borderColor);
        graphics.hLine(this.getX(), this.getX() + this.width - 1, this.getY() + 15, borderColor);
        graphics.vLine(this.getX(), this.getY(), this.getY() + 15, borderColor);
        graphics.vLine(this.getX() + this.width - 1, this.getY(), this.getY() + 15, borderColor);
        graphics.fill(this.getX() + 1, this.getY() + 1, this.getX() + this.width - 1, this.getY() + 15, -955248624);
        this.label.render(graphics, mouseX, mouseY, partialTicks);
    }

    public void setTextColors(int color, int highlight) {
        this.textColor = color;
        this.textColorHighlight = highlight;
    }

    public static interface OnPress {
        public void onPress(SimpleButton var1);
    }
}

