/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client;

import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.client.FrontierOverlay;
import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.client.plugin.MapFrontiersPlugin;
import games.alejandrocoria.mapfrontiers.common.Config;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.network.PacketCreateFrontier;
import games.alejandrocoria.mapfrontiers.common.network.PacketDeleteFrontier;
import games.alejandrocoria.mapfrontiers.common.network.PacketHandler;
import games.alejandrocoria.mapfrontiers.common.network.PacketPersonalFrontier;
import games.alejandrocoria.mapfrontiers.common.network.PacketSharePersonalFrontier;
import games.alejandrocoria.mapfrontiers.common.network.PacketUpdateFrontier;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.common.util.ColorHelper;
import games.alejandrocoria.mapfrontiers.common.util.ContainerHelper;
import games.alejandrocoria.mapfrontiers.platform.Services;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.api.v2.client.IClientAPI;
import journeymap.api.v2.client.display.Displayable;
import journeymap.api.v2.client.display.MarkerOverlay;
import journeymap.api.v2.client.model.MapImage;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

@ParametersAreNonnullByDefault
public class FrontiersOverlayManager {
    private final IClientAPI jmAPI;
    private final HashMap<ResourceKey<Level>, ArrayList<FrontierOverlay>> dimensionsFrontiers;
    private final HashMap<ResourceKey<Level>, MarkerOverlay> markersSelected;
    private final boolean personal;
    private File ModDir;
    private static final Minecraft minecraft = Minecraft.getInstance();
    private static final MapImage markerDotSelected = new MapImage(ResourceLocation.fromNamespaceAndPath((String)"mapfrontiers", (String)"textures/gui/marker.png"), 20, 0, 10, 10, -1, 1.0f);
    private static float targetDotSelectedOpacity = 0.3f;

    public FrontiersOverlayManager(IClientAPI jmAPI, boolean personal) {
        this.jmAPI = jmAPI;
        this.dimensionsFrontiers = new HashMap();
        this.markersSelected = new HashMap();
        this.personal = personal;
        ClientEventHandler.subscribeUpdatedConfigEvent(this, () -> this.updateAllOverlays(true));
    }

    public void close() {
        ClientEventHandler.unsubscribeAllEvents(this);
        for (List list : this.dimensionsFrontiers.values()) {
            for (FrontierOverlay frontier : list) {
                frontier.deleted();
            }
        }
        this.dimensionsFrontiers.clear();
        this.ModDir = null;
    }

    public void setFrontiersFromServer(List<FrontierData> frontiers) {
        block5: {
            block4: {
                this.ensureLoadData();
                if (!this.personal || minecraft.isLocalServer()) break block4;
                ArrayList<FrontierOverlay> localFrontiers = new ArrayList<FrontierOverlay>();
                this.dimensionsFrontiers.values().forEach(localFrontiers::addAll);
                for (FrontierData frontierData : frontiers) {
                    FrontierOverlay frontierOverlay;
                    if (localFrontiers.removeIf(x -> x.getId().equals(frontierData.getId()))) {
                        frontierOverlay = this.getAllFrontiers(frontierData.getDimension()).stream().filter(x -> x.getId().equals(frontierData.getId())).findFirst().orElseThrow();
                        frontierOverlay.updateFromData(frontierData);
                        continue;
                    }
                    frontierOverlay = new FrontierOverlay(frontierData, this.jmAPI);
                    this.getAllFrontiers(frontierData.getDimension()).add(frontierOverlay);
                }
                this.saveData();
                if (FrontiersOverlayManager.minecraft.player == null) break block5;
                SettingsUser playerUser = new SettingsUser((Player)FrontiersOverlayManager.minecraft.player);
                for (FrontierOverlay frontier : localFrontiers) {
                    if (!frontier.getOwner().equals(playerUser)) continue;
                    frontier.removeAllUserShared();
                    PacketHandler.sendToServer(new PacketPersonalFrontier(frontier));
                    frontier.removeChanges();
                }
                break block5;
            }
            for (FrontierData data : frontiers) {
                FrontierOverlay frontierOverlay = new FrontierOverlay(data, this.jmAPI);
                this.getAllFrontiers(data.getDimension()).add(frontierOverlay);
            }
        }
    }

    public FrontierOverlay addFrontier(FrontierData data) {
        List<FrontierOverlay> frontiers = this.getAllFrontiers(data.getDimension());
        FrontierOverlay frontierOverlay = new FrontierOverlay(data, this.jmAPI);
        frontiers.add(frontierOverlay);
        if (this.personal && !minecraft.isLocalServer()) {
            this.saveData();
        }
        return frontierOverlay;
    }

    public void addFrontier(FrontierOverlay frontierOverlay) {
        List<FrontierOverlay> frontiers = this.getAllFrontiers(frontierOverlay.getDimension());
        frontiers.add(frontierOverlay);
        if (this.personal && !minecraft.isLocalServer()) {
            this.saveData();
        }
    }

    public void clientCreateNewFrontier(ResourceKey<Level> dimension, @Nullable List<BlockPos> vertices, @Nullable List<ChunkPos> chunks) {
        if (MapFrontiersClient.isModOnServer()) {
            PacketHandler.sendToServer(new PacketCreateFrontier(dimension, this.personal, vertices, chunks));
        } else if (this.personal && FrontiersOverlayManager.minecraft.player != null) {
            FrontierData frontier = new FrontierData();
            frontier.setId(UUID.randomUUID());
            frontier.setOwner(new SettingsUser((Player)FrontiersOverlayManager.minecraft.player));
            frontier.setDimension(dimension);
            frontier.setPersonal(true);
            frontier.setColor(ColorHelper.getRandomColor());
            frontier.setCreated(new Date());
            if (vertices != null) {
                frontier.setMode(FrontierData.Mode.Vertex);
                for (BlockPos vertex : vertices) {
                    frontier.addVertex(vertex);
                }
            }
            if (chunks != null) {
                frontier.setMode(FrontierData.Mode.Chunk);
                for (ChunkPos chunk : chunks) {
                    frontier.toggleChunk(chunk);
                }
            }
            FrontierOverlay frontierOverlay = this.addFrontier(frontier);
            ClientEventHandler.postNewFrontierEvent(frontierOverlay, FrontiersOverlayManager.minecraft.player.getId());
        }
    }

    public void clientDeleteFrontier(FrontierOverlay frontier) {
        if (MapFrontiersClient.isModOnServer()) {
            PacketHandler.sendToServer(new PacketDeleteFrontier(frontier.getId()));
        } else if (this.personal && FrontiersOverlayManager.minecraft.player != null && frontier.getOwner().equals(new SettingsUser((Player)FrontiersOverlayManager.minecraft.player))) {
            this.deleteFrontier(frontier.getDimension(), frontier.getId());
            ClientEventHandler.postDeletedFrontierEvent(frontier.getId());
        }
    }

    public void clientUpdateFrontier(FrontierOverlay frontier) {
        FrontierOverlay frontierOverlay;
        if (MapFrontiersClient.isModOnServer()) {
            PacketHandler.sendToServer(new PacketUpdateFrontier(frontier));
            frontier.removeChanges();
        } else if (this.personal && FrontiersOverlayManager.minecraft.player != null && frontier.getOwner().equals(new SettingsUser((Player)FrontiersOverlayManager.minecraft.player)) && (frontierOverlay = this.updateFrontier(frontier)) != null) {
            ClientEventHandler.postUpdatedFrontierEvent(frontierOverlay, FrontiersOverlayManager.minecraft.player.getId());
        }
    }

    public void clientShareFrontier(UUID frontierID, SettingsUser targetUser) {
        if (MapFrontiersClient.isModOnServer()) {
            PacketHandler.sendToServer(new PacketSharePersonalFrontier(frontierID, targetUser));
        }
    }

    public FrontierOverlay deleteFrontier(UUID id) {
        for (ResourceKey<Level> dimension : this.dimensionsFrontiers.keySet()) {
            FrontierOverlay frontierOverlay = this.deleteFrontier(dimension, id);
            if (frontierOverlay == null) continue;
            return frontierOverlay;
        }
        return null;
    }

    public FrontierOverlay deleteFrontier(ResourceKey<Level> dimension, UUID id) {
        List<FrontierOverlay> frontiers = this.getAllFrontiers(dimension);
        int index = ContainerHelper.getIndexFromLambda(frontiers, i -> ((FrontierOverlay)frontiers.get(i)).getId().equals(id));
        if (index < 0) {
            return null;
        }
        FrontierOverlay frontier = frontiers.remove(index);
        frontier.deleted();
        if (this.personal && !minecraft.isLocalServer()) {
            this.saveData();
        }
        return frontier;
    }

    public FrontierOverlay updateFrontier(FrontierData data) {
        List<FrontierOverlay> frontiers = this.getAllFrontiers(data.getDimension());
        int index = ContainerHelper.getIndexFromLambda(frontiers, i -> ((FrontierOverlay)frontiers.get(i)).getId().equals(data.getId()));
        if (index < 0) {
            return null;
        }
        FrontierOverlay frontierOverlay = frontiers.get(index);
        frontierOverlay.updateFromData(data);
        frontierOverlay.setModified(new Date());
        if (this.personal && !minecraft.isLocalServer()) {
            this.saveData();
        }
        return frontierOverlay;
    }

    public Map<ResourceKey<Level>, ArrayList<FrontierOverlay>> getAllFrontiers() {
        this.ensureLoadData();
        return this.dimensionsFrontiers;
    }

    public List<FrontierOverlay> getAllFrontiers(ResourceKey<Level> dimension) {
        this.ensureLoadData();
        return this.dimensionsFrontiers.computeIfAbsent(dimension, k -> new ArrayList());
    }

    public List<FrontierOverlay> getFrontiersInPosition(ResourceKey<Level> dimension, BlockPos pos, double maxDistanceToOpen) {
        ArrayList<FrontierOverlay> frontiersInPosition = new ArrayList<FrontierOverlay>();
        ArrayList<FrontierOverlay> frontiers = this.dimensionsFrontiers.get(dimension);
        if (frontiers != null) {
            for (FrontierOverlay frontier : frontiers) {
                if (!frontier.getVisibility(FrontierData.VisibilityData.Visibility.Frontier) || !frontier.pointIsInside(pos, maxDistanceToOpen)) continue;
                frontiersInPosition.add(frontier);
            }
        }
        return frontiersInPosition;
    }

    public Set<FrontierOverlay> getFrontiersForAnnounce(ResourceKey<Level> dimension, BlockPos pos) {
        boolean forcedAnnounceInTitle;
        HashSet<FrontierOverlay> inPosition = new HashSet<FrontierOverlay>();
        if (Config.announceInChat == Config.Visibility.Never && Config.announceInTitle == Config.Visibility.Never) {
            return inPosition;
        }
        ArrayList<FrontierOverlay> frontiers = this.dimensionsFrontiers.get(dimension);
        boolean forcedAnnounceInChat = Config.announceInChat == Config.Visibility.Always;
        boolean bl = forcedAnnounceInTitle = Config.announceInTitle == Config.Visibility.Always;
        if (frontiers != null) {
            for (FrontierOverlay frontier : frontiers) {
                if (!forcedAnnounceInChat && !forcedAnnounceInTitle && !frontier.getVisibility(FrontierData.VisibilityData.Visibility.AnnounceInChat) && !frontier.getVisibility(FrontierData.VisibilityData.Visibility.AnnounceInTitle) || !frontier.pointIsInside(pos, 0.0)) continue;
                inPosition.add(frontier);
            }
        }
        return inPosition;
    }

    @Nullable
    public FrontierOverlay getFrontierCopiedFrom(UUID copiedFromId) {
        for (List list : this.dimensionsFrontiers.values()) {
            for (FrontierOverlay frontier : list) {
                if (!frontier.wasCopied() || !frontier.getCopiedFromId().equals(copiedFromId)) continue;
                return frontier;
            }
        }
        return null;
    }

    public void updateAllOverlays(boolean forceUpdate) {
        this.ensureLoadData();
        for (List list : this.dimensionsFrontiers.values()) {
            for (FrontierOverlay frontier : list) {
                if (forceUpdate) {
                    frontier.updateOverlay();
                    continue;
                }
                frontier.updateOverlayIfNeeded();
            }
        }
    }

    public void updateSelectedMarker(ResourceKey<Level> dimension, @Nullable FrontierOverlay frontier) {
        BlockPos pos;
        MarkerOverlay marker = this.markersSelected.get(dimension);
        if (marker != null) {
            this.jmAPI.remove((Displayable)marker);
        }
        if (frontier != null && (pos = frontier.getSelectedVertex()) != null) {
            marker = new MarkerOverlay("mapfrontiers", pos, markerDotSelected);
            marker.setDimension(dimension);
            marker.setDisplayOrder(101);
            try {
                this.jmAPI.show((Displayable)marker);
                this.markersSelected.put(dimension, marker);
            }
            catch (Throwable t) {
                MapFrontiers.LOGGER.error(t.getMessage(), t);
            }
        }
    }

    private boolean readFromNBT(CompoundTag nbt) {
        boolean needBackup = false;
        try {
            int version = nbt.getInt("Version");
            if (version == 0) {
                MapFrontiers.LOGGER.warn("Data version in personal_frontiers not found, expected 10");
                needBackup = true;
            } else if (version > 10) {
                MapFrontiers.LOGGER.warn("Data version in personal_frontiers higher than expected. The mod uses 10");
                needBackup = true;
            }
            ListTag frontiersTagList = nbt.getList("frontiers", 10);
            for (int i = 0; i < frontiersTagList.size(); ++i) {
                FrontierData frontier = new FrontierData();
                CompoundTag frontierTag = frontiersTagList.getCompound(i);
                frontier.readFromNBT(frontierTag, version);
                List<FrontierOverlay> frontiers = this.getAllFrontiers(frontier.getDimension());
                FrontierOverlay frontierOverlay = new FrontierOverlay(frontier, this.jmAPI);
                frontiers.add(frontierOverlay);
            }
        }
        catch (Exception ignored) {
            return true;
        }
        return needBackup;
    }

    private void writeToNBT(CompoundTag nbt) {
        ListTag frontiersTagList = new ListTag();
        if (FrontiersOverlayManager.minecraft.player != null) {
            SettingsUser playerUser = new SettingsUser((Player)FrontiersOverlayManager.minecraft.player);
            for (Map.Entry<ResourceKey<Level>, ArrayList<FrontierOverlay>> frontiers : this.dimensionsFrontiers.entrySet()) {
                for (FrontierData frontierData : frontiers.getValue()) {
                    if (!frontierData.getPersonal() || !frontierData.getOwner().equals(playerUser)) continue;
                    CompoundTag frontierTag = new CompoundTag();
                    frontierData.writeToNBT(frontierTag);
                    frontiersTagList.add((Object)frontierTag);
                }
            }
        }
        nbt.put("frontiers", (Tag)frontiersTagList);
        nbt.putInt("Version", 10);
    }

    private void ensureLoadData() {
        if (this.personal && !minecraft.isLocalServer() && this.ModDir == null) {
            this.loadData();
        }
    }

    private void loadData() {
        try {
            File jmDir = Services.JOURNEYMAP.getJMWorldDir(Minecraft.getInstance());
            this.ModDir = new File(jmDir, "mapfrontier");
            this.ModDir.mkdirs();
            CompoundTag nbtFrontiers = this.loadFile("personal_frontiers.dat");
            if (!nbtFrontiers.isEmpty() && this.readFromNBT(nbtFrontiers)) {
                MapFrontiers.createBackup(this.ModDir, "personal_frontiers.dat");
                this.saveData();
            }
        }
        catch (Exception e) {
            MapFrontiers.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private void saveData() {
        if (this.personal && !minecraft.isLocalServer() && this.ModDir != null) {
            CompoundTag nbtFrontiers = new CompoundTag();
            this.writeToNBT(nbtFrontiers);
            this.saveFile("personal_frontiers.dat", nbtFrontiers);
        }
    }

    private CompoundTag loadFile(String filename) {
        File f = new File(this.ModDir, filename);
        if (f.exists()) {
            CompoundTag compoundTag;
            FileInputStream inputStream = new FileInputStream(f);
            try {
                compoundTag = NbtIo.readCompressed((InputStream)inputStream, (NbtAccounter)NbtAccounter.unlimitedHeap());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    MapFrontiers.LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
            inputStream.close();
            return compoundTag;
        }
        return new CompoundTag();
    }

    private void saveFile(String filename, CompoundTag nbt) {
        try {
            File f = new File(this.ModDir, filename);
            try (FileOutputStream outputStream = new FileOutputStream(f);){
                NbtIo.writeCompressed((CompoundTag)nbt, (OutputStream)outputStream);
            }
            catch (Exception e) {
                MapFrontiers.LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        catch (Exception e) {
            MapFrontiers.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    static {
        markerDotSelected.setAnchorX(markerDotSelected.getDisplayWidth() / 2.0).setAnchorY(markerDotSelected.getDisplayHeight() / 2.0);
        markerDotSelected.setRotation(0);
        ClientEventHandler.subscribeClientTickEvent(FrontiersOverlayManager.class, client -> {
            if (MapFrontiersPlugin.isEditing()) {
                float opacity = markerDotSelected.getOpacity();
                if (opacity < targetDotSelectedOpacity) {
                    if ((opacity += client.getDeltaTracker().getGameTimeDeltaTicks() * 0.5f) >= targetDotSelectedOpacity) {
                        opacity = targetDotSelectedOpacity;
                        targetDotSelectedOpacity = 0.0f;
                    }
                } else if ((opacity -= client.getDeltaTracker().getGameTimeDeltaTicks() * 0.07f) <= targetDotSelectedOpacity) {
                    opacity = targetDotSelectedOpacity;
                    targetDotSelectedOpacity = 1.0f;
                }
                markerDotSelected.setOpacity(opacity);
            } else {
                markerDotSelected.setOpacity(0.0f);
                targetDotSelectedOpacity = 1.0f;
            }
        });
    }
}

