/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component.button;

import games.alejandrocoria.mapfrontiers.client.gui.component.button.ButtonBase;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;

@ParametersAreNonnullByDefault
public class OptionButton
extends ButtonBase {
    public static final OnPress DO_NOTHING = b -> {};
    protected final Font font;
    private final List<Component> options;
    private int selected = 0;
    private int color = -4144960;
    private int highlightedColor = -1;

    public OptionButton(Font font, int width, OnPress pressedAction) {
        super(0, 0, width, 12, (Component)Component.empty(), b -> pressedAction.onPress((OptionButton)b), Button.DEFAULT_NARRATION);
        this.font = font;
        this.options = new ArrayList<Component>();
    }

    public void addOption(Component text) {
        this.options.add(text);
    }

    public void setSelected(int selected) {
        if (selected < 0) {
            selected = 0;
        } else if (selected >= this.options.size()) {
            selected = this.options.size() - 1;
        }
        this.selected = selected;
    }

    public int getSelected() {
        return this.selected;
    }

    public void setColor(int color, int highlightedColor) {
        this.color = color;
        this.highlightedColor = highlightedColor;
    }

    public int getColor() {
        return this.color;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double hDelta, double vDelta) {
        if (this.visible && this.isHovered) {
            if (vDelta > 0.0) {
                ++this.selected;
                if (this.selected >= this.options.size()) {
                    this.selected = 0;
                }
            } else {
                --this.selected;
                if (this.selected < 0) {
                    this.selected = this.options.size() - 1;
                }
            }
            this.playDownSound(Minecraft.getInstance().getSoundManager());
            super.onPress();
            return true;
        }
        return false;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int c = this.color;
        if (!this.active) {
            c = -8947849;
        } else if (this.isHoveredOrKeyboardFocused()) {
            c = this.highlightedColor;
        }
        int borderColor = this.isKeyboardFocused() ? -1 : (this.active ? -6250336 : -12303292);
        graphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, borderColor);
        graphics.fill(this.getX() + 1, this.getY() + 1, this.getX() + this.width - 1, this.getY() + this.height - 1, -16777216);
        graphics.drawString(this.font, this.options.get(this.selected), this.getX() + 4, this.getY() + 2, c);
    }

    public void onPress() {
        ++this.selected;
        if (this.selected >= this.options.size()) {
            this.selected = 0;
        }
        super.onPress();
    }

    public static interface OnPress {
        public void onPress(OptionButton var1);
    }
}

