/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.screen;

import games.alejandrocoria.mapfrontiers.client.ChatFrontiers;
import games.alejandrocoria.mapfrontiers.client.FrontierOverlay;
import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.IconButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.SimpleButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.textbox.TextBoxUser;
import games.alejandrocoria.mapfrontiers.client.gui.screen.AutoScaledScreen;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;

@ParametersAreNonnullByDefault
public class SendFrontier
extends AutoScaledScreen {
    private static final Component titleLabel = Component.translatable((String)"mapfrontiers.title_send");
    private static final Component descriptionLabel = Component.translatable((String)"mapfrontiers.send_description");
    private static final Component errorUUIDSizeLabel = Component.translatable((String)"mapfrontiers.new_user_error_uuid_size");
    private static final Component errorUUIDFormatLabel = Component.translatable((String)"mapfrontiers.new_user_error_uuid_format");
    private static final Component errorUserNotFoundLabel = Component.translatable((String)"mapfrontiers.new_user_shared_error_user_not_found");
    private static final Component errorSelfLabel = Component.translatable((String)"mapfrontiers.new_user_shared_error_self");
    private static final Component doneLabel = Component.translatable((String)"gui.done");
    private FrontierOverlay frontier;
    private MultiLineTextWidget description;
    private TextBoxUser textNewUser;
    private IconButton buttonNewUser;

    public SendFrontier(FrontierOverlay frontier) {
        super(titleLabel, 470, 120);
        this.frontier = frontier;
        ClientEventHandler.subscribeDeletedFrontierEvent((Object)this, frontierID -> {
            if (frontierID.equals(this.frontier.getId())) {
                this.onClose();
            }
        });
        ClientEventHandler.subscribeUpdatedFrontierEvent((Object)this, (frontierOverlay, playerID) -> {
            if (frontierOverlay.getId().equals(this.frontier.getId())) {
                this.frontier = frontierOverlay;
            }
        });
    }

    @Override
    public void initScreen() {
        if (MapFrontiersClient.isModOnServer()) {
            this.onClose();
        }
        LinearLayout mainLayout = LinearLayout.vertical().spacing(8);
        mainLayout.defaultCellSetting().alignHorizontallyCenter();
        this.content.addChild((LayoutElement)mainLayout);
        LinearLayout header = LinearLayout.horizontal();
        mainLayout.addChild((LayoutElement)header);
        this.description = (MultiLineTextWidget)header.addChild((LayoutElement)new MultiLineTextWidget(descriptionLabel, this.font));
        this.description.setColor(-1);
        this.description.setCentered(true);
        LinearLayout newUserLayout = LinearLayout.horizontal().spacing(4);
        mainLayout.addChild((LayoutElement)newUserLayout);
        this.textNewUser = new TextBoxUser(this.minecraft, this.font, 238);
        this.textNewUser.setMaxLength(38);
        this.textNewUser.setSubmitCallback(value -> this.buttonNewUserPressed());
        newUserLayout.addChild((LayoutElement)this.textNewUser);
        this.buttonNewUser = new IconButton(IconButton.Type.Send, b -> this.buttonNewUserPressed());
        newUserLayout.addChild((LayoutElement)this.buttonNewUser);
        this.bottomButtons.addChild((LayoutElement)new SimpleButton(this.font, 140, doneLabel, b -> this.onClose()));
    }

    @Override
    public void renderScaledBackgroundScreen(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.drawCenteredBoxBackground(graphics, this.content.getWidth() + 20, this.content.getHeight() + 20);
    }

    private void buttonNewUserPressed() {
        if (this.minecraft.player == null) {
            return;
        }
        SettingsUser user = new SettingsUser();
        String usernameOrUUID = this.textNewUser.getValue();
        this.textNewUser.setFocused(false);
        if (StringUtils.isBlank((CharSequence)usernameOrUUID)) {
            return;
        }
        if (usernameOrUUID.length() < 28) {
            user.username = usernameOrUUID;
            user.fillMissingInfo(false, null);
        } else {
            if ((usernameOrUUID = usernameOrUUID.replaceAll("[^0-9a-fA-F]", "")).length() != 32) {
                this.textNewUser.setError(errorUUIDSizeLabel);
                return;
            }
            usernameOrUUID = usernameOrUUID.toLowerCase();
            String uuid = usernameOrUUID.substring(0, 8) + "-" + usernameOrUUID.substring(8, 12) + "-" + usernameOrUUID.substring(12, 16) + "-" + usernameOrUUID.substring(16, 20) + "-" + usernameOrUUID.substring(20, 32);
            try {
                user.uuid = UUID.fromString(uuid);
                user.fillMissingInfo(true, null);
            }
            catch (Exception e) {
                this.textNewUser.setError(errorUUIDFormatLabel);
                return;
            }
        }
        if (user.uuid == null) {
            this.textNewUser.setError(errorUserNotFoundLabel);
            return;
        }
        ClientPacketListener handler = this.minecraft.getConnection();
        if (handler != null && handler.getPlayerInfo(user.uuid) == null) {
            this.textNewUser.setError(errorUserNotFoundLabel);
            return;
        }
        if (StringUtil.isBlank((String)user.username)) {
            this.textNewUser.setError(errorUserNotFoundLabel);
            return;
        }
        if (user.username.equals(this.minecraft.player.getGameProfile().getName())) {
            this.textNewUser.setError(errorSelfLabel);
            return;
        }
        ChatFrontiers.sendFrontier(this.frontier, user);
        this.textNewUser.setValue("");
    }

    public void onClose() {
        ClientEventHandler.unsubscribeAllEvents((Object)this);
        super.onClose();
    }
}

