/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common.network;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

@ParametersAreNonnullByDefault
public class PacketFrontiers {
    public static final ResourceLocation CHANNEL = ResourceLocation.fromNamespaceAndPath((String)"mapfrontiers", (String)"packet_frontier");
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketFrontiers> STREAM_CODEC = StreamCodec.ofMember(PacketFrontiers::encode, PacketFrontiers::new);
    private final List<FrontierData> globalFrontiers = new ArrayList<FrontierData>();
    private final List<FrontierData> personalFrontiers = new ArrayList<FrontierData>();

    public PacketFrontiers() {
    }

    public static CustomPacketPayload.Type<CustomPacketPayload> type() {
        return new CustomPacketPayload.Type(CHANNEL);
    }

    public void addGlobalFrontier(FrontierData frontier) {
        this.globalFrontiers.add(frontier);
    }

    public void addPersonalFrontier(FrontierData frontier) {
        this.personalFrontiers.add(frontier);
    }

    public void addGlobalFrontiers(List<FrontierData> frontiers) {
        this.globalFrontiers.addAll(frontiers);
    }

    public void addPersonalFrontiers(List<FrontierData> frontiers) {
        this.personalFrontiers.addAll(frontiers);
    }

    public PacketFrontiers(FriendlyByteBuf buf) {
        try {
            if (buf.readableBytes() > 1) {
                FrontierData frontier;
                int i;
                int size = buf.readInt();
                for (i = 0; i < size; ++i) {
                    frontier = new FrontierData();
                    frontier.fromBytes(buf);
                    this.addGlobalFrontier(frontier);
                }
                size = buf.readInt();
                for (i = 0; i < size; ++i) {
                    frontier = new FrontierData();
                    frontier.fromBytes(buf);
                    this.addPersonalFrontier(frontier);
                }
            }
        }
        catch (Throwable t) {
            MapFrontiers.LOGGER.error(String.format("Failed to read message for PacketFrontiers: %s", t));
        }
    }

    public void encode(FriendlyByteBuf buf) {
        try {
            buf.writeInt(this.globalFrontiers.size());
            for (FrontierData frontier : this.globalFrontiers) {
                frontier.toBytes(buf, false);
            }
            buf.writeInt(this.personalFrontiers.size());
            for (FrontierData frontier : this.personalFrontiers) {
                frontier.toBytes(buf, false);
            }
        }
        catch (Throwable t) {
            MapFrontiers.LOGGER.error(String.format("Failed to write message for PacketFrontiers: %s", t));
        }
    }

    public static void handle(PacketContext<PacketFrontiers> ctx) {
        if (Side.CLIENT.equals((Object)ctx.side())) {
            PacketFrontiers message = (PacketFrontiers)ctx.message();
            MapFrontiersClient.setFrontiersFromServer(message.globalFrontiers, message.personalFrontiers);
        }
    }
}

