/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component;

import games.alejandrocoria.mapfrontiers.client.gui.component.AbstractWidgetNoNarration;
import games.alejandrocoria.mapfrontiers.common.Config;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;

@ParametersAreNonnullByDefault
public class SimpleLabel
extends AbstractWidgetNoNarration {
    private final class_327 font;
    private float scale = 1.0f;
    private int color;
    private final Align align;
    private List<String> texts;
    private List<Integer> widths;
    private Config.Point topLeft;
    private Config.Point bottomRight;

    public SimpleLabel(class_327 font, int x, int y, Align align, class_2561 text, int color) {
        super(x, y, 0, 0, text);
        this.font = font;
        this.color = color;
        this.align = align;
        this.setText(text);
    }

    public void setText(class_2561 text) {
        this.texts = new ArrayList<String>();
        this.widths = new ArrayList<Integer>();
        for (String t : text.getString().split("\\R")) {
            this.texts.add(t);
            this.widths.add(this.font.method_1727(t));
        }
        this.topLeft = new Config.Point();
        this.bottomRight = new Config.Point();
        this.bottomRight.y = this.texts.size() * 12;
        if (this.align == Align.Left) {
            for (int i = 0; i < this.texts.size(); ++i) {
                width = this.widths.get(i);
                if (width <= this.bottomRight.x) continue;
                this.bottomRight.x = width;
            }
        } else if (this.align == Align.Center) {
            for (int i = 0; i < this.texts.size(); ++i) {
                int halfWidth = this.widths.get(i) / 2;
                if (-halfWidth < this.topLeft.x) {
                    this.topLeft.x = -halfWidth;
                }
                if (halfWidth <= this.bottomRight.x) continue;
                this.bottomRight.x = halfWidth;
            }
        } else {
            for (int i = 0; i < this.texts.size(); ++i) {
                width = this.widths.get(i);
                if (-width >= this.topLeft.x) continue;
                this.topLeft.x = -width;
            }
        }
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.method_51448().method_22905(this.scale, this.scale, 1.0f);
        if (this.align == Align.Left) {
            for (int i = 0; i < this.texts.size(); ++i) {
                graphics.method_25303(this.font, this.texts.get(i), class_3532.method_15375((float)((float)this.method_46426() / this.scale)), class_3532.method_15375((float)((float)(this.method_46427() + i * 12) / this.scale)), this.color);
            }
        } else if (this.align == Align.Center) {
            for (int i = 0; i < this.texts.size(); ++i) {
                graphics.method_25303(this.font, this.texts.get(i), class_3532.method_15375((float)((float)this.method_46426() / this.scale - (float)(this.widths.get(i) - 1) / 2.0f)), class_3532.method_15375((float)((float)(this.method_46427() + i * 12) / this.scale)), this.color);
            }
        } else {
            for (int i = 0; i < this.texts.size(); ++i) {
                graphics.method_25303(this.font, this.texts.get(i), class_3532.method_15375((float)((float)this.method_46426() / this.scale - (float)this.widths.get(i).intValue())), class_3532.method_15375((float)((float)(this.method_46427() + i * 12) / this.scale)), this.color);
            }
        }
        this.field_22762 = (float)mouseX >= (float)this.topLeft.x * this.scale + (float)this.method_46426() && (float)mouseY >= (float)this.topLeft.y * this.scale + (float)this.method_46427() && (float)mouseX < (float)this.bottomRight.x * this.scale + (float)this.method_46426() && (float)mouseY < (float)this.bottomRight.y * this.scale + (float)this.method_46427();
        graphics.method_51448().method_22905(1.0f / this.scale, 1.0f / this.scale, 1.0f);
    }

    public static enum Align {
        Left,
        Center,
        Right;

    }
}

