/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.component;

import com.mojang.blaze3d.systems.RenderSystem;
import games.alejandrocoria.mapfrontiers.client.gui.component.SimpleLabel;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_357;

public class SimpleSlider
extends class_357 {
    private final class_327 font;
    private final int minValue;
    private final int maxValue;
    private final ValueChanged callback;
    private boolean dragging = false;
    private String translationKey;
    private SimpleLabel label;
    private int textColor = -6710887;
    private int textColorHighlight = -1;

    public SimpleSlider(class_327 font, int x, int y, int width, String translationKey, int minValue, int maxValue, int initialValue, ValueChanged callback) {
        super(x, y, width, 16, (class_2561)class_2561.method_43470((String)String.valueOf(initialValue)), SimpleSlider.normalize(initialValue, minValue, maxValue));
        this.font = font;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.callback = callback;
        this.translationKey = translationKey;
        this.label = new SimpleLabel(font, this.method_46426() + width / 2, this.method_46427() + 5, SimpleLabel.Align.Center, (class_2561)class_2561.method_43469((String)translationKey, (Object[])new Object[]{this.denormalize(this.field_22753)}), this.textColor);
        this.method_25346();
    }

    private static double normalize(int value, int min, int max) {
        return (double)(value - min) / (double)(max - min);
    }

    private int denormalize(double value) {
        return (int)Math.round((double)this.minValue + value * (double)(this.maxValue - this.minValue));
    }

    protected void method_25346() {
        int val = this.denormalize(this.field_22753);
        this.label.setText((class_2561)class_2561.method_43469((String)this.translationKey, (Object[])new Object[]{val}));
    }

    protected void method_25344() {
        int val = this.denormalize(this.field_22753);
        this.callback.onChanged(val, this.dragging);
    }

    public void setValue(int value) {
        this.field_22753 = SimpleSlider.normalize(value, this.minValue, this.maxValue);
        this.method_25346();
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (this.field_22764 && this.field_22762) {
            int val = this.denormalize(this.field_22753);
            val = delta > 0.0 ? Math.min(val + 1, this.maxValue) : Math.max(val - 1, this.minValue);
            this.setValue(val);
            this.method_25344();
            return true;
        }
        return false;
    }

    protected void method_25349(double mouseX, double mouseY, double dragX, double dragY) {
        this.dragging = true;
        super.method_25349(mouseX, mouseY, dragX, dragY);
    }

    public void mouseReleased() {
        if (this.dragging) {
            this.dragging = false;
            this.method_25344();
        }
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        if (this.field_22762) {
            this.label.setColor(this.textColorHighlight);
        } else {
            this.label.setColor(this.textColor);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.method_25292(this.method_46426(), this.method_46426() + this.field_22758, this.method_46427(), -8947849);
        graphics.method_25292(this.method_46426(), this.method_46426() + this.field_22758, this.method_46427() + 16, -8947849);
        graphics.method_25301(this.method_46426(), this.method_46427(), this.method_46427() + 16, -8947849);
        graphics.method_25301(this.method_46426() + this.field_22758, this.method_46427(), this.method_46427() + 16, -8947849);
        int handleX = this.method_46426() + (int)(this.field_22753 * (double)(this.field_22758 - 5)) + 1;
        graphics.method_25294(handleX, this.method_46427() + 1, handleX + 4, this.method_46427() + 16, this.method_25367() ? -1 : -5592406);
        this.label.method_25394(graphics, mouseX, mouseY, partialTick);
    }

    public static interface ValueChanged {
        public void onChanged(int var1, boolean var2);
    }
}

