/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.screen;

import games.alejandrocoria.mapfrontiers.client.FrontierOverlay;
import games.alejandrocoria.mapfrontiers.client.FrontiersOverlayManager;
import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.client.gui.ColorConstants;
import games.alejandrocoria.mapfrontiers.client.gui.component.ColorPicker;
import games.alejandrocoria.mapfrontiers.client.gui.component.SimpleLabel;
import games.alejandrocoria.mapfrontiers.client.gui.component.SimpleSlider;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.IconButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.OptionButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.button.SimpleButton;
import games.alejandrocoria.mapfrontiers.client.gui.component.textbox.TextBox;
import games.alejandrocoria.mapfrontiers.client.gui.component.textbox.TextBoxInt;
import games.alejandrocoria.mapfrontiers.client.gui.screen.ShareSettings;
import games.alejandrocoria.mapfrontiers.client.util.ScreenHelper;
import games.alejandrocoria.mapfrontiers.common.Config;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsProfile;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.common.util.ColorHelper;
import games.alejandrocoria.mapfrontiers.common.util.StringHelper;
import games.alejandrocoria.mapfrontiers.platform.Services;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.client.api.IClientAPI;
import journeymap.client.api.display.Context;
import journeymap.client.api.util.UIState;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1746;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;

@ParametersAreNonnullByDefault
public class FrontierInfo
extends class_437 {
    static final DateFormat dateFormat = new SimpleDateFormat();
    private final IClientAPI jmAPI;
    private final Runnable afterClose;
    private float scaleFactor;
    private int actualWidth;
    private int actualHeight;
    private final FrontiersOverlayManager frontiersOverlayManager;
    private final FrontierOverlay frontier;
    private TextBox textName1;
    private TextBox textName2;
    private OptionButton buttonVisible;
    private OptionButton buttonFullscreenVisible;
    private OptionButton buttonFullscreenNameVisible;
    private OptionButton buttonFullscreenOwnerVisible;
    private OptionButton buttonMinimapVisible;
    private OptionButton buttonMinimapNameVisible;
    private OptionButton buttonMinimapOwnerVisible;
    private OptionButton buttonAnnounceInChat;
    private OptionButton buttonAnnounceInTitle;
    private TextBoxInt textRed;
    private TextBoxInt textGreen;
    private TextBoxInt textBlue;
    private SimpleButton buttonRandomColor;
    private ColorPicker colorPicker;
    private IconButton buttonCopy;
    private IconButton buttonPaste;
    private IconButton buttonOpenPasteOptions;
    private IconButton buttonClosePasteOptions;
    private OptionButton buttonPasteName;
    private OptionButton buttonPasteVisibility;
    private OptionButton buttonPasteColor;
    private OptionButton buttonPasteBanner;
    private SimpleLabel labelPasteName;
    private SimpleLabel labelPasteVisibility;
    private SimpleLabel labelPasteColor;
    private SimpleLabel labelPasteBanner;
    private IconButton buttonUndo;
    private IconButton buttonRedo;
    private SimpleButton buttonSelect;
    private SimpleButton buttonShareSettings;
    private SimpleButton buttonDelete;
    private SimpleButton buttonDone;
    private SimpleButton buttonBanner;
    private SimpleSlider sliderBannerRotation;
    private final List<SimpleLabel> labels;
    private SimpleLabel modifiedLabel;
    private final Stack<FrontierData> undoStack = new Stack();
    private final Stack<FrontierData> redoStack = new Stack();

    public FrontierInfo(IClientAPI jmAPI, FrontierOverlay frontier) {
        this(jmAPI, frontier, null);
    }

    public FrontierInfo(IClientAPI jmAPI, FrontierOverlay frontier, @Nullable Runnable afterClose) {
        super((class_2561)class_2561.method_43471((String)"mapfrontiers.title_info"));
        this.jmAPI = jmAPI;
        this.afterClose = afterClose;
        this.frontiersOverlayManager = MapFrontiersClient.getFrontiersOverlayManager(frontier.getPersonal());
        this.frontier = frontier;
        this.labels = new ArrayList<SimpleLabel>();
        this.undoStack.push(new FrontierData(frontier));
        ClientEventHandler.subscribeDeletedFrontierEvent((Object)this, frontierID -> {
            if (frontier.getId().equals(frontierID)) {
                this.method_25419();
            }
        });
        ClientEventHandler.subscribeUpdatedFrontierEvent((Object)this, (frontierOverlay, playerID) -> {
            if (this.field_22787.field_1724 != null && frontier.getId().equals(frontierOverlay.getId())) {
                this.addToUndo(new FrontierData((FrontierData)frontierOverlay));
                if (playerID.intValue() != this.field_22787.field_1724.method_5628()) {
                    this.method_25423(this.field_22787, this.field_22789, this.field_22790);
                } else if (frontier.getModified() != null) {
                    class_5250 modified = class_2561.method_43469((String)"mapfrontiers.modified", (Object[])new Object[]{dateFormat.format(frontier.getModified())});
                    this.modifiedLabel.setText((class_2561)modified);
                }
            }
        });
        ClientEventHandler.subscribeUpdatedSettingsProfileEvent((Object)this, profile -> {
            this.updateButtons();
            this.updateBannerButton();
        });
    }

    public void method_25426() {
        this.scaleFactor = ScreenHelper.getScaleFactorThatFit(this.field_22787, this, 627, 336);
        this.actualWidth = (int)((float)this.field_22789 * this.scaleFactor);
        this.actualHeight = (int)((float)this.field_22790 * this.scaleFactor);
        int leftSide = this.actualWidth / 2 - 154;
        int rightSide = this.actualWidth / 2 + 10;
        int top = this.actualHeight / 2 - 142;
        this.labels.clear();
        this.labels.add(new SimpleLabel(this.field_22793, leftSide, top, SimpleLabel.Align.Left, (class_2561)class_2561.method_43471((String)"mapfrontiers.name"), -16711681));
        this.textName1 = new TextBox(this.field_22793, leftSide, top + 12, 144);
        this.textName1.method_1880(17);
        this.textName1.setHeight(20);
        this.textName1.method_1852(this.frontier.getName1());
        this.textName1.setLostFocusCallback(value -> this.sendChangesToServer());
        this.textName1.setValueChangedCallback(value -> {
            if (!this.frontier.getName1().equals(value)) {
                this.frontier.setName1((String)value);
            }
        });
        this.textName2 = new TextBox(this.field_22793, leftSide, top + 40, 144);
        this.textName2.method_1880(17);
        this.textName2.setHeight(20);
        this.textName2.method_1852(this.frontier.getName2());
        this.textName2.setLostFocusCallback(value -> this.sendChangesToServer());
        this.textName2.setValueChangedCallback(value -> {
            if (!this.frontier.getName2().equals(value)) {
                this.frontier.setName2((String)value);
            }
        });
        this.labels.add(new SimpleLabel(this.field_22793, leftSide, top + 70, SimpleLabel.Align.Left, (class_2561)class_2561.method_43471((String)"mapfrontiers.show_frontier"), -2236963));
        this.buttonVisible = new OptionButton(this.field_22793, leftSide + 116, top + 68, 28, this::buttonPressed);
        this.buttonVisible.addOption((class_2561)class_2561.method_43471((String)"options.on"));
        this.buttonVisible.addOption((class_2561)class_2561.method_43471((String)"options.off"));
        this.buttonVisible.setSelected(this.frontier.getVisible() ? 0 : 1);
        this.labels.add(new SimpleLabel(this.field_22793, rightSide, top + 70, SimpleLabel.Align.Left, (class_2561)class_2561.method_43471((String)"mapfrontiers.show_fullscreen"), -2236963));
        this.buttonFullscreenVisible = new OptionButton(this.field_22793, rightSide + 116, top + 68, 28, this::buttonPressed);
        this.buttonFullscreenVisible.addOption((class_2561)class_2561.method_43471((String)"options.on"));
        this.buttonFullscreenVisible.addOption((class_2561)class_2561.method_43471((String)"options.off"));
        this.buttonFullscreenVisible.setSelected(this.frontier.getFullscreenVisible() ? 0 : 1);
        this.labels.add(new SimpleLabel(this.field_22793, rightSide, top + 86, SimpleLabel.Align.Left, (class_2561)class_2561.method_43471((String)"mapfrontiers.show_name"), -2236963));
        this.buttonFullscreenNameVisible = new OptionButton(this.field_22793, rightSide + 116, top + 84, 28, this::buttonPressed);
        this.buttonFullscreenNameVisible.addOption((class_2561)class_2561.method_43471((String)"options.on"));
        this.buttonFullscreenNameVisible.addOption((class_2561)class_2561.method_43471((String)"options.off"));
        this.buttonFullscreenNameVisible.setSelected(this.frontier.getFullscreenNameVisible() ? 0 : 1);
        this.labels.add(new SimpleLabel(this.field_22793, rightSide, top + 102, SimpleLabel.Align.Left, (class_2561)class_2561.method_43471((String)"mapfrontiers.show_owner"), -2236963));
        this.buttonFullscreenOwnerVisible = new OptionButton(this.field_22793, rightSide + 116, top + 100, 28, this::buttonPressed);
        this.buttonFullscreenOwnerVisible.addOption((class_2561)class_2561.method_43471((String)"options.on"));
        this.buttonFullscreenOwnerVisible.addOption((class_2561)class_2561.method_43471((String)"options.off"));
        this.buttonFullscreenOwnerVisible.setSelected(this.frontier.getFullscreenOwnerVisible() ? 0 : 1);
        this.labels.add(new SimpleLabel(this.field_22793, rightSide + 154, top + 70, SimpleLabel.Align.Left, (class_2561)class_2561.method_43471((String)"mapfrontiers.show_minimap"), -2236963));
        this.buttonMinimapVisible = new OptionButton(this.field_22793, rightSide + 154 + 116, top + 68, 28, this::buttonPressed);
        this.buttonMinimapVisible.addOption((class_2561)class_2561.method_43471((String)"options.on"));
        this.buttonMinimapVisible.addOption((class_2561)class_2561.method_43471((String)"options.off"));
        this.buttonMinimapVisible.setSelected(this.frontier.getMinimapVisible() ? 0 : 1);
        this.labels.add(new SimpleLabel(this.field_22793, rightSide + 154, top + 86, SimpleLabel.Align.Left, (class_2561)class_2561.method_43471((String)"mapfrontiers.show_name"), -2236963));
        this.buttonMinimapNameVisible = new OptionButton(this.field_22793, rightSide + 154 + 116, top + 84, 28, this::buttonPressed);
        this.buttonMinimapNameVisible.addOption((class_2561)class_2561.method_43471((String)"options.on"));
        this.buttonMinimapNameVisible.addOption((class_2561)class_2561.method_43471((String)"options.off"));
        this.buttonMinimapNameVisible.setSelected(this.frontier.getMinimapNameVisible() ? 0 : 1);
        this.labels.add(new SimpleLabel(this.field_22793, rightSide + 154, top + 102, SimpleLabel.Align.Left, (class_2561)class_2561.method_43471((String)"mapfrontiers.show_owner"), -2236963));
        this.buttonMinimapOwnerVisible = new OptionButton(this.field_22793, rightSide + 154 + 116, top + 100, 28, this::buttonPressed);
        this.buttonMinimapOwnerVisible.addOption((class_2561)class_2561.method_43471((String)"options.on"));
        this.buttonMinimapOwnerVisible.addOption((class_2561)class_2561.method_43471((String)"options.off"));
        this.buttonMinimapOwnerVisible.setSelected(this.frontier.getMinimapOwnerVisible() ? 0 : 1);
        this.labels.add(new SimpleLabel(this.field_22793, leftSide, top + 86, SimpleLabel.Align.Left, (class_2561)class_2561.method_43471((String)"mapfrontiers.announce_in_chat"), -2236963));
        this.buttonAnnounceInChat = new OptionButton(this.field_22793, leftSide + 116, top + 84, 28, this::buttonPressed);
        this.buttonAnnounceInChat.addOption((class_2561)class_2561.method_43471((String)"options.on"));
        this.buttonAnnounceInChat.addOption((class_2561)class_2561.method_43471((String)"options.off"));
        this.buttonAnnounceInChat.setSelected(this.frontier.getAnnounceInChat() ? 0 : 1);
        this.labels.add(new SimpleLabel(this.field_22793, leftSide, top + 102, SimpleLabel.Align.Left, (class_2561)class_2561.method_43471((String)"mapfrontiers.announce_in_title"), -2236963));
        this.buttonAnnounceInTitle = new OptionButton(this.field_22793, leftSide + 116, top + 100, 28, this::buttonPressed);
        this.buttonAnnounceInTitle.addOption((class_2561)class_2561.method_43471((String)"options.on"));
        this.buttonAnnounceInTitle.addOption((class_2561)class_2561.method_43471((String)"options.off"));
        this.buttonAnnounceInTitle.setSelected(this.frontier.getAnnounceInTitle() ? 0 : 1);
        this.labels.add(new SimpleLabel(this.field_22793, rightSide, top + 152, SimpleLabel.Align.Left, (class_2561)class_2561.method_43471((String)"mapfrontiers.color"), -16711681));
        this.labels.add(new SimpleLabel(this.field_22793, rightSide - 11, top + 170, SimpleLabel.Align.Left, (class_2561)class_2561.method_43470((String)"R"), -16711681));
        this.textRed = new TextBoxInt(0, 0, 255, this.field_22793, rightSide, top + 164, 29);
        this.textRed.setHeight(20);
        this.textRed.method_25358(34);
        this.textRed.setValueChangedCallback(value -> {
            int newColor = this.frontier.getColor() & 0xFF00FFFF | value << 16;
            if (newColor != this.frontier.getColor()) {
                this.frontier.setColor(newColor);
                this.colorPicker.setColor(newColor);
                this.sendChangesToServer();
            }
        });
        this.labels.add(new SimpleLabel(this.field_22793, rightSide + 44, top + 170, SimpleLabel.Align.Left, (class_2561)class_2561.method_43470((String)"G"), -16711681));
        this.textGreen = new TextBoxInt(0, 0, 255, this.field_22793, rightSide + 55, top + 164, 29);
        this.textGreen.setHeight(20);
        this.textGreen.method_25358(34);
        this.textGreen.setValueChangedCallback(value -> {
            int newColor = this.frontier.getColor() & 0xFFFF00FF | value << 8;
            if (newColor != this.frontier.getColor()) {
                this.frontier.setColor(newColor);
                this.colorPicker.setColor(newColor);
                this.sendChangesToServer();
            }
        });
        this.labels.add(new SimpleLabel(this.field_22793, rightSide + 99, top + 170, SimpleLabel.Align.Left, (class_2561)class_2561.method_43470((String)"B"), -16711681));
        this.textBlue = new TextBoxInt(0, 0, 255, this.field_22793, rightSide + 110, top + 164, 29);
        this.textBlue.setHeight(20);
        this.textBlue.method_25358(34);
        this.textBlue.setValueChangedCallback(value -> {
            int newColor = this.frontier.getColor() & 0xFFFFFF00 | value;
            if (newColor != this.frontier.getColor()) {
                this.frontier.setColor(newColor);
                this.colorPicker.setColor(newColor);
                this.sendChangesToServer();
            }
        });
        this.textRed.setValue((this.frontier.getColor() & 0xFF0000) >> 16);
        this.textGreen.setValue((this.frontier.getColor() & 0xFF00) >> 8);
        this.textBlue.setValue(this.frontier.getColor() & 0xFF);
        this.buttonRandomColor = new SimpleButton(this.field_22793, rightSide, top + 190, 145, (class_2561)class_2561.method_43471((String)"mapfrontiers.random_color"), this::buttonPressed);
        this.colorPicker = new ColorPicker(leftSide + 2, top + 156, this.frontier.getColor(), (picker, dragging) -> this.colorPickerUpdated((boolean)dragging));
        this.buttonCopy = new IconButton(rightSide + 154, top + 263, IconButton.Type.Copy, this::buttonPressed);
        this.buttonPaste = new IconButton(rightSide + 174, top + 263, IconButton.Type.Paste, this::buttonPressed);
        this.buttonOpenPasteOptions = new IconButton(rightSide + 191, top + 263, IconButton.Type.ArrowUp, this::buttonPressed);
        this.buttonClosePasteOptions = new IconButton(rightSide + 191, top + 263, IconButton.Type.ArrowDown, this::buttonPressed);
        this.labelPasteName = new SimpleLabel(this.field_22793, rightSide + 154, top + 200, SimpleLabel.Align.Left, (class_2561)class_2561.method_43471((String)"mapfrontiers.paste_name"), -2236963);
        this.labels.add(this.labelPasteName);
        this.buttonPasteName = new OptionButton(this.field_22793, rightSide + 154 + 116, top + 198, 28, this::buttonPressed);
        this.buttonPasteName.addOption((class_2561)class_2561.method_43471((String)"options.on"));
        this.buttonPasteName.addOption((class_2561)class_2561.method_43471((String)"options.off"));
        this.buttonPasteName.setSelected(Config.pasteName ? 0 : 1);
        this.labelPasteVisibility = new SimpleLabel(this.field_22793, rightSide + 154, top + 216, SimpleLabel.Align.Left, (class_2561)class_2561.method_43471((String)"mapfrontiers.paste_visibility"), -2236963);
        this.labels.add(this.labelPasteVisibility);
        this.buttonPasteVisibility = new OptionButton(this.field_22793, rightSide + 154 + 116, top + 214, 28, this::buttonPressed);
        this.buttonPasteVisibility.addOption((class_2561)class_2561.method_43471((String)"options.on"));
        this.buttonPasteVisibility.addOption((class_2561)class_2561.method_43471((String)"options.off"));
        this.buttonPasteVisibility.setSelected(Config.pasteVisibility ? 0 : 1);
        this.labelPasteColor = new SimpleLabel(this.field_22793, rightSide + 154, top + 232, SimpleLabel.Align.Left, (class_2561)class_2561.method_43471((String)"mapfrontiers.paste_color"), -2236963);
        this.labels.add(this.labelPasteColor);
        this.buttonPasteColor = new OptionButton(this.field_22793, rightSide + 154 + 116, top + 230, 28, this::buttonPressed);
        this.buttonPasteColor.addOption((class_2561)class_2561.method_43471((String)"options.on"));
        this.buttonPasteColor.addOption((class_2561)class_2561.method_43471((String)"options.off"));
        this.buttonPasteColor.setSelected(Config.pasteColor ? 0 : 1);
        this.labelPasteBanner = new SimpleLabel(this.field_22793, rightSide + 154, top + 248, SimpleLabel.Align.Left, (class_2561)class_2561.method_43471((String)"mapfrontiers.paste_banner"), -2236963);
        this.labels.add(this.labelPasteBanner);
        this.buttonPasteBanner = new OptionButton(this.field_22793, rightSide + 154 + 116, top + 246, 28, this::buttonPressed);
        this.buttonPasteBanner.addOption((class_2561)class_2561.method_43471((String)"options.on"));
        this.buttonPasteBanner.addOption((class_2561)class_2561.method_43471((String)"options.off"));
        this.buttonPasteBanner.setSelected(Config.pasteBanner ? 0 : 1);
        this.buttonUndo = new IconButton(rightSide + 202, top + 263, IconButton.Type.Undo, this::buttonPressed);
        this.buttonRedo = new IconButton(rightSide + 222, top + 263, IconButton.Type.Redo, this::buttonPressed);
        int offset1 = StringHelper.getMaxWidth(this.field_22793, class_1074.method_4662((String)"mapfrontiers.type", (Object[])new Object[]{class_1074.method_4662((String)"mapfrontiers.config.Personal", (Object[])new Object[0])}), class_1074.method_4662((String)"mapfrontiers.type", (Object[])new Object[]{class_1074.method_4662((String)"mapfrontiers.config.Global", (Object[])new Object[0])})) + 10;
        int offset2 = StringHelper.getMaxWidth(this.field_22793, class_1074.method_4662((String)"mapfrontiers.vertices", (Object[])new Object[]{9999}), class_1074.method_4662((String)"mapfrontiers.chunks", (Object[])new Object[]{9999})) + 10;
        class_5250 type = class_2561.method_43469((String)"mapfrontiers.type", (Object[])new Object[]{class_2561.method_43471((String)(this.frontier.getPersonal() ? "mapfrontiers.config.Personal" : "mapfrontiers.config.Global"))});
        this.labels.add(new SimpleLabel(this.field_22793, rightSide, top, SimpleLabel.Align.Left, (class_2561)type, -1));
        if (this.frontier.getMode() == FrontierData.Mode.Vertex) {
            class_5250 vertices = class_2561.method_43469((String)"mapfrontiers.vertices", (Object[])new Object[]{this.frontier.getVertexCount()});
            this.labels.add(new SimpleLabel(this.field_22793, rightSide + offset1, top, SimpleLabel.Align.Left, (class_2561)vertices, -1));
        } else {
            class_5250 chunks = class_2561.method_43469((String)"mapfrontiers.chunks", (Object[])new Object[]{this.frontier.getChunkCount()});
            this.labels.add(new SimpleLabel(this.field_22793, rightSide + offset1, top, SimpleLabel.Align.Left, (class_2561)chunks, -1));
        }
        class_5250 owner = class_2561.method_43469((String)"mapfrontiers.owner", (Object[])new Object[]{this.frontier.getOwner()});
        this.labels.add(new SimpleLabel(this.field_22793, rightSide + offset1 + offset2, top, SimpleLabel.Align.Left, (class_2561)owner, -1));
        class_5250 dimension = class_2561.method_43469((String)"mapfrontiers.dimension", (Object[])new Object[]{this.frontier.getDimension().method_29177().toString()});
        this.labels.add(new SimpleLabel(this.field_22793, rightSide, top + 10, SimpleLabel.Align.Left, (class_2561)dimension, -6710887));
        class_5250 area = class_2561.method_43469((String)"mapfrontiers.area", (Object[])new Object[]{Float.valueOf(this.frontier.area)});
        this.labels.add(new SimpleLabel(this.field_22793, rightSide, top + 32, SimpleLabel.Align.Left, (class_2561)area, -1));
        class_5250 perimeter = class_2561.method_43469((String)"mapfrontiers.perimeter", (Object[])new Object[]{Float.valueOf(this.frontier.perimeter)});
        this.labels.add(new SimpleLabel(this.field_22793, rightSide, top + 42, SimpleLabel.Align.Left, (class_2561)perimeter, -1));
        if (this.frontier.getCreated() != null) {
            class_5250 created = class_2561.method_43469((String)"mapfrontiers.created", (Object[])new Object[]{dateFormat.format(this.frontier.getCreated())});
            this.labels.add(new SimpleLabel(this.field_22793, rightSide + 154, top + 32, SimpleLabel.Align.Left, (class_2561)created, -1));
        }
        if (this.frontier.getModified() != null) {
            class_5250 modified = class_2561.method_43469((String)"mapfrontiers.modified", (Object[])new Object[]{dateFormat.format(this.frontier.getModified())});
            this.modifiedLabel = new SimpleLabel(this.field_22793, rightSide + 154, top + 42, SimpleLabel.Align.Left, (class_2561)modified, -1);
            this.labels.add(this.modifiedLabel);
        }
        this.buttonSelect = new SimpleButton(this.field_22793, leftSide - 154, top + 290, 144, (class_2561)class_2561.method_43471((String)"mapfrontiers.select_in_map"), this::buttonPressed);
        this.buttonShareSettings = new SimpleButton(this.field_22793, leftSide, top + 290, 144, (class_2561)class_2561.method_43471((String)"mapfrontiers.share_settings"), this::buttonPressed);
        this.buttonDelete = new SimpleButton(this.field_22793, rightSide, top + 290, 144, (class_2561)class_2561.method_43471((String)"mapfrontiers.delete"), this::buttonPressed);
        this.buttonDelete.setTextColors(-34953, -65536);
        this.buttonDone = new SimpleButton(this.field_22793, rightSide + 154, top + 290, 144, (class_2561)class_2561.method_43471((String)"gui.done"), this::buttonPressed);
        this.buttonBanner = new SimpleButton(this.field_22793, leftSide - 152, top, 144, (class_2561)class_2561.method_43471((String)"mapfrontiers.assign_banner"), this::buttonPressed);
        this.sliderBannerRotation = new SimpleSlider(this.field_22793, leftSide - 152, top + 20, 144, "mapfrontiers.banner_rotation", 0, 360, this.frontier.hasBanner() ? this.frontier.getBannerRotation() : 0, (angle, dragging) -> {
            this.frontier.setBannerRotation(angle);
            if (!dragging) {
                this.sendChangesToServer();
            }
        });
        this.method_37063((class_364)this.textName1);
        this.method_37063((class_364)this.textName2);
        this.method_37063((class_364)this.buttonVisible);
        this.method_37063((class_364)this.buttonFullscreenVisible);
        this.method_37063((class_364)this.buttonFullscreenNameVisible);
        this.method_37063((class_364)this.buttonFullscreenOwnerVisible);
        this.method_37063((class_364)this.buttonMinimapVisible);
        this.method_37063((class_364)this.buttonMinimapNameVisible);
        this.method_37063((class_364)this.buttonMinimapOwnerVisible);
        this.method_37063((class_364)this.buttonAnnounceInChat);
        this.method_37063((class_364)this.buttonAnnounceInTitle);
        this.method_37063((class_364)this.textRed);
        this.method_37063((class_364)this.textGreen);
        this.method_37063((class_364)this.textBlue);
        this.method_37063((class_364)this.buttonRandomColor);
        this.method_37063((class_364)this.colorPicker);
        this.method_37063((class_364)this.buttonCopy);
        this.method_37063((class_364)this.buttonPaste);
        this.method_37063((class_364)this.buttonOpenPasteOptions);
        this.method_37063((class_364)this.buttonClosePasteOptions);
        this.method_37063((class_364)this.buttonPasteName);
        this.method_37063((class_364)this.buttonPasteVisibility);
        this.method_37063((class_364)this.buttonPasteColor);
        this.method_37063((class_364)this.buttonPasteBanner);
        this.method_37063((class_364)this.buttonUndo);
        this.method_37063((class_364)this.buttonRedo);
        this.method_37063((class_364)this.buttonSelect);
        this.method_37063((class_364)this.buttonShareSettings);
        this.method_37063((class_364)this.buttonDelete);
        this.method_37063((class_364)this.buttonDone);
        this.method_37063((class_364)this.buttonBanner);
        this.method_37063((class_364)this.sliderBannerRotation);
        this.updateBannerButton();
        this.updateButtons();
        this.updatePasteOptionsVisibility();
        this.updateUndoRedoVisibility();
    }

    public void method_25393() {
        this.textName1.method_1865();
        this.textName2.method_1865();
        this.textRed.method_1865();
        this.textGreen.method_1865();
        this.textBlue.method_1865();
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(graphics);
        mouseX = (int)((float)mouseX * this.scaleFactor);
        mouseY = (int)((float)mouseY * this.scaleFactor);
        if (this.scaleFactor != 1.0f) {
            graphics.method_51448().method_22903();
            graphics.method_51448().method_22905(1.0f / this.scaleFactor, 1.0f / this.scaleFactor, 1.0f);
        }
        graphics.method_27534(this.field_22793, this.field_22785, this.actualWidth / 2, 8, -1);
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        if (this.frontier.hasBanner()) {
            this.frontier.renderBanner(this.field_22787, graphics, this.actualWidth / 2 - 265, this.actualHeight / 2 - 94, 3);
        }
        for (SimpleLabel label : this.labels) {
            if (!label.field_22764) continue;
            label.method_25394(graphics, mouseX, mouseY, partialTicks);
        }
        if (this.buttonBanner.field_22764 && this.buttonBanner.method_49606()) {
            if (!this.frontier.hasBanner() && FrontierInfo.getHeldBanner(this.field_22787) == null) {
                class_5250 prefix = class_2561.method_43470((String)(String.valueOf(ColorConstants.WARNING) + "! " + String.valueOf(class_124.field_1070)));
                graphics.method_51438(this.field_22793, (class_2561)prefix.method_10852((class_2561)class_2561.method_43471((String)"mapfrontiers.assign_banner_warn")), mouseX, mouseY);
            }
        } else if (this.buttonCopy.method_49606()) {
            graphics.method_51438(this.field_22793, (class_2561)class_2561.method_43471((String)"mapfrontiers.copy"), mouseX, mouseY);
        } else if (this.buttonPaste.field_22764 && this.buttonPaste.method_49606()) {
            graphics.method_51438(this.field_22793, (class_2561)class_2561.method_43471((String)"mapfrontiers.paste"), mouseX, mouseY);
        } else if (this.buttonOpenPasteOptions.field_22764 && this.buttonOpenPasteOptions.method_49606()) {
            graphics.method_51438(this.field_22793, (class_2561)class_2561.method_43471((String)"mapfrontiers.open_paste_options"), mouseX, mouseY);
        } else if (this.buttonClosePasteOptions.field_22764 && this.buttonClosePasteOptions.method_49606()) {
            graphics.method_51438(this.field_22793, (class_2561)class_2561.method_43471((String)"mapfrontiers.close_paste_options"), mouseX, mouseY);
        } else if (this.buttonUndo.field_22764 && this.buttonUndo.method_49606()) {
            graphics.method_51438(this.field_22793, (class_2561)class_2561.method_43471((String)"mapfrontiers.undo"), mouseX, mouseY);
        } else if (this.buttonRedo.field_22764 && this.buttonRedo.method_49606()) {
            graphics.method_51438(this.field_22793, (class_2561)class_2561.method_43471((String)"mapfrontiers.redo"), mouseX, mouseY);
        }
        if (this.scaleFactor != 1.0f) {
            graphics.method_51448().method_22909();
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        mouseX *= (double)this.scaleFactor;
        mouseY *= (double)this.scaleFactor;
        if (mouseButton == 0) {
            this.textName1.method_25402(mouseX, mouseY, mouseButton);
            this.textName2.method_25402(mouseX, mouseY, mouseButton);
            this.textRed.method_25402(mouseX, mouseY, mouseButton);
            this.textGreen.method_25402(mouseX, mouseY, mouseButton);
            this.textBlue.method_25402(mouseX, mouseY, mouseButton);
        }
        return super.method_25402(mouseX, mouseY, mouseButton);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        mouseX *= (double)this.scaleFactor;
        mouseY *= (double)this.scaleFactor;
        for (class_364 w : this.method_25396()) {
            if (!(w instanceof ColorPicker)) continue;
            w.method_25406(mouseX, mouseY, button);
        }
        this.sliderBannerRotation.mouseReleased();
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        return super.method_25401(mouseX * (double)this.scaleFactor, mouseY * (double)this.scaleFactor, delta);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return super.method_25403(mouseX * (double)this.scaleFactor, mouseY * (double)this.scaleFactor, button, dragX * (double)this.scaleFactor, dragY * (double)this.scaleFactor);
    }

    public boolean method_25404(int key, int value, int modifier) {
        if (key == 90 && class_437.method_25441() && !class_437.method_25442() && !class_437.method_25443()) {
            this.undo();
            return true;
        }
        if (key == 90 && class_437.method_25441() && class_437.method_25442() && !class_437.method_25443()) {
            this.redo();
            return true;
        }
        return super.method_25404(key, value, modifier);
    }

    protected void buttonPressed(class_4185 button) {
        if (button == this.buttonVisible) {
            this.frontier.setVisible(this.buttonVisible.getSelected() == 0);
            this.sendChangesToServer();
        } else if (button == this.buttonFullscreenVisible) {
            this.frontier.setFullscreenVisible(this.buttonFullscreenVisible.getSelected() == 0);
            this.sendChangesToServer();
        } else if (button == this.buttonFullscreenNameVisible) {
            this.frontier.setFullscreenNameVisible(this.buttonFullscreenNameVisible.getSelected() == 0);
            this.sendChangesToServer();
        } else if (button == this.buttonFullscreenOwnerVisible) {
            this.frontier.setFullscreenOwnerVisible(this.buttonFullscreenOwnerVisible.getSelected() == 0);
            this.sendChangesToServer();
        } else if (button == this.buttonMinimapVisible) {
            this.frontier.setMinimapVisible(this.buttonMinimapVisible.getSelected() == 0);
            this.sendChangesToServer();
        } else if (button == this.buttonMinimapNameVisible) {
            this.frontier.setMinimapNameVisible(this.buttonMinimapNameVisible.getSelected() == 0);
            this.sendChangesToServer();
        } else if (button == this.buttonMinimapOwnerVisible) {
            this.frontier.setMinimapOwnerVisible(this.buttonMinimapOwnerVisible.getSelected() == 0);
            this.sendChangesToServer();
        } else if (button == this.buttonAnnounceInChat) {
            this.frontier.setAnnounceInChat(this.buttonAnnounceInChat.getSelected() == 0);
            this.sendChangesToServer();
        } else if (button == this.buttonAnnounceInTitle) {
            this.frontier.setAnnounceInTitle(this.buttonAnnounceInTitle.getSelected() == 0);
            this.sendChangesToServer();
        } else if (button == this.buttonRandomColor) {
            int newColor = ColorHelper.getRandomColor();
            this.frontier.setColor(newColor);
            this.colorPicker.setColor(newColor);
            this.textRed.setValue((newColor & 0xFF0000) >> 16);
            this.textGreen.setValue((newColor & 0xFF00) >> 8);
            this.textBlue.setValue(newColor & 0xFF);
            this.sendChangesToServer();
        } else if (button == this.buttonCopy) {
            MapFrontiersClient.setClipboard(this.frontier);
            this.updatePasteOptionsVisibility();
        } else if (button == this.buttonPaste) {
            FrontierData clipboard = MapFrontiersClient.getClipboard();
            if (clipboard != null && (Config.pasteName || Config.pasteVisibility || Config.pasteColor || Config.pasteBanner)) {
                this.setFrontier(clipboard, Config.pasteName, Config.pasteVisibility, Config.pasteColor, Config.pasteBanner);
                this.sendChangesToServer();
                this.method_25423(this.field_22787, this.field_22789, this.field_22790);
            }
        } else if (button == this.buttonOpenPasteOptions) {
            Config.pasteOptionsVisible = true;
            this.updatePasteOptionsVisibility();
            ClientEventHandler.postUpdatedConfigEvent();
        } else if (button == this.buttonClosePasteOptions) {
            Config.pasteOptionsVisible = false;
            this.updatePasteOptionsVisibility();
            ClientEventHandler.postUpdatedConfigEvent();
        } else if (button == this.buttonPasteName) {
            Config.pasteName = this.buttonPasteName.getSelected() == 0;
            ClientEventHandler.postUpdatedConfigEvent();
        } else if (button == this.buttonPasteVisibility) {
            Config.pasteVisibility = this.buttonPasteVisibility.getSelected() == 0;
            ClientEventHandler.postUpdatedConfigEvent();
        } else if (button == this.buttonPasteColor) {
            Config.pasteColor = this.buttonPasteColor.getSelected() == 0;
            ClientEventHandler.postUpdatedConfigEvent();
        } else if (button == this.buttonPasteBanner) {
            Config.pasteBanner = this.buttonPasteBanner.getSelected() == 0;
            ClientEventHandler.postUpdatedConfigEvent();
        } else if (button == this.buttonUndo) {
            this.undo();
        } else if (button == this.buttonRedo) {
            this.redo();
        } else if (button == this.buttonSelect) {
            class_2338 center = this.frontier.getCenter();
            Services.PLATFORM.popGuiLayer();
            Services.JOURNEYMAP.fullscreenMapCenterOn(center.method_10263(), center.method_10260());
        } else if (button == this.buttonShareSettings) {
            Services.PLATFORM.pushGuiLayer(new ShareSettings(this.frontiersOverlayManager, this.frontier));
        } else if (button == this.buttonDelete) {
            ClientEventHandler.unsuscribeAllEvents((Object)this);
            this.frontiersOverlayManager.clientDeleteFrontier(this.frontier);
            this.method_25419();
        } else if (button == this.buttonDone) {
            this.method_25419();
        } else if (button == this.buttonBanner) {
            if (!this.frontier.hasBanner()) {
                class_1799 heldBanner = FrontierInfo.getHeldBanner(this.field_22787);
                if (heldBanner != null) {
                    this.frontier.setBanner(heldBanner);
                }
            } else {
                this.frontier.setBanner(null);
                this.sliderBannerRotation.setValue(0);
            }
            this.updateBannerButton();
            this.sendChangesToServer();
        }
    }

    public void method_25432() {
        this.sendChangesToServer();
        ClientEventHandler.unsuscribeAllEvents((Object)this);
    }

    public void method_25419() {
        Services.PLATFORM.popGuiLayer();
        if (this.afterClose != null) {
            this.afterClose.run();
        }
    }

    private void colorPickerUpdated(boolean dragging) {
        this.frontier.setColor(this.colorPicker.getColor());
        this.textRed.setValue((this.frontier.getColor() & 0xFF0000) >> 16);
        this.textGreen.setValue((this.frontier.getColor() & 0xFF00) >> 8);
        this.textBlue.setValue(this.frontier.getColor() & 0xFF);
        if (!dragging) {
            this.sendChangesToServer();
        }
    }

    private void undo() {
        if (this.undoStack.size() == 1) {
            return;
        }
        this.redoStack.push(this.undoStack.pop());
        this.setFrontier(this.undoStack.peek(), true, true, true, true);
        this.sendChangesToServer();
        this.method_25423(this.field_22787, this.field_22789, this.field_22790);
    }

    private void redo() {
        if (this.redoStack.empty()) {
            return;
        }
        this.setFrontier(this.redoStack.peek(), true, true, true, true);
        this.undoStack.push(this.redoStack.pop());
        this.sendChangesToServer();
        this.method_25423(this.field_22787, this.field_22789, this.field_22790);
    }

    private void setFrontier(FrontierData other, boolean name, boolean visibility, boolean color, boolean banner) {
        if (name) {
            this.frontier.setName1(other.getName1());
            this.frontier.setName2(other.getName2());
        }
        if (visibility) {
            this.frontier.setVisible(other.getVisible());
            this.frontier.setFullscreenVisible(other.getFullscreenVisible());
            this.frontier.setFullscreenNameVisible(other.getFullscreenNameVisible());
            this.frontier.setFullscreenOwnerVisible(other.getFullscreenOwnerVisible());
            this.frontier.setMinimapVisible(other.getMinimapVisible());
            this.frontier.setMinimapNameVisible(other.getMinimapNameVisible());
            this.frontier.setMinimapOwnerVisible(other.getMinimapOwnerVisible());
            this.frontier.setAnnounceInChat(other.getAnnounceInChat());
            this.frontier.setAnnounceInTitle(other.getAnnounceInTitle());
        }
        if (color) {
            this.frontier.setColor(other.getColor());
        }
        if (banner) {
            this.frontier.setBannerData(other.getbannerData());
        }
    }

    private void updateBannerButton() {
        if (!this.frontier.hasBanner()) {
            class_5250 message = class_2561.method_43471((String)"mapfrontiers.assign_banner");
            if (FrontierInfo.getHeldBanner(this.field_22787) == null) {
                message.method_10852((class_2561)class_2561.method_43470((String)(String.valueOf(ColorConstants.WARNING) + " !")));
            }
            this.buttonBanner.method_25355((class_2561)message);
            this.sliderBannerRotation.field_22764 = false;
        } else {
            this.buttonBanner.method_25355((class_2561)class_2561.method_43471((String)"mapfrontiers.remove_banner"));
            this.sliderBannerRotation.field_22764 = true;
        }
    }

    private static class_1799 getHeldBanner(@Nullable class_310 minecraft) {
        if (minecraft == null || minecraft.field_1724 == null) {
            return null;
        }
        class_1799 mainhand = minecraft.field_1724.method_6118(class_1304.field_6173);
        class_1799 offhand = minecraft.field_1724.method_6118(class_1304.field_6171);
        class_1799 heldBanner = null;
        if (mainhand.method_7909() instanceof class_1746) {
            heldBanner = mainhand;
        } else if (offhand.method_7909() instanceof class_1746) {
            heldBanner = offhand;
        }
        return heldBanner;
    }

    private void updateButtons() {
        if (this.field_22787.field_1724 == null) {
            return;
        }
        SettingsProfile profile = MapFrontiersClient.getSettingsProfile();
        SettingsUser playerUser = new SettingsUser((class_1657)this.field_22787.field_1724);
        SettingsProfile.AvailableActions actions = SettingsProfile.getAvailableActions(profile, this.frontier, playerUser);
        this.textName1.method_1888(actions.canUpdate);
        this.textName2.method_1888(actions.canUpdate);
        this.buttonVisible.field_22763 = actions.canUpdate;
        this.buttonFullscreenVisible.field_22763 = actions.canUpdate;
        this.buttonFullscreenNameVisible.field_22763 = actions.canUpdate;
        this.buttonFullscreenOwnerVisible.field_22763 = actions.canUpdate;
        this.buttonMinimapVisible.field_22763 = actions.canUpdate;
        this.buttonMinimapNameVisible.field_22763 = actions.canUpdate;
        this.buttonMinimapOwnerVisible.field_22763 = actions.canUpdate;
        this.buttonAnnounceInChat.field_22763 = actions.canUpdate;
        this.buttonAnnounceInTitle.field_22763 = actions.canUpdate;
        this.textRed.method_1888(actions.canUpdate);
        this.textGreen.method_1888(actions.canUpdate);
        this.textBlue.method_1888(actions.canUpdate);
        this.buttonRandomColor.field_22764 = actions.canUpdate;
        this.colorPicker.field_22763 = actions.canUpdate;
        this.buttonPaste.field_22763 = actions.canUpdate;
        this.buttonOpenPasteOptions.field_22763 = actions.canUpdate;
        this.buttonClosePasteOptions.field_22763 = actions.canUpdate;
        this.buttonDelete.field_22764 = actions.canDelete;
        this.buttonBanner.field_22764 = actions.canUpdate;
        this.sliderBannerRotation.field_22764 = actions.canUpdate && this.frontier.hasBanner();
        UIState uiState = this.jmAPI.getUIState(Context.UI.Fullscreen);
        this.buttonSelect.field_22764 = uiState != null && this.frontier.getDimension().equals((Object)uiState.dimension);
        this.buttonShareSettings.field_22764 = actions.canShare;
    }

    private void updatePasteOptionsVisibility() {
        this.buttonPaste.field_22764 = MapFrontiersClient.getClipboard() != null;
        this.buttonOpenPasteOptions.field_22764 = this.buttonPaste.field_22764 && !Config.pasteOptionsVisible;
        this.buttonClosePasteOptions.field_22764 = this.buttonPaste.field_22764 && Config.pasteOptionsVisible;
        this.buttonPasteName.field_22764 = this.buttonPaste.field_22764 && Config.pasteOptionsVisible;
        this.buttonPasteVisibility.field_22764 = this.buttonPaste.field_22764 && Config.pasteOptionsVisible;
        this.buttonPasteColor.field_22764 = this.buttonPaste.field_22764 && Config.pasteOptionsVisible;
        this.buttonPasteBanner.field_22764 = this.buttonPaste.field_22764 && Config.pasteOptionsVisible;
        this.labelPasteName.field_22764 = this.buttonPaste.field_22764 && Config.pasteOptionsVisible;
        this.labelPasteVisibility.field_22764 = this.buttonPaste.field_22764 && Config.pasteOptionsVisible;
        this.labelPasteColor.field_22764 = this.buttonPaste.field_22764 && Config.pasteOptionsVisible;
        this.labelPasteBanner.field_22764 = this.buttonPaste.field_22764 && Config.pasteOptionsVisible;
    }

    private void updateUndoRedoVisibility() {
        this.buttonUndo.field_22764 = this.buttonPaste.field_22763 && this.undoStack.size() > 1;
        this.buttonRedo.field_22764 = this.buttonPaste.field_22763 && this.redoStack.size() > 0;
    }

    private void sendChangesToServer() {
        this.frontiersOverlayManager.clientUpdateFrontier(this.frontier);
    }

    private void addToUndo(FrontierData frontier) {
        FrontierData u;
        boolean add = this.undoStack.empty();
        if (!(add || Objects.equals((u = this.undoStack.peek()).getName1(), frontier.getName1()) && Objects.equals(u.getName2(), frontier.getName2()) && u.getVisible() == frontier.getVisible() && u.getFullscreenVisible() == frontier.getFullscreenVisible() && u.getFullscreenNameVisible() == frontier.getFullscreenNameVisible() && u.getFullscreenOwnerVisible() == frontier.getFullscreenOwnerVisible() && u.getMinimapVisible() == frontier.getMinimapVisible() && u.getMinimapNameVisible() == frontier.getMinimapNameVisible() && u.getMinimapOwnerVisible() == frontier.getMinimapOwnerVisible() && u.getAnnounceInChat() == frontier.getAnnounceInChat() && u.getAnnounceInTitle() == frontier.getAnnounceInTitle() && u.getColor() == frontier.getColor() && Objects.equals(u.getbannerData(), frontier.getbannerData()))) {
            add = true;
        }
        if (add) {
            this.undoStack.push(frontier);
            if (!this.redoStack.empty()) {
                this.redoStack.clear();
            }
            this.updateUndoRedoVisibility();
        }
    }
}

