/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common.network;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.FrontiersManager;
import games.alejandrocoria.mapfrontiers.common.network.PacketFrontierUpdated;
import games.alejandrocoria.mapfrontiers.common.network.PacketHandler;
import games.alejandrocoria.mapfrontiers.common.network.PacketSettingsProfile;
import games.alejandrocoria.mapfrontiers.common.settings.FrontierSettings;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUserShared;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

@ParametersAreNonnullByDefault
public class PacketUpdateFrontier {
    public static final class_2960 CHANNEL = new class_2960("mapfrontiers", "packet_update_frontier");
    private final FrontierData frontier;

    public PacketUpdateFrontier() {
        this.frontier = new FrontierData();
    }

    public PacketUpdateFrontier(FrontierData frontier) {
        this.frontier = frontier;
    }

    public static PacketUpdateFrontier decode(class_2540 buf) {
        PacketUpdateFrontier packet = new PacketUpdateFrontier();
        packet.frontier.fromBytes(buf);
        return packet;
    }

    public void encode(class_2540 buf) {
        this.frontier.toBytes(buf);
    }

    public static void handle(PacketContext<PacketUpdateFrontier> ctx) {
        if (Side.SERVER.equals((Object)ctx.side())) {
            PacketUpdateFrontier message = (PacketUpdateFrontier)ctx.message();
            class_3222 player = ctx.sender();
            if (player == null) {
                return;
            }
            MinecraftServer server = player.field_13995;
            SettingsUser playerUser = new SettingsUser((class_1657)player);
            FrontierData currentFrontier = FrontiersManager.instance.getFrontierFromID(message.frontier.getId());
            if (currentFrontier != null) {
                message.frontier.setPersonal(currentFrontier.getPersonal());
                if (!currentFrontier.getOwner().isEmpty()) {
                    message.frontier.setOwner(currentFrontier.getOwner());
                }
                message.frontier.setUsersShared(currentFrontier.getUsersShared());
                message.frontier.removeChange(FrontierData.Change.Shared);
                if (message.frontier.getPersonal()) {
                    boolean updated;
                    if (currentFrontier.checkActionUserShared(playerUser, SettingsUserShared.Action.UpdateFrontier) && (updated = FrontiersManager.instance.updatePersonalFrontier(message.frontier.getOwner(), message.frontier))) {
                        if (message.frontier.getUsersShared() != null) {
                            for (SettingsUserShared userShared : message.frontier.getUsersShared()) {
                                FrontiersManager.instance.updatePersonalFrontier(userShared.getUser(), message.frontier);
                            }
                        }
                        PacketHandler.sendToUsersWithAccess(new PacketFrontierUpdated(message.frontier, player.method_5628()), message.frontier, server);
                    }
                    return;
                }
                if (FrontiersManager.instance.getSettings().checkAction(FrontierSettings.Action.UpdateGlobalFrontier, playerUser, MapFrontiers.isOPorHost(player), message.frontier.getOwner())) {
                    boolean updated = FrontiersManager.instance.updateGlobalFrontier(message.frontier);
                    if (updated) {
                        PacketHandler.sendToAll(new PacketFrontierUpdated(message.frontier, player.method_5628()), server);
                    }
                    return;
                }
                PacketHandler.sendTo(new PacketSettingsProfile(FrontiersManager.instance.getSettings().getProfile(player)), player);
            }
        }
    }
}

