/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client;

import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.client.FrontierOverlay;
import games.alejandrocoria.mapfrontiers.common.Config;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_310;
import net.minecraft.class_3544;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class ChatFrontiers {
    private static int receivedId = -1;
    private static final List<String> receivedData = new ArrayList<String>();
    private static final LinkedHashMap<Integer, FrontierData> receivedFrontiers = LinkedHashMap.newLinkedHashMap(3);

    public static void clear() {
        receivedId = -1;
        receivedData.clear();
        receivedFrontiers.clear();
    }

    @Nullable
    public static FrontierData getReceivedFrontier(int id) {
        return receivedFrontiers.get(id);
    }

    public static void removeReceivedId(int id) {
        receivedFrontiers.remove(id);
    }

    public static void sendFrontier(FrontierOverlay frontier, SettingsUser user) {
        try {
            class_2487 nbt = new class_2487();
            frontier.writeToNBT(nbt);
            String encodedData = ChatFrontiers.encodeNBT(nbt);
            String command = Config.sendCommand + " " + user.username + " #MapFrontiers:";
            String format = "%d:%d:%d:%d:%s";
            ArrayList<String> dataList = new ArrayList<String>();
            int maxLength = 255 - command.length() - format.length();
            int dataLength = encodedData.length();
            for (int i = 0; i < dataLength; i += maxLength) {
                int end = Math.min(dataLength, i + maxLength);
                dataList.add(encodedData.substring(i, end));
            }
            int RandomId = new Random().nextInt(999) + 1;
            for (int i = 0; i < dataList.size(); ++i) {
                String message = command + String.format(format, 10, RandomId, i + 1, dataList.size(), dataList.get(i));
                class_310.method_1551().field_1724.field_3944.method_45730(message);
            }
        }
        catch (Throwable t) {
            MapFrontiers.LOGGER.error("Failed to send frontier {} {} to user {}: {}", (Object)frontier.getName1(), (Object)frontier.getName2(), (Object)user.username, (Object)t);
        }
    }

    public static boolean receiveFrontierFromChat(class_2561 messageComponent, @Nullable UUID sender) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null || sender == null) {
            return false;
        }
        String message = messageComponent.getString();
        int startIndex = message.indexOf("#MapFrontiers:");
        if (startIndex == -1) {
            return false;
        }
        if (player.method_5667().equals(sender)) {
            return true;
        }
        message = message.substring(startIndex);
        try {
            String[] parts = message.split(":", 6);
            if (parts.length != 6) {
                throw new IllegalArgumentException();
            }
            int version = Integer.parseInt(parts[1]);
            int id = Integer.parseInt(parts[2]);
            int index = Integer.parseInt(parts[3]);
            int total = Integer.parseInt(parts[4]);
            String data = parts[5];
            if (id > 999) {
                throw new IllegalArgumentException();
            }
            if (index < 1 || index > total) {
                throw new IllegalArgumentException();
            }
            if (id != receivedId || total != receivedData.size() || !class_3544.method_57181((String)receivedData.get(index - 1))) {
                receivedData.clear();
                receivedData.addAll(Collections.nCopies(total, ""));
                receivedId = id;
            }
            receivedData.set(index - 1, data);
            if (receivedData.stream().noneMatch(String::isBlank)) {
                String encodedData = String.join((CharSequence)"", receivedData);
                FrontierData frontier = new FrontierData();
                frontier.readFromNBT(ChatFrontiers.decodeNBT(encodedData), version);
                frontier.setCopiedFromId(frontier.getId());
                frontier.setCopiedFromUser(frontier.getOwner());
                frontier.setId(UUID.randomUUID());
                frontier.setOwner(new SettingsUser((class_1657)player));
                frontier.setPersonal(true);
                receivedFrontiers.remove(receivedId);
                if (receivedFrontiers.size() == 3) {
                    Iterator<Map.Entry<Integer, FrontierData>> iterator = receivedFrontiers.entrySet().iterator();
                    iterator.next();
                    iterator.remove();
                }
                receivedFrontiers.putLast(receivedId, frontier);
                Object frontierName = frontier.getName1().isEmpty() && frontier.getName2().isEmpty() ? "Unnamed Frontier" : (frontier.getName1().isEmpty() ? frontier.getName2() : (frontier.getName2().isEmpty() ? frontier.getName1() : frontier.getName1() + " " + frontier.getName2()));
                class_5250 button = class_2561.method_43470((String)frontierName);
                button.method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)("Click to accept or use command /mfacceptcopy " + receivedId)))));
                button.method_27694(style -> style.method_10982(Boolean.valueOf(true)));
                button.method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/mapfrontiersacceptcopy " + receivedId)));
                SettingsUser userSender = new SettingsUser();
                userSender.uuid = sender;
                userSender.fillMissingInfo(true, null);
                class_5250 text = class_2561.method_43470((String)(userSender.toString("User not found") + " "));
                if (userSender.equals(frontier.getCopiedFromUser())) {
                    text.method_27693("want to send a frontier to you: ");
                } else {
                    text.method_27693("want to send a frontier of " + frontier.getCopiedFromUser().toString("User not found") + " to you: ");
                }
                text.method_10852((class_2561)button);
                player.method_7353((class_2561)text, false);
                receivedId = -1;
            }
        }
        catch (Throwable t) {
            MapFrontiers.LOGGER.error("Failed to parse frontier from chat: \"{}\"\n{}", (Object)message, (Object)t);
            return false;
        }
        return true;
    }

    private static String encodeNBT(class_2487 nbt) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (DataOutputStream dos = new DataOutputStream(baos);){
            class_2507.method_10634((class_2487)nbt, (OutputStream)dos);
        }
        byte[] compressedBytes = baos.toByteArray();
        return Base64.getEncoder().encodeToString(compressedBytes);
    }

    private static class_2487 decodeNBT(String base64) throws IOException {
        byte[] data = Base64.getDecoder().decode(base64);
        try (DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));){
            class_2487 class_24872 = class_2507.method_10629((InputStream)dis, (class_2505)class_2505.method_53899((long)16384L));
            return class_24872;
        }
    }
}

