/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client;

import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.platform.Services;
import it.unimi.dsi.fastutil.Pair;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_310;

public class FrontierLocalOverrides {
    private final Map<UUID, Pair<FrontierData.VisibilityData, FrontierData.VisibilityData>> overrides = new HashMap<UUID, Pair<FrontierData.VisibilityData, FrontierData.VisibilityData>>();
    private File ModDir;

    public FrontierLocalOverrides() {
        this.loadData();
    }

    public Pair<FrontierData.VisibilityData, FrontierData.VisibilityData> getVisibility(UUID id) {
        Pair<FrontierData.VisibilityData, FrontierData.VisibilityData> override = this.overrides.get(id);
        if (override == null) {
            return Pair.of((Object)new FrontierData.VisibilityData(), (Object)new FrontierData.VisibilityData(false));
        }
        return override;
    }

    public void setVisibility(UUID id, Pair<FrontierData.VisibilityData, FrontierData.VisibilityData> visibility) {
        if (((FrontierData.VisibilityData)visibility.second()).hasSome()) {
            this.overrides.put(id, visibility);
        } else {
            this.overrides.remove(id);
        }
        this.saveData();
    }

    private boolean readFromNBT(class_2487 nbt) {
        boolean needBackup = false;
        try {
            int version = nbt.method_10550("Version");
            if (version == 0) {
                MapFrontiers.LOGGER.warn("Data version in frontier_overrides not found, expected 10");
                needBackup = true;
            } else if (version > 10) {
                MapFrontiers.LOGGER.warn("Data version in frontier_overrides higher than expected. The mod uses 10");
                needBackup = true;
            }
            class_2499 overridesTagList = nbt.method_10554("overrides", 10);
            for (int i = 0; i < overridesTagList.size(); ++i) {
                class_2487 overrideTag = overridesTagList.method_10602(i);
                UUID id = UUID.fromString(overrideTag.method_10558("id"));
                class_2487 dataTag = overrideTag.method_10562("data");
                FrontierData.VisibilityData data = new FrontierData.VisibilityData();
                data.readFromNBT(dataTag, version);
                class_2487 maskTag = overrideTag.method_10562("mask");
                FrontierData.VisibilityData mask = new FrontierData.VisibilityData(false);
                mask.readFromNBT(maskTag, version);
                if (!mask.hasSome()) continue;
                this.overrides.put(id, (Pair<FrontierData.VisibilityData, FrontierData.VisibilityData>)Pair.of((Object)data, (Object)mask));
            }
        }
        catch (Exception ignored) {
            return true;
        }
        return needBackup;
    }

    private void writeToNBT(class_2487 nbt) {
        class_2499 overridesTagList = new class_2499();
        for (Map.Entry<UUID, Pair<FrontierData.VisibilityData, FrontierData.VisibilityData>> override : this.overrides.entrySet()) {
            class_2487 overrideTag = new class_2487();
            overrideTag.method_10582("id", override.getKey().toString());
            class_2487 dataTag = new class_2487();
            ((FrontierData.VisibilityData)override.getValue().first()).writeToNBT(dataTag);
            overrideTag.method_10566("data", (class_2520)dataTag);
            class_2487 maskTag = new class_2487();
            ((FrontierData.VisibilityData)override.getValue().second()).writeToNBT(maskTag);
            overrideTag.method_10566("mask", (class_2520)maskTag);
            overridesTagList.add((Object)overrideTag);
        }
        nbt.method_10566("overrides", (class_2520)overridesTagList);
        nbt.method_10569("Version", 10);
    }

    private void loadData() {
        try {
            File jmDir = Services.JOURNEYMAP.getJMWorldDir(class_310.method_1551());
            this.ModDir = new File(jmDir, "mapfrontier");
            this.ModDir.mkdirs();
            class_2487 nbtFrontiers = this.loadFile("frontier_overrides.dat");
            if (!nbtFrontiers.method_33133() && this.readFromNBT(nbtFrontiers)) {
                MapFrontiers.createBackup(this.ModDir, "frontier_overrides.dat");
                this.saveData();
            }
        }
        catch (Exception e) {
            MapFrontiers.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private void saveData() {
        if (this.ModDir != null) {
            class_2487 nbtFrontiers = new class_2487();
            this.writeToNBT(nbtFrontiers);
            this.saveFile("frontier_overrides.dat", nbtFrontiers);
        }
    }

    private void saveFile(String filename, class_2487 nbt) {
        try {
            File f = new File(this.ModDir, filename);
            try (FileOutputStream outputStream = new FileOutputStream(f);){
                class_2507.method_10634((class_2487)nbt, (OutputStream)outputStream);
            }
            catch (Exception e) {
                MapFrontiers.LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        catch (Exception e) {
            MapFrontiers.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private class_2487 loadFile(String filename) {
        File f = new File(this.ModDir, filename);
        if (f.exists()) {
            class_2487 class_24872;
            FileInputStream inputStream = new FileInputStream(f);
            try {
                class_24872 = class_2507.method_10629((InputStream)inputStream, (class_2505)class_2505.method_53898());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    MapFrontiers.LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
            inputStream.close();
            return class_24872;
        }
        return new class_2487();
    }
}

