/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui;

import games.alejandrocoria.mapfrontiers.client.FrontierOverlay;
import games.alejandrocoria.mapfrontiers.client.FrontiersOverlayManager;
import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.client.event.ClientEventHandler;
import games.alejandrocoria.mapfrontiers.client.gui.dialog.ConfirmationDialog;
import games.alejandrocoria.mapfrontiers.client.gui.dialog.DeleteConfirmationDialog;
import games.alejandrocoria.mapfrontiers.client.gui.screen.FrontierInfo;
import games.alejandrocoria.mapfrontiers.client.gui.screen.FrontierList;
import games.alejandrocoria.mapfrontiers.client.gui.screen.NewFrontier;
import games.alejandrocoria.mapfrontiers.common.Config;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsProfile;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.api.v2.client.IClientAPI;
import journeymap.api.v2.client.display.Context;
import journeymap.api.v2.client.fullscreen.IThemeButton;
import journeymap.api.v2.client.fullscreen.ModPopupMenu;
import journeymap.api.v2.client.fullscreen.ThemeButtonDisplay;
import journeymap.api.v2.client.util.UIState;
import net.minecraft.class_1074;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_746;

@ParametersAreNonnullByDefault
public class FullscreenMap {
    private final IClientAPI jmAPI;
    private FrontierOverlay frontierHighlighted;
    private IThemeButton buttonFrontiers;
    private IThemeButton buttonNew;
    private IThemeButton buttonInfo;
    private IThemeButton buttonEdit;
    private IThemeButton buttonVisible;
    private IThemeButton buttonDelete;
    private boolean editing = false;
    private boolean relocating = false;
    private class_2338 relocatingPrevPos;
    private ChunkDrawing drawingChunk = ChunkDrawing.Nothing;
    private class_1923 lastEditedChunk;

    public FullscreenMap(IClientAPI jmAPI) {
        this.jmAPI = jmAPI;
        ClientEventHandler.subscribeDeletedFrontierEvent(this, frontierID -> {
            if (this.frontierHighlighted != null && this.frontierHighlighted.getId().equals(frontierID)) {
                this.frontierHighlighted = null;
                this.editing = false;
                this.relocating = false;
                this.updateButtons();
            }
        });
        ClientEventHandler.subscribeNewFrontierEvent(this, (frontierOverlay, playerID) -> {
            UIState uiState = jmAPI.getUIState(Context.UI.Fullscreen);
            if (uiState == null || frontierOverlay.getDimension() != uiState.dimension) {
                return;
            }
            class_746 localPlayer = class_310.method_1551().field_1724;
            if (playerID == -1 || localPlayer != null && localPlayer.method_5628() == playerID.intValue()) {
                this.stopEditing();
                if (this.frontierHighlighted != null) {
                    this.frontierHighlighted.setHighlighted(false);
                }
                this.frontierHighlighted = frontierOverlay;
                this.frontierHighlighted.setHighlighted(true);
                this.updateButtons();
                if (Config.afterCreatingFrontier == Config.AfterCreatingFrontier.Edit) {
                    this.buttonEditToggled();
                } else if (Config.afterCreatingFrontier == Config.AfterCreatingFrontier.Info) {
                    this.buttonInfoPressed();
                }
            }
        });
        ClientEventHandler.subscribeUpdatedFrontierEvent(this, (frontierOverlay, playerID) -> {
            if (this.frontierHighlighted != null && this.frontierHighlighted.getId().equals(frontierOverlay.getId())) {
                this.frontierHighlighted = frontierOverlay;
                this.frontierHighlighted.setHighlighted(true);
                this.editing = false;
                this.relocating = false;
                this.updateButtons();
            }
        });
        ClientEventHandler.subscribeUpdatedSettingsProfileEvent(this, profile -> this.updateButtons());
        ClientEventHandler.subscribeUpdatedConfigEvent(this, this::updateButtons);
        ClientEventHandler.subscribeMouseReleaseEvent(this, button -> {
            if (button != 1) {
                return;
            }
            this.relocating = false;
            if (!this.editing || this.drawingChunk == ChunkDrawing.Nothing || this.frontierHighlighted.getMode() != FrontierData.Mode.Chunk) {
                return;
            }
            this.drawingChunk = ChunkDrawing.Nothing;
        });
    }

    public void close() {
        if (this.frontierHighlighted != null) {
            this.frontierHighlighted.setHighlighted(false);
        }
        ClientEventHandler.unsubscribeAllEvents(this);
    }

    public void addButtons(ThemeButtonDisplay buttonDisplay) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null) {
            return;
        }
        String path = "textures/gui/journeymap/";
        this.buttonFrontiers = buttonDisplay.addThemeButton(class_1074.method_4662((String)"mapfrontiers.button_frontiers", (Object[])new Object[0]), class_2960.method_60655((String)"mapfrontiers", (String)(path + "frontiers.png")), b -> this.buttonFrontiersPressed());
        this.buttonNew = buttonDisplay.addThemeButton(class_1074.method_4662((String)"mapfrontiers.button_new_frontier", (Object[])new Object[0]), class_2960.method_60655((String)"mapfrontiers", (String)(path + "new_frontier.png")), b -> this.buttonNewPressed(mc.field_1724.method_24515()));
        this.buttonInfo = buttonDisplay.addThemeButton(class_1074.method_4662((String)"mapfrontiers.button_frontier_info", (Object[])new Object[0]), class_2960.method_60655((String)"mapfrontiers", (String)(path + "info_frontier.png")), b -> this.buttonInfoPressed());
        this.buttonEdit = buttonDisplay.addThemeToggleButton(class_1074.method_4662((String)"mapfrontiers.button_done_editing", (Object[])new Object[0]), class_1074.method_4662((String)"mapfrontiers.button_edit_frontier", (Object[])new Object[0]), class_2960.method_60655((String)"mapfrontiers", (String)(path + "edit_frontier.png")), this.editing, b -> this.buttonEditToggled());
        this.buttonVisible = buttonDisplay.addThemeToggleButton(class_1074.method_4662((String)"mapfrontiers.button_hide_frontier", (Object[])new Object[0]), class_1074.method_4662((String)"mapfrontiers.button_show_frontier", (Object[])new Object[0]), class_2960.method_60655((String)"mapfrontiers", (String)(path + "visible_frontier.png")), false, b -> this.buttonVisibleToggled());
        this.buttonDelete = buttonDisplay.addThemeButton(class_1074.method_4662((String)"mapfrontiers.button_delete_frontier", (Object[])new Object[0]), class_2960.method_60655((String)"mapfrontiers", (String)(path + "delete_frontier.png")), b -> this.buttonDelete());
        this.updateButtons();
    }

    public void addPopupMenu(ModPopupMenu popupMenu) {
        if (this.editing) {
            if (this.frontierHighlighted.getMode() == FrontierData.Mode.Vertex) {
                popupMenu.addMenuItem(class_1074.method_4662((String)"mapfrontiers.add_vertex", (Object[])new Object[0]), this::buttonAddVertex);
                if (this.frontierHighlighted.getSelectedVertexIndex() != -1) {
                    popupMenu.addMenuItem(class_1074.method_4662((String)"mapfrontiers.remove_vertex", (Object[])new Object[0]), p -> this.buttonRemoveVertex());
                }
            } else if (this.frontierHighlighted.hasChunk(this.lastEditedChunk)) {
                List<class_1923> chunksToRemove = this.frontierHighlighted.getConnectedChunks(this.lastEditedChunk);
                if (!chunksToRemove.isEmpty()) {
                    popupMenu.addMenuItem(class_1074.method_4662((String)"mapfrontiers.remove_connected_chunks", (Object[])new Object[0]), p -> this.buttonRemoveConnected(chunksToRemove));
                }
            } else {
                List<class_1923> chunksToFill = this.frontierHighlighted.getClosedRegion(this.lastEditedChunk);
                if (!chunksToFill.isEmpty()) {
                    popupMenu.addMenuItem(class_1074.method_4662((String)"mapfrontiers.fill_region_of_chunks", (Object[])new Object[0]), p -> this.buttonFillRegion(chunksToFill));
                }
            }
            popupMenu.addMenuItem(class_1074.method_4662((String)"mapfrontiers.button_done_editing", (Object[])new Object[0]), p -> this.buttonEditToggled());
        } else {
            class_746 player = class_310.method_1551().field_1724;
            if (player == null) {
                return;
            }
            SettingsProfile profile = MapFrontiersClient.getSettingsProfile();
            SettingsUser playerUser = new SettingsUser((class_1657)player);
            SettingsProfile.AvailableActions actions = SettingsProfile.getAvailableActions(profile, this.frontierHighlighted, playerUser);
            ModPopupMenu subMenu = popupMenu.createSubItemList("MapFrontiers");
            subMenu.addMenuItem(class_1074.method_4662((String)"mapfrontiers.button_frontiers", (Object[])new Object[0]), p -> this.buttonFrontiersPressed());
            subMenu.addMenuItem(class_1074.method_4662((String)"mapfrontiers.button_new_frontier", (Object[])new Object[0]), p -> this.buttonNewPressed(p));
            if (this.frontierHighlighted != null) {
                subMenu.addMenuItem(class_1074.method_4662((String)"mapfrontiers.button_frontier_info", (Object[])new Object[0]), p -> this.buttonInfoPressed());
            }
            if (actions.canUpdate && this.frontierHighlighted.getVisibility(FrontierData.VisibilityData.Visibility.Frontier) && this.frontierHighlighted.getVisibility(FrontierData.VisibilityData.Visibility.Fullscreen)) {
                subMenu.addMenuItem(class_1074.method_4662((String)"mapfrontiers.button_edit_frontier", (Object[])new Object[0]), p -> this.buttonEditToggled());
            }
            if (actions.canUpdate) {
                subMenu.addMenuItem(class_1074.method_4662((String)"mapfrontiers.button_hide_frontier", (Object[])new Object[0]), p -> this.buttonVisibleToggled());
            }
            if (actions.canUpdate) {
                subMenu.addMenuItem(class_1074.method_4662((String)"mapfrontiers.button_delete_frontier", (Object[])new Object[0]), p -> this.buttonDelete());
            }
        }
    }

    public void stopEditing() {
        if (this.editing) {
            this.editing = false;
            this.relocating = false;
            boolean personalFrontier = this.frontierHighlighted.getPersonal();
            FrontiersOverlayManager frontierManager = MapFrontiersClient.getFrontiersOverlayManager(personalFrontier);
            frontierManager.clientUpdateFrontier(this.frontierHighlighted);
        }
    }

    public void updateButtons() {
        class_746 player = class_310.method_1551().field_1724;
        if (this.buttonInfo == null || player == null) {
            return;
        }
        this.buttonFrontiers.setDrawButton(Config.fullscreenButtons);
        this.buttonNew.setDrawButton(Config.fullscreenButtons);
        this.buttonInfo.setDrawButton(Config.fullscreenButtons);
        this.buttonEdit.setDrawButton(Config.fullscreenButtons);
        this.buttonVisible.setDrawButton(Config.fullscreenButtons);
        this.buttonDelete.setDrawButton(Config.fullscreenButtons);
        SettingsProfile profile = MapFrontiersClient.getSettingsProfile();
        SettingsUser playerUser = new SettingsUser((class_1657)player);
        SettingsProfile.AvailableActions actions = SettingsProfile.getAvailableActions(profile, this.frontierHighlighted, playerUser);
        this.buttonFrontiers.setEnabled(!this.editing);
        this.buttonNew.setEnabled(!this.editing);
        this.buttonInfo.setEnabled(this.frontierHighlighted != null && !this.editing);
        this.buttonEdit.setEnabled(actions.canUpdate && this.frontierHighlighted.getVisibility(FrontierData.VisibilityData.Visibility.Frontier) && this.frontierHighlighted.getVisibility(FrontierData.VisibilityData.Visibility.Fullscreen));
        this.buttonVisible.setEnabled(actions.canUpdate && !this.editing);
        this.buttonDelete.setEnabled(actions.canDelete && !this.editing);
        if (this.frontierHighlighted != null) {
            this.buttonVisible.setToggled(Boolean.valueOf(this.frontierHighlighted.getVisibility(FrontierData.VisibilityData.Visibility.Frontier) && this.frontierHighlighted.getVisibility(FrontierData.VisibilityData.Visibility.Fullscreen)));
        } else {
            this.buttonVisible.setToggled(Boolean.valueOf(false));
        }
    }

    private void buttonFrontiersPressed() {
        new FrontierList(this.jmAPI, this).display();
    }

    private void buttonNewPressed(class_2338 centerPos) {
        if (this.frontierHighlighted != null) {
            this.frontierHighlighted.setHighlighted(false);
            this.frontierHighlighted = null;
        }
        new NewFrontier(this.jmAPI, centerPos).display();
        this.updateButtons();
    }

    private void buttonInfoPressed() {
        new FrontierInfo(this.jmAPI, this.frontierHighlighted).display();
    }

    private void buttonEditToggled() {
        this.buttonEdit.toggle();
        if (!this.editing) {
            this.editing = true;
            this.drawingChunk = ChunkDrawing.Nothing;
        } else {
            this.stopEditing();
        }
        this.updateButtons();
    }

    private void buttonVisibleToggled() {
        this.frontierHighlighted.setVisibility(FrontierData.VisibilityData.Visibility.Frontier, !this.frontierHighlighted.getVisibility(FrontierData.VisibilityData.Visibility.Frontier));
        boolean personalFrontier = this.frontierHighlighted.getPersonal();
        FrontiersOverlayManager frontierManager = MapFrontiersClient.getFrontiersOverlayManager(personalFrontier);
        frontierManager.clientUpdateFrontier(this.frontierHighlighted);
        this.updateButtons();
    }

    private void buttonDelete() {
        if (Config.askConfirmationFrontierDelete) {
            new DeleteConfirmationDialog("mapfrontiers.delete_frontier_dialog", response -> {
                if (response == ConfirmationDialog.Response.ConfirmAlternative) {
                    Config.askConfirmationFrontierDelete = false;
                    ClientEventHandler.postUpdatedConfigEvent();
                }
                this.deleteFrontier();
            }).display();
        } else {
            this.deleteFrontier();
        }
    }

    private void deleteFrontier() {
        if (this.editing) {
            this.stopEditing();
        }
        boolean personalFrontier = this.frontierHighlighted.getPersonal();
        FrontiersOverlayManager frontierManager = MapFrontiersClient.getFrontiersOverlayManager(personalFrontier);
        frontierManager.clientDeleteFrontier(this.frontierHighlighted);
        this.frontierHighlighted = null;
        this.updateButtons();
    }

    private void buttonAddVertex(class_2338 pos) {
        this.frontierHighlighted.selectClosestEdge(pos);
        this.frontierHighlighted.addVertex(pos);
        this.updateButtons();
    }

    private void buttonRemoveVertex() {
        this.frontierHighlighted.removeSelectedVertex();
        this.updateButtons();
    }

    private void buttonRemoveConnected(List<class_1923> chunks) {
        for (class_1923 chunk : chunks) {
            this.frontierHighlighted.removeChunk(chunk);
        }
    }

    private void buttonFillRegion(List<class_1923> chunks) {
        for (class_1923 chunk : chunks) {
            this.frontierHighlighted.addChunk(chunk);
        }
    }

    public boolean isEditingVertices() {
        return this.editing && this.frontierHighlighted.getMode() == FrontierData.Mode.Vertex;
    }

    public boolean isEditingChunks() {
        return this.editing && this.frontierHighlighted.getMode() == FrontierData.Mode.Chunk;
    }

    public FrontierOverlay getSelected() {
        return this.frontierHighlighted;
    }

    public void selectFrontier(@Nullable FrontierOverlay frontier) {
        UIState uiState = this.jmAPI.getUIState(Context.UI.Fullscreen);
        if (uiState != null && frontier != null && frontier.getDimension().equals((Object)uiState.dimension)) {
            if (this.frontierHighlighted != frontier) {
                if (this.frontierHighlighted != null) {
                    this.frontierHighlighted.setHighlighted(false);
                }
                this.frontierHighlighted = frontier;
                this.frontierHighlighted.setHighlighted(true);
            }
        } else if (this.frontierHighlighted != null) {
            this.frontierHighlighted.setHighlighted(false);
            this.frontierHighlighted = null;
        }
        this.updateButtons();
    }

    public boolean mapClicked(class_5321<class_1937> dimension, class_2338 position, int button) {
        UIState uiState = this.jmAPI.getUIState(Context.UI.Fullscreen);
        if (uiState == null) {
            return false;
        }
        double maxDistanceToClosest = Math.max(2.0, 8192.0 / (double)uiState.zoom);
        if (this.editing && this.frontierHighlighted != null) {
            if (class_437.method_25441() && button == 1) {
                this.relocating = true;
                this.relocatingPrevPos = position;
                return true;
            }
            if (this.frontierHighlighted.getMode() == FrontierData.Mode.Vertex) {
                this.frontierHighlighted.selectClosestVertex(position, maxDistanceToClosest);
            } else if (button == 1) {
                this.lastEditedChunk = new class_1923(position);
                if (class_437.method_25442()) {
                    return false;
                }
                this.drawingChunk = this.frontierHighlighted.toggleChunk(this.lastEditedChunk) ? ChunkDrawing.Adding : ChunkDrawing.Removing;
                return true;
            }
            return false;
        }
        if (Config.frontierVisibility == Config.Visibility.Never) {
            return false;
        }
        List<FrontierOverlay> frontiers = MapFrontiersClient.getFrontiersInPosition(dimension, position, maxDistanceToClosest);
        if (frontiers.isEmpty()) {
            this.selectFrontier(null);
        } else if (frontiers.size() == 1 || this.frontierHighlighted == null) {
            this.selectFrontier(frontiers.getFirst());
        } else {
            int i = frontiers.indexOf(this.frontierHighlighted);
            i = (i + 1) % frontiers.size();
            this.selectFrontier(frontiers.get(i));
        }
        return false;
    }

    public boolean mapDragged(class_5321<class_1937> dimension, class_2338 position) {
        UIState uiState = this.jmAPI.getUIState(Context.UI.Fullscreen);
        if (uiState == null || !this.editing || this.relocating) {
            return false;
        }
        if (this.frontierHighlighted == null || !this.frontierHighlighted.getDimension().equals(dimension)) {
            return false;
        }
        if (this.frontierHighlighted.getMode() == FrontierData.Mode.Chunk) {
            return false;
        }
        if (this.frontierHighlighted.getSelectedVertexIndex() == -1) {
            return false;
        }
        float snapDistance = 512.0f / (float)uiState.zoom * (float)Config.snapDistance;
        this.frontierHighlighted.moveSelectedVertex(position, snapDistance);
        return true;
    }

    public void mouseMoved(class_5321<class_1937> dimension, class_2338 position) {
        if (!this.editing) {
            return;
        }
        if (this.relocating) {
            if (this.frontierHighlighted.getMode() == FrontierData.Mode.Vertex) {
                if (!position.equals((Object)this.relocatingPrevPos)) {
                    this.frontierHighlighted.moveAllVertices(position.method_10059((class_2382)this.relocatingPrevPos));
                    this.relocatingPrevPos = position;
                }
            } else {
                class_1923 chunkPos = new class_1923(position);
                class_1923 prevChunkPos = new class_1923(this.relocatingPrevPos);
                if (!chunkPos.equals((Object)prevChunkPos)) {
                    this.frontierHighlighted.moveAllChunks(new class_1923(chunkPos.field_9181 - prevChunkPos.field_9181, chunkPos.field_9180 - prevChunkPos.field_9180));
                    this.relocatingPrevPos = position;
                }
            }
            return;
        }
        if (this.drawingChunk == ChunkDrawing.Nothing) {
            return;
        }
        if (this.frontierHighlighted == null || !this.frontierHighlighted.getDimension().equals(dimension)) {
            return;
        }
        if (this.frontierHighlighted.getMode() != FrontierData.Mode.Chunk) {
            return;
        }
        class_1923 chunk = new class_1923(position);
        if (chunk.equals((Object)this.lastEditedChunk)) {
            return;
        }
        this.lastEditedChunk = chunk;
        if (this.drawingChunk == ChunkDrawing.Adding) {
            this.frontierHighlighted.addChunk(chunk);
        } else {
            this.frontierHighlighted.removeChunk(chunk);
        }
    }

    private static enum ChunkDrawing {
        Nothing,
        Adding,
        Removing;

    }
}

