/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client.gui.screen;

import games.alejandrocoria.mapfrontiers.client.util.ScreenHelper;
import journeymap.api.v2.client.ui.component.LayeredScreen;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_8667;
import net.minecraft.class_8828;

public abstract class AutoScaledScreen
extends LayeredScreen {
    protected float scaleFactor = 1.0f;
    private final int minWidth;
    private final int minHeight;
    protected int actualWidth;
    protected int actualHeight;
    protected class_8667 content;
    protected class_8667 bottomButtons;

    public AutoScaledScreen(class_2561 title) {
        this(title, 0, 0);
    }

    public AutoScaledScreen(class_2561 title, int minWidth, int minHeight) {
        super(title);
        this.minWidth = minWidth;
        this.minHeight = minHeight;
    }

    public final void method_25426() {
        this.updateScale(this.field_22789, this.field_22790);
        this.content = class_8667.method_52741();
        this.bottomButtons = class_8667.method_52742();
        this.initScreen();
        this.content.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.content.method_48206(w -> w.method_48591(0));
        this.bottomButtons.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.bottomButtons.method_48206(w -> w.method_48591(1));
        this.bottomButtons.method_52735(7);
        this.method_48640();
    }

    public void method_48640() {
        this.content.method_48222();
        this.content.method_48229((this.actualWidth - this.content.method_25368()) / 2, (this.actualHeight - this.content.method_25364()) / 2);
        this.bottomButtons.method_48222();
        this.bottomButtons.method_48229((this.actualWidth - this.bottomButtons.method_25368()) / 2, this.actualHeight - 15 - this.bottomButtons.method_25364() / 2);
    }

    public void method_25410(class_310 minecraft, int width, int height) {
        this.field_22789 = width;
        this.field_22790 = height;
        this.updateScale(width, height);
        super.method_25410(minecraft, width, height);
    }

    private void updateScale(int width, int height) {
        this.scaleFactor = ScreenHelper.getScaleFactorThatFit(this.minecraft, (class_437)this, this.minWidth, this.minHeight);
        this.actualWidth = (int)((float)width * this.scaleFactor);
        this.actualHeight = (int)((float)height * this.scaleFactor);
    }

    protected abstract void initScreen();

    protected void renderScaledBackgroundScreen(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
    }

    protected void renderScaledScreen(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
    }

    protected final void renderPopupScreenBackground(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.method_57734(partialTicks);
    }

    protected final void renderPopupScreen(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        mouseX = (int)((float)mouseX * this.scaleFactor);
        mouseY = (int)((float)mouseY * this.scaleFactor);
        if (this.scaleFactor != 1.0f) {
            graphics.method_51448().method_22903();
            graphics.method_51448().method_22905(1.0f / this.scaleFactor, 1.0f / this.scaleFactor, 1.0f);
        }
        if (this.field_22785.method_10851() != class_8828.field_46625) {
            graphics.method_27534(this.field_22793, this.field_22785, this.actualWidth / 2, 11, -1);
        }
        this.renderScaledBackgroundScreen(graphics, mouseX, mouseY, partialTicks);
        for (class_364 child : this.method_25396()) {
            if (!(child instanceof class_4068)) continue;
            class_4068 renderable = (class_4068)child;
            renderable.method_25394(graphics, mouseX, mouseY, partialTicks);
        }
        this.renderScaledScreen(graphics, mouseX, mouseY, partialTicks);
        if (this.scaleFactor != 1.0f) {
            graphics.method_51448().method_22909();
        }
    }

    public boolean method_25404(int key, int value, int modifier) {
        if (key == 256) {
            this.method_25419();
            return true;
        }
        return super.method_25404(key, value, modifier);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        return super.method_25402(mouseX * (double)this.scaleFactor, mouseY * (double)this.scaleFactor, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        return super.method_25406(mouseX * (double)this.scaleFactor, mouseY * (double)this.scaleFactor, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double hDelta, double vDelta) {
        return super.method_25401(mouseX * (double)this.scaleFactor, mouseY * (double)this.scaleFactor, hDelta, vDelta);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return super.method_25403(mouseX * (double)this.scaleFactor, mouseY * (double)this.scaleFactor, button, dragX * (double)this.scaleFactor, dragY * (double)this.scaleFactor);
    }

    protected void closeAndReturnToFullscreenMap() {
        class_437 class_4372;
        if (this.minecraft == null) {
            return;
        }
        this.method_25419();
        if (this.minecraft.field_1755 != null && (class_4372 = this.minecraft.field_1755) instanceof AutoScaledScreen) {
            AutoScaledScreen autoScaledScreen = (AutoScaledScreen)class_4372;
            autoScaledScreen.closeAndReturnToFullscreenMap();
        }
    }

    protected void drawCenteredBoxBackground(class_332 graphics, int width, int height) {
        int x1 = (this.actualWidth - width) / 2;
        int x2 = (this.actualWidth + width) / 2;
        int y1 = (this.actualHeight - height) / 2;
        int y2 = (this.actualHeight + height) / 2;
        graphics.method_25294(x1, y1, x2, y2, -955248624);
        graphics.method_25292(x1, x2, y1, -8947849);
        graphics.method_25292(x1, x2, y2, -8947849);
        graphics.method_25301(x1, y1, y2, -8947849);
        graphics.method_25301(x2, y1, y2, -8947849);
    }
}

