/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.common.settings;

import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.common.util.UUIDHelper;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.StringUtils;

@ParametersAreNonnullByDefault
public class SettingsUser
implements Comparable<SettingsUser> {
    public String username;
    public UUID uuid;

    public SettingsUser() {
        this.username = "";
    }

    public SettingsUser(class_1657 player) {
        this.username = player.method_5477().getString();
        this.uuid = player.method_5667();
    }

    public boolean isEmpty() {
        return this.uuid == null && StringUtils.isBlank((CharSequence)this.username);
    }

    public void fillMissingInfo(boolean forceNameUpdate, @Nullable MinecraftServer server) {
        if (this.isEmpty()) {
            return;
        }
        if (this.uuid == null) {
            this.uuid = UUIDHelper.getUUIDFromName(this.username, server);
        } else if (StringUtils.isBlank((CharSequence)this.username) || forceNameUpdate) {
            String newUsername = UUIDHelper.getNameFromUUID(this.uuid, server);
            if (newUsername != null) {
                this.username = newUsername;
            } else if (this.username == null) {
                this.username = "";
            }
        }
    }

    public void readFromNBT(class_2487 nbt) {
        this.username = nbt.method_10558("username");
        try {
            this.uuid = UUID.fromString(nbt.method_10558("UUID"));
        }
        catch (Exception e) {
            MapFrontiers.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void writeToNBT(class_2487 nbt) {
        nbt.method_10582("username", this.username);
        if (this.uuid != null) {
            nbt.method_10582("UUID", this.uuid.toString());
        }
    }

    public void fromBytes(class_2540 buf) {
        boolean hasUsername = buf.readBoolean();
        this.username = hasUsername ? buf.method_10800(17) : "";
        boolean hasUUID = buf.readBoolean();
        this.uuid = hasUUID ? UUIDHelper.fromBytes((ByteBuf)buf) : null;
    }

    public void toBytes(class_2540 buf) {
        if (StringUtils.isBlank((CharSequence)this.username)) {
            buf.method_52964(false);
        } else {
            buf.method_52964(true);
            buf.method_10788(this.username, 17);
        }
        if (this.uuid == null) {
            buf.method_52964(false);
        } else {
            buf.method_52964(true);
            UUIDHelper.toBytes((ByteBuf)buf, this.uuid);
        }
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof SettingsUser) {
            SettingsUser user = (SettingsUser)other;
            if (this.uuid != null) {
                return this.uuid.equals(user.uuid);
            }
            return this.username.equals(user.username);
        }
        return false;
    }

    public String toString() {
        return this.toString(class_1074.method_4662((String)"mapfrontiers.unnamed", (Object[])new Object[]{class_124.field_1056}));
    }

    public String toString(String blank) {
        if (!StringUtils.isBlank((CharSequence)this.username)) {
            return this.username;
        }
        if (this.uuid != null) {
            return this.uuid.toString();
        }
        return blank;
    }

    @Override
    public int compareTo(SettingsUser other) {
        if (StringUtils.isBlank((CharSequence)this.username) && StringUtils.isBlank((CharSequence)other.username)) {
            if (this.uuid == null || other.uuid == null) {
                return 0;
            }
            return this.uuid.compareTo(other.uuid);
        }
        if (this.username == null) {
            return other.username == null ? 0 : -1;
        }
        if (other.username == null) {
            return 1;
        }
        return this.username.compareTo(other.username);
    }
}

