/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.mapfrontiers.client;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.serialization.DynamicOps;
import games.alejandrocoria.mapfrontiers.MapFrontiers;
import games.alejandrocoria.mapfrontiers.client.MapFrontiersClient;
import games.alejandrocoria.mapfrontiers.client.mixin.CubeInvoker;
import games.alejandrocoria.mapfrontiers.client.mixin.GuiGraphicsAccessor;
import games.alejandrocoria.mapfrontiers.client.mixin.SpriteContentsInvoker;
import games.alejandrocoria.mapfrontiers.common.Config;
import games.alejandrocoria.mapfrontiers.common.FrontierData;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUser;
import games.alejandrocoria.mapfrontiers.common.settings.SettingsUserShared;
import it.unimi.dsi.fastutil.Pair;
import java.awt.Color;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.api.v2.client.IClientAPI;
import journeymap.api.v2.client.display.Context;
import journeymap.api.v2.client.display.Displayable;
import journeymap.api.v2.client.display.MarkerOverlay;
import journeymap.api.v2.client.display.PolygonOverlay;
import journeymap.api.v2.client.model.MapImage;
import journeymap.api.v2.client.model.MapPolygon;
import journeymap.api.v2.client.model.ShapeProperties;
import journeymap.api.v2.client.model.TextProperties;
import journeymap.api.v2.client.util.PolygonHelper;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1058;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2509;
import net.minecraft.class_2582;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4722;
import net.minecraft.class_5321;
import net.minecraft.class_5602;
import net.minecraft.class_630;
import net.minecraft.class_638;
import net.minecraft.class_7764;
import net.minecraft.class_9307;
import net.minecraft.class_9848;

@ParametersAreNonnullByDefault
public class FrontierOverlay
extends FrontierData {
    private static final MapImage markerVertex = new MapImage(class_2960.method_60655((String)"mapfrontiers", (String)"textures/gui/marker.png"), 0, 0, 12, 12, -1, 1.0f);
    private static final MapImage markerDot = new MapImage(class_2960.method_60655((String)"mapfrontiers", (String)"textures/gui/marker.png"), 12, 0, 8, 8, -1, 1.0f);
    public class_2338 topLeft;
    public class_2338 bottomRight;
    public float perimeter = 0.0f;
    public float area = 0.0f;
    private int vertexSelected = -1;
    protected FrontierData.VisibilityData effectiveVisibilityData;
    private boolean highlighted = false;
    private final IClientAPI jmAPI;
    private final List<PolygonOverlay> polygonOverlays = new ArrayList<PolygonOverlay>();
    private Area polygonArea;
    private final List<MarkerOverlay> markerOverlays = new ArrayList<MarkerOverlay>();
    private final List<MarkerOverlay> bannerOverlays = new ArrayList<MarkerOverlay>();
    private final BannerRenderer bannerRenderer = new BannerRenderer();
    private int hash;
    private boolean dirtyhash = true;
    private boolean needUpdateOverlay = true;

    public FrontierOverlay(FrontierData data, @Nullable IClientAPI jmAPI) {
        super(data);
        this.jmAPI = jmAPI;
        this.setVisibilityOverride(MapFrontiersClient.getLocalOverrides().getVisibility(this.id));
        if (this.banner != null) {
            this.bannerRenderer.createTexture(this.id, this.banner);
        }
        this.updateOverlay();
    }

    @Override
    public void updateFromData(FrontierData other) {
        super.updateFromData(other);
        this.setVisibilityOverride(MapFrontiersClient.getLocalOverrides().getVisibility(this.id));
        if (this.vertexSelected >= this.vertices.size()) {
            this.vertexSelected = this.vertices.size() - 1;
        }
        if (other.hasChange(FrontierData.Change.Name) || other.hasChange(FrontierData.Change.Vertices) || other.hasChange(FrontierData.Change.Color) || other.hasChange(FrontierData.Change.Visibility)) {
            this.updateOverlay();
        }
        if (other.hasChange(FrontierData.Change.Banner)) {
            if (this.banner == null) {
                this.bannerRenderer.releaseTexture();
            } else {
                this.bannerRenderer.createTexture(this.id, this.banner);
            }
            this.dirtyhash = true;
        }
    }

    public int getHash() {
        if (this.dirtyhash) {
            this.dirtyhash = false;
            this.hash = Objects.hash(new Object[]{this.id, this.color, this.dimension, this.name1, this.name2, this.visibilityData, this.vertices, this.chunks, this.mode, this.banner, this.usersShared, this.copiedFrom});
        }
        return this.hash;
    }

    public List<PolygonOverlay> getPolygonOverlays() {
        return this.polygonOverlays;
    }

    public List<MarkerOverlay> getBannerOverlays() {
        return this.bannerOverlays;
    }

    public void updateOverlayIfNeeded() {
        if (this.needUpdateOverlay) {
            this.needUpdateOverlay = false;
            this.updateOverlay();
        }
    }

    public void updateOverlay() {
        this.dirtyhash = true;
        if (this.jmAPI == null) {
            return;
        }
        this.removeOverlay();
        this.recalculateOverlays();
        if (Config.getVisibilityValue(Config.frontierVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.Frontier))) {
            try {
                for (PolygonOverlay polygon : this.polygonOverlays) {
                    this.jmAPI.show((Displayable)polygon);
                }
                for (MarkerOverlay marker : this.markerOverlays) {
                    this.jmAPI.show((Displayable)marker);
                }
                for (MarkerOverlay banner : this.bannerOverlays) {
                    this.jmAPI.show((Displayable)banner);
                }
            }
            catch (Throwable t) {
                MapFrontiers.LOGGER.error(t.getMessage(), t);
            }
        }
    }

    private void removeOverlay() {
        for (PolygonOverlay polygon : this.polygonOverlays) {
            this.jmAPI.remove((Displayable)polygon);
        }
        for (MarkerOverlay marker : this.markerOverlays) {
            this.jmAPI.remove((Displayable)marker);
        }
        for (MarkerOverlay banner : this.bannerOverlays) {
            this.jmAPI.remove((Displayable)banner);
        }
    }

    public void deleted() {
        this.removeOverlay();
        this.bannerRenderer.releaseTexture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pointIsInside(class_2338 pos, double maxDistanceToOpen) {
        if (this.mode == FrontierData.Mode.Vertex) {
            if (this.vertices.size() > 2) {
                return this.polygonArea != null && this.polygonArea.contains((double)pos.method_10263() + 0.5, (double)pos.method_10260() + 0.5);
            }
            if (maxDistanceToOpen > 0.0) {
                List list = this.vertices;
                synchronized (list) {
                    for (int i = 0; i < this.vertices.size(); ++i) {
                        class_243 point = class_243.method_24954((class_2382)pos);
                        int y1 = pos.method_10264();
                        class_243 edge1 = class_243.method_24954((class_2382)((class_2338)this.vertices.get(i)).method_33096(y1));
                        int y = pos.method_10264();
                        class_243 edge2 = class_243.method_24954((class_2382)((class_2338)this.vertices.get((i + 1) % this.vertices.size())).method_33096(y));
                        double distance = FrontierOverlay.closestPointToEdge(point, edge1, edge2).method_1025(point);
                        if (!(distance <= maxDistanceToOpen * maxDistanceToOpen)) continue;
                        return true;
                    }
                }
            }
        } else if (pos.method_10263() >= this.topLeft.method_10263() && pos.method_10263() <= this.bottomRight.method_10263() && pos.method_10260() >= this.topLeft.method_10260() && pos.method_10260() <= this.bottomRight.method_10260()) {
            return this.chunks.contains(new class_1923(pos));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectClosestVertex(class_2338 pos, double limit) {
        if (this.mode != FrontierData.Mode.Vertex) {
            this.vertexSelected = -1;
            return;
        }
        double distance = limit * limit;
        int closest = -1;
        if (!this.vertices.isEmpty()) {
            List list = this.vertices;
            synchronized (list) {
                for (int i = 0; i < this.vertices.size(); ++i) {
                    int y;
                    class_2338 vertex = (class_2338)this.vertices.get(i);
                    double dist = vertex.method_10262((class_2382)pos.method_33096(y = vertex.method_10264()));
                    if (!(dist <= distance)) continue;
                    distance = dist;
                    closest = i;
                }
            }
        }
        this.vertexSelected = closest;
        MapFrontiersClient.getFrontiersOverlayManager(this.personal).updateSelectedMarker(this.getDimension(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectClosestEdge(class_2338 pos) {
        if (this.mode != FrontierData.Mode.Vertex) {
            this.vertexSelected = -1;
            return;
        }
        double distance = Double.MAX_VALUE;
        int closest = -1;
        double angleSimilarity = -1.0;
        if (this.vertices.size() == 1) {
            closest = 0;
        } else if (this.vertices.size() > 1) {
            List list = this.vertices;
            synchronized (list) {
                for (int i = 0; i < this.vertices.size(); ++i) {
                    double dist;
                    double dot;
                    class_243 point = class_243.method_24954((class_2382)pos);
                    int y1 = pos.method_10264();
                    class_243 edge1 = class_243.method_24954((class_2382)((class_2338)this.vertices.get(i)).method_33096(y1));
                    int y = pos.method_10264();
                    class_243 edge2 = class_243.method_24954((class_2382)((class_2338)this.vertices.get((i + 1) % this.vertices.size())).method_33096(y));
                    if (edge1.equals((Object)edge2)) {
                        dot = -1.0;
                        dist = point.method_1025(edge1);
                    } else {
                        class_243 closestPoint = FrontierOverlay.closestPointToEdge(point, edge1, edge2);
                        if (!closestPoint.equals((Object)edge1) && !closestPoint.equals((Object)edge2)) {
                            dot = -1.0;
                        } else {
                            class_243 toPos;
                            class_243 edge = edge2.method_1020(edge1);
                            class_241 edgeDirection = new class_241((float)edge.field_1352, (float)edge.field_1350).method_35581();
                            if (closestPoint.equals((Object)edge1)) {
                                toPos = point.method_1020(edge1);
                            } else {
                                edgeDirection = edgeDirection.method_35588();
                                toPos = point.method_1020(edge2);
                            }
                            class_241 toPosDirection = new class_241((float)toPos.field_1352, (float)toPos.field_1350).method_35581();
                            dot = toPosDirection.method_35583(edgeDirection);
                        }
                        dist = point.method_1025(closestPoint);
                    }
                    if (dist < distance) {
                        distance = dist;
                        closest = i;
                        angleSimilarity = dot;
                        continue;
                    }
                    if (dist != distance || !(dot > angleSimilarity)) continue;
                    closest = i;
                    angleSimilarity = dot;
                }
            }
        }
        this.vertexSelected = closest;
        MapFrontiersClient.getFrontiersOverlayManager(this.personal).updateSelectedMarker(this.getDimension(), this);
    }

    private static class_243 closestPointToEdge(class_243 point, class_243 edge1, class_243 edge2) {
        class_243 edge = edge2.method_1020(edge1);
        if (edge.field_1352 == 0.0 && edge.field_1350 == 0.0) {
            return edge1;
        }
        double u = ((point.field_1352 - edge1.field_1352) * edge.field_1352 + (point.field_1350 - edge1.field_1350) * edge.field_1350) / (edge.field_1352 * edge.field_1352 + edge.field_1350 * edge.field_1350);
        if (u < 0.0) {
            return edge1;
        }
        if (u > 1.0) {
            return edge2;
        }
        return new class_243(edge1.field_1352 + u * edge.field_1352, point.field_1351, edge1.field_1350 + u * edge.field_1350);
    }

    public void setCurrentPlayerAsOwner() {
        if (class_310.method_1551().field_1724 != null) {
            this.owner = new SettingsUser((class_1657)class_310.method_1551().field_1724);
        }
    }

    @Override
    public void setId(UUID id) {
        super.setId(id);
        this.needUpdateOverlay = true;
    }

    @Override
    public void addVertex(class_2338 pos) {
        this.addVertex(pos, this.vertexSelected + 1, Config.snapDistance);
        this.selectNextVertex();
    }

    public void addVertex(class_2338 pos, int index, int snapDistance) {
        if (snapDistance != 0) {
            pos = this.snapVertex(pos, snapDistance);
        }
        super.addVertex(pos, index);
        this.needUpdateOverlay = true;
    }

    @Override
    public void removeVertex(int index) {
        super.removeVertex(index);
        this.needUpdateOverlay = true;
    }

    @Override
    public void moveAllVertices(class_2338 delta) {
        super.moveAllVertices(delta);
        this.needUpdateOverlay = true;
    }

    @Override
    public boolean toggleChunk(class_1923 chunk) {
        boolean added = super.toggleChunk(chunk);
        this.needUpdateOverlay = true;
        return added;
    }

    @Override
    public boolean addChunk(class_1923 chunk) {
        if (super.addChunk(chunk)) {
            this.needUpdateOverlay = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeChunk(class_1923 chunk) {
        if (super.removeChunk(chunk)) {
            this.needUpdateOverlay = true;
            return true;
        }
        return false;
    }

    @Override
    public void moveAllChunks(class_1923 delta) {
        super.moveAllChunks(delta);
        this.needUpdateOverlay = true;
    }

    public boolean hasChunk(class_1923 chunk) {
        return this.chunks.contains(chunk);
    }

    public List<class_1923> getConnectedChunks(class_1923 chunk) {
        ArrayList<class_1923> connected = new ArrayList<class_1923>();
        if (!this.hasChunk(chunk)) {
            return connected;
        }
        HashSet<class_1923> visited = new HashSet<class_1923>();
        visited.add(chunk);
        HashSet<class_1923> toCheck = new HashSet<class_1923>();
        toCheck.add(chunk);
        while (!toCheck.isEmpty()) {
            class_1923 pos = (class_1923)toCheck.iterator().next();
            toCheck.remove(pos);
            connected.add(pos);
            class_1923 posUp = new class_1923(pos.field_9181, pos.field_9180 - 1);
            if (!visited.contains(posUp) && this.hasChunk(posUp)) {
                toCheck.add(posUp);
            }
            visited.add(posUp);
            class_1923 posDown = new class_1923(pos.field_9181, pos.field_9180 + 1);
            if (!visited.contains(posDown) && this.hasChunk(posDown)) {
                toCheck.add(posDown);
            }
            visited.add(posDown);
            class_1923 posRight = new class_1923(pos.field_9181 + 1, pos.field_9180);
            if (!visited.contains(posRight) && this.hasChunk(posRight)) {
                toCheck.add(posRight);
            }
            visited.add(posRight);
            class_1923 posLeft = new class_1923(pos.field_9181 - 1, pos.field_9180);
            if (!visited.contains(posLeft) && this.hasChunk(posLeft)) {
                toCheck.add(posLeft);
            }
            visited.add(posLeft);
        }
        return connected;
    }

    public List<class_1923> getClosedRegion(class_1923 chunk) {
        ArrayList<class_1923> region = new ArrayList<class_1923>();
        if (this.hasChunk(chunk) || this.chunks.isEmpty()) {
            return region;
        }
        class_1923 topLeft = new class_1923(this.topLeft);
        class_1923 bottomRight = new class_1923(this.bottomRight);
        if (chunk.field_9181 <= topLeft.field_9181 || chunk.field_9181 >= bottomRight.field_9181 || chunk.field_9180 <= topLeft.field_9180 || chunk.field_9180 >= bottomRight.field_9180) {
            return region;
        }
        HashSet<class_1923> visited = new HashSet<class_1923>();
        visited.add(chunk);
        HashSet<class_1923> toCheck = new HashSet<class_1923>();
        toCheck.add(chunk);
        while (!toCheck.isEmpty()) {
            class_1923 pos = (class_1923)toCheck.iterator().next();
            toCheck.remove(pos);
            region.add(pos);
            class_1923 posUp = new class_1923(pos.field_9181, pos.field_9180 - 1);
            if (!visited.contains(posUp) && !this.hasChunk(posUp)) {
                if (posUp.field_9180 == topLeft.field_9180) {
                    return new ArrayList<class_1923>();
                }
                toCheck.add(posUp);
            }
            visited.add(posUp);
            class_1923 posDown = new class_1923(pos.field_9181, pos.field_9180 + 1);
            if (!visited.contains(posDown) && !this.hasChunk(posDown)) {
                if (posUp.field_9180 == bottomRight.field_9180) {
                    return new ArrayList<class_1923>();
                }
                toCheck.add(posDown);
            }
            visited.add(posDown);
            class_1923 posRight = new class_1923(pos.field_9181 + 1, pos.field_9180);
            if (!visited.contains(posRight) && !this.hasChunk(posRight)) {
                if (posUp.field_9181 == bottomRight.field_9181) {
                    return new ArrayList<class_1923>();
                }
                toCheck.add(posRight);
            }
            visited.add(posRight);
            class_1923 posLeft = new class_1923(pos.field_9181 - 1, pos.field_9180);
            if (!visited.contains(posLeft) && !this.hasChunk(posLeft)) {
                if (posUp.field_9181 == topLeft.field_9181) {
                    return new ArrayList<class_1923>();
                }
                toCheck.add(posLeft);
            }
            visited.add(posLeft);
        }
        return region;
    }

    public void moveSelectedVertex(class_2338 pos, float snapDistance) {
        if (this.vertexSelected < 0 || this.vertexSelected >= this.vertices.size()) {
            return;
        }
        if (snapDistance != 0.0f) {
            pos = this.snapVertex(pos, snapDistance);
        }
        super.moveVertex(pos, this.vertexSelected);
        this.needUpdateOverlay = true;
        MapFrontiersClient.getFrontiersOverlayManager(this.personal).updateSelectedMarker(this.getDimension(), this);
    }

    @Override
    public void setName1(String name) {
        super.setName1(name);
        this.needUpdateOverlay = true;
    }

    @Override
    public void setName2(String name) {
        super.setName2(name);
        this.needUpdateOverlay = true;
    }

    @Override
    public void setVisibility(FrontierData.VisibilityData.Visibility visibility, boolean enable) {
        super.setVisibility(visibility, enable);
        this.setVisibilityOverride(MapFrontiersClient.getLocalOverrides().getVisibility(this.id));
        this.needUpdateOverlay = true;
    }

    @Override
    public void toggleVisibility(FrontierData.VisibilityData.Visibility visibility) {
        super.toggleVisibility(visibility);
        this.setVisibilityOverride(MapFrontiersClient.getLocalOverrides().getVisibility(this.id));
        this.needUpdateOverlay = true;
    }

    public void setVisibilityOverride(Pair<FrontierData.VisibilityData, FrontierData.VisibilityData> visibilityOverride) {
        this.effectiveVisibilityData = new FrontierData.VisibilityData(this.visibilityData);
        for (FrontierData.VisibilityData.Visibility visibility : FrontierData.VisibilityData.Visibility.values()) {
            if (!((FrontierData.VisibilityData)visibilityOverride.second()).getValue(visibility)) continue;
            this.effectiveVisibilityData.setValue(visibility, ((FrontierData.VisibilityData)visibilityOverride.first()).getValue(visibility));
        }
        this.needUpdateOverlay = true;
    }

    @Override
    public boolean getVisibility(FrontierData.VisibilityData.Visibility visibility) {
        return this.effectiveVisibilityData.getValue(visibility);
    }

    @Override
    public void setVisibilityData(FrontierData.VisibilityData visibilityData) {
        super.setVisibilityData(visibilityData);
        this.setVisibilityOverride(MapFrontiersClient.getLocalOverrides().getVisibility(this.id));
        this.needUpdateOverlay = true;
    }

    @Override
    public void setColor(int color) {
        super.setColor(color);
        this.needUpdateOverlay = true;
    }

    @Override
    public void setDimension(class_5321<class_1937> dimension) {
        super.setDimension(dimension);
        this.dirtyhash = true;
    }

    @Override
    public void setBanner(@Nullable class_1799 itemBanner) {
        super.setBanner(itemBanner);
        this.needUpdateOverlay = true;
        if (itemBanner == null) {
            this.bannerRenderer.releaseTexture();
        } else {
            this.bannerRenderer.createTexture(this.id, this.banner);
        }
    }

    @Override
    public void setBanner(class_1767 base, class_9307 bannerPatterns) {
        super.setBanner(base, bannerPatterns);
        this.bannerRenderer.createTexture(this.id, this.banner);
        this.needUpdateOverlay = true;
    }

    @Override
    public void setBannerData(@Nullable FrontierData.BannerData bannerData) {
        super.setBannerData(bannerData);
        this.needUpdateOverlay = true;
        if (bannerData == null) {
            this.bannerRenderer.releaseTexture();
        } else {
            this.bannerRenderer.createTexture(this.id, this.banner);
        }
    }

    @Override
    public void setBannerRotation(int rotation) {
        if (this.hasBanner()) {
            super.setBannerRotation(rotation);
            this.bannerRenderer.setRotation(rotation);
            this.needUpdateOverlay = true;
            this.dirtyhash = true;
        }
    }

    @Override
    public void addUserShared(SettingsUserShared userShared) {
        super.addUserShared(userShared);
        this.dirtyhash = true;
    }

    @Override
    public void removeUserShared(int index) {
        super.removeUserShared(index);
        this.dirtyhash = true;
    }

    @Override
    public void setUsersShared(List<SettingsUserShared> usersShared) {
        super.setUsersShared(usersShared);
        this.dirtyhash = true;
    }

    public class_2338 getClosestVertex(class_2338 vertex, double belowDistance) {
        class_2338 closest = null;
        double closestDistance = belowDistance;
        for (PolygonOverlay overlay : this.polygonOverlays) {
            for (class_2338 v : overlay.getOuterArea().getPoints()) {
                double distance = v.method_10262((class_2382)vertex);
                if (!(distance <= closestDistance)) continue;
                closestDistance = distance;
                closest = v;
            }
            if (overlay.getHoles() == null) continue;
            for (MapPolygon hole : overlay.getHoles()) {
                for (class_2338 v : hole.getPoints()) {
                    double distance = v.method_10262((class_2382)vertex);
                    if (!(distance <= closestDistance)) continue;
                    closestDistance = distance;
                    closest = v;
                }
            }
        }
        return closest;
    }

    public int[] getBannerBounds(int x, int y, int scale) {
        int width = 22 * scale;
        int height = 40 * scale;
        float centerX = (float)x + (float)width / 2.0f;
        float centerY = (float)y + (float)height / 2.0f;
        double radians = Math.toRadians(this.banner.rotation);
        double cos = Math.abs(Math.cos(radians));
        double sin = Math.abs(Math.sin(radians));
        float rotatedWidth = (float)((double)width * cos + (double)height * sin);
        float rotatedHeight = (float)((double)width * sin + (double)height * cos);
        int minX = (int)Math.floor(centerX - rotatedWidth / 2.0f);
        int maxX = (int)Math.ceil(centerX + rotatedWidth / 2.0f);
        int minY = (int)Math.floor(centerY - rotatedHeight / 2.0f);
        int maxY = (int)Math.ceil(centerY + rotatedHeight / 2.0f);
        return new int[]{minX, minY, maxX, maxY};
    }

    public BannerRenderer getBannerRenderer() {
        return this.bannerRenderer;
    }

    public void recreateBannerRenderer() {
        this.bannerRenderer.releaseTexture();
        if (this.banner != null) {
            this.bannerRenderer.createTexture(this.id, this.banner);
        }
    }

    public void removeSelectedVertex() {
        if (this.vertexSelected < 0) {
            return;
        }
        super.removeVertex(this.vertexSelected);
        this.vertexSelected = this.vertices.isEmpty() ? -1 : (this.vertexSelected > 0 ? --this.vertexSelected : this.vertices.size() - 1);
        MapFrontiersClient.getFrontiersOverlayManager(this.personal).updateSelectedMarker(this.getDimension(), this);
        this.needUpdateOverlay = true;
    }

    public void selectNextVertex() {
        ++this.vertexSelected;
        if (this.vertexSelected >= this.vertices.size()) {
            this.vertexSelected = -1;
        }
        MapFrontiersClient.getFrontiersOverlayManager(this.personal).updateSelectedMarker(this.getDimension(), this);
    }

    public int getSelectedVertexIndex() {
        return this.vertexSelected;
    }

    public class_2338 getSelectedVertex() {
        if (this.vertexSelected >= 0 && this.vertexSelected < this.vertices.size()) {
            return (class_2338)this.vertices.get(this.vertexSelected);
        }
        return null;
    }

    public void setHighlighted(boolean highlighted) {
        this.highlighted = highlighted;
        this.needUpdateOverlay = true;
    }

    public class_2338 getCenter() {
        return new class_2338((this.topLeft.method_10263() + this.bottomRight.method_10263()) / 2, 70, (this.topLeft.method_10260() + this.bottomRight.method_10260()) / 2);
    }

    private class_2338 snapVertex(class_2338 vertex, float snapDistance) {
        double dist;
        class_2338 v;
        class_2338 closest = vertex = vertex.method_33096(70);
        double closestDistance = snapDistance * snapDistance;
        for (FrontierOverlay frontier : MapFrontiersClient.getFrontiersOverlayManager(true).getAllFrontiers((class_5321<class_1937>)this.dimension)) {
            if (frontier == this || (v = frontier.getClosestVertex(vertex, closestDistance)) == null || !((dist = v.method_10262((class_2382)vertex)) <= closestDistance)) continue;
            closest = v;
            closestDistance = dist;
        }
        for (FrontierOverlay frontier : MapFrontiersClient.getFrontiersOverlayManager(false).getAllFrontiers((class_5321<class_1937>)this.dimension)) {
            if (frontier == this || (v = frontier.getClosestVertex(vertex, closestDistance)) == null || !((dist = v.method_10262((class_2382)vertex)) <= closestDistance)) continue;
            closest = v;
            closestDistance = dist;
        }
        return closest;
    }

    public void recalculateOverlays() {
        this.polygonOverlays.clear();
        this.markerOverlays.clear();
        this.bannerOverlays.clear();
        this.updateBounds();
        this.area = 0.0f;
        this.perimeter = 0.0f;
        this.polygonArea = null;
        ShapeProperties shapeProps = new ShapeProperties().setStrokeWidth((float)Config.borderWidth).setStrokeColor(this.color).setStrokeOpacity((float)Config.borderOpacity).setStrokePosition(ShapeProperties.StrokePosition.INSIDE).setFillColor(this.color).setFillOpacity((float)Config.polygonsOpacity);
        if (this.mode == FrontierData.Mode.Vertex) {
            this.recalculateVertices(shapeProps);
        } else {
            this.recalculateChunks(shapeProps);
        }
        if (this.highlighted) {
            ShapeProperties highlightShapeProps = new ShapeProperties().setStrokeWidth(2.0f).setStrokeColor(0xFFFFFF).setStrokeOpacity(1.0f).setStrokePosition(ShapeProperties.StrokePosition.OUTSIDE).setFillOpacity(0.0f);
            ArrayList<PolygonOverlay> highlightedOverlays = new ArrayList<PolygonOverlay>();
            for (PolygonOverlay polygonOverlay : this.polygonOverlays) {
                highlightedOverlays.add(new PolygonOverlay("mapfrontiers", this.dimension, highlightShapeProps, polygonOverlay.getOuterArea(), polygonOverlay.getHoles()));
            }
            this.polygonOverlays.addAll(highlightedOverlays);
        }
    }

    private void addPolygonOverlays(ShapeProperties shapeProps, MapPolygon polygon, @Nullable List<MapPolygon> polygonHoles) {
        PolygonOverlay overlay;
        boolean fullscreenV = Config.getVisibilityValue(Config.fullscreenVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.Fullscreen));
        boolean fullscreenNameV = Config.getVisibilityValue(Config.fullscreenNameVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.FullscreenName));
        boolean fullscreenOwnerV = Config.getVisibilityValue(Config.fullscreenOwnerVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.FullscreenOwner));
        boolean fullscreenBannerV = Config.getVisibilityValue(Config.fullscreenBannerVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.FullscreenBanner));
        boolean fullscreenDayV = Config.getVisibilityValue(Config.fullscreenDayVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.FullscreenDay));
        boolean fullscreenNightV = Config.getVisibilityValue(Config.fullscreenNightVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.FullscreenNight));
        boolean fullscreenUndergroundV = Config.getVisibilityValue(Config.fullscreenUndergroundVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.FullscreenUnderground));
        boolean fullscreenTopoV = Config.getVisibilityValue(Config.fullscreenTopoVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.FullscreenTopo));
        boolean fullscreenBiomeV = Config.getVisibilityValue(Config.fullscreenBiomeVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.FullscreenBiome));
        boolean minimapV = Config.getVisibilityValue(Config.minimapVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.Minimap));
        boolean minimapNameV = Config.getVisibilityValue(Config.minimapNameVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.MinimapName));
        boolean minimapOwnerV = Config.getVisibilityValue(Config.minimapOwnerVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.MinimapOwner));
        boolean minimapBannerV = Config.getVisibilityValue(Config.minimapBannerVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.MinimapBanner));
        boolean minimapDayV = Config.getVisibilityValue(Config.minimapDayVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.MinimapDay));
        boolean minimapNightV = Config.getVisibilityValue(Config.minimapNightVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.MinimapNight));
        boolean minimapUndergroundV = Config.getVisibilityValue(Config.minimapUndergroundVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.MinimapUnderground));
        boolean minimapTopoV = Config.getVisibilityValue(Config.minimapTopoVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.MinimapTopo));
        boolean minimapBiomeV = Config.getVisibilityValue(Config.minimapBiomeVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.MinimapBiome));
        boolean webmapV = Config.getVisibilityValue(Config.webmapVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.Webmap));
        boolean webmapNameV = Config.getVisibilityValue(Config.webmapNameVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.WebmapName));
        boolean webmapOwnerV = Config.getVisibilityValue(Config.webmapOwnerVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.WebmapOwner));
        boolean webmapBannerV = Config.getVisibilityValue(Config.webmapBannerVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.WebmapBanner));
        boolean webmapDayV = Config.getVisibilityValue(Config.webmapDayVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.WebmapDay));
        boolean webmapNightV = Config.getVisibilityValue(Config.webmapNightVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.WebmapNight));
        boolean webmapUndergroundV = Config.getVisibilityValue(Config.webmapUndergroundVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.WebmapUnderground));
        boolean webmapTopoV = Config.getVisibilityValue(Config.webmapTopoVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.WebmapTopo));
        boolean webmapBiomeV = Config.getVisibilityValue(Config.webmapBiomeVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.WebmapBiome));
        class_2338 firstpoint = (class_2338)polygon.getPoints().getFirst();
        Rectangle2D.Double polygonBound = new Rectangle2D.Double(firstpoint.method_10263(), firstpoint.method_10260(), 1.0, 1.0);
        for (class_2338 point : polygon.getPoints()) {
            polygonBound.add(point.method_10263(), point.method_10260());
        }
        if (fullscreenV) {
            overlay = new PolygonOverlay("mapfrontiers", this.dimension, shapeProps, polygon, polygonHoles);
            overlay.setActiveUIs(new Context.UI[]{Context.UI.Fullscreen});
            overlay.setActiveMapTypes(this.getActiveMapTypes(fullscreenDayV, fullscreenNightV, fullscreenUndergroundV, fullscreenTopoV, fullscreenBiomeV));
            this.addNameOwnerAndBanner(overlay, polygonBound, fullscreenNameV, fullscreenOwnerV, fullscreenBannerV);
            this.polygonOverlays.add(overlay);
        }
        if (minimapV) {
            overlay = new PolygonOverlay("mapfrontiers", this.dimension, shapeProps, polygon, polygonHoles);
            overlay.setActiveUIs(new Context.UI[]{Context.UI.Minimap});
            overlay.setActiveMapTypes(this.getActiveMapTypes(minimapDayV, minimapNightV, minimapUndergroundV, minimapTopoV, minimapBiomeV));
            this.addNameOwnerAndBanner(overlay, polygonBound, minimapNameV, minimapOwnerV, minimapBannerV);
            this.polygonOverlays.add(overlay);
        }
        if (webmapV) {
            overlay = new PolygonOverlay("mapfrontiers", this.dimension, shapeProps, polygon, polygonHoles);
            overlay.setActiveUIs(new Context.UI[]{Context.UI.Webmap});
            overlay.setActiveMapTypes(this.getActiveMapTypes(webmapDayV, webmapNightV, webmapUndergroundV, webmapTopoV, webmapBiomeV));
            this.addNameOwnerAndBanner(overlay, polygonBound, webmapNameV, webmapOwnerV, webmapBannerV);
            this.polygonOverlays.add(overlay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalculateVertices(ShapeProperties shapeProps) {
        List list = this.vertices;
        synchronized (list) {
            if (this.vertices.size() > 2) {
                MapPolygon polygon = new MapPolygon(this.vertices);
                this.addPolygonOverlays(shapeProps, polygon, null);
                this.polygonArea = PolygonHelper.toArea((MapPolygon)polygon);
                class_2338 last = (class_2338)this.vertices.getLast();
                for (class_2338 vertex : this.vertices) {
                    this.area += (float)(last.method_10263() * vertex.method_10260() - last.method_10260() * vertex.method_10263());
                    last = vertex;
                }
                this.area = Math.abs(this.area / 2.0f);
            } else {
                boolean fullscreenV = Config.getVisibilityValue(Config.fullscreenVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.Fullscreen));
                boolean fullscreenDayV = Config.getVisibilityValue(Config.fullscreenDayVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.FullscreenDay));
                boolean fullscreenNightV = Config.getVisibilityValue(Config.fullscreenNightVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.FullscreenNight));
                boolean fullscreenUndergroundV = Config.getVisibilityValue(Config.fullscreenUndergroundVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.FullscreenUnderground));
                boolean fullscreenTopoV = Config.getVisibilityValue(Config.fullscreenTopoVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.FullscreenTopo));
                boolean fullscreenBiomeV = Config.getVisibilityValue(Config.fullscreenBiomeVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.FullscreenBiome));
                boolean minimapV = Config.getVisibilityValue(Config.minimapVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.Minimap));
                boolean minimapDayV = Config.getVisibilityValue(Config.minimapDayVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.MinimapDay));
                boolean minimapNightV = Config.getVisibilityValue(Config.minimapNightVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.MinimapNight));
                boolean minimapUndergroundV = Config.getVisibilityValue(Config.minimapUndergroundVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.MinimapUnderground));
                boolean minimapTopoV = Config.getVisibilityValue(Config.minimapTopoVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.MinimapTopo));
                boolean minimapBiomeV = Config.getVisibilityValue(Config.minimapBiomeVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.MinimapBiome));
                boolean webmapV = Config.getVisibilityValue(Config.webmapVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.Webmap));
                boolean webmapDayV = Config.getVisibilityValue(Config.webmapDayVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.WebmapDay));
                boolean webmapNightV = Config.getVisibilityValue(Config.webmapNightVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.WebmapNight));
                boolean webmapUndergroundV = Config.getVisibilityValue(Config.webmapUndergroundVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.WebmapUnderground));
                boolean webmapTopoV = Config.getVisibilityValue(Config.webmapTopoVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.WebmapTopo));
                boolean webmapBiomeV = Config.getVisibilityValue(Config.webmapBiomeVisibility, this.getVisibility(FrontierData.VisibilityData.Visibility.WebmapBiome));
                if (fullscreenV) {
                    this.createMarkersFromVertices(Context.UI.Fullscreen, this.getActiveMapTypes(fullscreenDayV, fullscreenNightV, fullscreenUndergroundV, fullscreenTopoV, fullscreenBiomeV));
                }
                if (minimapV) {
                    this.createMarkersFromVertices(Context.UI.Minimap, this.getActiveMapTypes(minimapDayV, minimapNightV, minimapUndergroundV, minimapTopoV, minimapBiomeV));
                }
                if (webmapV) {
                    this.createMarkersFromVertices(Context.UI.Webmap, this.getActiveMapTypes(webmapDayV, webmapNightV, webmapUndergroundV, webmapTopoV, webmapBiomeV));
                }
            }
            if (this.vertices.size() > 1) {
                class_2338 last = (class_2338)this.vertices.getLast();
                for (class_2338 vertex : this.vertices) {
                    this.perimeter += (float)Math.sqrt(vertex.method_10262((class_2382)last));
                    last = vertex;
                }
            }
        }
    }

    private Context.MapType[] getActiveMapTypes(boolean day, boolean night, boolean underground, boolean topo, boolean biome) {
        ArrayList<Context.MapType> mapTypes = new ArrayList<Context.MapType>();
        if (day) {
            mapTypes.add(Context.MapType.Day);
        }
        if (night) {
            mapTypes.add(Context.MapType.Night);
        }
        if (underground) {
            mapTypes.add(Context.MapType.Underground);
        }
        if (topo) {
            mapTypes.add(Context.MapType.Topo);
        }
        if (biome) {
            mapTypes.add(Context.MapType.Biome);
        }
        return mapTypes.toArray(new Context.MapType[0]);
    }

    private void createMarkersFromVertices(Context.UI uiArray, Context.MapType[] mapTypesArray) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            MarkerOverlay marker = new MarkerOverlay("mapfrontiers", (class_2338)this.vertices.get(i), markerVertex);
            marker.setDimension(this.dimension);
            marker.setDisplayOrder(100);
            marker.setActiveUIs(new Context.UI[]{uiArray});
            marker.setActiveMapTypes(mapTypesArray);
            this.markerOverlays.add(marker);
            if (i != 0 || this.vertices.size() != 2) continue;
            this.addMarkerDots((class_2338)this.vertices.get(0), (class_2338)this.vertices.get(1), uiArray, mapTypesArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalculateChunks(ShapeProperties shapeProps) {
        HashMultimap edges = HashMultimap.create();
        Set set = this.chunks;
        synchronized (set) {
            for (class_1923 chunk : this.chunks) {
                FrontierOverlay.addNewEdge((Multimap<class_1923, class_1923>)edges, new class_1923(chunk.field_9181, chunk.field_9180), new class_1923(chunk.field_9181 + 1, chunk.field_9180));
                FrontierOverlay.addNewEdge((Multimap<class_1923, class_1923>)edges, new class_1923(chunk.field_9181 + 1, chunk.field_9180), new class_1923(chunk.field_9181 + 1, chunk.field_9180 + 1));
                FrontierOverlay.addNewEdge((Multimap<class_1923, class_1923>)edges, new class_1923(chunk.field_9181 + 1, chunk.field_9180 + 1), new class_1923(chunk.field_9181, chunk.field_9180 + 1));
                FrontierOverlay.addNewEdge((Multimap<class_1923, class_1923>)edges, new class_1923(chunk.field_9181, chunk.field_9180 + 1), new class_1923(chunk.field_9181, chunk.field_9180));
            }
        }
        ArrayList outerPolygons = new ArrayList();
        HashMultimap holesPolygons = HashMultimap.create();
        while (!edges.isEmpty()) {
            boolean clockwise;
            class_1923 edge2;
            class_1923 starting = (class_1923)Collections.min(edges.keySet(), (e1, e2) -> e1.field_9181 == e2.field_9181 ? e1.field_9180 - e2.field_9180 : e1.field_9181 - e2.field_9181);
            ArrayList<class_1923> arrayList = new ArrayList<class_1923>();
            Object edge = starting;
            int direction = 1;
            do {
                arrayList.add((class_1923)edge);
                Iterator it = edges.get(edge).iterator();
                edge2 = (class_1923)it.next();
                while (it.hasNext() && Integer.signum(direction) == Integer.signum(edge2.field_9181 - ((class_1923)edge).field_9181 + ((class_1923)edge).field_9180 - edge2.field_9180)) {
                    edge2 = (class_1923)it.next();
                }
                edges.remove(edge, (Object)edge2);
                direction = edge2.field_9181 - ((class_1923)edge).field_9181 + edge2.field_9180 - ((class_1923)edge).field_9180;
            } while (!(edge = edge2).equals((Object)starting));
            this.perimeter += (float)(arrayList.size() * 16);
            boolean bl = clockwise = ((class_1923)arrayList.get((int)0)).field_9181 != ((class_1923)arrayList.get((int)1)).field_9181;
            if (clockwise) {
                outerPolygons.add(arrayList);
                continue;
            }
            class_1923 ray = (class_1923)arrayList.getFirst();
            class_1923 outerFound = null;
            for (int i = 0; i < 999; ++i) {
                for (List list : outerPolygons) {
                    class_1923 outerStart = (class_1923)list.getFirst();
                    if (list.contains(ray)) {
                        outerFound = outerStart;
                        break;
                    }
                    for (List hole : holesPolygons.get((Object)outerStart)) {
                        if (!hole.contains(ray)) continue;
                        outerFound = outerStart;
                        break;
                    }
                    if (outerFound == null) continue;
                    break;
                }
                if (outerFound != null) break;
                ray = new class_1923(ray.field_9181 - 1, ray.field_9180);
            }
            if (outerFound != null) {
                holesPolygons.put(outerFound, arrayList);
                continue;
            }
            MapFrontiers.LOGGER.warn(String.format("Frontier %1$s is too large and the polygon corresponding to the hole %2$s could not be located", this.id, arrayList.getFirst()));
        }
        for (List list : outerPolygons) {
            FrontierOverlay.removeCollinear(list);
            for (List hole : holesPolygons.get((Object)((class_1923)list.getFirst()))) {
                FrontierOverlay.removeCollinear(hole);
            }
        }
        for (List list : outerPolygons) {
            MapPolygon polygon = new MapPolygon(list.stream().map(c -> new class_2338(c.method_8326(), 70, c.method_8328())).toList());
            ArrayList<MapPolygon> polygonHoles = null;
            if (holesPolygons.containsKey(list.getFirst())) {
                polygonHoles = new ArrayList<MapPolygon>();
                for (List hole : holesPolygons.get((Object)((class_1923)list.getFirst()))) {
                    polygonHoles.add(new MapPolygon(hole.stream().map(c -> new class_2338(c.method_8326(), 70, c.method_8328())).toList()));
                }
            }
            this.addPolygonOverlays(shapeProps, polygon, polygonHoles);
        }
        this.area = this.chunks.size() * 256;
    }

    private static void addNewEdge(Multimap<class_1923, class_1923> edges, class_1923 from, class_1923 to) {
        if (!edges.remove((Object)to, (Object)from)) {
            edges.put((Object)from, (Object)to);
        }
    }

    private static void removeCollinear(List<class_1923> chunks) {
        if (chunks.size() <= 4) {
            return;
        }
        class_1923 prev = chunks.getFirst();
        for (int i = chunks.size() - 1; i > 0; --i) {
            class_1923 next = chunks.get(i - 1);
            if (prev.field_9181 == next.field_9181 || prev.field_9180 == next.field_9180) {
                chunks.remove(i);
            }
            if (i >= chunks.size()) continue;
            prev = chunks.get(i);
        }
    }

    private void addNameOwnerAndBanner(PolygonOverlay polygonOverlay, Rectangle2D.Double polygonBound, boolean nameVisible, boolean ownerVisible, boolean bannerVisible) {
        boolean bl = bannerVisible = bannerVisible && this.bannerRenderer.hasBanner();
        if (!(nameVisible || ownerVisible || bannerVisible)) {
            return;
        }
        TextProperties textProps = new TextProperties().setOpacity((float)Config.textOpacity).setScale((float)Config.textSize).setBackgroundOpacity(0.0f);
        switch (Config.textColor) {
            case Frontier: {
                textProps.setColor(this.color);
                break;
            }
            case Bright: {
                textProps.setColor(this.colorMaxBrightness(this.color));
                break;
            }
            case White: {
                textProps.setColor(-1);
            }
        }
        int lines = 0;
        int totalWidth = 0;
        Object label = "";
        if (nameVisible) {
            if (!this.name1.isEmpty()) {
                ++lines;
                totalWidth = Math.max(totalWidth, class_310.method_1551().field_1772.method_1727(this.name1));
                label = (String)label + this.name1;
            }
            if (!this.name2.isEmpty()) {
                ++lines;
                totalWidth = Math.max(totalWidth, class_310.method_1551().field_1772.method_1727(this.name2));
                if (!((String)label).isEmpty()) {
                    label = (String)label + "\n";
                }
                label = (String)label + this.name2;
            }
        }
        if (ownerVisible && !this.owner.username.isEmpty()) {
            ++lines;
            totalWidth = Math.max(totalWidth, class_310.method_1551().field_1772.method_1727(this.owner.username));
            if (!((String)label).isEmpty()) {
                label = (String)label + "\n";
            }
            label = (String)label + String.valueOf(class_124.field_1056) + this.owner.username;
        }
        totalWidth *= Config.textSize;
        int totalHeight = lines * 9 * Config.textSize;
        if (bannerVisible) {
            totalHeight += 40 * Config.bannerSize;
        }
        int topOffset = totalHeight / 2;
        int textOffset = topOffset - lines * 9 * Config.textSize / 2;
        int bannerOffset = topOffset - lines * 9 * Config.textSize;
        if (lines > 1) {
            textOffset = bannerVisible ? (textOffset -= 6) : (textOffset += 12);
        } else if (lines == 1) {
            textOffset = bannerVisible ? (textOffset += 5) : (textOffset += 3);
        }
        textProps.setOffsetY(textOffset);
        if (Config.hideNamesThatDontFit) {
            if (bannerVisible) {
                totalWidth = Math.max(totalWidth, 20 * Config.bannerSize);
            }
            this.setMinSizeTextProperties(textProps, polygonBound, totalWidth + 6, totalHeight + 6);
        }
        if (bannerVisible) {
            MapImage bannerIcon = new MapImage(this.bannerRenderer.getImage());
            bannerIcon.setBlur(false);
            bannerIcon.setAnchorX((double)(10 * Config.bannerSize));
            bannerIcon.setAnchorY((double)bannerOffset);
            bannerIcon.setDisplayWidth((double)(20 * Config.bannerSize));
            bannerIcon.setDisplayHeight((double)(40 * Config.bannerSize));
            bannerIcon.setOpacity((float)Config.bannerOpacity);
            bannerIcon.setRotation(-this.bannerRenderer.getRotation());
            class_2338 polygonCenter = class_2338.method_49637((double)polygonBound.getCenterX(), (double)70.0, (double)polygonBound.getCenterY());
            MarkerOverlay bannerOverlay = new MarkerOverlay("mapfrontiers", polygonCenter, bannerIcon);
            bannerOverlay.setActiveUIs(polygonOverlay.getActiveUIs().toArray(new Context.UI[0]));
            bannerOverlay.setActiveMapTypes(polygonOverlay.getActiveMapTypes().toArray(new Context.MapType[0]));
            bannerOverlay.setDimension(this.dimension);
            bannerOverlay.setMinZoom(textProps.getMinZoom());
            bannerOverlay.setMaxZoom(textProps.getMaxZoom());
            this.bannerOverlays.add(bannerOverlay);
            if (lines > 0) {
                bannerOverlay.setTextProperties(textProps).setOverlayGroupName("frontier").setLabel((String)label);
            }
        } else if (lines > 0) {
            polygonOverlay.setTextProperties(textProps).setOverlayGroupName("frontier").setLabel((String)label);
        }
    }

    private int colorMaxBrightness(int color) {
        float[] hsv = Color.RGBtoHSB(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, null);
        return Color.HSBtoRGB(hsv[0], hsv[1], 1.0f);
    }

    private void setMinSizeTextProperties(TextProperties textProperties, Rectangle2D.Double polygonBound, int width, int height) {
        int zoom;
        double polygonWidthScaled = polygonBound.getWidth() / 256.0;
        double polygonHeightScaled = polygonBound.getHeight() / 256.0;
        for (zoom = 2; ((double)width > polygonWidthScaled || (double)height > polygonHeightScaled) && zoom < 8192; zoom *= 2, polygonWidthScaled *= 2.0, polygonHeightScaled *= 2.0) {
        }
        textProperties.setMinZoom(zoom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBounds() {
        if (this.mode == FrontierData.Mode.Vertex) {
            if (this.vertices.isEmpty()) {
                this.topLeft = new class_2338(0, 70, 0);
                this.bottomRight = new class_2338(0, 70, 0);
            } else {
                int minX = Integer.MAX_VALUE;
                int minZ = Integer.MAX_VALUE;
                int maxX = Integer.MIN_VALUE;
                int maxZ = Integer.MIN_VALUE;
                List list = this.vertices;
                synchronized (list) {
                    for (class_2338 vertex : this.vertices) {
                        if (vertex.method_10263() < minX) {
                            minX = vertex.method_10263();
                        }
                        if (vertex.method_10260() < minZ) {
                            minZ = vertex.method_10260();
                        }
                        if (vertex.method_10263() > maxX) {
                            maxX = vertex.method_10263();
                        }
                        if (vertex.method_10260() <= maxZ) continue;
                        maxZ = vertex.method_10260();
                    }
                }
                this.topLeft = new class_2338(minX, 70, minZ);
                this.bottomRight = new class_2338(maxX, 70, maxZ);
            }
        } else if (this.chunks.isEmpty()) {
            this.topLeft = new class_2338(0, 70, 0);
            this.bottomRight = new class_2338(0, 70, 0);
        } else {
            int minX = Integer.MAX_VALUE;
            int minZ = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int maxZ = Integer.MIN_VALUE;
            Set set = this.chunks;
            synchronized (set) {
                for (class_1923 chunk : this.chunks) {
                    if (chunk.field_9181 < minX) {
                        minX = chunk.field_9181;
                    }
                    if (chunk.field_9180 < minZ) {
                        minZ = chunk.field_9180;
                    }
                    if (chunk.field_9181 > maxX) {
                        maxX = chunk.field_9181;
                    }
                    if (chunk.field_9180 <= maxZ) continue;
                    maxZ = chunk.field_9180;
                }
            }
            this.topLeft = new class_2338(minX * 16, 70, minZ * 16);
            this.bottomRight = new class_2338(maxX * 16 + 16, 70, maxZ * 16 + 16);
        }
    }

    private void addMarkerDots(class_2338 from, class_2338 to, Context.UI uiArray, Context.MapType[] mapTypesArray) {
        if (Math.abs(to.method_10260() - from.method_10260()) < Math.abs(to.method_10263() - from.method_10263())) {
            if (from.method_10263() > to.method_10263()) {
                this.addLineMarkerDots(to.method_10263(), to.method_10260(), from.method_10263(), from.method_10260(), uiArray, mapTypesArray);
            } else {
                this.addLineMarkerDots(from.method_10263(), from.method_10260(), to.method_10263(), to.method_10260(), uiArray, mapTypesArray);
            }
        } else if (from.method_10260() > to.method_10260()) {
            this.addLineMarkerDots(to.method_10263(), to.method_10260(), from.method_10263(), from.method_10260(), uiArray, mapTypesArray);
        } else {
            this.addLineMarkerDots(from.method_10263(), from.method_10260(), to.method_10263(), to.method_10260(), uiArray, mapTypesArray);
        }
    }

    private void addLineMarkerDots(int x0, int z0, int x1, int z1, Context.UI uiArray, Context.MapType[] mapTypesArray) {
        int dx = Math.abs(x1 - x0);
        int sx = x0 < x1 ? 1 : -1;
        int dz = -Math.abs(z1 - z0);
        int sz = z0 < z1 ? 1 : -1;
        int err = dx + dz;
        int i = 0;
        while (x0 != x1 || z0 != z1) {
            int e2 = 2 * err;
            if (e2 >= dz) {
                if (x0 == x1) break;
                err += dz;
                x0 += sx;
            }
            if (e2 <= dx) {
                if (z0 == z1) break;
                err += dx;
                z0 += sz;
            }
            class_2338 pos = new class_2338(x0, 70, z0);
            MarkerOverlay dot = new MarkerOverlay("mapfrontiers", pos, markerDot);
            dot.setDimension(this.dimension);
            dot.setDisplayOrder(99);
            dot.setActiveUIs(new Context.UI[]{uiArray});
            dot.setActiveMapTypes(mapTypesArray);
            int minZoom = 2;
            if (i % 2 == 0) {
                minZoom = 16384;
            } else if (i % 4 == 1) {
                minZoom = 8192;
            } else if (i % 8 == 3) {
                minZoom = 4096;
            }
            dot.setMinZoom(minZoom);
            this.markerOverlays.add(dot);
            ++i;
        }
    }

    static {
        markerVertex.setAnchorX(markerVertex.getDisplayWidth() / 2.0).setAnchorY(markerVertex.getDisplayHeight() / 2.0);
        markerDot.setAnchorX(markerDot.getDisplayWidth() / 2.0).setAnchorY(markerDot.getDisplayHeight() / 2.0);
    }

    public static class BannerRenderer {
        private class_2960 textureLocation;
        private class_1011 bannerImage;
        private int rotation;

        private void createTexture(UUID id, FrontierData.BannerData bannerData) {
            this.releaseTexture();
            this.rotation = bannerData.rotation;
            class_310 mc = class_310.method_1551();
            class_638 level = mc.field_1687;
            if (level == null) {
                return;
            }
            Optional bannerPatterns = class_9307.field_49405.parse((DynamicOps)level.method_30349().method_57093((DynamicOps)class_2509.field_11560), (Object)bannerData.patterns).result();
            if (!bannerPatterns.isPresent()) {
                MapFrontiers.LOGGER.error("Error creating banner pattern layers");
                return;
            }
            class_9307 patternLayers = (class_9307)bannerPatterns.get();
            class_630 bannerModelPart = mc.method_31974().method_32072(class_5602.field_55122).method_32086("flag");
            float[] flagUV = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
            bannerModelPart.method_35745(new class_4587(), (pose, path, i, cube) -> {
                for (class_630.class_593 polygon : ((CubeInvoker)cube).mapfrontiers$getPolygon()) {
                    if (!(polygon.comp_3185().z() < 0.0f)) continue;
                    flagUV[0] = polygon.comp_3184()[0].comp_3187();
                    flagUV[1] = polygon.comp_3184()[0].comp_3188();
                    flagUV[2] = polygon.comp_3184()[2].comp_3187();
                    flagUV[3] = polygon.comp_3184()[2].comp_3188();
                }
            });
            if (flagUV[0] == flagUV[2] || flagUV[1] == flagUV[3]) {
                MapFrontiers.LOGGER.error("Error creating banner pattern layers");
                return;
            }
            class_1058 base = class_4722.field_49769.method_24148();
            class_7764 baseSprite = base.method_45851();
            int width = (int)(Math.abs(flagUV[0] - flagUV[2]) * (float)baseSprite.method_45807());
            int height = (int)(Math.abs(flagUV[1] - flagUV[3]) * (float)baseSprite.method_45815());
            class_1011 tempBannerImage = new class_1011(width, height, false);
            BannerRenderer.generateBannerLayer(tempBannerImage, flagUV, baseSprite, bannerData.baseColor);
            for (int i2 = 0; i2 < patternLayers.comp_2428().size(); ++i2) {
                class_9307.class_9308 layer = (class_9307.class_9308)patternLayers.comp_2428().get(i2);
                class_2960 patternTextureLocation = ((class_2582)layer.comp_2429().comp_349()).comp_2456().method_45138("entity/banner/");
                class_1058 sprite = (class_1058)mc.method_1549(class_4722.field_21706).apply(patternTextureLocation);
                BannerRenderer.generateBannerLayer(tempBannerImage, flagUV, sprite.method_45851(), layer.comp_2430());
            }
            this.bannerImage = tempBannerImage.method_48462(class_9848::method_61334);
            this.textureLocation = class_2960.method_60655((String)"mapfrontiers", (String)id.toString());
            class_1043 texture = new class_1043(() -> this.textureLocation.toString(), this.bannerImage);
            texture.method_4527(false, false);
            mc.method_1531().method_4616(this.textureLocation, (class_1044)texture);
        }

        private static void generateBannerLayer(class_1011 bannerImage, float[] flagUV, class_7764 sprite, class_1767 dye) {
            class_1011 spriteImage = ((SpriteContentsInvoker)sprite).mapfrontiers$getOriginalImage();
            for (int y = 0; y < bannerImage.method_4323(); ++y) {
                for (int x = 0; x < bannerImage.method_4307(); ++x) {
                    int u = (int)(class_3532.method_16439((float)(((float)x + 0.5f) / (float)bannerImage.method_4307()), (float)flagUV[2], (float)flagUV[0]) * (float)sprite.method_45807());
                    int v = (int)(class_3532.method_16439((float)(((float)y + 0.5f) / (float)bannerImage.method_4323()), (float)flagUV[1], (float)flagUV[3]) * (float)sprite.method_45815());
                    int color = class_9848.method_61322((int)spriteImage.method_61940(u, v), (int)dye.method_7787());
                    BannerRenderer.blendPixel(bannerImage, x, y, color);
                }
            }
        }

        private static void blendPixel(class_1011 image, int x, int y, int color) {
            int i = image.method_61940(x, y);
            float f = (float)class_9848.method_61320((int)color) / 255.0f;
            float f1 = (float)class_9848.method_61327((int)color) / 255.0f;
            float f2 = (float)class_9848.method_61329((int)color) / 255.0f;
            float f3 = (float)class_9848.method_61331((int)color) / 255.0f;
            float f4 = (float)class_9848.method_61320((int)i) / 255.0f;
            float f5 = (float)class_9848.method_61327((int)i) / 255.0f;
            float f6 = (float)class_9848.method_61329((int)i) / 255.0f;
            float f7 = (float)class_9848.method_61331((int)i) / 255.0f;
            float f8 = 1.0f - f;
            float f9 = f * f + f4 * f8;
            float f10 = f1 * f + f5 * f8;
            float f11 = f2 * f + f6 * f8;
            float f12 = f3 * f + f7 * f8;
            if (f9 > 1.0f) {
                f9 = 1.0f;
            }
            if (f10 > 1.0f) {
                f10 = 1.0f;
            }
            if (f11 > 1.0f) {
                f11 = 1.0f;
            }
            if (f12 > 1.0f) {
                f12 = 1.0f;
            }
            int j = (int)(f9 * 255.0f);
            int k = (int)(f10 * 255.0f);
            int l = (int)(f11 * 255.0f);
            int i1 = (int)(f12 * 255.0f);
            image.method_61941(x, y, class_9848.method_61324((int)j, (int)k, (int)l, (int)i1));
        }

        public void renderBanner(class_332 graphics, int centerX, int y, int scale) {
            if (this.textureLocation == null) {
                return;
            }
            int width = 20 * scale;
            int height = 40 * scale;
            int x = centerX - width / 2;
            float centerY = (float)y + (float)height / 2.0f;
            graphics.method_51448().pushMatrix();
            graphics.method_51448().translate((float)centerX, centerY);
            graphics.method_51448().rotate((float)Math.toRadians(this.rotation));
            graphics.method_51448().translate((float)(-centerX), -centerY);
            ((GuiGraphicsAccessor)graphics).innerBlitInvoker(class_10799.field_56883, this.textureLocation, x, x + width, y, y + height, 0.0f, 1.0f, 0.0f, 1.0f, -1);
            graphics.method_51448().popMatrix();
        }

        public boolean hasBanner() {
            return this.textureLocation != null;
        }

        public class_1011 getImage() {
            return this.bannerImage;
        }

        private void releaseTexture() {
            if (this.textureLocation != null) {
                class_310.method_1551().method_1531().method_4615(this.textureLocation);
                this.textureLocation = null;
            }
            if (this.bannerImage != null) {
                this.bannerImage.close();
                this.bannerImage = null;
            }
        }

        public void setRotation(int rotation) {
            this.rotation = rotation;
        }

        public int getRotation() {
            return this.rotation;
        }
    }
}

